title RAM Disk / Kaypro 2000 Wasted RAM Disk
name disk

comment ~
	DUAL PURPOSE RAM DISK PROGRAM

	T. Jennings 2 Aug 85


	This is a dual purpose RAM Disk
program. As a RAM disk, it is of variable size,
and has the nice side effect of not trashing 
it's contents between reboots, if possible.

	It can also be used as a special RAM 
disk for the Kaypro 2000 laptop with 796K. In
this case, the disk size is fixed at 128K, and
resides in the otherwise wasted RAM above the
display RAM, at segment d000h.


	WHAT IT DOES

	The program preserves it's contents by
making the assumption that while you cannot 
assume that MSDOS loads a device driver at any
specific location, the truth is that unless you
change CONFIG.SYS between reboots, all drivers
load at the same address every reboot. When 
installed, the driver sees if it is still at
the same location; if so, it assumes the disk
is OK and does not "format" it. If it is not,
the disk is "formatted", ie. cleared out.

	This is done by the kludge of looking
at the FAT ID byte for the drive; I suppose 
it's possible that random memory contents could
fool it, but I'll let someone else worry about 
it.

	RAM DISK SIZE

	If the RAMDISK type is selected, the
size of the disk is specified in CONFIG.SYS. If
nothing is specified, it defaults to some 
reasonable size. The size is specified in K 
bytes, like so:

device = FIDODISK.SYS 300

	This example sets a 300K RAM disk. 



	ASSEMBLING THE DRIVER

	It is assumed that you have MASM, LINK,
EXE2BIN, etc, and know how to use them. This is
set up to be a .COM type file, so use EXE2BIN.
Rename the binary FIDODISK.SYS or whatever.

	There is a conditional assembly switch
that defines what type of disk it is. KAYDISK
removes the set-disk-size option and fixes the
disk location to d000:0000 with a length of
128K. RAMDISK installs the RAMDISK type 
functions.


end comment ... ~
;
;The big conditional assembly value: Use
;KAYDISK EQU 1 for the Kaypro specific one, or
;KAYDISK EQU 0 for a general MSDOS RAM disk.
;
KAYDISK	equ	0
;
;Useful stuff
;
CR	equ	13
LF	equ	10
NUL	equ	0

if KAYDISK
;
;Kaypro 2000:
;  Kaypro 2000 Hardware definitions.
;
KAYSEG	equ	0d000h	;Kaypro 2000 wasted RAM
KAYLEN	equ	2000h	;Kaypro size paragraphs

ELSE
;
;MSDOS RAM Disk:
;  Define the default, minimums and maximums
;for the disk size.
;
DEFSIZE	equ	128	;in K bytes
MINSIZE	equ	4	;pretty small
MAXSIZE	equ	512	;pretty large

ENDIF
;
;Definitions for making the RAM disk or Kaypro
;disk. These are stuffed into the BPB and also
;used by the INIT code. This makes no attempt
;to emulate an IBM diskette or any such crap.
;SECSFAT is correct for the defaults only.
;
SECSIZE	equ	256	;our sector size
FATID	equ	0f8h	;FAT ID byte (fixed)
FATS	equ	1	;number of FATs
SECSFAT	equ	4	;sectors per FAT
RESV	equ	1	;reserved sectors
DIRSECS	equ	8	;total dir secs
;
;MSDOS 2.00 IO device data packet layout.
;This is the thing passed to us by MSDOS. If
;you arent familiar with MASM's structures,
;dont be alarmed: all it does is define, for
;instance, the element cmd (iodata.cmd) as
;a stupid offset. So, to access iodata.cmd,
;you use [bx.cmd], which is IDENTICAL to
;[bx + cmd] and cmd equ 3. No, you cannot 
;define more than one structure if any elements
;have the same name! Stupid crap.
;
iodata struc
cmdlen	db	(?)	;packet length,
unit	db	(?)	;unit number,
cmd	db	(?)	;command,
status	dw	(?)	;returned status,
	db 8 dup (?)
media	db	(?)	;descriptor byte
trans	dw	(?)	;transfer address
transh	dw	(?)
count	dw	(?)	;data count
start	dw	(?)	;starting record
iodata ends
;
;Normalize a segment/offset register pair,
;such that offset is as small as possible,
;to avoid segment wrap problems. Stupid Intel
;segmented minds.
;
normal macro seg,off
	push	off
	shr	off,1
	shr	off,1
	shr	off,1
	shr	off,1
	push	ax
	mov	ax,seg
	add	ax,off
	mov	seg,ax
	pop	ax
	pop	off
	and	off,000fh
endm
page
cgroup group code
code segment
assume cs:cgroup,ds:cgroup
;
;-------------------------------------------+
;     DWORD pointer to next device          |
;         (-1,-1 if last device)            |
;-------------------------------------------+
;     Device attribute WORD                 ;
;       Bit 15 = 1 for chacter devices.     ;
;                0 for Block devices.       ;
;                                           ;
;       Character devices. (Bit 15=1)       ;
;         Bit 0 = 1  current sti device.    ;
;         Bit 1 = 1  current sto device.    ;
;         Bit 2 = 1  current NUL device.    ;
;         Bit 3 = 1  current Clock device.  ;
;         Bit 4 = 1  SPECIAL CON device     ;
;         Bit 14 = 1 IOCTL control bit.     ;
;-------------------------------------------+
;     Device strategy pointer.              ;
;-------------------------------------------+
;     Device interrupt pointer.             ;
;-------------------------------------------+
;     Device name field.                    ;
;       Character devices are any valid name;
;         left justified, in a space filled ;
;         field.                            ;
;       Block devices contain # of units in ;
;         the first byte.                   ;
;-------------------------------------------+
;
codestart:
;
;Device driver linkage table. This MUST BE
;the very first code generated. MSDOS uses this
;table to link the driver into the device 
;chain.
;
devtbl label byte
	dw -1,-1	;link to next device
	dw 0000h 	;IBM type
	dw strategy
	dw interrupt
	db 1		;one device
	db 7 dup (0)	;filler
;
;Our BPB. (BIOS Parameter Block.) This
;defines the disk to MSDOS.
;
bpb label byte
	dw SECSIZE	;sector size
	db 1		;secs/block
	dw RESV		;reserved sectors
	db FATS		;FATs
	dw 64		;dir entries
bpbsize	dw (?)		;total sectors
	db FATID	;media byte
spf	dw SECSFAT	;secs/FAT
;
;A pointer to our table of BPBs (though
;there is only one.) This is needed only
;at INIT time.
;
bpbptr	dw	bpb
;
;Various variables. 
;
ptrsave	label dword	;DOS packet addr
ptroff dw (?)
ptrseg dw (?)

dskaddr label dword	;address of sector
dskoff dw (?)		;disk addr offset
dskseg dw (?)		;ditto segment

dosaddr	label dword	;address from DOS
dosoff dw (?)
dosseg dw (?)

datacount dw (?)	;byte count
;
;Location of the RAM disk. Set at INIT time.
;
ramseg	dw	(?)	;set at INIT time
ramlen	dw	(?)	;size, in paras
ramend	dw	(?)	;end of driver

if KAYDISK
;
;Kaypro 2000:
;  Just a signon message. This could be
;used for other machines too. If not an IBM
;compatible, you will have to rewrite the
;PUTC function to output to the screen.
;
signon 	db 'Kaypro 2000 Wasted RAM Disk '
	db 'T. Jennings 2 Aug 85',13,10,0
fmtstr	db 'Initializing the disk',13,10,0

ENDIF

;
;Jump table for executing the command 
;from DOS.
;
jmptbl label word
	dw	init		;0
	dw	mediachk	;1
	dw	buildbpb	;2
	dw	return		;3
	dw	read		;4
	dw	return
	dw	return
	dw	return
	dw	write		;8
	dw	write		;9
	dw	return
	dw	return
	dw	return
page
;
;Device STRATEGY entry point. All this does
;is store the packet pointer and return.
;
stratg proc far

strategy:
	mov	cs:ptroff,bx
	mov	cs:ptrseg,es
	ret

stratg endp
;
;Device INTERRUPT entry point. Save things,
;put the packet contents into convenient 
;places, and dispatch to the right routine.
;
dispatch proc far	;wierd way to get RETF

interrupt:
	push	ax
	push	bx
	push	cx
	push	dx	;push those regs
	push	si
	push	di
	push	bp
	push	ds
	push	es

	mov	ax,cs
	mov	ds,ax	;set local data seg
	les	bx,ptrsave
	mov	word ptr es:[bx.status],0100h
	call	args	;convert addresses
	mov	bl,es:[bx.cmd]
	mov	bh,0	;call the function
	shl	bx,1	;via the jump table
	call	word ptr jmptbl[bx]

	pop	es
	pop	ds
	pop	bp
	pop	di	;pop those zits
	pop	si
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	ret

dispatch endp	;end wierdness
;
;Return for the unsupported functions.
;
return:	ret
;
;  Set the DOS and DISK addresses for the 
;block move later.
;
;  Given the start sector and sector count,
;calculate the start address of the data
;and store it for later. This is short-cut
;arithmetic, since our sector size is 256
;bytes, and there are no messy tracks and
;heads.
;
;  Note that the offset portion of the disk
;address is never set; it is always 0000h, 
;set by the (0) initialization.
;
args:
;
;To convert sector count into byte count,
;its sector count * sector size. Or, shift 
;sector count left 8 times. Or, swap the 
;two bytes.
;
	mov	ax,es:[bx.count];sector count
	mov	ah,al		;byte count=
	mov	al,0		; shl 8
	mov	datacount,ax
;
;To convert the sector number into a paragraph
;address, its sector # * sector size / para 
;size. Or, sect# * 256 / 16. Or, sect# shl 4.
;This is the DISK ADDRESS. It is inherently
;normalized.
;
	mov	ax,es:[bx.start];start sector
	mov	cl,4
	shl	ax,cl		;sector addr
	add	ax,ramseg	; + base addr
	mov	dskseg,ax
	mov	dskoff,0
;
;Get the address from DOS. All we have to do is
;normalize it so the offset part wont wrap. 
;This is the DOS ADDRESS.
;
	mov	ax,es:[bx.trans]
	mov	dosoff,ax
	mov	ax,es:[bx.transh]
	mov	dosseg,ax
	normal	dosseg,dosoff	;normalize
	cld			;upwards
	ret
page
;
;INIT the disk system. This checks to see if
;the disk is corrupted; if so, it "formats"
;the drive by clearing the FAT.
;
;    The memory for the RAM disk itself is
;above the DOS partition; therefore we dont
;have to tell DOS about it, only the code
;for the driver itself.
;
;MSDOS SECRET REVEALED: DOS passes the
;"command tail" from CONFIG.SYS in the
;packet header. The command tail is a
;pointer to a string, terminated by a CR.
;
;	There are some inconsistencies
;between different DOS versions. The fix is
;easy. When parsing the cmd tail, consider
;nulls the same as spaces, and consider the
;CR the string terminator. This implies that
;you have to be prepared to do leading/trailing
;space stripping, etc, but it means that your 
;device can run on MSDOS 2.xx and 3.xx both.
;
init:	mov	ax,cs		;calc ZGROUP,
	add	ax,ZGROUP	;end of driver
	inc	ax		;AX = end code
	mov	ramend,ax	;stash it
	mov	ramseg,ax	;start of disk

if KAYDISK
;
;KAYPRO 2000:
;  Since the size and location of the RAM disk
;is fixed, all we have to do is set the 
;location and size of the disk. Put the disk
;size, in paragraphs, in AX.
;
	mov	si,offset signon
	call	puts		;say hello
	mov	ramseg,KAYSEG	;start of disk
	mov	ramlen,KAYLEN	;size of disk
ELSE
;
; REGULAR RAMDISK:
;  Use the command tail to determine the RAM
;disk size. This involves copying the cmd tail
;to the string buffer to make parsing it 
;easier.
;
	les	bx,cs:ptrsave	;CONFIG.SYS
	mov	si,es:[bx.count];cmd tail
	mov	es,es:[bx.start];pointer

	mov	di,offset buff	;work space
i1:	mov	al,es:[si]	;copy tail up
	and	al,7fh		;(paranoia)
	cmp	al,NUL		;convert nulls
	jne	i1a		;to spaces
	mov	al,' '
i1a:	cmp	al,CR		;to the CR 
	je	i1b		;(paranoia)
	cmp	al,LF		;or LF
	je	i1b
	mov	[di],al
	inc	si
	inc	di
	jmp	i1
i1b:	mov	byte ptr [di],NUL
;
;Now convert to a decimal number. Assume it
;means K bytes, if reasonable use it, otherwise
;set to our default disk size.
;
	call	atoi		;number to DX
	mov	ax,DEFSIZE	;default in AX
	cmp	dx,MINSIZE	;check in range
	jb	i1c
	cmp	dx,MAXSIZE
	ja	i1c
	mov	ax,dx		;tis OK
;
;AX is the size of the disk, in K bytes. We use
;paragraphs internally, so its:
;
;	paras = AX * 1024 / 16 
; or	paras = AX * 64
; or	paras = AX shl 6
;
i1c:	mov	cl,6
	shl	ax,cl
;
;Also adjust the end of driver location, to
;reflect the additional space needed for the
;disk data. 
;
	mov	ramlen,ax
	add	ramend,ax

ENDIF

;
;  Set the RAM disk size, in sectors. We know
;the disk size in paras, so its easy. 
;
;	sectors = bytes / SECSIZE
; or	sectors = paras / (SECSIZE / 16)
; or	sectors = paras / 16
; or	sectors = paras shr 4
;
	mov	ax,ramlen
	mov	cl,4
	shr	ax,cl
	mov	bpbsize,ax	;disk size
;
;We need to calculate the FAT size. Pretty 
;easy; cluster size is fixed at 1 sector per
;cluster (makes no sense to do anything else)
;and the dir size is fixed. We use a 12 bit
;FAT, so at 12 bits per block:
;
;    FAT secs = (clusters * 1.5) secsize + 1
;    FAT secs = ((clusters * 3) / 2) / 256 +1
;
	sub	ax,DIRSECS	;minus dir secs
	mov	cx,3		;DX:AX = secs
	xor	dx,dx
	mul	cx		; * 3,
	mov	cx,2
	xor	dx,dx
	div	cx		; / 2,
	mov	cx,SECSIZE
	xor	dx,dx
	div	cx		; / secsize,
	inc	ax		; + 1
	mov	spf,ax		
;
;  Check the integrity of the RAM disk; if it 
;is still there, assume it's OK. If the FAT ID
;byte is different, assume the disk is trashed
;and reinitialize it.
;
	mov	ax,ramseg
	mov	es,ax
	mov	di,0		;for debugging
	mov	ax,cs		;store CS in 
	stosw			;the boot sec

	mov	di,SECSIZE * RESV;RAM address
	mov	al,es:[di]	;if FAT ID is
	cmp	al,FATID	; OK, skip it
	je	i2
;
;Format the disk by zeroing the FAT(s) and
;directory.
;
if KAYDISK
;
;Kaypro 2000:
;	Tell the user that we have to format 
;the disk. This could be used as is for an IBM
;compatible machine; see the PUTC funtion for 
;other type machines.
;
	mov	si,offset fmtstr
	call	puts		;say so

ENDIF

	mov	cx,SECSIZE * ((SECSFAT * FATS) + DIRSECS)
	xor	ax,ax		;clear it
	rep	stosb
	mov	di,SECSIZE * RESV
	mov	al,FATID	;write FAT ID
	stosb
	mov	ax,0ffffh	;and the marker
	stosw
;
;Tell MSDOS about this driver. We tell it the
;number of units, the address of a BPB pointer,
;and the address of the end of the code. 
;
i2:	les	bx,cs:ptrsave
	mov	byte ptr es:[bx.media],1 ;# drives
	mov	word ptr es:[bx.count],offset bpbptr
	mov	es:[bx.start],cs;BPB ptr
	mov	ax,ramend	;end of driver
	mov	word ptr es:[bx.trans],0
	mov	es:[bx.transh],ax
	ret
;
;MEDIA CHECK: always return "disk not 
;changed".
;
mediachk:
	les	bx,ptrsave
	mov	byte ptr es:[bx.media+1],1
	ret
;
;BUILD BPB: return a pointer to the BPB for 
;this drive. Really easy.
;
buildbpb:
	les	bx,ptrsave
	mov	word ptr es:[bx.count],offset bpb
	mov	es:[bx.start],cs
	ret
;
;READ a sector from the disk to DOS.
;
read:	mov	cx,datacount
	les	di,dosaddr	;DEST: dos
	lds	si,dskaddr	;SOURCE: disk
	rep	movsb
	ret
;
;WRITE a sector from DOS to the disk.
;
write:	mov	cx,datacount
	les	di,dskaddr	;DEST: disk
	lds	si,dosaddr
	rep	movsb
	ret
page

if KAYDISK
;
;Kaypro 2000:
;	Write a string to the screen. This also
;works on any IBM compatible, since it just 
;calls INT 10h. It could be used on ANY MSDOS
;machine, if you write a PUTC accordingly.
;
;Write a nul terminated string to the screen.
;
puts:	lodsb
	or	al,al
	jz	ps1
	call	putc
	jmp	puts
ps1:	ret
;
;Write a character to the screen. IBM 
;dependent.
;
putc:	push	si
	mov	bl,7
	mov	bh,0
	mov	ah,14
	int	10h
	pop	si
	ret

ENDIF

ife KAYDISK
;
;MSDOS RAM Disk:
;	Convert a string into an integer in 
;DX. Skips leading spaces and such. Stops at 
;the first nondigit found.
;
buff db 80 dup (?)	;string space

atoi:	mov	si,offset buff
	mov	dx,0	;initial number
	cld
a0:	lodsb		;skip leading
	call	pac	;non-digits
	jnc	a1	;look for a digit
	cmp	al,NUL	;exit if NUL
	jne	a0
	jmp	az

a1:	push	ax	;save new digit
	add	dx,dx	; * 2,
	mov	ax,dx	; (save * 2)
	add	dx,dx	; * 4,
	add	dx,dx	; * 8,
	add	dx,ax	; dx * 8 + dx * 2
	pop	ax
	add	dx,ax	; + digit
	lodsb		;get next char,
	call	pac	;process it,
	jnc	a1	;repeat
az:	ret
;
;Process a character for atoi(). Return carry
;set if its not a digit. If it is a digit,
;strip the ASCII from it.
;
pac:	cmp	al,NUL	;check for nul ...
	stc
	jz	pz
	xor	ah,ah	;zap upper byte
	sub	al,'0'	;convert digits
	jc	pz
	cmp	al,10
	cmc		;flip carry
pz:	ret

ENDIF

code ends
;
;Dummy segment to find the endof the driver
;code. LINK puts GROUPS in (!) alphabetical
;order.
;
zgroup group zzz
zzz segment byte public 'zzz'
zzz ends

	end	codestart
