#include <stdio.h>

/* zippy.c
 * 
 * Print a quotation from Zippy the Pinhead.
 * Qux <Kaufman-David@Yale> March 6, 1986
 * 
 */

#define void int
#define BUFSIZE  2000
#define SEP      '|'

main (argc, argv)
     int argc;
     char *argv[];
{
  FILE *fp;
  char *file;
  void yow();
  void srand();
  unsigned long timesecs();
  FILE *fopen();
  char *envfind();

  /* try to find YOW quotes filename in environment.  If not found, default to
     file called "yowlines" in current directory. */

  if ((file=envfind("YOW"))==NULL) file="yowlines";

  if ((fp = fopen(file, "r")) == NULL) {
    fprintf(stderr, "Yow!  Can't open quotes file %s\n", file);
    exit(1);
  }

  /* initialize random seed from clock */
  srand(timesecs());

  yow(fp);
  fclose(fp);
  exit(0);
}

void yow (fp)
     FILE *fp;
{
  static long len = -1;
  long offset;
  int c, i = 0;
  char buf[BUFSIZE];
  long rand();
  long fseek(), ftell();

  /* Get length of file, go to a random place in it */
  if (len == -1) {
    if (fseek(fp, 0L, 2) == -1) {
      fprintf(stderr, "Yow!  fseek 1 failed");
      exit(1);
    }
    len = ftell(fp);
  }
  offset = (rand()/1000) % len;
  if (fseek(fp, offset, 0) == -1) {
    fprintf(stderr, "Yow!  fseek 2 failed");
    exit(1);
  }

  /* Read until SEP, read next line, print it.
     (Note that we will never print anything before the first seperator.)
     If we hit EOF looking for the first SEP, just recurse. */
  while ((c = getc(fp)) != SEP)
    if (c == EOF) {
      yow(fp);
      return;
    }

  /* Skip leading whitespace, then read in a quotation.
     If we hit EOF before we find a non-whitespace char, recurse. */
  while (isspace(c = getc(fp)))
    ;
  if (c == EOF) {
    yow(fp);
    return;
  }
  buf[i++] = c;
  while ((c = getc(fp)) != SEP && c != EOF) {
    buf[i++] = c;

    if (i == BUFSIZE-1)
      /* Yow! Is this quotation too long yet? */
      break;
  }
  buf[i++] = 0;
  printf("%s\n", buf);
}

