	TITLE	CPU2
;
; CPU2 WAS TAKEN FROM PUBLIC DOMAIN AND MODIFIED TO PROVIDE
; A REPRESENTATIVE INSTRUCTION MIX FOR QUANTIFYING SPEED
; OF ONE'S 8086/8088/80186/80286 COMPUTER IN TERMS OF STANDARD
; IBM-PC. RESULT IS IN EFFECTIVE CLOCK RATE (I.E. YOUR COMPUTER
; RUNS AS FAST AS AN IBM PC WITH THE FOLLOWING CLOCK RATE)
;
; (ADDED SIEVE OF ERATOSTHENES BENCHMARK WITH TIMER TO PROVIDE
; AN ADDITIONAL BENCHMARK) - KIM LEVITT (MBBS HQ PDSE (213) 653-6398)
;
; (SOURCE FOR CPU BENCHMARK AND SIEVE COPIED FROM MICRO/SYSTEMS
; JOURNAL NOV/DEC 1985 ISSUE, ARTICLE: "TURBO CHARGE YOUR 8086/8088
; COMPUTER" BY STEPHEN R. DAVIS, ROUTE 5 BOX 107K, GREENVILLE, TX 75401)
;

LF	EQU	0AH
CR	EQU	0DH
HUNDRED	EQU	64H
THOUSAND EQU	3E8H
TEN	EQU	0AH

NTIMES 	EQU	8190		;STANDARD SIZE
NLOOPS	EQU	10		;TEN ITERATIONS STANDARD

CSEG	SEGMENT PUBLIC PARA
	ASSUME CS:CSEG,DS:CSEG,SS:CSEG,ES:NOTHING
	ORG	100H

; FIRST OUTPUT A 'WAIT A MINUTE' MESSAGE AND THEN GET TIME

START:
	MOV	AH,9
	MOV	DX,OFFSET INIT_MSG
	INT	21H

	MOV	AH,2CH
	INT	21H

	MOV	TIME1,DX
	STI			;BE SURE CLOCK IS RUNNING

;HERE IS THE BIG TIMING LOOP

	XOR	AX,AX
	MOV	DX,TEN

OUTERLOOP:

	MOV	CX,03B84H	;THIS NUMBER MUST BE AD-
				;JUSTED FOR DIFFERENT MIXES
TIMERLOOP:

;MY MIX OF REPRESENTATIVE, USEFUL INSTRUCTIONS -
;USER MAY PROVIDE HIS OWN AND REASSEMBLE, BEING CAREFUL
;TO ADJUST CONSTANT ABOVE FOR TOTAL NUMBER

	MOV	AX,BX		;REGISTER TO REGISTER MOVE
	MOV	AX,BX		;(FAR AND AWAY MOST COMMON)
	MOV	AX,BX
	MOV	AX,BX
	MOV	AX,BX
	MOV	AX,BX

	MOV	AX,10[BX]	;COMPLEX ADDRESSING
	MOV	AX,10[BX]	;(PRETTY COMMON)
	MOV	AX,10[BX]
	MOV	AX,10[BX]

	ADD	AX,AX		;REG-REG ARITHMETIC

	ADD	AX,10		;REG-IMMED ARITHMETIC

	PUSH	CX		;PUSH (POP FOLLOWS) ARE COMMON

	MOV	CL,5
	SHL	AX,CL
	POP	CX
	CALL	DUMMY_ROUTINE	;THESE CALLS/JUMPS SHOULD ALSO
				;FAVOR NEC
	JMP	CONTINUE

DUMMY_ROUTINE PROC NEAR
	RET
DUMMY_ROUTINE ENDP

CONTINUE:
	LOOP	TIMERLOOP
	DEC	DX
	JNZ	OUTERLOOP

; NOW GET TIME AGAIN (AFTER LOOP)

	MOV	AH,2CH
	INT	21H

; OK - CONVERT THIS INTO CLOCK SPEED RELATIVE TO 8088
; AND OUTPUT IN ASCII FORM

	MOV	AX,HUNDRED
	IMUL	DH
	MOV	DH,0
	ADD	AX,DX
	MOV	BX,AX
	MOV	DX,TIME1

	MOV	AX,HUNDRED
	IMUL	DH
	MOV	DH,0
	ADD	AX,DX
	SUB	BX,AX
	JNB	SKIP
	ADD	BX,1770H
SKIP:
	MOV	AX,BX
	MOV	TIME2,BX
	MOV	BP,OFFSET VALUE1
	MOV	BX,THOUSAND
	CWD
	IDIV	BX
	CALL	CONVERT2NUM	;CONVERT FIRST VALUE & STORE
	MOV	BX,HUNDRED	;HUNDREDS DIGIT
	MOV	AX,DX
	CWD
	IDIV	BX
	CALL	CONVERT2NUM
	INC	BP
	MOV	BX,TEN		;TENS DIGIT
	MOV	AX,DX
	CWD
	IDIV	BX
	CALL	CONVERT2NUM
	MOV	AX,DX
	CALL	CONVERT2NUM

	MOV	AH,9
	MOV	DX,OFFSET RES_MSG
	INT	21H

	MOV	AX,12A2H/TEN	;CALCULATE EFFECTIVE CLOCK RATE
	CWD
	MOV	BX,TIME2
	DIV	BX
	MOV	BP,OFFSET VALUE2
	CALL	CONVERT2NUM	;TENS DIGIT
	MOV	AX,DX
	MOV	CX,TEN
	MUL	CX
	DIV	BX
	CALL	CONVERT2NUM	;ONES DIGIT
	INC	BP
	MOV	AX,DX
	MUL	CX
	DIV	BX
	CALL	CONVERT2NUM	;TENTHS DIGIT
	MOV	AX,DX
	MUL	CX
	DIV	BX
	CALL	CONVERT2NUM	;HUNDRETHS DIGIT

	MOV	AH,9
	MOV	DX,OFFSET RES_MSG2
	INT	21H

	MOV	AH,9
	MOV	DX,OFFSET INIT_MSG2
	INT	21H

	MOV	AH,2CH
	INT	21H

	MOV	TIME1,DX
	STI			;BE SURE CLOCK IS RUNNING
START2:
	MOV	LOOP_CNT,NLOOPS	;INIT LOOP COUNTER
OUTER_LOOP:
	XOR	AX,AX		;FIRST ZERO OUT FLAG ARRAY
	MOV	DI,OFFSET ARRAY
	MOV	CX,NTIMES/2
	CLD
	REP	STOSW
				;NOW COUNT THE PRIMES
	XOR	DX,DX		;KEEP THE COUNT IN DX
	XOR	BX,BX		;START AT SUBSCRIPT 0
	MOV	CX,NTIMES	;GET THE LOOP COUNT
	MOV	DI,CX
INNER_LOOP:
	CMP	BYTE PTR ARRAY[BX],0
	JNZ	SKIP_AROUND
	MOV	AX,BX
	ADD	AX,BX
	ADD	AX,3
	MOV	PRIME,AX
	MOV	SI,BX		;NOW MARK OUT MULTIPLES
	ADD	SI,AX
MARK_OUT:
	MOV	BYTE PTR ARRAY[SI],0FFH ;MARK THIS MULTIPLE OUT
	ADD	SI,AX
	CMP	SI,DI		;IS THAT IT
	JNA	MARK_OUT
	INC	DX		;INCREMENT PRIME NUMBER COUNT
SKIP_AROUND:
	INC	BX
	LOOP	INNER_LOOP
	MOV	COUNT,DX	;NOW COUNT IS IN DX REGISTER
	DEC	LOOP_CNT	;DO IT TEN TIMES
	JNZ	OUTER_LOOP

; NOW GET TIME AGAIN (AFTER LOOP)

	MOV	AH,2CH
	INT	21H

; OK - CONVERT THIS INTO REAL TIME
; AND OUTPUT IN ASCII FORM

	MOV	AX,HUNDRED
	IMUL	DH
	MOV	DH,0
	ADD	AX,DX
	MOV	BX,AX
	MOV	DX,TIME1

	MOV	AX,HUNDRED
	IMUL	DH
	MOV	DH,0
	ADD	AX,DX
	SUB	BX,AX
	JNB	SKIP2
	ADD	BX,1770H
SKIP2:
	MOV	AX,BX
	MOV	TIME2,BX
	MOV	BP,OFFSET VALUE3
	MOV	BX,THOUSAND
	CWD
	IDIV	BX
	CALL	CONVERT2NUM	;CONVERT FIRST VALUE & STORE
	MOV	BX,HUNDRED	;HUNDREDS DIGIT
	MOV	AX,DX
	CWD
	IDIV	BX
	CALL	CONVERT2NUM
	INC	BP
	MOV	BX,TEN		;TENS DIGIT
	MOV	AX,DX
	CWD
	IDIV	BX
	CALL	CONVERT2NUM
	MOV	AX,DX
	CALL	CONVERT2NUM

	MOV	AH,9
	MOV	DX,OFFSET RES_MSG3
	INT	21H

	MOV	AH,4CH		;TERMINATE
	INT	21H

CONVERT2NUM:
	OR	AL,30H		;'0'
	MOV	[BP+0],AL
	INC	BP
	RET

INIT_MSG EQU	$
	DB	CR,LF
	DB	'CPU2: SPEED CHECKER/BENCHMARK PROGRAM',CR,LF
	DB	'01/07/86 -- Stephen R. Davis, Kim Levitt',CR,LF
	DB	CR,LF
	DB	'BENCHMARK #1: - Mixed Instruction Repetition',CR,LF
	DB	CR,LF
	DB	'  Please wait...',CR,LF
	DB	CR,LF,'$'

RES_MSG	EQU	$
	DB	'  Execution time is 10.00 secs on a 4.77 Mhz 8088',CR,LF
	DB	'    with no waits on RAM access.',CR,LF
	DB	CR,LF
	DB	'  Actual execution time here = '
VALUE1	DB	'00.00'
	DB	' seconds.',CR,LF,'$'

RES_MSG2 EQU	$
	DB	'  Effective 8088 clock speed = '
VALUE2	DB	'00.00'
	DB	' Mhz',CR,LF
	DB	CR,LF,'$'

INIT_MSG2 EQU	$
	DB	'BENCHMARK #2 - Sieve of Eratosthenes, 10 reps',CR,LF
	DB	CR,LF 
	DB	'  Please wait...',CR,LF
	DB	CR,LF,'$'

RES_MSG3 EQU	$
	DB	'  Execution time is 3.68 secs on a 4.77 Mhz 8088',CR,LF
	DB	'    with no waits on RAM access.',CR,LF
	DB	CR,LF
	DB	'  Actual execution time here = '
VALUE3	DB	'00.00'
	DB	' seconds.',CR,LF,'$'

;DEFINE OUR VARIABLES DOWN HERE

TIME1	DW	0000
TIME2	DW	0000

LOOP_CNT DW	0
PRIME	DW	0
COUNT	DW	0
ARRAY	DB 	NTIMES DUP (0)

CSEG	ENDS

	END	START
