/* Uses DOS functions to search for matching files.
   The file/path name is given as an argument on the first call. On
   subsequent calls, NULL signals that the prior search is to continue.
   The function returns a pointer to the DTA structure.
   NULL is returned when the search is complete. */

/* Copyright 1986 John Navas II, All Rights Reserved.
FILESRCH is made available for personal, non-commercial use only.  You
are granted a limited license to use FILESRCH, and to copy it and
distribute it, provided that no fee is charged for such copying and
distribution, and that it is ONLY distributed in its original,
unmodified state. */

/* Language: Microsoft C Version 3.00 */

#include <dos.h>
#include <stdio.h>

#define FA_RDONLY	0x01				/* file attributes */
#define FA_HIDDEN	0x02
#define FA_SYSTEM	0x04
#define FA_VOLABL	0x08
#define FA_SUBDIR	0x10
#define FA_ARCHIV	0x20

struct FILESRCH_DTA {					/* struct for filesrch routine */
	char dosarea[ 21 ];
	unsigned char attrib;
	unsigned int time;
	unsigned int date;
	unsigned long size;
	char filename[ 13 ];
	} ;

struct FILESRCH_DTA *filesrch( fn, at )		/* FIND MATCHING FILES */
char *fn;									/* filename (NULL = continue) */
int at;										/* attribute bits */
{
	static struct FILESRCH_DTA dta;
	union REGS reg;

	bdos( 0x1A, (unsigned int) &dta, 0 );

	reg.h.ah = ( fn != NULL ) ? 0x4E : 0x4F;
	reg.x.cx = (unsigned char) at;
	reg.x.dx = (unsigned int) fn;
	intdos( &reg, &reg );

	return reg.x.ax ? NULL : &dta;
	}
