
PAGE	60,132
TITLE  Dummy device driver to echo CONFIG.SYS comments

;------------------------------------------------------------------------------
;
; module name = comment.asm
;
; copyright(C) 1984	Skip Gilbrech
;			90 Lexington Ave. #10-G
;			New York, NY 10016
;			212-685-0551
;
; This code may be freely used and/or modified for any purpose, as long as
; appropriate credit is given.
;
; date written = 05/19/85
;
; change activity =
;
;   05/19/85 sg ny r1.0:	original date
;
; function = Echoes arguments passed on invoking CONFIG.SYS line
;		(doesn't stay resident)
;
; environment =
;   system = ibm pc (developed under pcdos 3.0 - requires 2.0 or above)
;
; processor = microsoft MASM (V3.0) macro assembler
;
;------------------------------------------------------------------------------

.lfcond

FALSE	equ	0
TRUE	equ	not FALSE

CR		equ	0dh	; carriage return
LF		equ	0ah	; line feed

; dos delimiters:

SPACE		equ	' '	; space, blank
COMMA		equ	','	;
SEMICOLON	equ	';'	;
EQUAL_SIGN	equ	'='	;
TAB		equ	9	; tab

; dos equates:

DOSINT		equ	21h	; interrupt number for dos functions
DISPLAY_OUT	equ	2	; display output

;------------------------------------------------------------------------------
;
;	EQUATES SPECIFIC TO DEVICE DRIVER
;
;------------------------------------------------------------------------------

; definitions for device header attribute bits:
ATTR_CHAR	equ	1000000000000000b	; bit 15
ATTR_BLOCK	equ	0			;
ATTR_IOCTL	equ	0100000000000000b	; bit 14
ATTR_NON_IBM	equ	0010000000000000b	; bit 13
ATTR_OP_CL_RM	equ	0000100000000000b	; bit 11
ATTR_CLOCK	equ	0000000000001000b	; bit 3
ATTR_NUL	equ	0000000000000100b	; bit 2
ATTR_STDOUT	equ	0000000000000010b	; bit 1
ATTR_STDIN	equ	0000000000000001b	; bit 0

; definitions for device driver command codes:

DRIVER_INIT		equ	0
MEDIA_CHECK		equ	1
BUILD_BPB		equ	2
IOCTL_INPUT		equ	3
INPUT			equ	4
INPUT_NO_WAIT		equ	5
INPUT_STATUS		equ	6
INPUT_FLUSH		equ	7
OUTPUT			equ	8
OUTPUT_WITH_VERIFY	equ	9
OUTPUT_STATUS		equ	10
OUTPUT_FLUSH		equ	11
IOCTL_OUTPUT		equ	12
DEVICE_OPEN		equ	13
DEVICE_CLOSE		equ	14
REMOVABLE_MEDIA		equ	15

; definitions for request header status error codes (bits 7-0):

WRITE_PROTECT		equ	0
UNKNOWN_UNIT		equ	1
DEVICE_NOT_READY	equ	2
UNKNOWN_COMMAND		equ	3
CRC_ERROR		equ	4
BAD_DRQ_STRUC_LENGTH	equ	5
SEEK_ERROR		equ	6
UNKNOWN_MEDIA		equ	7
SECTOR_NOT_FOUND	equ	8
PRINTER_OUT_OF_PAPER	equ	9
WRITE_FAULT		equ	10
READ_FAULT		equ	11
GENERAL_FAILURE		equ	12
INVALID_DISK_CHANGE	equ	15

; definitions for other request header status bits:

ERROR_BIT		equ	1000000000000000b	; bit 15
BUSY_BIT		equ	0000001000000000b	; bit 9
DONE_BIT		equ	0000000100000000b	; bit 8

;------------------------------------------------------------------------------

SUBTTL	Data Structures
PAGE

;------------------------------------------------------------------------------

; dos 2.0+ device header structure:

DEVICE_HDR struc
    DEV_NXT_HDR_OFST	dw	?
    DEV_NXT_HDR_SEG	dw	?
    DEV_ATTR		dw	?
    DEV_STRAT_OFST	dw	?
    DEV_INT_OFST	dw	?
    DEV_NAME_UNIT	db	8 dup (0)
DEVICE_HDR ends

; dos 2.0+ request header structure:

REQUEST_HDR	struc
    RQ_LEN		db	?
    RQ_UNIT_CODE	db	?
    RQ_CMD_CODE		db	?
    RQ_STATUS		dw	?
    RQ_DOS_RSVD		db	8 dup (?)
    RQD			db	?	; beginning of variable data area
REQUEST_HDR	ends

; extensions to request header for various operations (all start at RQD):

RQ_INIT	struc
    RQIN_NUM_UNITS	db	?
    RQIN_END_ADR	dd	?
    RQIN_BPB		dd	?
    RQIN_DRV_NUM	db	?
RQ_INIT	ends

RQ_IO	struc
    RQIO_MED_DESC	db	?
    RQIO_BUF_ADR	dd	?
    RQIO_COUNT		dw	?
    RQIO_START_SEC	dw	?
    RQIO_VOL_ID		dd	?
RQ_IO	ends

;------------------------------------------------------------------------------

SUBTTL	Data Area
PAGE

;------------------------------------------------------------------------------

CODE	segment
	assume	cs:CODE,ds:CODE

;------------------------------------------------------------------------------

ATTR	equ ATTR_BLOCK

; device header (Address 0000H in device driver)

COMMENT_HDR DEVICE_HDR <-1,-1,ATTR,STRAT_ROUT,INT_ROUT,>

even

SAVE_SP	dw	?			; for old stack
SAVE_SS	dw	?

STRAT_PTR	dd	?	; ptr to passed request header

;------------------------------------------------------------------------------

SUBTTL	Main Code Area
PAGE

;------------------------------------------------------------------------------
; save pointer to request header

STRAT_ROUT	proc far

	mov	word ptr cs:STRAT_PTR,bx		; store offset
	mov	word ptr cs:STRAT_PTR + 2,es		; and segment
	ret

STRAT_ROUT	endp

;------------------------------------------------------------------------------

INT_ROUT	proc far

	pushf
	push	ax			;

	mov	cs:SAVE_SS,ss		; save incoming stack
	mov	cs:SAVE_SP,sp		;

	mov	ax,cs			; get code seg in AX

	cli				; set up local stack
	mov	ss,ax			;
	mov	sp,offset STACK_TOP	;
	sti				;

	push	bx			;
	push	cx			;
	push	dx			;
	push	si			;
	push	di			;
	push	bp			;
	push	es			;
	push	ds			;

	mov	ds,ax			; set DS = CS
	les	si,STRAT_PTR		; point ES:SI to request header

					; don't bother to check command code

	push	es			; save req. hdr ptr
	push	si			;

	call	ECHO_COMMENTS		; process & echo comments

	pop	si			; restore req. hdr. ptr.
	pop	es			;

	; don't allow dos to install driver..

	sub	ax,ax			;
	mov	byte ptr es:[si].(RQD+RQIN_NUM_UNITS),al ; show 0 units
	mov	word ptr es:[si].(RQD+RQIN_END_ADR),ax	; set adr to beg. of code
	mov	word ptr es:[si].(RQD+RQIN_END_ADR+2),cs ;
	mov	word ptr es:[si].(RQD+RQIN_BPB),ax	; return null ptr to BPB
	mov	word ptr es:[si].(RQD+RQIN_BPB+2),ax	;
	mov	es:[si].RQ_STATUS,(ERROR_BIT or DONE_BIT or DEVICE_NOT_READY)

	pop	ds			;
	pop	es			;
	pop	bp			;
	pop	di			;
	pop	si			;
	pop	dx			;
	pop	cx			;
	pop	bx			;

	cli				; restore old stack
	mov	ss,word ptr cs:SAVE_SS	;
	mov	sp,word ptr cs:SAVE_SP	;
	sti				;

	pop	ax
	popf
	ret

INT_ROUT	endp

;------------------------------------------------------------------------------

ECHO_COMMENTS	proc near

	; copy parms from CONFIG.SYS command line to local buffer

	push	ds			; save data seg

	lds	si,es:[si].(RQD+RQIN_BPB) ; pt to passed parms
	mov	es,ax			; set ES = CS

	mov	di,offset PARM_BUF	; pt to local buf
	mov	cx,PARM_BUF_SIZE	;
	push	di			; save offset
	push	cx			; and num. bytes
	cld				; auto increment
rep	movsb				; get the buf
	pop	cx			; restore num. bytes
	pop	si			; get buffer offset in SI
	mov	di,si			; save offset in DI

	pop	ds			; restore data seg
ECHO_C_0:
	lodsb				; look for CR or LF - there's no NULL,
					;  contrary to documentation
	or	al,al			; NULL can follow filename in 2.0 or 2.1
	jnz	ECHO_C_1		; not 0, check for cr/lf
	mov	byte ptr [si-1],' '	; change the NULL to a space
					; (and fall through with 0 in AL)
ECHO_C_1:
	cmp	al,CR			;
	je	ECHO_C_2		;
	cmp	al,LF			;
	loopne	ECHO_C_0		; no match, loop back for count in CX

ECHO_C_2:
	mov	byte ptr [si-1],0	; end buffer with null
	mov	si,di			; point to beginning of comment string

	; bump SI past the filename

	call	SKIP_WHITE		; returns SI pointing to 1st non-white char
	call	SKIP_NON_WHITE		; returns SI pointing to 1st white char
	call	SKIP_WHITE		; returns SI pointing to 1st non-white char

	call	CK_LOWER		; check for lower-case escapes
	call	MSG			; print null terminated buffer
	ret

ECHO_COMMENTS	endp

;------------------------------------------------------------------------------
; returns SI pointing to 1st non-white char

SKIP_WHITE	proc near

	mov	al,[si]		; get byte
	cmp	al,SPACE	; space?
	je	SKIP_WHITE_1	; yes, try again
	cmp	al,TAB		; tab?
	jne	SKIP_WHITE_EXIT	; no, then it's non-white
SKIP_WHITE_1:
	inc	si		; bump ptr
	jmp	SKIP_WHITE	; and check next char.

SKIP_WHITE_EXIT:
	ret

SKIP_WHITE	endp

;------------------------------------------------------------------------------
; returns SI pointing to 1st white char

SKIP_NON_WHITE	proc near

	mov	al,[si]			; get byte
	or	al,al			; don't bump past null
	jz	SKIP_NON_WHITE_EXIT	;

	cmp	al,SPACE		; space?
	je	SKIP_NON_WHITE_EXIT	; yes, done
	cmp	al,TAB			; tab?
	je	SKIP_NON_WHITE_EXIT	; yes, done

	inc	si			; bump ptr
	jmp	SKIP_NON_WHITE		; and check next char.

SKIP_NON_WHITE_EXIT:
	ret

SKIP_NON_WHITE	endp

;------------------------------------------------------------------------------
; check for lower-case escapes ('\' character toggles translation)

LOWERING	equ	byte ptr [bp]

CK_LOWER	proc near
	push	bp		;
	sub	sp,2		; make room for stack var.
	mov	bp,sp		;
	mov	LOWERING,FALSE	; show not converting to lower case
	push	si		; save ptr to string beginning
CKL_1:
	mov	al,[si]		; get char
	or	al,al		; null?
	jz	CKL_EXIT	; yes, done
	cmp	LOWERING,FALSE	; converting to lower case?
	je	CKL_2		; no, continue
	call	LOWER		; make char in AL lower case
	mov	[si],al		; and store it
CKL_2:
	cmp	al,'\'		; escape char?
	jne	CKL_3		; no, loop back

	call	STR_CLOSE	; move the string down one
	cmp	byte ptr [si],'\'	; 'escaped' escape char?
	je	CKL_3		; just get next char..

	not	LOWERING	; otherwise, flip the flag
	jmp	CKL_1		; and process the char. at new SI pos
CKL_3:
	inc	si		; otherwise, bump ptr
	jmp	CKL_1		; & check next char
CKL_EXIT:
	pop	si
	add	sp,2
	pop	bp
	ret

CK_LOWER	endp

;------------------------------------------------------------------------------
; remove one char from the null-terminated string starting at SI

STR_CLOSE	proc near

	push	si

STR_CLOSE_1:
	mov	al,[si+1]	; get next char
	mov	[si],al		; store it
	or	al,al		; ending null?
	jz	STR_CLOSE_EXIT	; yes, done
	inc	si		; else, bump ptr
	jmp	STR_CLOSE_1	; and get next char

STR_CLOSE_EXIT:
	pop	si
	ret

STR_CLOSE	endp

;------------------------------------------------------------------------------
; make char in AL lower case

LOWER	proc near

	cmp	al,'A'		; check if upper case
	jb	LOWER_EXIT	; less than 'A', done
	cmp	al,'Z'		;
	ja	LOWER_EXIT	; greater than 'Z', done
	add	al,'a'-'A'	; convert to lower case
LOWER_EXIT:
	ret

LOWER	endp

;------------------------------------------------------------------------------
; print null-terminated msg (offset in DS:SI), end with CR/LF

MSG proc near

	cld			; auto-increment
MSG_1:
	lodsb			; get byte in AL
	or	al,al		; null?
	jz	MSG_EXIT	; yes, finished
	mov	dl,al		; get byte in DL
	mov	ah,DISPLAY_OUT	; function number
	int	DOSINT		;
	jmp	MSG_1		; get next char.
MSG_EXIT:
	mov	dl,CR		; end line with CR/LF
	mov	ah,DISPLAY_OUT	;
	int	DOSINT		;
	mov	dl,LF		;
	mov	ah,DISPLAY_OUT	;
	int	DOSINT		;
	ret

MSG endp

;------------------------------------------------------------------------------

;local stack for dos/device driver interface

even				; stack on even boundary

STACK_TOP	equ	$ + 100H
PARM_BUF	equ	STACK_TOP
PARM_BUF_SIZE	equ	256

CODE	ends

end
