PAGE	  64,132
TITLE	  RAMSET.ASM	PC-DOS DEVICE DRIVER TO INITIALIZE MEMORY
PAGE
COMMENT   \

    PROGRAM NAME:    RAMSET (Version 1.2 OCTOBER 1985)

	FUNCTION:    PC-DOS DEVICE DRIVER TO INITIALIZE RAM

	  AUTHOR:    MARK ALLEN BYRD, CDP	(312) 623-3833
		     38141 HOLDRIDGE AVENUE
		     WAUKEGAN, IL 60087

ACKNOWLEDGEMENTS:    DANIEL O'BRIEN, TOM PERRY
		     MARK FRANKLIN, DAVID BRADLEY

	   USAGE:    1) ASSEMBLE WITH IBM MACRO ASSEMBLER
		     2) LINK WITH PC-DOS LINKAGE EDITOR
		     3) CONVERT TO BIN FROM EXE WITH EXE2BIN
		     4) INSTALL IN CONFIG.SYS WITH DEVICE=RAMSET.SYS

	   NOTES:    DEVICE=RAMSET.SYS SHOULD BE THE FIRST STATEMENT
		     IN YOUR CONFIG.SYS FILE!

	ABSTRACT:    THE DRIVER IS TO BE CALLED AFTER BOOT BY IBMBIO.COM.
		     DRIVER INITIALIZATION WILL DISPLAY ANY PARMS INCLUDED
		     IN CONFIG.SYS AND OTHER SYSTEM INFORMATION, INCLUDING
		     THE INDICATED RAM SIZE,  THE DRIVER WILL THE SEARCH FOR
		     ADDITIONAL RAM STARTING AT THE ADDRESS INDICATED.

		     ANY ACTIVE RAM FOUND ABOVE THAT INDICATED WILL BE
		     INITIALIZED TO PREVENT POSSIBLE PARITY ERRORS.  THE
		     ACTUAL AMOUNT OF ACTIVE RAM WILL BE RESET IN THE
		     SYSTEM "CONTROL INFORMATION AREA" (@ 40:0013).  A BIOS
		     INTERRUPT IS USED TO RESET THE SYSTEM AND PICK-UP THE
		     MODIFIED CONTROL INFORMATION.

		     IF THE DRIVER RECOGNIZES THAT IT HAS ALREADY BEEN RUN, OR
		     THAT THE INDICATED MEMORY IS EQUAL TO ACTUAL MEMORY, THE
                     THE DRIVER TERMINATES, RELEASING MOST OF IT'S MEMORY.

		     MESSAGES ARE ISSUED INDICATING THE DRIVERS STATUS.


     APPLICATION:    THIS DRIVER HAS PRIMARY APPLICATION FOR AN IBM PC-1 WITH
		     THE ORIGINAL ROM BIOS CHIP.  A COMMON CONFIGURATION FOR
		     THIS MACHINE INCLUDES THE ADDITION OF BOTH 256k AND
		     384k MEMORY EXPANSION BOARDS.  THIS COMBINATION CAN
		     ALLOW UPTO 704k OF RAM TO BE PHISICALLY INSTALLED.

		     THE MEMORY MAP OF THE IBM PC SUPPORTS WORKING RAM THRU
		     640k.  THE NEXT TWO 64k BLOCKS ARE RESERVED FOR DISPLAY
		     ADAPTOR MEMORY.  UNLESS AN EXTENDED FUNCTION DISPLAY
                     ADAPTOR, SUCH AS IBM'S "EGA" IS INSTALLED, THE FIRST 64K
		     BLOCK OF THIS  ADDRESS SPACE CAN BE USED AS WORKING RAM.

                     THE PC'S POWER ON SELF TEST (POST) WILL ONLY TEST AND
		     THE AMOUNT OF MEMORY INDICATED BY SYSTEM BOARD SWITCHES.
		     IN A PC-1, THESE SWITCHES CAN ONLY BE USED TO INDICATE
		     544k.  IN NO MODEL WILL THE POST ALLOW THE INITIALIZATION
		     OF MEMORY GREATER THAN 640k.  ADDITIONALLY, THE POST
		     MEMORY INITIALIZATION CODE IN A PC-1 IS SLOW!

                     THIS DRIVER PERMITS SETTING THE PC'S SYSTEM BOARD SWITCHES
		     TO INDICATE LESS THAT THE ACTUAL AMOUNT OF INSTALLED RAM.
		     A SWITCH SETTING OF 64k EFFECTS THE FASTEST POSSIBLE
		     COMPLETION OF THE POST.


     USAGE NOTES:    THE AST "6-PACK" BOARD AND CLONES (BT-6, ETC.) WILL NOT
		     SUPPORT MEMORY ADDRESSES ABOVE 640k. IF THIS BOARD IS USED
                     IT MUST HAVE IT'S STARTING ADDRESS AT OR BELOW 320k.  THIS
		     IMPLIES A MEMORY BOARD MUST BE INSTALLED "ABOVE" THE 6-PACK
		     TO ACCESS 704k.

                     ONE COMMON BOARD IN EARLY PC'S IS THE SEATTLE "RAM+".  THIS
		     BOARD HAS A COUPLE OF PROBLEMS...	1) IT IS NOT COMPATIBLE
		     WITH THE BIOS UPGRADE CHIP.  2) THE SYSTEM SWITCHES MUST
		     BE USED TO INDICATE AT LEAST THE 1ST 64K IS PRESENT ON THE
		     BOARD.  IF THIS BOARD IS USED IN COMBINATION WITH AN AST
		     "6-PACK", SYSTEM BOARD SWITCHES MUST INDICATE 512k PRESENT.

	  \



;	  MACRO DEFINITIONS


MSG	  MACRO  TEXT
	  MOV	 DX,OFFSET TEXT
	  MOV	 AH,09h
	  INT	 21h
	  ENDM


PUSHALL   MACRO
	  PUSH	 DS
	  PUSH	 ES
	  PUSH	 AX
	  PUSH	 BX
	  PUSH	 CX
	  PUSH	 DX
	  PUSH	 DI
	  PUSH	 SI
	  ENDM

POPALL	  MACRO
	  POP	 SI
	  POP	 DI
	  POP	 DX
	  POP	 CX
	  POP	 BX
	  POP	 AX
	  POP	 ES
	  POP	 DS
	  ENDM



;	  STRUCTURE DEFINITIONS


RH	  EQU	 DS:[BX]	       ;BASE FOR RH STRUCTURE

RHSTRUC   STRUC
	  DB	 ?,?
COMMAND   DB	 ?
STATUS	  DW	 ?
	  DQ	 ?
UNITS	  DB	 ?
END_OFF   DW	 ?
END_SEG   DW	 ?
BPB_PTR   DD	 ?
	  DB	 ?
RHSTRUC   ENDS

CMD_INIT  EQU	 0		       ;RH COMMAND - INTIALIZE

STAT_DONE EQU	 01h		       ;RH STATUS  - DONE


;	  DEVICE DRIVER

CODE	  SEGMENT
	  ASSUME CS:CODE,DS:CODE,ES:CODE


;	  DEVICE DRIVER HEADER

	  DD	 -1		       ;NEXT DEVICE
	  DW	 8000h		       ;CHARACTER DEVICE
	  DW	 STRATEGY	       ;PTR TO DEVICE STRATEGY
	  DW	 INTERRUPT	       ;PTR TO DEVICE INTERRUPT HANDLER
DEV_NAME  DB     'RAMSETZZ'            ;DEVICE NAME


;	  WORK AREA

RH_PTR	  LABEL  DWORD		       ;REQUEST HEADER ADDRESS
RH_SEG	  DW	 0		       ;SEGMENT
RH_OFF	  DW	 0		       ;OFFSET


STRATEGY  PROC	 FAR		       ;DEVICE STRATEGY

	  MOV	 CS:RH_SEG,ES	       ;SAVE DEVICE REQUEST HEADER ADDRESS
	  MOV	 CS:RH_OFF,BX	       ;...
	  RET

STRATEGY  ENDP


INTERRUPT PROC	 FAR		       ;DEVICE INTERRUPT HANDLER

	  CLD			       ;CLEAR DIRECTION FLAGS
	  PUSHALL		       ;SAVE ALL REGISTERS

	  CALL	 MEMSET 	       ;GO TO IT !!!

	  MOV	 BX,RH_OFF	       ;ABORT DRIVER...
	  MOV	 AX,RH_SEG	       ;GET RH ADDRESS
	  MOV	 ES,AX		       ;
	  MOV	 DS,AX		       ;
	  MOV	 AX,OFFSET RELEASE     ;SET ENDING ADDRESS OFFSET
	  MOV	 RH.END_OFF,AX	       ;
	  MOV	 AX,CS		       ;SET ENDING ADDRESS SEGMENT = CS
	  MOV	 RH.END_SEG,AX	       ;
	  XOR	 AX,AX		       ;SET STATUS FOR "NO ERROR"
	  OR	 AH,STAT_DONE	       ;SET STATUS FOR "DONE"
	  MOV	 RH.STATUS,AX

	  POPALL		       ;RESTORE ALL REGISTERS
	  RET			       ;RETURN TO CALLER (DOS)

RELEASE   DB	 ?

INTERRUPT ENDP


MEMSET	  PROC	 NEAR
	  JMP	 START

CR	  EQU	 0dh		       ;ASCII CARRIGE RETURN
LF	  EQU	 0ah		       ;ASCII LINE FEED
BS	  EQU	 08h		       ;ASCII BACKSPACE

MEM_SIZE  DW			       ;INITIAL MEMORY SIZE
TEST_PARA DW			       ;CURRENT PARAGRAPH ADDRESS

MSG1	  DB	 "RAMSET (V1.02)  PC-DOS DEVICE DRIVER TO INITIALIZE MEMORY$"

MSG2	  DB	 CR,LF,LF,"DEVICE = "
DEV_PARM  DB	 80 DUP (?)
	  DB	 "$"

MSG3	  DB	 CR,LF,LF,"ROM BIOS DATE = "
ROM_DATE  DB	 "MM/DD/YY"
	  DB	 "$"

MSG4	  DB	 CR,LF,LF,"INDICATED MEMORY SIZE IS$"
KBYTE1	  DB	 "     ","k.","$"

MSG5	  DB	 "   ACTUAL MEMORY SIZE IS	      $"

KBYTE2	  DB	 BS,BS,BS,BS,BS,BS,BS
KBYTES	  DB	 "     ","k.$"

MSG6	  DB	 CR,LF,LF
	  DB	 "MEMORY SIZE ALTERED...  ASKING BIOS FOR RE-BOOT...$"

MSG7	  DB	 CR,LF,LF
	  DB	 "RAMSET COMPLETE !"
	  DB	 CR,LF,LF,"$"

START:
	  PUSH	 DS		       ;CHECK OUT THE
	  MOV	 AX,040h	       ;CONTROL INFORMATION AREA
	  MOV	 DS,AX		       ;IF THE
	  MOV	 BX,0f0H	       ;INTRA-APPLICATION COM AREA
	  MOV	 AX,[BX]	       ;IF WE FIND AN "!"
          CMP    AX,"!"                ;THEN WE'VE BEEN HERE BEFORE
	  JNE	 FIRST		       ;AND SHOULD SIMPLY TERMINATE
	  JMP	 FINISH
FIRST:
	  POP	 DS
	  MSG	 MSG1		       ;DISPLAY PROGRAM IDENTIFICATION

	  CALL	 GET_PARM	       ;GET DRIVER PARMS FROM CONFIG.SYS
	  MSG	 MSG2		       ;THEN DISPLAY IT...

	  CALL	 GET_ID 	       ;GET ROM IDENTIFICATION
	  MSG	 MSG3

	  MSG	 MSG4		       ;DISPLAY INDICATED MEMORY SIZE...

	  INT	 12h		       ;ROM BIOS MEMSIZE INTERRUPT
	  MOV	 MEM_SIZE,AX	       ;SAVE K-BYTES RETURNED IN AX

	  MOV	 BX,OFFSET KBYTE1      ;MEM SIZE ASCII STRING
	  CALL	 CNV_ASCII	       ;CONVERT TO ASCII
	  MSG	 KBYTE1 	       ;DISPLAY "K" BYTES
	  MSG	 MSG5		       ;DISPLAY ACTUAL MEMORY SIZE...

	  XOR	 AX,AX		       ;SET NMI MASK
	  OUT	 0a0h,AL	       ;TO DISABLE PARITY ERRORS

	  MOV	 AX,MEM_SIZE	       ;GET MEM SIZE IN K-BYTES
	  MOV	 CL,6		       ;SETUP SHIFT COUNT
	  SHL	 AX,CL		       ;SHIFT K-BYTES TO SEGMENT
	  MOV	 TEST_PARA,AX	       ;SAVE HIGH MEMORY PARAGRAPH ADDR

TESTMEM:
	  MOV	 BX,0		       ;SETUP INDEX
	  MOV	 AX,TEST_PARA	       ;GET ADDREDD OF PARAGRAPH TO TEST
	  CMP	 AX,0b000h	       ;ADDRESS OF THE DISPLAY ADAPTER? (704k)
	  JE	 SETRAM 	       ;YUP... AS FAR AS WE GO
				       ;NOPE... VALIDATE THE TEST PARAGRAPH
	  PUSH	 DS		       ;SAVE CURRENT PROGRAM DATA SEGMENT
	  MOV	 DS,AX		       ;GET ADDRESS OF CURRENT TEST PARAGRAPH
	  MOV	 [BX],AX	       ;WRITE TO IT...
	  MOV	 CX,[BX]	       ;READ IT BACK...
	  POP	 DS		       ;RESTORE CURRENT PROGRAM DATA SEGMENT
	  CMP	 AX,CX		       ;DID WE READ WHAT WE WROTE?
	  JNE	 SETRAM 	       ;NOPE...  ONE TOO MANY PARAGRAPHS

	  MOV	 CX,03fffh	       ;YUP...	INITIALIZE THIS PARAGRAPH
	  MOV	 ES,AX		       ;SETUP ES FOR A STRING OPERATION
          XOR    AX,AX                 ;SETUP TO STORE X'0000'
	  XOR	 DI,DI		       ;SETUP INITIAL OFFSET
	  REP	 STOSW		       ;STORE...

	  MOV	 AX,TEST_PARA	       ;GET LAST PARAGRAPH TESTED
	  MOV	 CL,6		       ;SETUP SHIFT COUNT
	  SHR	 AX,CL		       ;SHIFT PARAGRAPH TO K-BYTES
	  MOV	 BX,OFFSET KBYTES      ;MEM SIZE ASCII STRING
	  CALL	 CNV_ASCII	       ;CONVERT TO ASCII
	  MSG	 KBYTE2 	       ;DISPLAY "K" BYTES

	  MOV	 AX,TEST_PARA	       ;GET LAST PARAGRAPH USED
	  ADD	 AX,400h	       ;INCREMENT FOR NEXT PARAGRAPH
	  MOV	 TEST_PARA,AX	       ;SAVE NEW HIGH MEMORY PARAGRAPH
	  JMP	 TESTMEM	       ;GO TEST IT...

SETRAM:
	  MOV	 AL,80h 	       ;SET NMI MASK
	  OUT	 0a0h,AL	       ;TO ENABLE PARITY ERRORS

	  MOV	 AX,TEST_PARA	       ;GET LAST PARAGRAPH TESTED
	  MOV	 CL,6		       ;SETUP SHIFT COUNT
	  SHR	 AX,CL		       ;SHIFT PARAGRAPH TO K-BYTES
	  MOV	 BX,OFFSET KBYTES      ;MEM SIZE ASCII STRING
	  CALL	 CNV_ASCII	       ;CONVERT TO ASCII
	  MSG	 KBYTE2 	       ;DISPLAY "K" BYTES

	  MOV	 AX,TEST_PARA	       ;GET LAST PARAGRAPH TESTED
	  MOV	 CL,6		       ;SETUP SHIFT COUNT
	  SHR	 AX,CL		       ;SHIFT PARAGRAPH TO K-BYTES
	  PUSH	 DS		       ;SAVE CURRENT PROGRAM DATA SEGMENT
	  MOV	 BX,40h 	       ;POINT TO BIOS MEM_SIZE
	  MOV	 DS,BX
	  MOV	 BX,13h
	  CMP	 [BX],AX	       ;SAME AS WHAT WE JUST FOUND?
	  JE	 FINISH 	       ;THEN TERMINATE NORMALLY

	  MOV	 [BX],AX	       ;ELSE... UPDATE WITH NEW MEM_SIZE

	  MOV	 BX,0f0h	       ;GET OFFSET OF ICA
	  MOV	 AX,"!" 	       ;INDICATE THAT WE WERE HERE
	  MOV	 [BX],AX

	  POP	 DS		       ;RESTORE CURRENT PROGRAM DATA SEGMENT
	  MSG	 MSG6		       ;NOTIFY ABOUT RESET OF CONTROL BLOCKS
	  XOR	 AX,AX
	  INT	 19h		       ;ASK BIOS FOR RE-BOOT

FINISH:
	  POP	 DS		       ;RESTORE CURRENT PROGRAM DATA SEGMENT
	  MSG	 MSG7		       ;NOTIFY MEMORY SET CORRECTLY
	  RET			       ;RETURN TO CALLER

GET_PARM  PROC	 NEAR		       ;GET DEVICE DRIVER COMMAND LINE
	  PUSH	 DS		       ;SET UP DS/ES FOR STRING OPERATION
	  PUSH	 DS
	  POP	 ES		       ;ORIGIN...
	  MOV	 BX,RH_OFF	       ;SEGMENT = REQUEST HEADER
	  MOV	 AX,RH_SEG	       ;OFFSET	= BPB POINTER
	  MOV	 DS,AX
	  LDS	 SI,RH.BPB_PTR	       ;DESTINATION...
	  MOV	 DI,OFFSET DEV_PARM    ;TEXT FOR MSG3
	  MOV	 CX,LENGTH DEV_PARM
GET_CHR:
	  LODSB 		       ;GET ONE CHARACTER
	  CMP	 AL,LF		       ;IS IT A LINE FEED?
	  JZ	 GET_LST	       ;YUP... END OF PARM
	  STOSB 		       ;NO...  STORE IT
	  LOOP	 GET_CHR	       ;       LOOP FOR NEXT CHARACTER
GET_LST:
	  POP	 DS		       ;POINT TO OUR DATA SEGMENT
	  MOV	 AX,"$" 	       ;TERMINATE THE PARM STRING
	  STOSB 		       ;WITH END MESSAGE CHARACTER
	  RET
GET_PARM  ENDP


GET_ID	  PROC	 NEAR		       ;GET ROM BIOS RELEASE DATE
	  PUSH	 DS		       ;SET UP DS/ES FOR STRING OPERATION
	  PUSH	 DS
	  POP	 ES
	  LEA	 DI,ROM_DATE
	  MOV	 AX,0f000h	       ;SEGMENT = ROM BIOS
	  MOV	 DS,AX
	  MOV	 SI,0fff5h	       ;OFFSET = RELEASE MARKER
	  MOV	 CX,8
	  REP	 MOVSB		       ;MOVE IT TO OUR DATA SEGMENT
	  POP	 DS
	  RET
GET_ID	  ENDP


CNV_ASCII PROC	 NEAR		       ;CONVERT BINARY TO ASCII

	  PUSH	 DX		       ;SAVE WORKING REGS
	  PUSH	 SI
	  MOV	 CX,5		       ;SETUP TO FILL ASCII STRING

CVA_FILL: MOV    BYTE PTR [BX],' '
	  INC	 BX
	  LOOP	 CVA_FILL

	  MOV	 SI,10		       ;SETUP DIVISOR FOR BASE 10

CVA_DVD:  SUB	 DX,DX		       ;CLEAR REMAINDER
	  DIV	 SI		       ;DIVIDE AX BY 10
          ADD    DX,'0'                ;CONVERT REMAINDER TO ASCII
	  DEC	 BX		       ;BACK THROUGH OR STRING
	  MOV	 [BX],DL	       ;STORE THE CHARACTER
	  INC	 CS		       ;COUNT CONVERTED CHARACTERS
	  OR	 AX,AX		       ;ANY BINARY LEFT?
	  JNZ	 CVA_DVD	       ;THEN DIVIDE AGAIN

	  POP	 SI		       ;RESTORE REGISTERS
	  POP	 DX
	  RET
CNV_ASCII ENDP


MEMSET	  ENDP

CODE	  ENDS
	  END
