/* Describe the parts required to make a bicycle. Firt the elementary parts
are given (basicpart). Then a description of various subassemblies.
Ask: ?-partsof( hub, P ). to get all the basic parts required to make a hub.
Ask: ?-partsof( bike, P ). for the whole bike. */


basicpart( rim ).
basicpart( rearframe ).
basicpart( gears ).
basicpart( nut ).
basicpart( spoke ).
basicpart( handles ).
basicpart( bolt ).
basicpart( fork ).

assembly( bike, [quant( wheel, 2 ), quant( frame, 1 )] ).
assembly( wheel, [quant( spoke, 20 ), quant( rim, 1 ), quant( hub, 1)] ).
assembly( frame, [quant( rearframe, 1), quant( frontframe, 1 ) ] ).
assembly( frontframe, [quant( fork, 1 ), quant( handles, 1 )] ).
assembly( hub, [quant( gears, 1 ), quant( axle, 1 ) ] ).
assembly( axle, [quant( bolt, 1 ), quant( nut, 2) ] ).

partsof( X, [X] ) :- basicpart( X ).
partsof( X, P ) :- assembly( X, Subparts ),
                   partsoflist( Subparts, P ).

partsoflist( [], [] ).
partsoflist( [quant( X,N ) | Tail ], Total ) :-
             partsof( X, Headparts ),
             partsoflist( Tail, Tailparts ),
             append( Headparts, Tailparts, Total ).

append( [], L, L ).
append( [X|L1], L2, [X|L3] ) :- append( L1, L2, L3 ).
