/*
Program written in Lattice C 2.14 by Adam Finnefrock  6/30/85
Diskette Labeller Program  -  DLAB
*/

#include "stdio.h"
#include "dos.h"
#include "util.h"


#define DIRSIZE		200
#define WIDE		5
#define CONDENSED	17
#define LLENGTH		1.4375
#define LSKIP		2
#define LLINES		(LLENGTH*12)
#define	LCOLUMNS	(LCHARS/13)


char *findfirst(),*findnext(),*strchr();
char *dta,*setdta();
char **dirlist();
char drive;
long bytesused(),bytesfree();


main()
{
	char *list[DIRSIZE],label[80];
	int i,files,valid=0;
	FILE *fp;
	float LWIDTH=4;
	int LWIDECHARS,LCHARS,linesofdata,lastline;
	char *s,c;



	dta=setdta((char *) getmem(0x80));

	printf("DISKETTE LABEL PROGRAM (DLAB)\n");
	printf("    created by Adam Finnefrock\n");
	if ((fp=fopen("prn:","w"))==NULL) {
		printf("Printer not working.\n");
		exit(1);
	}

	printf("\nDrive letter? ");
	while ((drive=toupper(getch())) <'A' || drive>'H')
		;
	putch(drive);
	printf("\nDo you have the FX-80 without the external tractor feed? ");
        while (! valid) {
		printf("N\b");
		c=toupper(getch());
		if (c=='Y' || c=='N' || c=='\r')
			valid=1;
	}
	putch(c);
        if (c=='Y')
		LWIDTH=LWIDTH - 0.4;

	LWIDECHARS=LWIDTH*WIDE;
	LCHARS=LWIDTH*CONDENSED;


	printf("\n\nInput a floppy diskette in %c: and press any key",drive);
	printf(" or press ESC to quit.\n");

	while (getch() !='\033') {
		dirlist(list);
		cls();
		for (i=0; list[i] !=NULL; ++i)
			;
		files=i;
		sort(list,files-1);
		column(list,files-1,20,stdout);
		printf("\n\n");
		linesofdata=(files-1)/LCOLUMNS +1;
		if (linesofdata > LLINES-5) {
			printf("Warning: the disk list may overrun the label size\n");
			printf("Are you sure you want to print it? ");
			while ((c=toupper(getch())) !='Y' && c !='N')
				;
			printf("%c\n",c);
			if (c == 'N')
				goto reloop;
		}


		printf("Press ESC to skip this disk.\n");
		printf("Label for disk: ");
		label[0]='\0';

		if (input(label,LWIDECHARS,' ','[',']') !=NULL) {
			fprintf(fp,"\033E\033G"); 	/* emphasized, double strike */
			fprintf(fp,"\016%s\n",label);	/* wide label */
			fprintf(fp,"\033F\033H");	/* no emphasized, no double strike */
			fprintf(fp,"\033S0\017");	/* condensed, superscript */
			fprintf(fp,"\033A\006");	/* half-line spacing */
			for (i=1; i<=LCHARS; ++i)
				fputc('-',fp);
			fputc('\n',fp);

			lastline=column(list,files-1,(int) max(linesofdata,LLINES-7),fp);
			for (i=lastline; i<=LLINES-7; ++i)	/* go to two spaces above bottom */
				fputc('\n',fp);			/*   if not there or beyond already */
			if (lastline <= LLINES-7) {		/* if room, print extra data */
				for (i=1; i<=LCHARS; ++i)
					fputc('-',fp);
				fputc('\n',fp);
				fprintf(fp,"FILES: %-6d BYTES FREE: %-10ld BYTES USED: %-10ld\n",files,bytesfree(),bytesused());
			}
			for (i=1; i<=LSKIP; ++i)	/* skip to new label */
				fputc('\n',fp);
			fprintf(fp,"\033T\022");	/* no superscript, no condensed */
			fprintf(fp,"\0332");		/* normal line spacing */
		}

reloop:		printf("\n\nInsert another disk and press any key");
		printf(" or press ESC to quit.\n");
	}
	fclose(fp);

}


column(list,lastitem,pagelen,outfile) /* return number of lines printed */
char *list[];
int lastitem,pagelen;
FILE *outfile;
{
	int i,j;

	for (i=0; i<=lastitem && i<pagelen; ++i) {
		for (j=i; j<=lastitem; j+=pagelen)
			fprintf(outfile,"%-13s",list[j]);
		fprintf(outfile,"\n");
	}
	return(i);
}



sort(list,lastitem)
char *list[];
int lastitem;
{
	int i,j;
	char *temp;

	for (i=lastitem-1; i>=0; --i)
		for (j=0; j<=i; ++j)
			if (strcmp(list[j],list[j+1])>0) {
				temp=list[j];
				list[j]=list[j+1];
				list[j+1]=temp;
			}
}



char **dirlist(directory)
				/* put simple directory
				   into sp. Returns pointer to
				   where next item might go. */
char *directory[];
{
	char *filename,*retfile,*name;

	filename=" :\\*.*";
	*filename=drive;

	if ((retfile=findfirst(filename)) !=NULL) {
		align(retfile);
		name=(char *) getmem((strlen(retfile)+1) *sizeof(char));
		if (name==NULL)
			outofmem();
		strcpy(name,retfile);
		*directory++ = name;
	}



	while ((retfile=findnext()) !=NULL) {
		align(retfile);
		name=(char *) getmem((strlen(retfile)+1) *sizeof(char));
		if (name==NULL)
			outofmem;
		strcpy(name,retfile);
		*directory++ = name;
	}

	*directory=NULL;
	return(directory);

}


align(s)				/* space out extension */
char *s;				/* NOTE: s should be 13 chars long */
{
	char *p;
	int period,from,to,last,i;

	p= strchr(s,'.');
	if (p !=NULL) {
		last=strlen(s)-1;
		period= p-s;
		while (last-period<3)
			s[++last]=' ';

		for (from=last, to=11; from >=period+1; --from,--to)
			s[to]=s[from];
		s[8]='.';
		for (i=period; i<8; ++i)
			s[i]=' ';
		s[12]='\0';
	}
}



char *findfirst(s)			/* NOTE: may ruin s */
char *s;
{
	union REGS *inregs;
	union REGS *outregs;

	inregs->x.dx=(short) s;		/* filename */
	inregs->x.cx=0;			/* atribute find all normal */
	inregs->h.ah=0x4E;		/* int 21h, FIND FIRST */
	intdos(inregs,outregs);
	if (outregs->x.ax==2 || outregs->x.ax==18)
		return(NULL);
	else
		return((char *) dta+30);

}

char *findnext()
{
	union REGS *inregs;
	union REGS *outregs;

	inregs->h.ah=0x4F;		/* int 21h, FIND NEXT */
	intdos(inregs,outregs);
	if (outregs->x.ax==18)
		return(NULL);
	else
		return((char *) dta+30);
}

char *setdta(p)
char *p;
{
	union REGS *inregs;
	union REGS *outregs;

	inregs->x.dx=(short) p;		/* dta area */
	inregs->h.ah=0x1A;		/* int 21h with 1Ah */
	intdos(inregs,outregs);
	return(p);
}

outofmem()
{
	cprintf("\r\nLABEL: Out of memory.\r\n");
	exit(2);
}


long bytesfree()
{
	union REGS *inregs;
	union REGS *outregs;
	int free_clusters,bytes_per_sector,sectors_per_cluster;
	long free_bytes;

	inregs->h.dl=drive-'A'+1;	/* drive */
	inregs->h.ah=0x36;		/* int 21h with 36h */
	intdos(inregs,outregs);

	sectors_per_cluster=outregs->x.ax;
	free_clusters=outregs->x.bx;
	bytes_per_sector=outregs->x.cx;

	free_bytes=free_clusters;
	free_bytes *= (sectors_per_cluster * bytes_per_sector);
	return(free_bytes);
}


long bytesused()
{
	union REGS *inregs;
	union REGS *outregs;
	int free_clusters,bytes_per_sector,sectors_per_cluster,total_clusters;
	long used_bytes;

	inregs->h.dl=drive-'A'+1;	/* drive */
	inregs->h.ah=0x36;		/* int 21h with 36h */
	intdos(inregs,outregs);

	sectors_per_cluster=outregs->x.ax;
	free_clusters=outregs->x.bx;
	bytes_per_sector=outregs->x.cx;
	total_clusters=outregs->x.dx;

	used_bytes=total_clusters-free_clusters;
	used_bytes *= (sectors_per_cluster * bytes_per_sector);
	return(used_bytes);
}


                 