;GETFIRST.ASM

;6.12.85
;4.29.85
;Hack of LIST547.ASM by Vern Buerg

comment ~

		Open the first matching file

On entry:
	

Uses:
	dta2		address of working dta
	dpathfilenm	ASCIIZ string from cmdline, w/*.* if any
	dpathfilenm_len	length of ASCIIZ string, w/o trailing zero

Error codes if CY set:
	2	File not found
	18	No more files
	

Writes to:

        fileptr		2 bytes before file name

Equates defined in PSPEQU.ASM:

psp_dta         equ     80H     ;80H-FFH;Default disk transfer area (128 bytes)
psp_cmlin_tail  equ     80H             ;Command line tail
psp_dta_res     equ     80H     ;80H-94H;21 reserved bytes for next find call
psp_dta_fattr   equ     95H     ;95H    ;attribute found (1 byte)
psp_dta_ftime   equ     96H     ;96H-97H;file's time (2 bytes)
psp_dta_fdate   equ     98H     ;98H-99H;file's date (2 bytes)
psp_dta_fsizlw  equ     9AH     ;9AH-9BH;file's size - low word (2 bytes)
psp_dta_fsizhw  equ     9CH     ;9CH-9DH;file's size - high word (2 bytes)
psp_dta_fnamext equ     9EH     ;9EH-A9H;file name.ext, no blanks (12 bytes)
psp_dta_fnxtzer equ     AAH     ;AAH    ;trailing zero, to make ASCIIZ (1 byte)

~       

;----------------------------------------------------------
;		constants and messages

newline		db	cr,lf,eos
gf_msg		db	cr,lf,'getfirst: ',eos
gn_msg		db	cr,lf,'getnext: ',eos

GETNEXT:                                ;Second entry point--for next file
;Note: not 3.0, which requires setting DS:DX
  
	        mov     dx,offset dta2          ;Reset DTA...bashed by EXEC
		mov	ah,1ah			;set DTA function call
        	int     21h
		jc	gn_err		

	        mov     ah,4FH                  ;Find Next call
	        int     21H
		jc	gn_err
		mov     si,fileptr              ;set ptr to drop in found name
	        jmp     getnext2                ;now continue with file ops

gn_err:
		push	ax			;save error code
		mov	dx,offset gn_msg
		mov	ah,9h			;print string function call
		int	21h			;ignore err ret, if any
		pop	ax			;restore error code
		call	errmsg
		stc
		ret 

GETFIRST	proc	near

		mov     dx,offset dta2  	;Reset DTA...bashed by EXEC
		mov	ah,1ah			;set DTA function call
		int	21h
		jnc	gf1
		jmp	gf_err_xit		

gf1:	        mov     dx,offset dpathfilenm   ;set to (*.*) ASCIIZ string
	        xor     cx,cx                   ;here, normal--change to include dirs
	        mov     ah,4EH                  ;Find First Matching File call
		int	21h
		jnc	gf2
		jmp	gf_err_xit

gf2:
						;check for leading dpath
		mov     si,offset dpathfilenm-1
	        add     si,dpathfilenm_len
	        mov     cx,dpathfilenm_len
	        std                     ;reverse direction, parse from the end

gf3:
		lodsb
		cmp	al,'\'		;end of path?
		je	gf4
		cmp	al,'/'		;alternate path delimiter
		je	gf4
		cmp	al,':'		;drive prefix?
		je	gf4
		loop	gf3
		dec	si

;this ptr two bytes before the file name?  Has word for KB buffer read count

gf4:		mov	fileptr,si

getnext2:                               ;enter here with next file name
gf5:		mov	di,si		;copy found file name 

;psp_dta_fnamext        equ     9EH     ;9EH-A9H;file name.ext, no blanks (12 bytes)
;point to the filename.ext portion in the DTA
;       Mov     SI,Offset DTA+30
;       mov     si,psp_dta_fnamext

	        mov     si,offset dta2+30
	        add     di,2                    ;back up to first char in file name
	        cld                             ;now forward direction

;now xfer the found filename.ext and overlay the wildcard portion of the dpath..
	        mov     cx,13                   ;max len of fname.ext, incl ".", 0

gf6:		lodsb
		stosb
		cmp	al,0
		loopne	gf6

;note that length now has to be updated if used (dpathfilenm_len)
gf7:  		
		sub	di,offset dpathfilenm+1
		mov	dpathfilenm_len,di
		
;		neg	cx
;		add	cx,13-1
;		mov	dpathfilenm_len,cx

gf8:
;insert test code to check file name:
		mov     dx,offset dpathfilenm
		mov     cx,dpathfilenm_len	;length of string
		mov     ah,40H			;write to file/dev function 
		mov     bx,1			;write to std out
		int     21H
		mov	dx,offset newline
		mov	ah,9h			;print string function call
		int	21h

gf_ok_xit:	
		clc
		ret

gf_err_xit:
		push	ax			;save error code
		mov	dx,offset gf_msg
		mov	ah,9h
		int	21h
		pop	ax
		call	errmsg
		stc
		ret

getfirst	endp

