{.HETURBO-UT.PAS : Pascal tools for application development            #}
{ * TURBO-UT.PAS ram/rom *                                }
{ * by Don Ramsey and Larry Romero *                   }
{ * March-April-May 1984 *                             }

program turbo_ut;

 {$I UT-MOD00.INC }   { load global variables }

{**********************************************************}
{*  Shell-Module 01                                       *}
{*  Purpose:            Misc. utilities and commands      *}
{**********************************************************}

 {$I UT-MOD01.INC }

{**********************************************************}
{*  Shell-Module 02                                       *}
{*  Purpose: Input procedures and commands.               *}
{*       These modules are required for use with          *}
{*       the Input Procedure but can be used any time.    *}
{**********************************************************}

 {$I UT-MOD02.INC }

{******************************************************************}
{*  Shell-Module 03                                               *}
{*  Purpose : Handle Variables for the Input procedure.           *}
{*      These routines handle all input for NEW variables and     *}
{*      CHANGES for old inputs. They handle all prompting,        *}
{*      defaults, and validation.                                 *}
{******************************************************************}

 {$I UT-MOD03.INC }

{******************************************************************}
{*  Shell-Module 04                                               *}
{*  Purpose : Provide a Lotus Type Menu.                          *}
{*      This routine handles all Menu Selections and Prompting    *}
{*      for a Lotus Menu. Ths programmer provides Selections      *}
{*      and prompts before calling the routine.                   *}
{*  Requires Global Procedures:                                   *}
{*      Set_Cap_Num, Ck_edit_key                                  *}
{******************************************************************}

 {$I UT-MOD04.INC }

{.pa}
{************************************************************}
{*  Source Code Module: UT-MOD90                            *}
{*  Purpose:            Main Menu Module : Program Control  *}
{************************************************************}

procedure ProgramExit;
 begin
   Clrscr; Center('This Program is about to end',1,11,80);
   highvideo; Center('Verify Ok (Y/N)',1,13,80); lowvideo;
   repeat
     Option; if not (Ch in ['Y','N']) then beep(350,150);
   until Ch in ['Y','N'];
 end;

procedure MainMenu;
 var I,Tab: integer;
     Okchoices: set of char;
  begin
   if First_run then
    begin
     ClrScr; HighVideo;
     Center('*** MAIN  MENU ***  ',1,4,80); LowVideo;
     for I:= 1 to 4 do  writeln('');
     Tab:= 25;
     writeln('':Tab,'<1> ');
     writeln('':Tab,'<2> '); writeln('');
     writeln('':Tab,'<3> ');
     writeln('':Tab,'<4> ');   writeln('');
     writeln('':Tab,'<5> ');
     writeln('':Tab,'<6> '); writeln('');
     writeln('':Tab,'<7> Exit the Program'); writeln('');
     Box(20,2,60,20,6);writeln('');
     SaveScreen; First_run:=false;
    end else FlashScreen;
    Set_Cap_num(' ','N',' '); Say_Cap_Num;
    Highvideo; Center('Press Your Selection',21,19,38); LowVideo;
    OKchoices:=['1'..'7'];
    repeat
      Option; if not (Ch in OKchoices) then Beep(350,150);
    until Ch in OKchoices;
    case Ch of
      '1' :  ;
      '2' :  ;
      '3' :  ;
      '4' :  ;
      '5' :  ;
      '6' :  ;
      '7' :  begin
               ProgramExit;
               if Ch='Y' then Exit := true;
             end;
    end; { case }
  end;

{**********************************************************}
{*              Program Starts Execution                  *}
{**********************************************************}

begin
  ClrScr; Exit:=false; First_run:=true;
  repeat
    MainMenu;
  until Exit = true;
end.
