           TITLE     'Wolfware Sample Program','Clear Part'

;--------------------------------------------------------------------;
;                         Clear Partial Screen                       ;
;                                                                    ;
; BASIC machine language subroutine to scroll or clear the entire    ;
; screen or just a window within it.                                 ;
;                                                                    ;
; Five integer parameters are passed from BASIC to the subroutine:   ;
; upper row, left column, lower row, right column, and number of     ;
; lines to scroll up.  Zero lines to scroll means clear the window.  ;
;                                                                    ;
; The following is example BASIC implementation, the program having  ;
; been assembled to the file CLP.BLD:                                ;
;                                                                    ;
; 10 DEF SEG                                  'BASIC data segment    ;
; 20 CLP$ = STRING$(255,0)                    'create string space   ;
; 30 CLP = VARPTR(CLP$)                       'string descriptor     ;
; 40 CLP = PEEK(CLP+1) + (PEEK(CLP+2) * 256)  'string data location  ;
; 50 BLOAD "CLP.BLD",CLP                      'load routine to CLP$  ;
; 60 '                                                               ;
; 70 'clear the entire screen                                        ;
; 80 A%=1:B%=1:C%=25:D%=80:E%=0               'set coordinates       ;
; 90 CALL CLP(A%,B%,C%,D%,E%)                 'call routine          ;
; 100 '                                                              ;
; 110 'scroll a 5 by 5 window in                                     ;
; 120 'the upper left corner up 2                                    ;
; 130 A%=1:B%=1:C%=5:D%=5:E%=2                'set coordinates       ;
; 140 CALL CLP(A%,B%,C%,D%,E%)                'call routine          ;
;                                                                    ;
; Due to a quirk of the BIOS function you cannot scroll just one row ;
; or one column.  The smallest window is two rows by two columns.    ;
; None of the values are checked, so the BASIC program better better ;
; make sure they're valid.                                           ;
;                                                                    ;
; The object code resulting from assembly is directly BLOADable from ;
; BASIC.  Since BLOADable programs are not directly executable, it   ;
; is a good idea not to use COM (the default) as the object file     ;
; extension.                                                         ;
;--------------------------------------------------------------------;

           PROC      FAR
BLANK_ATR  EQU       07H            ;screen attribute for blanked screen

;----- bload header

           ORG       0
           DB        0FDH           ;bload marker
           DW        0F000H,0       ;default load location
           DW        PROGRAM_SIZE   ;size

;----- load upper left row

           MOV       BP,SP          ;base for finding parameters
           MOV       SI,[BP+12]     ;parameter location
           MOV       CH,[SI]        ;load
           DEC       CH             ;decrement (make scale 0-24)

;----- load upper left column

           MOV       SI,[BP+10]     ;parameter location
           MOV       CL,[SI]        ;load
           DEC       CL             ;decrement

;----- load lower right row

           MOV       SI,[BP+8]      ;parameter location
           MOV       DH,[SI]        ;load
           DEC       DH             ;decrement

;----- load lower right column

           MOV       SI,[BP+6]      ;parameter location
           MOV       DL,[SI]        ;load
           DEC       DL             ;decrement

;----- load lines to scroll

           MOV       SI,[BP+4]      ;parameter location
           MOV       AL,[SI]        ;load

;----- scroll window

           MOV       BH,BLANK_ATR   ;attribute for blanked lines
           MOV       AH,6H          ;scroll function
           INT       10H            ;execute

           RET       10             ;exit, return to basic
           ENDP

