#include <dos.h>
#include <stdio.h>

union REGS regs;		/* register structure */

main()
{
	int	ret[4];
	int	r;

	cursize( 2, 4 );
	rd_mode( ret );
	printf("The current page is %d", ret[2]);
	set_page( 1 );
	clr_scrn( 1 );
	fillscrn( 1, 'X' );
	for( r = 0; r < 100; r++ ) {
		set_page( 1 );
		set_page( 0 );
		}

}

bios( ah, al, bx, cx, dx, xregs )
int   ah, al, bx, cx, dx, xregs[];
{
	regs.h.ah	= ah;
	regs.h.al	= al;
	regs.x.bx	= bx;
	regs.x.cx	= cx;
	regs.x.dx	= dx;

	int86( 0x10, &regs, &regs );

	xregs[0]	= regs.x.ax;
	xregs[1]	= regs.x.bx;
	xregs[2]	= regs.x.cx;
	xregs[3]	= regs.x.dx;

}

cursize( top, bottom )	/* change cursor size */
int top, bottom;
{
  int	dummy[4];

	top	= ( top		> 0 ) ? top	: 0 ;
	top	= ( top		< 13) ? top	: 13;
	bottom	= ( bottom	> 0 ) ? bottom	: 0 ;
	bottom	= ( bottom	< 13) ? bottom	: 13;
	bios( 1, 0, 0, (( top * 256 ) + bottom ), 0, dummy );
}

rd_mode ( ret_val )	/* read current screen mode */
int       ret_val[];
{
	int	prm[4];

	bios( 15, 0, 0, 0, 0, prm );
	ret_val[0] = prm[0] % 256;	/* mode number */
	ret_val[1] = prm[0] / 256;	/* cols on screen */
	ret_val[2] = prm[1] / 256;	/* active page nbr */

}

int set_mode ( mode )	/* set screen mode */
int            mode;
{
	int	dummy[4];

	if( mode < 0 || mode > 6 )
		return( 0 );

	bios( 0, mode, 0, 0, 0, dummy );
	return( 1 );

}

int set_page ( page )	/* set active page */
int	       page;
{
	int	tmp[4];

	rd_mode( tmp );

	if( tmp[0] == 7 )
		return( 0 );	/* page always 0 if monochrome disp. */

	if( page > 7 )
		return( 0 );			/* error */

	if( tmp[0] > 1 && page > 3 )		/* error */
		return( 0 );

	if( tmp[0] == 4 && page > 1 )		/* error */
		return( 0 );

	if( tmp[0] > 4 && page > 0 )		/* error */
		return( 0 );

	bios( 5, page, 0, 0, 0, tmp );
	return( 1 );				/* normal exit */

}

int fillscrn( page, chnbr )	/* fill screen with char # */
int	      page, chnbr;
{
	int	nch, tmp[4];

	rd_mode( tmp );
	nch = tmp[1] * 25;	/* nbr chars on screen */

	if( !home( page ) )
		return( 0 );

	bios( 10, chnbr, page * 256, nch, 0, tmp );
	return( 1 );

}

clr_scrn( page )		/* clear screen */
int	  page;
{
	int	rc;

	rc = fillscrn( page, 0x20 );
	return( rc );

}

int home( page )		/* home cursor in sel page */
int	  page;
{
	int	tmp[4];

	rd_mode( tmp );

	if( page > 7 )
		return( 0 );			/* error */

	if( tmp[0] > 1 && page > 3 )		/* error */
		return( 0 );

	if( tmp[0] == 4 && page > 1 )		/* error */
		return( 0 );

	if( tmp[0] > 4 && page > 0 )		/* error */
		return( 0 );

	bios( 2, 0, ( page * 256 ), 0, 0, tmp );
	return( 1 );				/* normal exit */

}

get_curs( page, xy )		/* get current cursor position */
int	  page, xy[];
{
	int	tmp[4];

	rd_mode( tmp );

	if( page > 7 )
		return( 0 );			/* error */

	if( tmp[0] > 1 && page > 3 )		/* error */
		return( 0 );

	if( tmp[0] == 4 && page > 1 )		/* error */
		return( 0 );

	if( tmp[0] > 4 && page > 0 )		/* error */
		return( 0 );

	bios( 3, 0, ( page * 256 ), 0, 0, tmp );

	xy[ 0 ] = tmp[ 3 ] / 256;	/* row */
	xy[ 1 ] = tmp[ 3 ] % 256;	/* col */
	xy[ 2 ] = tmp[ 2 ] / 256;	/* curs start */
	xy[ 3 ] = tmp[ 2 ] % 256;	/* curs end   */

	return( 1 );				/* normal exit */

}

int put_curs( page, row, col )		/* place cursor */
int	      page, row, col;
{
	int	tmp[4];

	rd_mode( tmp );

	if( page > 7 )
		return( 0 );			/* error */

	if( tmp[0] > 1 && page > 3 )		/* error */
		return( 0 );

	if( tmp[0] == 4 && page > 1 )		/* error */
		return( 0 );

	if( tmp[0] > 4 && page > 0 )		/* error */
		return( 0 );

	if( col > tmp[1] )
		return( 0 );			/* col too large */

	if( row > 24 )
		return( 0 );			/* row too large */

	bios( 2, 0, ( page * 256 ), 0, (( row * 256 ) + col), tmp );
	return( 1 );

}

clr_eol( page )			/* clear to end of line from
				  current cursor position	*/
int	 page;
{
	int	tmp[4], nc;

	rd_mode( tmp );
	nc = tmp[1];

	if( !get_curs( page, tmp ) )
		return( 0 );

	nc -= tmp[1];

	bios( 10, ' ', ( page * 256 ), nc, 0, tmp );
	return( 1 );

}

int clr_eos( page )		/* clear to end of screen from
				  current cursor position	*/
int	     page;
{
	int	tmp[4], nc;

	nc = tmp[1];

	if( !get_curs( page, tmp ) )
		return( 0 );

	nc *= ( 24 - tmp[0] + 1 );	
	nc -= tmp[1];

	bios( 10, ' ', ( page * 256 ), nc, 0, tmp );
	return( 1 );

}

char rd_char( page, attrib )	/* read char and attrib at
				  current cursor position	*/
int	      page, attrib;
{
	char	c;
	int	tmp[4];

	attrib = 0;

	if( page > 7 )
		return( 0 );			/* error */

	if( tmp[0] > 1 && page > 3 )		/* error */
		return( 0 );

	if( tmp[0] == 4 && page > 1 )		/* error */
		return( 0 );

	if( tmp[0] > 4 && page > 0 )		/* error */
		return( 0 );

	bios( 8, 0, ( page * 256 ), 0, 0, tmp );
	attrib = tmp[1];
	c = tmp[0] ;
	return( c );

}

char txt_attr( fg, bg, blink )		/* build text attribute byte */
int	       fg, bg, blink;
{
	char	f, b, bl;

	bl = blink * 128;
	b  = bg * 16;
	f  = fg & 15;
	bl = bl | b | f;
	return( bl );

}

int put_text( page, row, col, attrib, text )	/* writes a line
					of text at specified location */
int	      page, row, col;
char			      attrib, text[];
{
	int	tmp[4], p = 0;
	char	ch;

	if( attrib == 0 )
		attrib = 15;

	while( ch = text[ p++ ] ) {
		if( !put_curs( page, row, col++ ) )
			return( 0 );
		bios( 9, ch, ( page * 256 ) + attrib, 1, 0, tmp );
	}

}
