;		 LABEL WIZ
;	   LABEL MAKER ROUTINE
;	     BY KEN HOPKINS
;	     ELK GROVE, IL.
;
;THIS IS FREE FREEWARE. NO CONTRIBUTIONS ARE SOLICITED
;NOR ACCEPTED. IT IS SATISFACTION ENOUGH THAT MY
;BEGINNER'S KNOWLEDGE OF ASSEMBLER WAS USEFUL NOT ONLY
;TO ME, BUT TO ANOTHER PERSON AS WELL. ENJOY.
;
;
TITLE	  LABELWIZ
;----------------------------------------
DATASG    SEGMENT  PARA 'DATA'

MSG       DB 09,09,09, '  WELCOME TO LABEL WIZ',13,10,
          DB 09,09,09, ' ** By Ken Hopkins **',13,10,
          DB 09,09,09,'    Elk Grove, Ill. ',13,10,

          DB 13,10,09,09,' THIS PROGRAM WILL LET YOU PRINT A FIVE',13,10,
          DB 09,09,'LINE LABEL (1" X 3-1/2"), PRINT AS',13,10,
          DB 09,09,'MANY COPIES AS YOU WANT, THEN SAVE THE', 13,10,
          DB 09,09,'LABEL FOR FUTURE PRINTING.$'

INSTR     DB 13,10,09,09,' YOU CAN NOW ENTER 5 LINES OF TEXT YOU WANT',13,10,
          DB 09,09,'TO PRINT. TO LEAVE A LINE BLANK, JUST HIT THE',13,10,
          DB 09,09,'<ENTER> KEY. WHEN YOU ARE DONE THE PROGRAM WILL',13,10,
          DB 09,09,'PROMPT YOU TO PRINT OR SAVE THE LABEL.$'

LINE1     DB  27,?,27 DUP(' '),'$' ;buffer to store 5 lines of text
LINE2     DB  27,?,27 DUP(' '),'$' ;$ sign so we can print the buffer
LINE3     DB  27,?,27 DUP(' '),'$' ;with function 09 later
LINE4     DB  27,?,27 DUP(' '),'$'
LINE5     DB  27,?,27 DUP(' '),'$'

REDO      DB 13,10,13,10,09,09,'IS THIS THE LABEL YOU WANT TO PRINT? '
          DB '<Y>es/<N>o$'
COUNT     DB 13,10,13,10,09,09,'ENTER HOW MANY LABELS YOU WANT <MAXIMUM 99> $'
DIGIT1	  DB ?			  ;store 1st digit of number of labels

MULT	  DB 10h		  ;tens mulitiplier
ERR       DB 09,09,'CAUTION!! YOUR PRINTER IS NOT TURNED ON.',13,10,
          DB 09,09,'TURN PRINTER ON AND HIT SPACEBAR$'

RELOAD    DB 13,10,13,10,09,09,'DO YOU WANT TO LOAD A PREVIOUSLY SAVED LABEL ?'
          DB 13,10,09,09, '<Y>es/<N>o$'
SAVE      DB 13,10,13,10,09,09,'DO YOU WANT TO SAVE THIS LABEL?$'
AGAIN     DB 13,10,13,10,09,09,'DO YOU WANT ANOTHER LABEL ?? <Y>es/<N>o $'
PROMPTOUT DB 13,10,13,10,09,09,'ENTER DRIVE:FILENAME.EXT $'
PROMPTIN  DB 13,10,13,10,09,09,'ENTER DRIVE:FILENAME.EXT $'

FILE_NAME DB 14 DUP(' '),0             ;vacant space for drive:name.ext
				       ;ASCIIZ for disk routines
DATASG	  ENDS

CODESG    SEGMENT PARA 'CODE'
BEGIN	  PROC	 FAR
	  ASSUME CS:CODESG,DS:DATASG,ES:NOTHING

	  PUSH	 DS
	  MOV	 AX,0
	  PUSH	 AX		       ;set up normal DOS return
	  MOV	 AX,DATASG
	  MOV	 DS,AX

	  CALL	 PRINT_CK	       ;check printer - is it on?
	  CALL	 CLS		       ;clear screen

	  LEA	 DX,MSG 	      ;print welcome and menu
	  MOV	 AH,9
	  INT	 21H

	  LEA	 DX,RELOAD	      ;want to use previously stored label?
	  MOV	 AH,9
	  INT	 21H
	  MOV	 AH,0		      ;get answer
	  INT	 16H
          CMP    AL,'N'               ;did he say NO?
	  JE	 START		      ;if so, jump to return
          CMP    AL,'n'               ;allow lower case "n" also
	  JE	 START
	  LEA	 DX,PROMPTIN	      ;print name of file to load
	  MOV	 AH,9
	  INT	 21H

	  MOV	 CX,14		      ;name is 14 spaces long
NAMEIN:   MOV	 AH,01H 	      ;get each one
	  INT	 21H
	  CMP	 AL,0DH
	  JE	 FILE

	  MOV	 FILE_NAME[BX],AL     ;point to file name
	  INC	 BX		      ;get next digit of name
	  LOOP	 NAMEIN 	      ;loop back 14 times

FILE:	  LEA	 DX,FILE_NAME	      ;point to file name
	  MOV	 AH,3DH 	      ;open file
	  MOV	 AL,00		      ;file open for read only
	  INT	 21H
	  MOV	 BX,AX		      ;put handle in bx
	  MOV	 AH,3FH 	      ;read from file
	  MOV	 CX,26		      ;26 times
	  LEA	 DX,LINE1+3	      ;point to 1st line of text
	  INT	 21H
	  MOV	 AH,3FH 	      ;read from file
	  MOV	 CX,26		      ;etc.
	  LEA	 DX,LINE2+3
	  INT	 21H
	  MOV	 AH,3FH
	  MOV	 CX,26
	  LEA	 DX,LINE3+3
	  INT	 21H
	  MOV	 AH,3FH
	  MOV	 CX,26
	  LEA	 DX,LINE4+3
	  INT	 21H
	  MOV	 AH,3FH
	  MOV	 CX,26
	  LEA	 DX,LINE5+3
	  INT	 21H

	  MOV	 AH,3EH
	  INT	 21H		       ;close file

	  CALL	 DISPLAY	       ;display label
	  CALL	 BORDER 	       ;within border
	  JMP	 START2 	       ;skip choose function
START:				       ;just a label to have a place to start
	  CALL	 CHOOSE

START2:   LEA	 DX,REDO	       ;is this the label to print?
	  MOV	 AH,09
	  INT	 21H
	  MOV	 AH,0		       ;get answer
	  INT	 16H
          CMP    AL,'N'                ;did he say NO?
	  JE	 START		       ;yes so go again
          CMP    AL,'n'                ;allow lower case "n" also
	  JE	 START		       ;otherwise keep going

	  CALL	 PRINT		       ;print label
	  CALL	 DISKOUT	       ;save the label to disk

	  LEA	 DX,AGAIN	       ;print request for a new label
	  MOV	 AH,09
	  INT	 21H
	  MOV	 AH,0		      ;get answer
	  INT	 16H
          CMP    AL,'N'               ;did he say NO?
	  JE	 QUIT		      ;if not, jump to exit
          CMP    AL,'n'               ;allow lower case "n" also
	  JE	 QUIT

	  CALL	 ZERO		      ;zero buffer if another label
	  JMP	 START		      ;go again

QUIT:	  CALL	 CLS		      ;clear screen before exit
	  RET
BEGIN	  ENDP

CLS	  PROC	 NEAR		      ;clear screen function by
	  MOV	 AH,0		      ;setting monochrome screen
	  MOV	 AL,2
	  INT	 10H
	  RET
CLS	  ENDP

BORDER	  PROC	NEAR		       ;draw the frame for label
	  MOV	 AH,2
	  MOV	 DH,09		       ;set cursor position at top
	  MOV	 DL,20
	  MOV	 BH,0
	  INT	 10H
	  MOV	 AH,09
	  MOV	 AL,0CDH
	  MOV	 BH,00		       ;draw top line
	  MOV	 BL,0FH
	  MOV	 CX,30		       ;30 times
	  INT	 10H

	  MOV	 AH,2
	  MOV	 DH,15		       ;set cursor position at bottom
	  MOV	 DL,20
	  MOV	 BH,0
	  INT	 10H
	  MOV	 AH,09
	  MOV	 AL,0cdH	       ;draw another line
	  MOV	 BH,00
	  MOV	 BL,0fH
	  MOV	 CX,30		       ;30 times
	  INT	 10H

	  MOV	 AH,2
	  MOV	 DH,09
	  MOV	 DL,20		       ;position cursor at top left corner
	  MOV	 BH,0
	  INT	 10H

	  MOV	 AH,09
	  MOV	 Al,0C9H
	  MOV	 BH,00		       ;draw corner
	  MOV	 Bl,0fH
	  MOV	 CX,1
	  INT	 10H

	  MOV	 AH,2
	  MOV	 DH,09
	  MOV	 DL,50		       ;position cursor upper right corner
	  MOV	 BH,0
	  INT	 10H

	  MOV	 AH,09
	  MOV	 Al,0BBH
	  MOV	 BH,00		       ;draw corner
	  MOV	 Bl,0fH
	  MOV	 CX,1
	  INT	 10H

	  MOV	 AH,2
	  MOV	 DH,15		       ;position cursor lower left
	  MOV	 DL,20
	  MOV	 BH,0
	  INT	 10H

	  MOV	 AH,09
	  MOV	 Al,0C8H
	  MOV	 BH,00		       ;draw corner
	  MOV	 Bl,0fH
	  MOV	 CX,1
	  INT	 10H

	  MOV	 AH,2
	  MOV	 DH,15
	  MOV	 DL,50		       ;position cursor lower right
	  MOV	 BH,0
	  INT	 10H

	  MOV	 AH,09
	  MOV	 Al,0BCH
	  MOV	 BH,00		       ;draw corner
	  MOV	 Bl,0fH
	  MOV	 CX,1
	  INT	 10H

	  MOV	 AH,2
	  MOV	 DH,10
	  MOV	 DL,20		       ;position cursor upper left
	  MOV	 BH,0
	  INT	 10H

	  MOV	 AH,09
	  MOV	 Al,0BAH
	  MOV	 BH,00		       ;draw vertical line
	  MOV	 Bl,0fH
	  MOV	 CX,1
	  INT	 10H

	  MOV	 SI,04		       ;put 20 into counter

    LLN:  MOV	 AH,3		       ;read current cursor position
	  INT	 10H
	  INC	 DH		       ;increment row by 1
	  MOV	 AH,2		       ;position cursor
	  INT	 10H

	  MOV	 AH,09
	  MOV	 Al,0BAH
	  MOV	 BH,00		       ;draw vertical line
	  MOV	 Bl,0fH
	  MOV	 CX,1
	  INT	 10H

	  DEC	 SI		      ;decrement counter by 1
	  CMP	 SI,0		      ;is counter 0 yet?
	  JA	 LLN		      ;no, go back and draw another line

	  MOV	 AH,2
	  MOV	 DH,10
	  MOV	 Dl,50		      ;position cursor upper right
	  MOV	 BH,0
	  INT	 10H

	  MOV	 AH,09
	  MOV	 Al,0BAH
	  MOV	 BH,00		      ;draw vertical line
	  MOV	 Bl,0fH
	  MOV	 CX,1
	  INT	 10H

	  MOV	 SI,04		      ;put 20 into counter

    RLN:  MOV	 AH,3		      ;read cursor position
	  INT	 10H

	  INC	 DH		      ;increment row by 1
	  MOV	 AH,2
	  INT	 10H

	  MOV	 AH,09
	  MOV	 Al,0BAH
	  MOV	 BH,00		      ;draw vertical line
	  MOV	 BL,0FH
	  MOV	 CX,1
	  INT	 10H

	  DEC	 SI		      ;decrement counter by 1
	  CMP	 SI,0		      ;is counter 0 yet?
	  JA	 RLN		      ;no, go back and draw another line

	  RET
BORDER	  ENDP			      ;of of border drawing routine

DISPLAY   PROC	 NEAR
	  CALL	 CLS
	  MOV	 AH,2
	  MOV	 DH,10		       ;position cursor within label
	  MOV	 DL,21
	  INT	 10H

	  MOV	 DX,OFFSET LINE1+2     ;display 1st line
	  MOV	 AH,9H
	  INT	 21H
	  MOV	 AH,2
	  MOV	 DH,11		       ;move cursor to next line
	  MOV	 DL,21
	  INT	 10H
	  MOV	 DX,OFFSET LINE2+2     ;diplay 2nd line
	  MOV	 AH,9H
	  INT	 21H		       ;etc.
	  MOV	 AH,2
	  MOV	 DH,12
	  MOV	 DL,21
	  INT	 10H
	  MOV	 DX,OFFSET LINE3+2
	  MOV	 AH,9H
	  INT	 21H
	  MOV	 AH,2
	  MOV	 DH,13
	  MOV	 DL,21
	  INT	 10H
	  MOV	 DX,OFFSET LINE4+2
	  MOV	 AH,9H
	  INT	 21H
	  MOV	 AH,2
	  MOV	 DH,14
	  MOV	 DL,21
	  INT	 10H
	  MOV	 DX,OFFSET LINE5+2
	  MOV	 AH,9H
	  INT	 21H
	  RET
DISPLAY   ENDP

CHOOSE	  PROC	 NEAR		       ;get input for label
	  CALL	 ZERO
	  MOV	 AH,2
	  MOV	 DH,01	     ;position cursor within label
	  MOV	 DL,21
	  INT	 10H

	  LEA	 DX,INSTR	       ;print instructions
	  MOV	 AH,9
	  INT	 21H
	  CALL	 BORDER

	  MOV	 AH,2
	  MOV	 DH,10	     ;position cursor within label
	  MOV	 DL,21
	  INT	 10H

	  MOV	 DX,OFFSET LINE1       ;accept and store 1st line
	  MOV	 AH,0AH
	  INT	 21H

	  MOV	 AH,2
	  MOV	 DH,11		       ;position cursor for next line
	  MOV	 DL,21
	  INT	 10H

	  MOV	 DX,OFFSET LINE2       ;line 2, etc.
	  MOV	 AH,0AH
	  INT	 21H

	  MOV	 AH,2
	  MOV	 DH,12
	  MOV	 DL,21
	  INT	 10H

	  MOV	 DX,OFFSET LINE3
	  MOV	 AH,0AH
	  INT	 21H

	  MOV	 AH,2
	  MOV	 DH,13
	  MOV	 DL,21
	  INT	 10H

	  MOV	 DX,OFFSET LINE4
	  MOV	 AH,0AH
	  INT	 21H

	  MOV	 AH,2
	  MOV	 DH,14
	  MOV	 DL,21
	  INT	 10H

	  MOV	 DX,OFFSET LINE5
	  MOV	 AH,0AH
	  INT	 21H
	  RET
CHOOSE	  ENDP

PRINT	  PROC	 NEAR
	  CALL	 DIG2
STRT:	  PUSH	 BX		       ;save counter
	  MOV	 CX,27		       ;set loop for size of buffer
	  LEA	 SI,LINE1	       ;point to 1st line buffer
P1:
	  MOV	 DL,[SI]	       ;get 1st character
	  MOV	 AH,05		       ;select print routine
	  INT	 21H		       ;bios print
	  INC	 SI		       ;increment for next character
	  LOOP	 P1		       ;go back and get it
	  CALL	 LINEFD 	       ;add linefeed
	  MOV	 CX,27		       ;reset loop for size of buffer
	  LEA	 SI,LINE2	       ;point to next line
P2:
	  MOV	 DL,[SI]	       ;get 1st character, etc.
	  MOV	 AH,05		       ;select print routine
	  INT	 21H
	  INC	 SI
	  LOOP	 P2
	  CALL	 LINEFD
	  MOV	 CX,27
	  LEA	 SI,LINE3
P3:
	  MOV	 DL,[SI]
	  MOV	 AH,05
	  INT	 21H
	  INC	 SI
	  LOOP	 P3
	  CALL	 LINEFD
	  MOV	 CX,27
	  LEA	 SI,LINE4
P4:
	  MOV	 DL,[SI]
	  MOV	 AH,05
	  INT	 21H
	  INC	 SI
	  LOOP	 P4
	  CALL	 LINEFD
	  MOV	 CX,27
	  LEA	 SI,LINE5
P5:
	  MOV	 DL,[SI]
	  MOV	 AH,05
	  INT	 21H
	  INC	 SI
	  LOOP	 P5
	  CALL	 LINEFD
	  CALL	 LINEFD

	  POP	 BX		       ;get counter back from stack
	  DEC	 BX		       ;decrement it
	  CMP	 BX,00		       ;is it 0 yet?
	  JA	 STRT		       ;no, go back and print another label

	  RET
PRINT	  ENDP			       ;end print routine

LINEFD	  PROC	 NEAR
	  MOV	 AH,05		       ;select print routine
	  MOV	 DL,10		       ;10 = carriage return
	  INT	 21H		       ;bios print
	  RET
LINEFD	  ENDP

DIG2	  PROC	 NEAR
	  SUB	 BX,BX		       ;zero out bx as counter

	  LEA	 DX,COUNT	       ;print request for number of labels
	  MOV	 AH,9
	  INT	 21H

	  MOV	 AH,01		       ;accept 1st digit of number
	  INT	 21H
	  SUB	 AL,30h 	       ;adjust for ascii
	  MUL	 MULT		       ;mulitply 1st digit by ten
	  MOV	 DIGIT1,AL	       ;store result

	  MOV	 AH,01		       ;get 2nd digit
	  INT	 21H
	  CMP	 AL,0DH 	       ;is it a CR?
	  JE	 ONE		       ;need to adjust 1st digit if only one
	  SUB	 AL,30h 	       ;adjust for ascii
	  SUB	 BH,BH		       ;zero high byte of bx
	  MOV	 BL,DIGIT1	       ;get 1st digit
	  ADD	 BL,AL		       ;add second digit to it
	  JMP	 FIN		       ;go around routine to end
ONE:	  MOV	 AL,DIGIT1	       ;get 1st digit back
	  DIV	 MULT		       ;divide by 10 to cancel previous mult.
	  SUB	 BH,BH		       ;zero out high byte of bx
	  MOV	 BL,AL		       ;put digit in counter
	  SUB	 BL,10H 	       ;this is a kludge to get rid of a 10
FIN:	  RET			       ;that popped up somewhere
DIG2	  ENDP

DISKOUT   PROC	 NEAR

	  LEA	 DX,SAVE	       ;do we want to save the label?
	  MOV	 AH,09
	  INT	 21H
	  MOV	 AH,0		       ;get answer
	  INT	 16H
          CMP    AL,'Y'                ;did he say YES?
	  JE	 DISKO		       ;yes so jump to disk routine
          CMP    AL,'y'                ;allow lower case "y" also
	  JE	 DISKO
	  RET			       ;otherwise, return without disk
DISKO:
	  LEA	 DX,PROMPTOUT	       ;print disk prompt and request
	  MOV	 AH,9		       ;name for use of stored file
	  INT	 21H

	  MOV	 CX,14
NAMEOUT:  MOV	 AH,01H
	  INT	 21H
	  CMP	 AL,0DH
	  JE	 FILEST
	  MOV	 FILE_NAME[BX],AL
	  INC	 BX
	  LOOP	 NAMEOUT

FILEST:   MOV	 AH,3CH 	       ;create file
	  SUB	 CX,CX		       ;zero out number of bytes to write
	  LEA	 DX,FILE_NAME	       ;point to file name to create
	  INT	 21H

	  MOV	 AH,3DH 	       ;open file
	  MOV	 AL,01		       ;file open for writing only
	  INT	 21H

	  MOV	 BX,AX		       ;put handle in bx
	  MOV	 AH,40H 	       ;write to file
	  MOV	 CX,26		       ;26 times
	  LEA	 DX,LINE1+2	       ;point to 2nd line of text
	  INT	 21H
	  MOV	 AH,40H 	       ;write to file
	  MOV	 CX,26		       ;etc.
	  LEA	 DX,LINE2+2
	  INT	 21H
	  MOV	 AH,40H
	  MOV	 CX,26
	  LEA	 DX,LINE3+2
	  INT	 21H
	  MOV	 AH,40H
	  MOV	 CX,26
	  LEA	 DX,LINE4+2
	  INT	 21H
	  MOV	 AH,40H
	  MOV	 CX,26
	  LEA	 DX,LINE5+2
	  INT	 21H

	  MOV	 AH,3EH
	  INT	 21H		       ;close file
	  RET
DISKOUT   ENDP

PRINT_CK  PROC	 NEAR		       ;error check routine
	  JMP	 OK		       ;go to start of error routine
ERRMSG:   LEA	 DX,ERR 	       ;error message, turn printer on
	  MOV	 AH,09
	  INT	 21H
	  MOV	 AH,0		       ;hit any key to proceed
	  INT	 16H
OK:	  MOV	 AH,02		       ;test the printer
	  MOV	 DX,00		       ;get printer status
	  INT	 17H
	  CMP	 AH,90H 	       ;is it on?
	  JNE	 ERRMSG 	       ;no, go and print error message
	  RET
PRINT_CK  ENDP

ZERO	  PROC	 NEAR
	  MOV	 CX,27		       ;set loop for size of buffer
	  LEA	 SI,LINE1+2	       ;point to 1st line buffer
Z1:	  MOV	 AL,20H
	  MOV	 [SI],AL	       ;get 1st character

	  INC	 SI		       ;increment for next character
	  LOOP	 Z1		       ;go back and get it
	  MOV	 CX,27		       ;set loop for size of buffer
	  LEA	 SI,LINE2+2	       ;point to next line of buffer
Z2:	  MOV	 AL,20H
	  MOV	 [SI],AL	       ;get next character

	  INC	 SI		       ;increment for next character
	  LOOP	 Z2		       ;go back and get it
	  MOV	 CX,27		       ;set loop for size of buffer
	  LEA	 SI,LINE3+2	       ;etc.
Z3:	  MOV	 AL,20H
	  MOV	 [SI],AL

	  INC	 SI
	  LOOP	 Z3
	  MOV	 CX,27
	  LEA	 SI,LINE4+2
Z4:	  MOV	 AL,20H
	  MOV	 [SI],AL

	  INC	 SI
	  LOOP	 Z4
	  MOV	 CX,27
	  LEA	 SI,LINE5+2
Z5:	  MOV	 AL,20H
	  MOV	 [SI],AL

	  INC	 SI
	  LOOP	 Z5
	  CALL	 CLS
	  CALL	 BORDER
	  RET
ZERO	  ENDP

CODESG    ENDS                         ;that's all folks!
	  END	BEGIN
