; FLASH PRINT control program

	PAGE 60,132
CODE	SEGMENT
	ASSUME CS:CODE, DS:CODE, ES:CODE, SS:CODE

; COM file  e.i. assume IP = 100, SP = FFFE.
; Since this is a com file, it will be loaded in the lowest available memory
; and all of the memory will be allocated to this program. See page 4-2
; in Microsoft's Programmer's Reference Manual for all the other EXEC system
; call information.

KEYBOARD_NO_ECHO EQU	8		; msdos function call equates
DISPLAY_CHAR	EQU	2
DISPLAY_STRING	EQU	9
TERMINATE	EQU	4CH

CR			EQU	0DH
LF			EQU	0AH
BUFFER_INT_NUMBER	EQU	65H

	ORG 100H
BEGIN:
	JMP S1
; data
HEADER		DB "Seattle Computer Product's FLASH PRINT control program. Version 2.0",cr,lf,lf,"$"
NOT_INSTALLED	DB "FLASH PRINT is not installed.",cr,lf,"$"
NOT_VALID_PORT	DB "The output port does not exist",cr,lf,"$"
LINE1		DB "The number of characters in the buffer: $"
LINE2		DB "The size of the buffer in characters: $"
LINE3		DB "The port being used with the printer: $"
LINE4		DB "The priority of the printer (1 lowest, 200 highest): $"
MENU		DB CR,LF,"Choose the number of one of the following command options.",cr,lf
		DB "1.) Clear the buffer",cr,lf
		DB "2.) Change the port to use with the printer",cr,lf
		DB "3.) Change the priority",cr,lf
		DB "4.) Exit the program",cr,lf,"$"
NUMBER		DB "Number: ","$"
PORT_MENU	DB CR,LF,LF,"Choose the port to use with the printer.",cr,lf
		DB "1.) LPT1",cr,lf
		DB "2.) LPT2",cr,lf
		DB "3.) LPT3",cr,lf
		DB "4.) COM1",cr,lf
		DB "5.) COM2",cr,lf
		DB "6.) Exit the program",cr,lf,"$"
NOT_AVALIABLE	DB "The port chosen is not in the system",cr,lf,"$"
BUFFER_CLEARED	DB "The buffer is empty",cr,lf,"$"
NEW_PORT	DB "The new port to use with the printer is $"
LPT1_MESS	DB "LPT1",CR,LF,"$"
LPT2_MESS	DB "LPT2",CR,LF,"$"
LPT3_MESS	DB "LPT3",CR,LF,"$"
COM1_MESS	DB "COM1",CR,LF,"$"
COM2_MESS	DB "COM2",CR,LF,"$"
NEW_PRIORITY	DB "Input the new priority: $"
NOTHING_DONE	DB "Nothing was done",cr,lf,"$"
YOU_SURE	DB "You sure you what to clear the buffer? (y=yes) $"
CRLF		DB CR,LF,"$"
SPACE		DB "  $"
NOT_VALID_NUMBER DB cr,lf,"invalid number",cr,lf,"$"

PORT_NUMBER		DB ?
PORT_TYPE		DB ?
BUFFER_SIZE		DW ?
CHARACTERS_IN_BUFFER	DW ?
PRIORITY		DW ?
; end of data

; macros
PRINT	MACRO	MESSAGE
	MOV AH, DISPLAY_STRING
	MOV DX, OFFSET MESSAGE
	INT 21H
	ENDM

BUFFER_INPUT	MACRO	SIZE_OF_BUFFER
	LOCAL I2, BUFFER, NUM_OF_CHARS, BUFFER2
; This macro inputs characters from the keyboard with echo and stores them in memory.
; The string of characters is terminated with two bytes of 0.
; enter: ds = cs
; exit: al = # of characters typed not including the CR
;	ds:si -> first char. of the string typed

	JMP I2
BUFFER		DB SIZE_OF_BUFFER + 1
NUM_OF_CHARS	DB ?
BUFFER2		DB SIZE_OF_BUFFER DUP(?)
		DW ?
I2:
	MOV AH, 0AH			; buffer keyboard input
	MOV DX, OFFSET BUFFER
	INT 21H
	
	MOV AL, [NUM_OF_CHARS]		; end the string with 0,0
	MOV AH, 0
	MOV SI, OFFSET BUFFER2
	ADD SI, AX
	MOV [SI], WORD PTR 0
	SUB SI, AX
	
	ENDM
; end of macros

S1:
	PRINT HEADER			; print "Seattle Computer Product's FLASH PRINT ..."
	
	MOV AH, 35H			; get the buffer vector
	MOV AL, BUFFER_INT_NUMBER
	INT 21H				; es:bx = vector
	
	CMP BX, 0			; determine if the device driver is installed
	JNZ B1
	MOV AX, ES
	CMP AX, 0
	JNZ B1
	
	PRINT NOT_INSTALLED		; print "FLASH PRINT is not installed."
	JMP TERMIN_ATE
B1:
	MOV AX, CS			; restore es = cs
	MOV ES, AX

	MOV AX, 1			; get port # and type
	INT BUFFER_INT_NUMBER
	MOV [PORT_NUMBER], BL
	MOV [PORT_TYPE], BH
	
	MOV AX, 3			; get buffer size
	INT BUFFER_INT_NUMBER
	MOV [BUFFER_SIZE], BX
	
	MOV AX, 4			; get # of char. in the buffer
	INT BUFFER_INT_NUMBER
	MOV [CHARACTERS_IN_BUFFER], BX
	
	MOV AX, 6			; get the priority
	INT BUFFER_INT_NUMBER
	MOV [PRIORITY], BX

	PRINT LINE1			; print "The number of characters in the buffer:"
	
	MOV AX, [CHARACTERS_IN_BUFFER]
	CALL BIN2DEC
	CALL PRINTBXCXDX
	PRINT CRLF		
	
	PRINT LINE2			; print "The size of the buffer in characters:"
	
	MOV AX, [BUFFER_SIZE]
	CALL BIN2DEC
	CALL PRINTBXCXDX
	PRINT CRLF
	
	PRINT LINE3			; print "The port being used with the printer:"
	
	MOV AH, [PORT_TYPE]
	MOV AL, [PORT_NUMBER]	
	CALL PRINT_PORT
	
	PRINT LINE4			; print "The priority of the printer (1 lowest, 65536 highest):"
	
	MOV AX, [PRIORITY]
	CALL BIN2DEC
	CALL PRINTBXCXDX
	PRINT CRLF
		
	PRINT MENU			; print the menu
B2:	
	PRINT NUMBER			; print "Number: "
	
	MOV AH, KEYBOARD_NO_ECHO	; wait for a number to be typed
	INT 21H

	CMP AL, CR
	JE EXIT8
	
	PUSH AX				; echo every thing except cr
	MOV AH, DISPLAY_CHAR
	MOV DL, AL
	INT 21H

	PRINT SPACE			; print two spaces
	POP AX
	
	CMP AL, "1"			; jump to the correct command
	JE CLEAR_THE_BUFFER
	CMP AL, "2"
	JNE B23
	JMP CHANGE_PORT
B23:
	CMP AL, "3"
	JE CHANGE_PRIORITY
	CMP AL, "4"
	JE EXIT8
	JMP B2

EXIT8:
	PRINT CRLF
	JMP TERMIN_ATE

CLEAR_THE_BUFFER:
	PRINT YOU_SURE			; print "Are you sure you want to clear the buffer? (y=yes) "
	
	MOV AH, KEYBOARD_NO_ECHO	; wait for something to be typed
	INT 21H

	CMP AL, CR
	JE B245

	PUSH AX				; echo everything except cr
	MOV AH, DISPLAY_CHAR
	MOV DL, AL
	INT 21H
	
	PRINT SPACE			; print two spaces
	POP AX

	AND AL, 0DFH			; convert the something to upper case
	
	CMP AL, "Y"
	JE B25
B245:
	PRINT NOTHING_DONE		; print "Nothing was done"
	JMP TERMIN_ATE
B25:	
	MOV AX, 0			; flush the buffer
	INT BUFFER_INT_NUMBER

	PRINT BUFFER_CLEARED		; print "The buffer is empty"	
	JMP TERMIN_ATE

CHANGE_PRIORITY:
	PRINT NEW_PRIORITY		; print "Input the new priority"
	
	BUFFER_INPUT  5			; input max. of 5 character from the keyboard with echo
	CMP AL, 0			; if no characters were typed exit
	JNZ B26
	JMP TERMIN_ATE
B26:	
	CALL ASCBIN			; conver the ascii characters to binary
	PUSH AX	

	PRINT CRLF

	LODSB				; if the first non convertable character is a 0, then it was a good #.
	CMP AL, 0
	POP AX
	JNZ B265

	CMP AX, 0			; the priority must be between 1 and 200
	JE B265
	CMP AX, 200			
	JA B265
	JMP B27

B265:
	PRINT NOT_VALID_NUMBER
	JMP CHANGE_PRIORITY
B27:	
	MOV BX, AX			; set the new priority
	MOV AX, 5
	INT BUFFER_INT_NUMBER

	PRINT CRLF	
	JMP TERMIN_ATE
	
CHANGE_PORT:
	PRINT PORT_MENU			; print the port menu
B3:
	PRINT NUMBER			; print "Number: "
	
	MOV AH, KEYBOARD_NO_ECHO	; wait for a number to be typed
	INT 21H

	CMP AL, CR
	JE EXIT9
	
	PUSH AX				; echo every thing except cr
	MOV AH, DISPLAY_CHAR
	MOV DL, AL
	INT 21H

	PRINT SPACE			; print two spaces
	POP AX

	CMP AL, "1"			; jump to the correct command
	JE LPT1
	CMP AL, "2"
	JE LPT2
	CMP AL, "3"
	JE LPT3
	CMP AL, "4"
	JNE B35
	JMP COM1
B35:
	CMP AL, "5"
	JNE B4
	JMP COM2
B4:
	CMP AL, "6"
	JE EXIT9
	JMP B3

EXIT9:
	PRINT CRLF
	JMP TERMIN_ATE
LPT1:
	MOV BX, 0000H
	CALL GET_PORT_ADDRESS		; determine if this port is in the system
	CMP DX, 0
	JNZ  B5
	JMP THIS_PRN_NOT_AVALIABLE
B5:	
	PRINT NEW_PORT			; print "The new port to use with the printer is "
	PRINT LPT1_MESS			; print "LPT1."
	
	MOV AX, 2			; use lpt1 for the output port
	MOV BL, 0			; port number
	MOV BH, 1			; port type = parallel
	INT BUFFER_INT_NUMBER
	JMP TERMIN_ATE
	
LPT2:
	MOV BX, 0001
	CALL GET_PORT_ADDRESS		; determine if this port is in the system
	CMP DX, 0
	JNZ B6
	JMP THIS_PRN_NOT_AVALIABLE
B6:	
	PRINT NEW_PORT			; print "The new port to use with the printer is "
	PRINT LPT2_MESS			; print "LPT2."
		
	MOV AX, 2
	MOV BL, 1	; port number
	MOV BH, 1	; port type = parallel
	INT BUFFER_INT_NUMBER
	JMP TERMIN_ATE

LPT3:
	MOV BX, 0002
	CALL GET_PORT_ADDRESS		; determine if this port is in the system
	CMP DX, 0
	JZ THIS_PRN_NOT_AVALIABLE
	
	PRINT NEW_PORT			; print "The new port to use with the printer is "
	PRINT LPT3_MESS			; print "LPT3."
	
	MOV AX, 2
	MOV BL, 2	; port number (0,1,2)
	MOV BH, 1	; port type = parallel
	INT BUFFER_INT_NUMBER
	
	JMP TERMIN_ATE

COM1:
	MOV BX, 0100H
	CALL GET_PORT_ADDRESS		; determine if this port is in the system
	CMP DX, 0
	JZ THIS_PRN_NOT_AVALIABLE
	
	PRINT NEW_PORT			; print "The new port to use with the printer is "
	PRINT COM1_MESS			; print "COM1."
	
	MOV AX, 2
	MOV BL, 0	; port number
	MOV BH, 0	; port type = serial
	INT BUFFER_INT_NUMBER
	JMP TERMIN_ATE

COM2:
	MOV BX, 0101H
	CALL GET_PORT_ADDRESS		; determine if this port is in the system
	CMP DX, 0
	JZ THIS_PRN_NOT_AVALIABLE
	
	PRINT NEW_PORT			; print "The new port to use with the printer is "
	PRINT COM2_MESS			; print "COM2."
	
	MOV AX, 2
	MOV BL, 1	; port number
	MOV BH, 0	; port type = serial
	INT BUFFER_INT_NUMBER
	JMP TERMIN_ATE

THIS_PRN_NOT_AVALIABLE:
	PRINT NOT_AVALIABLE
	JMP B3

TERMIN_ATE:
	MOV AH, TERMINATE		; return to msdos
	INT 21H

;--------------------------------------------------------------------

PRINTBXCXDX	PROC
; print registers bx, cx, dx if they are not spaces
	PUSH DX
	PUSH DX

	CMP BH, " "
	JE P1

	MOV AH, DISPLAY_CHAR
	MOV DL, BH
	INT 21H
P1:
	CMP BL, " "
	JE P2

	MOV AH, DISPLAY_CHAR
	MOV DL, BL
	INT 21H
P2:
	CMP CH, " "
	JE P3

	MOV AH, DISPLAY_CHAR
	MOV DL, CH
	INT 21H
P3:
	CMP CL, " "
	JE P4

	MOV AH, DISPLAY_CHAR
	MOV DL, CL
	INT 21H
P4:
	MOV AH, DISPLAY_CHAR
	POP DX
	CMP DH, " "
	JE P5
	MOV DL, DH
	INT 21H
P5:
	MOV AH, DISPLAY_CHAR
	POP DX
	INT 21H

	RET
PRINTBXCXDX	ENDP

;--------------------------------------------------------------------

BIN2DEC	PROC
; Convert a two byte binary number to a six byte ascii decimal number.
; call: ax = binary number
;	es = cs = ds
; return: bxcxdx = ascii decimal number
; registers changed: bx cx dx
; algorithm used:
; REPEAT digit = (x mod 10) + '0'; x = x DIV 10 UNTIL x = 0
	
	PUSHF
	PUSH AX
	PUSH SI
	PUSH DI

	CLD			; auto increment
	MOV DI, OFFSET SCRATCH	; work space
	MOV SI, DI
	PUSH AX
	MOV AX, 2020H
	STOSW
	STOSW
	STOSW
	POP AX
	MOV DI, SI
	MOV BX, 10

REPEAT3:	
	XOR DX, DX		; get the first digit
	DIV BX			; dxax/bx = ax R dx
	ADD DX, "0"
	PUSH AX
	MOV AL, DL
	STOSB			; mov es:[di], al
	POP AX
	OR AX, AX
	JNZ REPEAT3

	LODSW
	MOV DX, AX
	LODSW
	MOV CX, AX
	LODSW
	MOV BX, AX

	POP DI
	POP SI
	POP AX
	POPF
	RET

SCRATCH	DB 6 DUP(9)
BIN2DEC	ENDP

;--------------------------------------------------------------------

GET_PORT_ADDRESS	PROC
; call: bh = port type (0 com, 1 if parallel)
;	bl = port_number (0, 1, 2)
; return: dx = port address
	PUSH AX
	PUSH ES
	PUSH SI

	MOV	AX,0040H	; use es:si to get the port address
	MOV	ES,AX		; the com and parallel ports are at 40:0 to 40:0010
	MOV	SI,8	
	CMP	BH, 0
	JNZ	G1
	MOV 	SI, 0
G1:
	MOV	AL, BL
	CBW		
	ADD	SI,AX	
	ADD	SI,AX	
	MOV	DX,ES:[SI]
	
	POP SI
	POP ES
	POP AX
	RET
GET_PORT_ADDRESS	ENDP

;--------------------------------------------------------------------

PRINT_PORT	PROC
; print the port type (LPT1, LPT2, LPT3, COM1, COM2) on the screen
; call:	ah = port type (0 = com, 1 = parallel)
;	al = port number (0, 1, 2)
; return: carry set if al or ah are out of range
	CMP AH, 0
	JZ COM
	CMP AH, 1
	JZ LPT
	JMP ERROR3
COM:	
	CMP AL, 0
	JZ COM_ONE
	CMP AL, 1
	JZ COM_TWO
	JMP ERROR3
LPT:
	CMP AL, 0
	JZ LPT_ONE
	CMP AL, 1
	JZ LPT_TWO
	CMP AL, 2
	JZ LPT_THREE
	JMP ERROR3
COM_ONE:
	PRINT COM1_MESS
	RET
COM_TWO:
	PRINT COM2_MESS
	RET
LPT_ONE:
	PRINT LPT1_MESS
	RET
LPT_TWO:
	PRINT LPT2_MESS
	RET
LPT_THREE:
	PRINT LPT3_MESS
	RET
ERROR3:
	STC
	RET
PRINT_PORT	ENDP
	
;--------------------------------------------------------------------

ASCBIN	PROC
COMMENT *
DECIMAL ASCII TO BINARY CONVERSION UTILITY
Dr. Dobb's  September 82 , page 65
	
Scans past any leading blanks.  Terminates on the first illegal character and
returns its address.
call:
	SI = address of ASCII string containing any of the characters
	     +-.0123456789
return:
	AX = signed binary result
	CX = number of digits after the decimal, or -1 if none
	SI = address of first non-convertible character
registers:
	direction flag is cleared
	
	*

	CLD
	PUSH DX
	PUSH BX
	XOR BX,BX
	MOV CX,-1
AB1:
	CMP BYTE PTR [SI],' '
	JNZ AB2
	INC SI
	JMP AB1
AB2:
	PUSH SI
	CMP BYTE PTR [SI],'+'
	JZ AB25
	CMP BYTE PTR [SI],'-'
	JNZ AB3
AB25:
	INC SI
AB3:
	LODSB
	CMP AL,'.'
	JNZ AB4
	XOR CX,CX
	JMP AB3
AB4:
	CMP AL,'0'
	JB AB5
	CMP AL,'9'
	JA AB5
	AND AX,0FH
	XCHG AX,BX
	MOV DX,10
	MUL DX
	ADD BX,AX
	OR CX,CX
	JS AB3
	INC CX
	JMP AB3
AB5:
	DEC SI
	MOV AX,BX
	POP BX
	CMP BYTE PTR [BX],'-'
	JNZ AB6
	NEG AX
AB6:
	POP BX
	POP DX
	RET
ASCBIN	ENDP

;--------------------------------------------------------------------

CODE	ENDS
	END BEGIN
