/***************************************************************************
*									   *
*	Nifty James' Famous Disk Tidy Program				   *
*									   *
*	(C) Copyright 1987 by Mike Blaszczak All Rights Reserved	   *
*									   *
*	Version 1.00 of 7 December 1987					   *
*	Written for the Microsoft Optimizing C Compiler, Version 5.00	   *
*			(Use the COMPACT model)				   *
*									   *
***************************************************************************/

#include <dos.h>
#include <malloc.h>
#include <stdio.h>
#include <string.h>

#include <noenv.h>
#include <noargs.h>

#define	MAXSTACK	7168
#define	MAX_PATH_LEN	64

char    *subdirlist[MAXSTACK];		/* list of subdirectories 	*/
int     topdir = 1;			/* first free subdirlist entry	*/
int	worktop = 0;			/* used as iteration counter	*/

int	index;				/* loop variable		*/

char	tempname[MAX_PATH_LEN];		/* temporary name for file dels */

long	deleted =0L;			/* number of files deleted	*/
unsigned long totalbytes =0L;		/* number of bytes freed	*/

unsigned        result;			/* result of _dos operations	*/
struct  find_t  c_file;			/* structure for _dos ops	*/

/* ---------------------------------------------------------------------- */ 

int deleteone(n)
int n;
{
	strcpy(tempname, subdirlist[n]);
	tempname[strlen(tempname)-3] = '\0';
	strcat(tempname, c_file.name);

	printf("Deleting file %s", tempname);
	return(remove(tempname));
}	

/* ---------------------------------------------------------------------- */ 

void main()
{
	puts("Nifty James Famous Disk Tidyer");
	puts("Version 1.00 of 07 December 1987");
	puts("(C)Copyright 1987 by Mike Blaszczak\n");

	subdirlist[0] = "\\*.*";

	while(worktop<topdir)	{	
	result = _dos_findfirst(subdirlist[worktop], _A_SUBDIR, &c_file);

		while(result == 0)
		{
			if (strcmp(c_file.name, ".") != 0  &&
			    strcmp(c_file.name, "..") != 0 &&
			    c_file.attrib == _A_SUBDIR)
			{
				if ( topdir == MAXSTACK ||
				    (subdirlist[topdir] = (char *) malloc(MAX_PATH_LEN)) == NULL )
				{
					puts("NJTIDY: Out of memory error\n");
					exit(1);
				}
				strcpy(subdirlist[topdir], subdirlist[worktop]);
				subdirlist[topdir][strlen(subdirlist[topdir])-3] = '\0';
				strcat(subdirlist[topdir], c_file.name);
				strcat(subdirlist[topdir++], "\\*.*");
			}
			result = _dos_findnext(&c_file);
		}
		worktop++;
	}

	for(index = 0; index < topdir; index++)
	{
		result = _dos_findfirst(subdirlist[index], _A_NORMAL, &c_file);

		while(result == 0)
		{
			if (strstr(c_file.name, ".BAK") != NULL)
			{
				deleteone(index);
				putchar('\n');
				deleted++;
				totalbytes += c_file.size;
			}
			else
				if (c_file.size == 0L && c_file.attrib != _A_SUBDIR)
				{
					deleteone(index);
					puts(" (file's length was zero)");
					deleted++;
				}
			result = _dos_findnext(&c_file);
		}
	}		

	if(deleted == 0L)
		puts("\nNo files were deleted\n");
	else
		printf("\n%ld files were deleted for a total of %lu bytes freed.\n",
			deleted, totalbytes);

	exit(0);
}

