;Cpu indentification program
;
	org	100h
;
whoami: mvi	a,7fh		;weed out Z80 with p/v flag test
	add	a		;add 7f to 7f
	jpe	z80		;parity (overflow) = Z80
	stc			;force carry on
	xra	a		;try to clear carry with xra
	jc	nec80		;if carry still on then NEC 8080A
	ana	a		;now and 0 with 0
	push	psw		;look at AC to weed out 8085
	pop	b		;get flags
	mov	a,c		;
	ani	10h		;see if AC is set
	jnz	i8085		;INTEL 8085 snarfed out
	mvi	a,8		;try AND with bit 3 on
	ani	a
	push	psw
	pop	b
	mov	a,c		;test AC again
	ani	10h
	jz	a9080		;if AC 0 then AMD 9080 cpu
	lxi	d,msgi80	;else INTEL 8080
	jmp	tcpu
z80:	mvi	a,7fh		;now weed out NSC800
	.z80			;Z80 codes OK now
	ld	r,a
	ld	a,r		;see if R 8 or 7 bits long
	.8080			;back to INTEL set
	ani	80h		;mask for bit 7
	jz	zz80		;zilog Z80
	lxi	d,msg800	;NSC800 cpu
	jmp	tcpu
nec80:	lxi	d,msgn80
	jmp	tcpu
a9080:	lxi	d,msga80
	jmp	tcpu
i8085:	lxi	d,msgi85
	jmp	tcpu
zz80:	lxi	d,msgz80
tcpu:	mvi	c,9
	call	5
	jmp	0		;back to CP/M
msgi80: db	'CPU is an INTEL 8080',10,13,'$'
msg800: db	'CPU is a National Semiconductor NSC800',10,13,'$'
msgn80: db	'CPU is a N.E.C. 8080A (INTEL equivalent)',10,13,'$'
msga80: db	'CPU is an A.M.D. 9080',10,13,'$'
msgi85: db	'CPU is an 8085',10,13,'$'
msgz80: db	'CPU is a Zilog / Mostek Z80',10,13,'$'
	end	whoami
.M.D. 9080',10,13,'$'
msgi85: db	'CPU is an 8085',10,13,'$'
msgz80: db	'CPU is 