;CBBS V3.5.0 	CBBSDISK.ASM - DISK SUBROUTINES
;10/11/81 23:14:27
;	LINKS TO CBBSCLKC IF CLOCKC=TRUE, (COMPUTIME)
;	   OR TO CBBSCLKS IF CLOCKS=TRUE, (SCITRONICS)
;	      OR CBBSSUB1 IF NEITHER
;
;
;	O O	O O O	O O O	O   O
;	O   O	  O	O	O  O
;CBBS	O   O	  O	O O O	O O	.ASM
;	O   O	  O	    O	O  O
;	O O	O O O	O O O	O   O
;
;MOD LOG (THRU 3.2 WRITTEN TO "HISTORY")
;
;====> HISTORICAL COMMENTS SINCE 3.3 TO "HISTORY.033"
;
;	----------------
;ROUTINE TO TYPE CONTENTS OF A FILE.  ALLOWS
;THE TYPE COMMAND TO BE FOLLOWED BY ',' THEN
;A CHARACTER STRING TO BE SEARCHED FOR.  USED
;BY OPERATORS.  LAST TIME YOU CALLED IN YOU
;WERE CALLER 18923, SO TO SEE LOG ENTRIES
;FROM THAT POINT: TYPE B:LOG,18923
;
TYPEF	CALL	SETRD	;SET UP FILE
	RC		;RET IF ERROR
02;ADD LABEL TFNEXT:
TFNEXT	LDA	STRFLG	;STRING SPECIFIED?
	CPI	','
	JNZ	TFLOOP	;NO, JUST TYPE
TFSTRS	LHLD	STRPTR	;STRING START
TFSTRC	CALL	RDBYTE	;STRING CHAR
	RC
04; START OF MODS
	CPI	61H
	JC	TFSTRCL
	ANI	5FH	;MAKE LOWER CASE
TFSTRCL:
04; END OF MODS
	CMP	M
	JNZ	TFSTRS	;NO MATCH, START OVER
;MATCHED.  SEE IF END
	INX	H
	MOV	A,M
	CPI	CR
	JNZ	TFSTRC
;
TFLOOP	CALL	RDBYTE	;READ BYTE FROM FILE
	RC		;RETURN WHEN EOF
	CALL	TYPE	;TYPE THE CHAR
;CHECK FOR CTL-C, -K, OR -S
	CALL	CTLCKS	;GET CHAR (0 IF CTL-C)
	JZ	TFSKP	;CRLF, SKIP
	CPI	'X'-40H	;CTL-X?
	JZ	TFSKIP
	CPI	CR	;OPERATOR SKIP TO NEXT STRING?
	JNZ	TFLOOP	;NO, LOOP
	CALL	CRLF
	JMP	TFNEXT	;GET NEXT STRING
;
;CTL-X WAS TYPED.  SKIP 10 LINES, THEN CONTINUE
;
TFSKIP	MVI	B,10	;SET # OF LINES
TFSKL	CALL	RDBYTE
	RC
	CPI	LF	;NEW LINE?
	JNZ	TFSKL	;NO. GET NEXT CHAR
	DCR	B	;DECREMENT LINE COUNT
	JNZ	TFSKL	;LOOP IF MORE
;11/11/78 ADDED CALL CRLF
	CALL	CRLF
	JMP	TFLOOP	;10 LINES SKIPPED.  CONTINUE
04;MODS:
TFSKP	CALL	CRLF
05	CALL	CRLF	;DOUBLE SPACE SHOWS UP BETTER
	CALL	IQSKIP	;SKIP TO ']', BELL, OR EOF
	JMP	TFLOOP
;
;====>	TYPEFH	TYPE LINES IN A FILE ONLY IF THEY START "]"
;		07/11/81
;	IF EXECUTED FROM "TYPEK" OPERATOR COMMAND, THEN
;	THE NEXT 2 LINES ALSO TYPED.
;	(USED TO CHECK THE KILLED FILE)
;
TYPEFK	MVI	A,1
	STA	SUMTYP
	JMP	TYPEFR
;
TYPEFH	XRA	A
	STA	SUMTYP	;USE THIS AS A FLAG
TYPEFR	CALL	SETRD
	RC		;NO FILE
	JMP	TFHLC	;TYPE FIRST LINE
;
TFHLN	CALL	CTLCKS	;ALLOW ^K ABORT
	CALL	RDBYTE
	RC
	CPI	']'
	JNZ	TFHLN
TFHLC	CALL	TYPELN	;TYPE A LINE
	LDA	SUMTYP	;TYPEK?
	ORA	A
	JZ	TFHLN
	CALL	TYPELN	;MESSAGE HEADER LINE 1 (FROM/TO)
	CALL	CRLF
	JMP	TFHLN
;
;SUBROUTINE TO TYPE NEXT LINE FROM A FILE
;
TYPELN	CALL	RDBYTE
	JNC	TYPELN2	;NOT EOF
TYPELNE	POP	H	;DUMP RET ADDR
	RET		;RET BACK 1 LEVEL
;
TYPELN2	PUSH	PSW
	CALL	TYPE
	POP	PSW
	CPI	LF
	RZ
	CALL	CTLCKS
	JNZ	TYPELN
;
;GOT ^C, SKIP TO END OF LINE
;
TYPELN3	CALL	RDBYTE
	JC	TYPELNE	;EOF
	CPI	LF
	JNZ	TYPELN3
	JMP	CRLF
;
;====> INTQF FORMERLY HERE MOVED TO CBBSBYE.ASM <====
;
;
;-----> MAKE OUTPUT FILE.  HL POINTS TO FILE NAME
;
FMAKE	LXI	D,FCB	;TO FCB
	MVI	B,12
	CALL	MOVE	;SET UP FCB
;ERASE OLD FILE NAME
FMAKEN	XRA	A
	STA	FCBEXT	;ZERO EXTENT
	LXI	D,FCB
	MVI	C,ERASE
	CALL	BDOS	;NO RETURN CODE
	XRA	A
	STA	FCBRNO	;SET REC # = 0
	LXI	H,80H	;SET BUFFER
	SHLD	BUFPTR	;= EMPTY
	LXI	D,FCB
	MVI	C,MAKE	;MAKE
	CALL	BDOS	;NEW
	INR	A	;FILE
	RNZ		;RET OK?
	CALL	ILPRT
	DB	'++Sorry, disk directory is full++'
	DB	CR,LF,0
;
;TYPE MESSAGE TO CALL RANDY/WARD
;
;    N   N   O O O   T T T   E E E
;    NN  N   O   O     T     E
;    N N N   O   O     T     E E
;    N  NN   O   O     T     E
;    N   N   O O O   T T T   E E E       X X X
;
;
;	 TO CHANGE THE FOLLOWING TO Y-O-U-R
;	 SYSTEM OPERATORS NAME(S)/PHONE
;
TELLUS	CALL	ILPRT
	DB	7,7,7,7,7,CR,LF ;(BELLS)
	DB	'++AN ERROR OCCURRED++',CR,LF,CR,LF
	DB	'Please call '
;	DB	'Randy (312 545-7535), or '
;	DB	'Ward (312 849-6279)',CR,LF
	db	'Jack (604) 596-6631)',cr,lf
	DB	'and tell him of this error.'
	DB	7,7,7,7,7,7,7 ;BELLS
	DB	CR,LF,0
	JMP	DEFUNCT
;
;-----> WRITE EOF BY PADDING SECTOR WITH CONTROL-Z,
;	THEN WRITING SECTOR, AND CLOSING FILE
;
WREOF	MVI	A,EOF	;WRITE
	CALL	WRBYTE	;	EOF
	LDA	BUFPTR	;DONE WITH SECTOR?
	CPI	80H
	JNZ	WREOF	;	NO, LOOP
;
;WRBYTE WROTE SECTOR, SO CLOSE THE FILE
;
03;ADDED NEXT LABEL
CLOSENX	LXI	D,FCB
	MVI	C,CLOSE
	CALL	BDOS
	INR	A	;OK?
	RNZ
;ERROR: COULDN'T CLOSE FILE
	CALL	ILPRT
	DB	'++Sorry, couldn''t close the file.',CR,LF,0
	JMP	TELLUS
;
;-----> WRITE BYTE TO CURRENTLY OPENED FILE
;
WRBYTE	PUSH	H
	LHLD	BUFPTR
	MOV	M,A	;STORE CHAR
	INX	H
	MOV	A,H	;TIME TO WRITE? (ADDR=100H)
	DCR	A
	JNZ	WRBNOW	;NO WRITE
;WRITE SECTOR
	PUSH	B
	PUSH	D
	LXI	D,FCB
	MVI	C,WRITE
	CALL	BDOS
	POP	D
	POP	B
	ORA	A
	JZ	WRBOK	;WRITE OK
	PUSH	PSW	;SAVE ERROR
	CALL	ILPRT
	DB	'++Sorry, DISK WRITE ERROR, code=',0
	POP	PSW	;GET CODE
	ADI	'1'	;MAKE PRINTABLE
	CALL	TYPE
	CALL	CRLF
	JMP	TELLUS	;TELL RANDY/WARD
;
;WRITE WAS OK
;
WRBOK	LXI	H,80H	;BACK TO START OF BUFFER
WRBNOW	SHLD	BUFPTR	;SAVE POINTER
	POP	H
	RET
;
;---->	WRITE NAME TO DISK
;
WRNAME	LXI	H,FNAME
	CALL	WRVAR	;FIRST NAME
	MVI	A,' '	
	CALL	WRBYTE	;SPACE
	LXI	H,LNAME
	CALL	WRVARC	;LAST NAME, COMMA
	RET
;
;-----> WRITE A C/R TERMINATED VARIABLE TO DISK
;
WRVAR	MOV	A,M	;GET CHAR
	CPI	CR	;END?
	RZ		;YES, RET
;DON'T WRITE A COMMA, AS THAT IS THE DELIMITER
;USED WHEN READING BACK
	CPI	','
	JNZ	WRVWR
	MVI	A,'/'	;SUBSTITUTE '/'
WRVWR	CALL	WRBYTE
	INX	H
	JMP	WRVAR	;LOOP UNTIL C/R
;
;-----> WRITE VARIABLE FOLLOWED BY COMMA
;
WRVARC	CALL	WRVAR	;WRITE VAR,
	MVI	A,','	;	THEN COMMA
	JMP	WRBYTE
;
;-----> WRITE A LINE (THRU CR/LF) INTO FILE
;
WRLINE	CALL	SETTABS	;TAB COMPRESS THE LINE
WRLLP	MOV	A,M	;GET CHAR
	CPI	CR	;END?
	JZ	WRCRLF	;YES, WRITE CR/LF, RET.
	CALL	WRBYTE
	INX	H
	JMP	WRLLP
;
;-----> WRITE CR/LF INTO FILE
;
WRCRLF	MVI	A,CR
	CALL	WRBYTE
	MVI	A,LF
	JMP	WRBYTE
;
;-----> ROUTINE TO SET UP FILE FOR READ
;HL POINTS TO FCB.
;
SETRD	XRA	A	;GET 'NOT EOF' VALUE
	STA	EOFLG	;SET EOF FLAG
	STA	FCBEXT	;ZERO EXTENT
	STA	FCBRNO	;ZERO RECORD NUMBER
;MOVE FILENAME TO FCB
	LXI	D,FCB
	MVI	B,12	;FILENAME LENGTH
	CALL	MOVE	;MOVE FILENAME TO FCB
SETOPEN	LXI	H,100H	;EMPTY BUFF VALUE
	SHLD	BUFPTR	
	lxi	d,fcb
	mvi	c,open
	call	bdos
	inr	a
	ora	a
	rnz		;ok , return
;
;OPEN FAILED - CHANGE THE FOLLOWING TO "IF -1"
;IF YOU WANT THE ERROR MESSAGE "THERE IS NO FILE"
;TO PRINT (FOR DEBUGGING ONLY, NOT FOR ONLINE):
;
	IF	0	;SEE NOTE ABOVE
	LXI	H,NOFMSG
	CALL	TYPEM0	;TYPE 'THERE IS NO FILE: '
	LXI	H,FCB+1	;POINT TO FILE NAME
	XRA	A	;GET 0
	STA	FCB+12	;SET ENDING CHAR
	CALL	TYPEM0	;TYPE FILE NAME
	CALL	CRLF
	ENDIF
;
	STC		;CARRY ON TO SHOW ERROR
	RET
;
;ROUTINE TO READ A NIBBLE OF HEX FROM A FILE
;	USED IN HELP INDEX FUNCTION
;
DKRDHEX	CALL	RDBYTE
	SUI	'0'	;DECIMAL?
	CPI	10
	RC
	SUI	7
	RET
;
;-----> ROUTINE TO READ BYTE FROM FILE.
;5CH FCB USED, BUFFER AT 80, BUFPTR POINTING
;INTO BUFFER.  MUST CALL 'SETRD' FIRST, 
;WITH HL POINTING TO FCB
;
;NOTE: RETURNS CARRY IF E.O.F.
;
RDBYTE	LDA	EOFLG	;ALREADY HAVE EOF?
	ORA	A	;SET TO 1AH IF EOF.
	STC		;CARRY & RET IF EOF,
	RNZ		;A=1AH FROM EOFLG
	PUSH	H
	LHLD	BUFPTR	;GET POINTER
	MOV	A,H	;TIME
	DCR	A	;	TO READ?
	JNZ	NORD
;READ A SECTOR FROM THE FILE
	PUSH	B
	PUSH	D
	LXI	D,FCB
	MVI	C,READ
	CALL	BDOS
	POP	D
	POP	B
	ORA	A	;READ OK?
	JZ	RDOK
	POP	H
	MVI	A,EOF	;FAKE EOF
	STA	EOFLG	;SET FLAG
	STC		;SHOW EOF
	RET
;
RDOK	LXI	H,80H	;GET START OF BUFF POINTER
;
NORD	MOV	A,M	;GET CHAR
	INX	H	;POINT TO NEXT CHAR
	SHLD	BUFPTR
	POP	H
	CPI	EOF
	JNZ	RDBNEOF
	STA	EOFLG	;SET EOF FLAG
	STC		;SHOW EOF
	RET
;
RDBNEOF	ORA	A	;CLEAR CARRY: NOT EOF
	RET
;
;---->	"UN" READ A BYTE (BACK UP 1)
;MAY ONLY BE CALLED ONCE WITHOUT AN
;INTERVEINING RDBYTE BECAUSE 2 MIGHT
;BACK UP INTO PREVIOUS SECTOR
;
UNRDBYT	LHLD	BUFPTR
	DCX	H
	SHLD	BUFPTR
	RET
;
;-----> EXTEND A FILE.
;NAME (NOT FCB) POINTED TO BY HL.
;MAKE THE FILE IF IT DOESN'T EXIST.
;
EXTEND	PUSH	H	;SAVE NAME POINTER
	CALL	SETRD	;TRY OPENING IT
	POP	H	;GET SAVED NAME PTR
	JC	FMAKE	;NEW FILE - MAKE IT
01;START OF MODS
EXTCK	LDA	FCBNSEC	;GET HI SECTOR
	CPI	80H	;ANOTHER
	JNZ	EXT0	;	EXTENT?
;ANOTHER EXTENT - OPEN IT
	LXI	H,FCBEXT
	INR	M
	CALL	SETOPEN
	JC	EXTFAR	;TOO FAR
;TEST FOR EMPTY EXTENT
	XRA	A
	STA	FCBRNO
	LDA	FCBNSEC
	ORA	A	;0?
	JNZ	EXTCK
;WENT TOO FAR
EXTFAR	LXI	H,FCBEXT
	DCR	M
	CALL	SETOPEN
	LDA	FCBNSEC
EXT0	DCR	A	;IF START OF EXT,
01;END OF MODS
	JM	EXTEOF	;	JUST SCAN
	STA	FCBRNO	;SET REC #
EXTEOF	CALL	RDBYTE	;SCAN FOR
	JNC	EXTEOF	;	EOF
;
;GOT EOF - BACK UP BUFPTR BY 1 FOR SUBSEQUENT WRITES,
;ALSO BACK UP THE SECTOR NUMBER, IN PREP FOR WRITE
;(IT WAS INCR TO N-E-X-T SECTOR BY READ)
;
01	CALL	UNRDBYT
	LDA	FCBRNO	;GET REC #
	DCR	A
	STA	FCBRNO
	RET
;
;READ THE NEXT MESSAGE NUMBER TO ASSIGN
;
RDNEXT	LXI	H,NEXTFL ;POINT TO FILENAME
	CALL	SETRD	;OPEN THE FILE
	JNC	RDBYTE	;FORCE SECTOR READ
;
;ERROR - NEXT FILE NOT FOUND
;
	CALL	ILPRT
	DB	'System "NEXT" file missing!',CR,LF,0
	JMP	TELLUS
;
	IF	CLOCKC	;COMPUTIME?
	LINK	CBBSCLKC
	ENDIF
;
	IF	CLOCKS	;SCITRONICS?
	LINK	CBBSCLKS
	ENDIF
;
;THIS WON'T BE SEEN IF LINKED TO CLOCK ROUTINE
;
	LINK	CBBSSUB1 ;TO NEXT .ASM FILE
