;CBBS V3.5.0 	CBBSCLKC.ASM - COMPUTIME CLOCK FUNCTIONS
;07/11/81 12:56:29
; LINKED FROM CBBSDISK ONLY IF CLOCKC=TRUE
;
;	LINKS TO CBBSSUB1
;
;	O O O	O	O   O	O O O
;	O	O	O  O	  O
; CBBS	O	O	OOO	  O	.ASM
;	O	O	O  O	  O
;	O O O	O O O	O   O	  O
;
;MOD LOG (THRU 3.2 WRITTEN TO "HISTORY")
;
;====> HISTORICAL COMMENTS SINCE 3.3 TO "HISTORY.033"
;
;COMPUTIME CLOCK BOARD EQUATES
;
ADATA	EQU	24H
ACTL	EQU	ADATA+1
BDATA	EQU	ACTL+1
BCTL	EQU	BDATA+1
;
;'T' COMMAND: PRINTS DATE, TIME, ELAPSED TIME
;
PRDTIME	CALL	PRETIME
	JMP	FUNCT
;
;DATE/TIME PRINT SUBROUTINE
;
PRTIME	LXI	H,ANSWER ;STORE IT HERE
	PUSH	H
	CALL	RDDATE
	MVI	M,' '
	INX	H
	JC	CLKINOP
	CALL	RDTIME	;GET TIME
	MVI	M,0
	POP	H
	MOV	A,M	;GET HI
	CPI	'3'	;VALID?
	JNC	CLKINO1
	CALL	TYPEM0	;TYPE DATE
	CALL	CRLF
01	ORA	A
	RET
;
CLKINOP	POP	H	;FIXUP STACK
CLKINO1	CALL	ILPRT
	DB	'++System clock/calendar '
	DB	'inop++',CR,LF,0
	STC
	RET
;
;PRETIME: PRINTS CURRENT AND ELAPSED TIME
;
PRETIME	CALL	PRTIME
	RC		;RET IF NO CLOCK
	LXI	H,ANSWER
	PUSH	H
	CALL	RDTIME
	POP	H
	CALL	CONVTBI	;HL=BINARY CURR TIME
	PUSH	H
	LXI	H,LGINTIM ;GET LOGGED IN TIME
	CALL	CONVTBI	;HL=LOGGED IN TIME
	POP	D	;DE=CURR TIME
;SUBTRACT TO GET ELAPSED MINUTES
	MOV	A,E
	SUB	L
	MOV	L,A
	MOV	A,D
	SBB	H
	MOV	H,A
	RAL		;CARRY IF NEG
	JNC	PRETOK
;ELAPSED TIME IS NEGATIVE - ADD 24 HOURS
	LXI	D,1440	;1 DAY OF MINUTES
	DAD	D
PRETOK	MOV	A,H
	ORA	A	;>255 MINUTES?
	JNZ	PREBAD
	MOV	A,L	;GET TIME
	CPI	120	;>2 HRS? PROB. BAD.
	JNC	PREBAD
;E.T. IS VALID, PRINT IT
	PUSH	PSW
	CALL	ILPRT
	DB	'Connect time ',0
	POP	PSW
	CALL	PRDEC
	CALL	ILPRT
	DB	' minutes',CR,LF,0
	RET
;
PREBAD	CALL	ILPRT
	DB	'Unable to calc connect time',cr,lf,0
	RET
;
;WRITE DATE, TIME, ELAPSED TIME
;
WRETIME	CALL	PRETIME	;PRINT & CALC ELAPSED
	RC		;INVALID CLOCK
	LXI	H,WRETMSG
	JMP	WRVARC	;WRITE ELAPSED
;
;WRITE DATE AND TIME TO CURRENTLY OPEN
;FILE (USUALLY LOG, BUT SOMETIMES "NOTES")
;
WRTIME	LXI	H,ANSWER ;WORK AREA
	PUSH	H
	CALL	RDDATE
	MVI	M,0DH
NKS TO CBBSSUB1
;
;	O O O	O	O   O	O O O
;	O	O	O  O	O
; CBBS	O	O	OOO	O O O	.ASM
;	O	O	O  O	    O
;	O O O	O O O	O   O	O O O
ALL	RDTIME
	MVI	M,0DH
	POP	H
	JMP	WRVARC	;WRITE DATE
;
;RDTIME - STORES THE TIME (HH:MM:SS) INTO
;	FIELD POINTED TO BY HL.  UPON RETURN,
;	HL POINTS PAST LAST BYTE.
;
RDTIME	MVI	A,40H	;CLOCK 'TIME' REQUEST
	MVI	B,':'	;DELIMITER
	CALL	CLKDAT	;GET VALUE
	RET
;
;RDDATE - STORES THE DATE "MM/DD/YY" INTO
;	FIELD POINTED TO BY HL.  UPON RETURN,
;	HL POINTS TO LAST BYTE
;
RDDATE	XRA	A	;CLOCK 'DATE' REQUEST
	MVI	B,'/'	;DELIMITER
	CALL	CLKDAT	;GET VALUE
	MVI	M,'/'
	INX	H
;
;Y1, Y2 STORED AS BYTES 3, 4 OF CBBS.COM
;TO MAKE PATCHING EASY
;
	LDA	Y1	;GET YEAR TENS
	MOV	M,A
	INX	H
	LDA	Y2	;GET YEAR UNITS
	MOV	M,A
	INX	H
	MVI	M,0	;END OF DATA
	RET
;
;CLKDAT SUBROUTINE - STORES TIME OR DATE
;
CLKDAT	MOV	C,A	;SAVE SELECT BYTE
	IN	ADATA	;SEE IF CLOCK
	INR	A	;..PRESENT
	MOV	M,A	;STORE 0 IF NONE
	STC		;SET CARRY IF NO CLOCK
	RZ		;RET IF NO CLOCK
;CLOCK PRESENT - INIT PIA
	MVI	A,70H
	OUT	ADATA
	MVI	A,77H
	OUT	BDATA
	MVI	A,14H
	OUT	ACTL
	MVI	A,4
	OUT	BCTL
	MOV	A,C	;GET SELECT CHAR
	OUT	BDATA
;I FOUND A DELAY WAS REQUIRED FOR RELIABILITY:
	PUSH	D
	LXI	D,2000
CLKDLY	DCX	D
	MOV	A,D
	ORA	E
	JNZ	CLKDLY
	POP	D
;
	MVI	C,0	;GET DIGIT SELECT
	CALL	RCLKDIG	;GET A DIGIT
	CALL	RCLKDIG
CLKDEL	MOV	M,B	;STORE DELIMITER
	INX	H
	CALL	RCLKDIG
	CALL	RCLKDIG
;IF DATE, RETURN, OTHERWISE GET SECONDS
	MOV	A,B
	CPI	'/'
	RZ
;IF DONE W/SECONDS, RETURN
	MOV	A,C
	CPI	60H	;DIGIT SELECT PAST SEC'S?
	RZ
	JMP	CLKDEL	;STORE SECONDS
;
;SUBROUTINE TO READ, STORE A SINGLE DIGIT
;
RCLKDIG	MOV	A,C	;GET DIGIT SELECT
	OUT	ADATA
	ADI	10H	;TO NEXT DIGIT SELECT
	MOV	C,A	;SAVE BACK
	IN	ADATA	;STROBE (?)
RCLKWT	IN	ACTL
	ANI	80H	;READY?
	JZ	RCLKWT
	IN	ADATA	;GET DIGIT
	ANI	0FH	;MAKE BCD
	ADI	'0'	;MAKE ASCII
	MOV	M,A	;STORE IT
	INX	H
	MVI	M,0
	RET
	ENDIF		;CLOCK
;
;SUBROUTINE TO CONVERT ASCII TIME TO BINARY
;
;USED TO PRINT CALLER'S ELAPSED TIME
;
;	HL POINTS TO "HH:MM"
;
;	BINARY MINUTES RETURNED IN HL
;
CONVTBI	EQU	$
	MOV	B,H	;POINTER..
	MOV	C,L	;..TO BC
	LXI	H,0	;INIT ANS
	CALL	CT10F	;GET DIGIT
	CALL	CT10	;X 10 + NEXT DIGIT
	INX	B	;SKIP COLON
	CALL	CT6	;X 6 + NEXT DIGIT
;
;FALL INTO CB10, TO MULTIPLY BY 10
;AND GET LAST DIGIT
;
;MULTIPLY HL BY 10 AND ADD IN BINARY
;VALUE OF NEXT ASCII DIGIT POINTED TO BY BC.
;
CT10	MOV	D,H	;SET UP..
	MOV	E,L	;..FOR MULT
	DAD	H	;X2
	DAD	H	;X4
	DAD	D	;X5
	DAD	H	;X10
;
;ENTER HERE TO GET FIRST DIGIT
;
CT10F	LDAX	B	;GET DIGIT
	INX	B	;TO NEXT DIGIT
	SUI	'0'	;MAKE BINARY
	ADD	L	;ADD TO LOW
	MOV	L,A	;SAVE BACK
	RNC
	INR	H	;ADD IN CARRY
	RET
;
;ROUTINE TO MULTIPLY HL BY 60, AND ADD
;IN NEXT DIGIT
;
CT6	MOV	D,H	;SET UP..
	MOV	E,L	;..FOR MULT
	DAD	H	;X2
	DAD	D	;X3
	DAD	H	;X6
	JMP	CT10F	;GET DIGIT
;
	LINK	CBBSSUB1 ;TO NEXT .ASM FILE
