Pragma crt(ON); -- list output to screen

-- Augusta Demonstration Program
-- written by Edward Mitchell, 29 July, 1982

Procedure NumGuess is
  lowbnd   : integer;    -- the lower bound of the guessing interval
  hibnd    : integer;    -- the upper bound
  again    : boolean;    -- false when the user wants to quit
  ch       : character;  -- dummy variable for input
  s        : string;     -- dummy string for input
  nguesses : integer;    -- # of guesses made by computer

function Guesser return integer is
  response : integer;   -- player's hi, lo or equal response
  count    : integer;   -- counts the number of guesses
  guess    : integer;   -- the guess
  lastguess: integer;   -- the previous guess
begin
  count := 1;           -- initialize some stuff
  guess := 0;
  loop
    lastguess := guess;
    guess := (lowbnd + hibnd) / 2;      -- uses a binary search

    if lastguess = guess then
      putline ("You messed up your entries!  I guarantee");
      putline ("to guess your number in less than 11 moves");
      putline ("but you entered a wrong response! and that");
      putline ("really upsets me.  I never make mistakes");
      putline ("like that . . .");
      return count;
    end if;

    newline; newline;
    putstr("Guess # ");
    putint(count);
    putstr("   Computer's guess = ");
    putint(guess); newline;

    putstr("Enter:  1=Too high,  2=Too low,  3=Equal or Quit ? ");
    getint(@response);

    case response is
      when 1 => hibnd := guess - 1;
      when 2 => lowbnd := guess + 1;
      when 3 => return count;
      when others => putline("Invalid input ignored");
    end case;

    count := count + 1;

  end loop;

end;  -- of function Guesser


begin -- procedure Guessnum
  again := true;
  putline("Number Guessing Game"); newline;
  putline("Choose a number between 1 and 1000 and the");
  putline("computer will try to guess your choice.");

  while again
  loop

    newline;
    putstr("Press RETURN after you have chosen your number:  ");
    getstr(@S);

    lowbnd := 1;
    hibnd := 1000;

    nguesses := guesser;        -- call the guessing routine
    newline;
    putstr("Number of guesses = ");
    putint(nguesses); newline; newline;


    putstr("Do you wish to play again (CR=yes/N=no) ? ");
    getchar(@ch);
    newline;
    if ch='N' then again := false;
    end if;
  end loop;
End;    -- of the program
