'Rascal Program Debugger, version 1.00  (C) Copyright 1983 Marty Franz

PROCEDURE DEBUG.SETUP
	'Set up stack of procedure names
	DB.NPROCS = 10
	DIM DB.LABEL$(DB.NPROCS),DB.LINE(DB.NPROCS)

	'Set up cursor and output variables
	DB.STATUS.LINE = 25
	DB.CUROFF = 0 : DB.CURON = 1
	DB.BLINK = 5 : DB.CURCNT = DB.BLINK
	DB.CURSOR$ = CHR$(&H5F)
	DB.BKSP$ = CHR$(8)
	DB.RET$ = CHR$(13)
	DB.TLBOX$ = CHR$(&HC9) : DB.TRBOX$ = CHR$(&HBB)
	DB.BLBOX$ = CHR$(&HC8) : DB.BRBOX$ = CHR$(&HBC)
	DB.TOP$ = CHR$(&HCD)   : DB.SIDE$ = CHR$(&HBA)
	DB.MASK$ = "\                              \"

	'String for proofing labels input as breakpoints
	DB.LABCHRS$ = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789."

	'Establish error and key trapping (F10 stops debugger)
	ON ERROR GOTO DB.BASIC.ERROR
	ON KEY(10) DO DEBUG.KEYBD.STOP
	KEY OFF
	KEY (10) ON

	DB.LEVEL = 0				'No procedures entered yet
	DB.BPOINT = 0				'No breakpoints in effect
	DB.CMDSTOP = 0				'No command keyboard stops

	DO DEBUG.HELLO
	DO DEBUG.PUSH.CURSOR
	DO DEBUG.CLR.MSG
	DO DEBUG.CMD
ENDPROC

DB.BASIC.ERROR| 				'Error routine for BASIC errors
	DO DEBUG.BASIC.ERROR
	DO DEBUG.CMD
	RESUME

PROCEDURE DEBUG.KEYBD.STOP		'Entered when F10 pressed
	DB.CMDSTOP = 1
ENDPROC

PROCEDURE DEBUG.HELLO			'Tell user available functions
	CLS
	PRINT "Rascal Program Debugger active..."
	PRINT
	PRINT "You can enter the debugger by:"
	PRINT 
	PRINT "   1. Pressing F10 during program execution,"
	PRINT "   2. Setting a procedure breakpoint with the B command,"
	PRINT "   3. Your program causing a BASIC error."
	PRINT
	PRINT "In the debugger, you can type:"
	PRINT
	PRINT "   X  to exit into BASIC (type CONT to go back),"
	PRINT "   D  to list the Rascal procedures called,"
	PRINT "   B  to set a procedure breakpoint,"
    PRINT "   G  to resume your program's execution"
ENDPROC

PROCEDURE DEBUG.BASIC.ERROR		'Process BASIC errors
	COLOR 15,0
	LOCATE DB.STATUS.LINE,1,CUROFF
	PRINT USING "##### ";ERL;
	DB.ERROR = ERR
	IF DB.ERROR > 77
		DB.ERROR = 77
	ENDIF
	DO DEBUG.ERROR.MSG
	LOCATE ,,CURON
	COLOR 7,0
ENDPROC

PROCEDURE DEBUG.ERROR.MSG		'Decode BASIC error msg
	RESTORE DB.ERROR.MSGS
	REPEAT
		READ DB.ERR.KEY,DB.ERROR.MSG$
		IF DB.ERR.KEY = DB.ERROR
			BREAK
		ENDIF
	UNTIL DB.ERR.KEY = 77
	PRINT USING DB.MASK$;DB.ERROR.MSG$
ENDPROC

PROCEDURE DEBUG.PROC			'Handle procedure call
	DO DEBUG.PUSH.CURSOR
	DB.LEVEL = DB.LEVEL + 1
	DB.LABEL$(DB.LEVEL) = DEBUG.LABEL$
	DB.LINE(DB.LEVEL) = DEBUG.LINE
	DO DEBUG.TRACE.MSG
	IF DB.BPOINT = 1 AND DB.BPLABEL$ = DEBUG.LABEL$
		DB.CMDSTOP = 1
	ENDIF
	IF DB.CMDSTOP = 1
		DO DEBUG.CLR.CMD
		DO DEBUG.CMD
		DB.CMDSTOP = 0
	ENDIF
	DO DEBUG.POP.CURSOR
ENDPROC

PROCEDURE DEBUG.ENDP			'Handle procedure exit
	DO DEBUG.PUSH.CURSOR
	DB.LEVEL = DB.LEVEL - 1
	DO DEBUG.TRACE.MSG
	DO DEBUG.POP.CURSOR
ENDPROC

PROCEDURE DEBUG.TRACE.MSG		'Display procedure and line
	COLOR 15,0
	LOCATE DB.STATUS.LINE,1,CUROFF
	IF DB.LEVEL > 0
		PRINT USING "##### ";DB.LINE(DB.LEVEL);
		PRINT USING DB.MASK$;DB.LABEL$(DB.LEVEL);
	ELSE
		PRINT USING DB.MASK$;"Exit";
	ENDIF
	LOCATE ,,CURON
	COLOR 7,0
ENDPROC

PROCEDURE DEBUG.CMD				'Get and process commands
	DB.DONE = 0
	REPEAT
		DO DEBUG.GET.CMD
		DO DEBUG.DO.CMD
	UNTIL DB.DONE = 1
	DO DEBUG.CLR.CMD
ENDPROC

PROCEDURE DEBUG.GET.CMD 		'Get and proof debugger command
	DO DEBUG.CLR.CMD
	PRINT "debug: ";
	REPEAT
		DO DEBUG.GET.KEY
		DB.ISKEY = INSTR("BDGX",DB.KEY$)
	UNTIL DB.ISKEY > 0
ENDPROC

PROCEDURE DEBUG.DO.CMD			'Call procedure for each command
	IF DB.KEY$ = "G"
		DB.DONE = 1
	ELSE
		IF DB.KEY$ = "X"
			DO DEBUG.DO.STOP
		ELSE
			IF DB.KEY$ = "B"
				DO DEBUG.DO.BPOINT
			ELSE
				IF DB.KEY$ = "D"
					DO DEBUG.DO.DUMP
				ELSE
					BEEP
				ENDIF
			ENDIF
		ENDIF
	ENDIF
ENDPROC

PROCEDURE DEBUG.DO.STOP 		'Handle exit to BASIC
	PRINT "exit to BASIC";
	DO DEBUG.POP.CURSOR
	PRINT : PRINT "Type CONT to go back to debugger..."
	STOP
ENDPROC

PROCEDURE DEBUG.DO.BPOINT		'Set breakpoint
	DO DEBUG.CLR.CMD
	PRINT "breakpoint: ";
	DO DEBUG.GET.STRING
	DB.BPLABEL$ = DB.INPUT$
	IF LEN(DB.BPLABEL$) > 0
		DB.BPOINT = 1
	ELSE
		DB.BPOINT = 0
	ENDIF
ENDPROC

PROCEDURE DEBUG.DO.DUMP 		'Dump stack of procedure calls
	PRINT "dump procedure stack";
	LOCATE 1,38
	PRINT DB.TLBOX$;
	FOR DB.I = 1 TO 40 : PRINT DB.TOP$; : NEXT DB.I
    PRINT DB.TRBOX$
	FOR DB.I = DB.LEVEL TO 1 STEP -1
		LOCATE ,38
		PRINT DB.SIDE$;" ";
		PRINT USING "##### ";DB.LINE(DB.I);
		PRINT USING DB.MASK$;DB.LABEL$(DB.I);
		PRINT " ";DB.SIDE$
	NEXT DB.I
	LOCATE ,38
	PRINT DB.BLBOX$;
	FOR DB.I = 1 TO 40 : PRINT DB.TOP$; : NEXT DB.I
	PRINT DB.BRBOX$;
ENDPROC

PROCEDURE DEBUG.GET.STRING		'Get label name for breakpoint
	DB.INPUT$ = ""
	DB.START.COL = POS(0)
	REPEAT
		DO DEBUG.GET.KEY
		IF DB.KEY$ = DB.RET$
			BREAK
		ELSE
			IF DB.KEY$ = DB.BKSP$
				DO DEBUG.DEL.CHAR
			ELSE
				IF INSTR(DB.LABCHRS$,DB.KEY$) > 0
					DO DEBUG.INS.CHAR
				ELSE
					BEEP
				ENDIF
			ENDIF
		ENDIF
	UNTIL 1 = 0
ENDPROC

PROCEDURE DEBUG.GET.KEY 		'Get uppercase key from keyboard
	REPEAT
		DO DEBUG.CURSOR
		DB.KEY$ = INKEY$
	UNTIL LEN(DB.KEY$) > 0
	IF ASC(DB.KEY$) > 96 AND ASC(DB.KEY$) < 123
		DB.KEY$ = CHR$(ASC(DB.KEY$) - 32)
	ENDIF
ENDPROC

PROCEDURE DEBUG.INS.CHAR		'Add char to end of breakpoint label
	IF POS(0) < 79
		PRINT DB.KEY$;
		DB.INPUT$ = DB.INPUT$ + DB.KEY$
	ELSE
		BEEP
	ENDIF
ENDPROC

PROCEDURE DEBUG.DEL.CHAR		'Handle backspace key in input
	DB.CUR.COL = POS(0)
	IF DB.CUR.COL > DB.START.COL
		DB.INPUT$ = LEFT$(DB.INPUT$,LEN(DB.INPUT$)-1)
		PRINT " ";
		LOCATE ,DB.CUR.COL-1
	ELSE
		BEEP
	ENDIF
ENDPROC

PROCEDURE DEBUG.CURSOR			'Simulate BASIC cursor
	IF DB.CURCNT = DB.BLINK
		IF DB.CURCHAR$ = DB.CURSOR$
			DB.CURCHAR$ = " "
		ELSE
			DB.CURCHAR$ = DB.CURSOR$
		ENDIF
		DB.CURCNT = 0
	ENDIF
	PRINT DB.CURCHAR$;
	DB.CURCNT = DB.CURCNT + 1
	LOCATE ,POS(0)-1
ENDPROC

PROCEDURE DEBUG.CLR.CMD 		'Clear command area of status line
	LOCATE DB.STATUS.LINE,40,CUROFF
	PRINT SPACE$(40);
	LOCATE DB.STATUS.LINE,40,CURON
ENDPROC

PROCEDURE DEBUG.CLR.MSG 		'Clear message area of status line
	LOCATE DB.STATUS.LINE,1,CUROFF
	PRINT SPACE$(40);
	LOCATE DB.STATUS.LINE,1,CURON
ENDPROC

PROCEDURE DEBUG.PUSH.CURSOR		'Save program's cursor
	DB.ROW = CSRLIN : DB.COL = POS(0)
ENDPROC

PROCEDURE DEBUG.POP.CURSOR		'Restore program's cursor
	LOCATE DB.ROW,DB.COL
ENDPROC

DB.ERROR.MSGS|					'Table of BASIC error messages
	DATA  1,"NEXT without FOR"
	DATA  2,"Syntax error"
	DATA  3,"RETURN without GOSUB"
	DATA  4,"Out of data"
	DATA  5,"Illegal function call"
	DATA  6,"Overflow"
	DATA  7,"Out of memory"
	DATA  8,"Undefined line number"
	DATA  9,"Subscript out of range"
	DATA 10,"Duplicate definition"
	DATA 11,"Division by zero"
	DATA 12,"Illegal direct"
	DATA 13,"Type mismatch"
	DATA 14,"Out of string space"
	DATA 15,"String too long"
	DATA 16,"String formula too complex"
	DATA 17,"Can't continue"
	DATA 18,"Undefined user function"
	DATA 19,"No RESUME"
	DATA 20,"RESUME without error"
	DATA 22,"Missing operand"
	DATA 23,"Line buffer overflow"
	DATA 24,"Device timeout"
	DATA 25,"Device fault"
	DATA 26,"FOR without NEXT"
	DATA 27,"Out of paper"
	DATA 29,"WHILE without WEND"
	DATA 30,"WEND without WHILE"
	DATA 50,"FIELD overflow"
	DATA 51,"Internal error"
	DATA 52,"Bad file number"
	DATA 53,"File not found"
	DATA 54,"Bad file mode"
	DATA 55,"File already open"
	DATA 57,"Device I/O error"
	DATA 58,"File already exists"
	DATA 61,"Disk full"
	DATA 62,"Input past end"
	DATA 63,"Bad record number"
	DATA 64,"Bad file name"
	DATA 66,"Direct statement in file"
	DATA 67,"Too many files"
	DATA 68,"Device unavailable"
	DATA 69,"Communication buffer overflow"
	DATA 70,"Disk Write Protect"
	DATA 71,"Disk not ready"
	DATA 72,"Disk media error"
	DATA 73,"Advanced feature"
	DATA 74,"Rename across disks"
	DATA 75,"Path/file access error"
	DATA 76,"Path not found"
	DATA 77,"Unprintable error"
