;NEEDLEN.ASM
;
;6.12.85

comment ~

        Compute length of file needed.


Uses:
	clavail         clusters available
	hisiz           file size in bytes, high word
	losiz           "		  , low word	
	bpc             bytes per cluster (word)

On output:
	clneed          clusters needed: to be computed
	clmake		clusters to be made by dummy file

Notes:
	clusters needed = file size
        	          ------------          , rounded up to next whole cluster
                	  bytes per cluster


This is a double word divided by word division operation (Reference p. 3-38)

~

;----------------------------------------------------------
;		constants and messages

needlen_msg	db	cr,lf,'needlen: ',eos
zerodiv_msg	db	'zero divide error',cr,lf,eos
nospace_msg	db	'not enough disk space',cr,lf,eos

;----------------------------------------------------------
;		data storage

clneed  	dw      0
clmake  	dw      0

;----------------------------------------------------------
;		main code section

NEEDLEN		proc	near

clneeded:
	        mov     dx,hisiz                ;load most sig and..
        	mov     ax,losiz                ;..least sig parts of byte count
	        cmp     bpc,0                   ;check for imminent division by zero
	        jnz     divok
		mov	dx,offset needlen_msg	;error--div by zero
		mov	ah,9h
		int	21h
		mov	dx,offset zerodiv_msg
		mov	ah,9h
		int	21h
		mov	ax,99
		jmp	nl_err

divok:  	div     bpc                     ;divide by the bytes per cluster
	        cmp     dx,0                    ;if zero remainder..
	        je      clnok                   ;..do not need to round up
	        add     ax,1                    ;round up for the remainder
clnok:  	mov     clneed,ax
	        cmp     ax,clavail              ;compare with available
	        jna     okneed
		mov	dx,offset needlen_msg	;need more than available
		mov	ah,9h			;print string function call
		int	21h
		mov	dx,offset nospace_msg
		mov	ah,9h
		int	21h
		mov	ax,99			;special error return code		
		jmp	nl_err

okneed: 
	        neg     ax                      ;change sign
        	add     ax,clavail
	        mov     clmake,ax
        
nlok_xit:	
		clc				;clear CY for ok return
		ret

nl_err:
		cmp	ax,99
		je	nl_err99
		push	ax		;save error code
		mov	dx,offset needlen_msg
		mov	ah,9h
		int	21h
		pop	ax
		call	errmsg
nl_err99:	
		stc
		ret

needlen		endp
