#include <stdio.h>

/*
STRUX2 --	"structured" assembly-language preprocessor
			%1.a =>%1.asm

V 2.0 --
  This version compiled under DeSmet v2.5 and v3.0
  
THIS PROGRAM IS PUBLIC DOMAIN
 and may be freely used, modified, and distributed.
 
 If you find it useful and would like to express your appreciation,
 DON'T send me a contribution!  Just support your local bulletin
 boards with courtesy, enthusiasm and good free software.
 That's what it's all about, after all!
 
 Davidson Corry
 4610 SW Lander
 Seattle, WA  98116
 206 / 935-0244

The SWITCH features were added by

Dr Joseph Mack, Mar 88
Dept Chem, UMBC
5401 Wilkens Ave
Catonsville,MD,21228
(301)-455-3292/2564(w)

		or via the CPCUG MIX RBBS				301-480-0350 (adv conference)
		or via the Chicago RBBS/Loren Jones Sysop	312-352-1013 (coders conference)
		or via the Fargo RBBS/Jim Grettum Sysop		701-235-3982 (coders conference)
	(These last two are subscription phone numbers. If you aren't
a subscriber, on sign on you will be given the non-subscription
phone number, which you can use to  call back.)

Comments by Joe Mack on how it works.
	A few variable names from v1.0 have been changed to better show
their function

		name							function
STRUX2			STRUX1

nestlevel		depth				nest level number
labelnumber		counter				target counter
typestruct		typestack				IF, WHILE, SWITCH


	nestlevel keeps track of the nest layer of nested loops
(ie IF, WHILE, SWITCH's) that we are in.
	labelnumber is a counter that increments everytime we need a
new unique label to jump to.
	typestruct[nestlevel] holds the type of structure we are in,
eg IF, WHILE, SWITCH. It's used whenever a matched open/close is
needed eg IF-ENDIF, WHILE-WEND, SWITCH-SWEND.
	The labels for the targets of jump instructions consist of
two parts; an alphabetical part showing the type of jump to it
and a counter (labelnumber, contained in targetstack[nestlevel])
which is incremented every time a new target is needed. As only
one counter is used for all the different types of nests, there
will be gaps in the numbering sequence for any particular type of
jump. 

Jump target labelling convention

	_fxx	forward jump 
	_bxx	backward jump
	_exx	structure end

	etargetstack[nestlevel] holds labelnumber for the end of the
current nest  (ENDIF, WEND, SWEND). The number is the value of
labelnumber when the nest is entered.
	For STRUX2, the labelling for .BREAK targets has been changed
from _fxx: of STRUX1 to _exx: so that .BREAK can be used to exit
from both .SWITCH and .LOOP.

*/


#define 	IF		1
#define 	ELSEIF 	2
#define 	ELSE 	3
#define 	ENDIF 	4
#define 	WHILE 	5
#define 	BREAK 	6
#define 	CNTNU 	7
#define 	WEND 	8
#define 	SWITCH	9
#define 	CASE 	10
#define	SWEND	11
#define	DEFAULT	12


int errorcount = 0;
int	etargetstack[20];
int	labelnumber;
int lincount = 0;
int nestlevel;
int	targetstack[20];
int	typestruct[20];

char *index();

char switcharguementstack[20][15] =; 
				/* 20 levels, of opcodes of upto 15 (plus NULL) char each */

char infilname[20], outfilname[20];

char buf[256], remark[256], opcode[256], test[256];

char tabs[256];

FILE *inf, *outf;

char *findstruct(i)
int i;
	/*
	find string assoc with i. Reverse of #define for .IF=>1
	*/
	{
	switch (i)
		{
		case 1:
			return (".IF");
			break;

		case 5:
			return (".WHILE");
			break;

		case	9:
			return (".SWITCH");
			break;

		default:
			return ("unknown nest type");
			break;
		}
	}


main(argc,argv)
int argc;
char *argv[];
	{
	if (argc<2)
		usage();

	strcpy(infilname,argv[1]);
	strcat(infilname,".A");
	if ( !(inf = fopen(infilname,"r")) )
		cantopen(infilname);
	strcpy(outfilname,argv[1]);
	strcat(outfilname,".ASM");
	if ( !(outf = fopen(outfilname,"w")) )
		cantopen(outfilname);

	while (fgets(buf,255,inf))
		{
		++lincount;
		if (!(lincount%20)) fprintf(stderr,"\r%d",lincount);
		striplabel();
		expand(buf);
		}
	/*STRUX1 would exit with unclosed structures eg an .IF without .ENDIF*/
	while (nestlevel)
		{
		bad (""); 					/*bad supplies \n for next line */
		printf ("Open %s at nest level %d. ", findstruct(typestruct[nestlevel]), nestlevel);
		printf ("Expecting to write jump target _e%d: or _f%d:",etargetstack[nestlevel], etargetstack[nestlevel]);
		nestlevel--;
		}
	printf ("\n"); /* closing \n from nestlevel errors */	

	fputs("\r             \r",stderr);
	fclose(inf);
	fclose(outf);
	exit(errorcount);
	}

expand(s)
char *s;
	{
	int ityp;

	ityp = itype(s);
	if (!ityp) { fputs(s,outf); return; }
	fprintf(outf,";%s",s);

	switch (ityp)
		{

	case IF:
		++nestlevel; ++labelnumber;
		typestruct[nestlevel] = IF;
		targetstack[nestlevel] = labelnumber;
		etargetstack[nestlevel] = labelnumber;
		if (strlen(opcode))
			fprintf(outf,"%s%s\n",tabs,opcode);
		if (strlen(test))
			fprintf(outf,"%s%s\t_f%d\n",tabs,notjump(test),labelnumber);
		break;

	case ELSEIF:
		if (!nestlevel || typestruct[nestlevel] != IF)
			{
			bad(".ELSEIF w/o .IF");
			break;
			}
		fprintf(outf,"%sjmp\t_e%d\n_f%d:\n",tabs,etargetstack[nestlevel],targetstack[nestlevel]);
		targetstack[nestlevel] = ++labelnumber;
		if (strlen(opcode))
			fprintf(outf,"%s%s\n",tabs,opcode);
		if (strlen(test))
			fprintf(outf,"%s%s\t_f%d\n",tabs,notjump(test),labelnumber);
		break;

	case ELSE:
		if (!nestlevel || typestruct[nestlevel] != IF)
			{
			bad(".ELSE w/o .IF");
			break;
			}
		fprintf(outf,"%sjmp\t_e%d\n_f%d:\n",tabs,etargetstack[nestlevel],targetstack[nestlevel]);
		targetstack[nestlevel] = ++labelnumber;
		break;

	case ENDIF:
		if (!nestlevel || typestruct[nestlevel] != IF)
			{
			bad(".ENDIF w/o .IF");
			break;
			}
		fprintf(outf,"%s_f%d:\n%s_e%d:\n",tabs, targetstack[nestlevel], tabs, etargetstack[nestlevel]);
		--nestlevel;
		break;

	case WHILE:
		++nestlevel;
		++labelnumber;
		etargetstack[nestlevel] = labelnumber; /*e*/
		typestruct[nestlevel] = WHILE;
		fprintf(outf,"%s_b%d:\n", tabs, etargetstack[nestlevel]);
		if (strlen(opcode))
			fprintf(outf,"%s%s\n",tabs,opcode);
		if (strlen(test))
			fprintf(outf,"%s%s\t_e%d\n",tabs,notjump(test),etargetstack[nestlevel]);
		break;

	case BREAK:
		if (loopdepth() == -1)
			{
			bad(".BREAK not within a .SWITCH/.LOOP structure");
			break;
			}
		if (strlen(opcode))
			fprintf(outf,"%s%s\n",tabs,opcode);
		if (strlen(test))
			fprintf(outf,"%s%s\t_e%d\n",tabs,jump(test),etargetstack[loopdepth()]);
		else
			fprintf(outf,"%sjmp\t_e%d\n",tabs,etargetstack[loopdepth()]);
		break;

	case CNTNU:
		if (loopdepth() == -1)
			{
			bad(".CNTNU w/ no .LOOP open");
			break;
			}
		if (strlen(opcode))
			fprintf(outf,"%s%s\n",tabs,opcode);
		if (strlen(test))
			fprintf(outf,"%s%s\t_b%d\n",tabs,jump(test),etargetstack[loopdepth()]);
		else
			fprintf(outf,"%sjmp\t_b%d\n",tabs,etargetstack[loopdepth()]);
		break;

	case WEND:
		if (nestlevel==0 || typestruct[nestlevel]!=WHILE)
			{
			bad(".LEND w/ no .LOOP open");
			break;
			}
		if (strlen(opcode))
			fprintf(outf,"%s%s\n", tabs, opcode);
		if (strlen(test))
			fprintf(outf,"%s%s\t_b%d\n", tabs, notjump(test), etargetstack[nestlevel]);
		else
			fprintf(outf,"%sjmp\t_b%d\n",tabs, etargetstack[nestlevel]);/*e*/
			fprintf(outf,"%s_e%d:\n", tabs, etargetstack[nestlevel]);
		--nestlevel;
		break;


	case SWITCH:

		++nestlevel;
		++labelnumber;
		typestruct[nestlevel] = SWITCH;
		targetstack[nestlevel] = labelnumber;
		etargetstack[nestlevel] = labelnumber;

		fprintf(outf,";%sswitch arguement = %s\n",tabs,opcode);
		strcpy (switcharguementstack[nestlevel], opcode);

		break;
		
	case	CASE:

		if (!nestlevel || typestruct[nestlevel] != SWITCH)
			{
			bad(".CASE w/o .SWITCH");
			break;
			}
		targetstack[nestlevel] = labelnumber;
		fprintf(outf,"%s_f%d:\n", tabs, targetstack[nestlevel]);
		++labelnumber;
		targetstack[nestlevel] = labelnumber;
		fprintf(outf,"%scmp\t%s, %s\n", tabs, switcharguementstack[nestlevel], opcode); 	
		fprintf(outf,"%sjne\t_f%d\n", tabs, targetstack[nestlevel]);

		break;


	case	DEFAULT:

		if (!nestlevel || typestruct[nestlevel] != SWITCH)
			{
			bad(".DEFAULT w/o .SWITCH");
			break;
			}
		labelnumber++;
		fprintf(outf,"%s_f%d:\n", tabs, targetstack[nestlevel]);
		break;
	
	case	SWEND:
		 if (!nestlevel || typestruct[nestlevel] != SWITCH)
			{
			bad(".SWEND w/o opening .SWITCH");
			break;
			}
		fprintf(outf,"%s_e%d:\n", tabs, etargetstack[nestlevel]);
		--nestlevel;
		break;


	default:
		fputs(buf,outf);
		break;
		}
	}

usage()
	{
	fputs("STRUX [file]\n\trewrites [file].A with structures expanded",stderr);
	exit(0);
	}

leads(s,o)
char *s, *o;
	{
	for ( ; isspace(*s); ++s)
		;
	if (strncmp(s,o,strlen(o))==0 && isspace(*(s+strlen(o))) )
		return(TRUE);
	return(FALSE);
	}

itype(s)
char *s;
	{
	char *p, *q;
	int typ;

	for ( p=tabs ; isspace(*s); *p++ = *s++)
		;
	*p = '\0';
	if (leads(s,".IF"))
		typ = IF;
	else if (leads(s,".ELSEIF"))
		typ = ELSEIF;
	else if (leads(s,".ELSE"))
		typ = ELSE;
	else if (leads(s,".ENDIF"))
		typ = ENDIF;
	else if (leads(s,".WHILE") || leads(s,".REPEAT") || leads(s,".LOOP") )
		typ = WHILE;
	else if (leads(s,".BREAK"))
		typ = BREAK;
	else if (leads(s,".CNTNU"))
		typ = CNTNU;
	else if (leads(s,".WEND") || leads(s,".UNTIL") || leads(s,".LEND") )
		typ = WEND;
	else if (leads(s,".SWITCH"))
		typ = SWITCH;
	else if (leads(s,".CASE"))
		typ = CASE;
	else if (leads(s,".DEFAULT"))
		typ = DEFAULT;
	else if (leads(s,".SWEND"))
		typ = SWEND;
	else
		typ = NULL;

	if (typ)
		{
		opcode[0] = test[0] = remark[0] = '\0';
		/* break into opcode, argument, remark */
		for ( ; !isspace(*s); ++s)
			;
		for ( ; isspace(*s); ++s)
			;
		if (*s==';' || *s=='\n')
			{
			strcpy(test,"");
			strcpy(opcode,"");
			strcpy(remark,s);
			}
		else
			{
			if (*s=='<')
				{
				p = s+1;
				for ( s = p; *s && *s != '>'; ++s )
					{
					if (*s=='\'')
						s = index(s+1,'\'');
					else if (*s=='\"')
						s = index(s+1,'\"');
					}
				}
			else
				{
				p = s;
				for ( s = p; *s && *s != ','; ++s )
					{
					if (*s=='\'')
						s = index(s+1,'\'');
					else if (*s=='\"')
						s = index(s+1,'\"');
					}
				}
			for (q = opcode; p < s; *q++ = *p++)
				;
			*q = '\0';
			while ( *s && *s++ != ',')
				;
			for (p = s; isalpha(*s); ++s)
				;
			for (q = test; p < s; *q++ = *p++)
				;
			*q = '\0';
			strcpy(remark,s);
			}
		}
	return(typ);
	}

striplabel()
	{
	char *p;

	if (!isid(buf[0]))
		return;
	strcpy(remark,buf);
	for (p = remark+1; isid(*p) || isdigit(*p); ++p)
		;
	for ( ; *p==':'; ++p )
		;
	strcpy(buf,p);
	if (*(p-1)==':') strcpy(p,"\n"); else *p='\0';
	fputs(remark,outf);
	strcpy(remark,"");
	}

isid(k)
char k;
	{
	return(isalpha(k)||k=='_'||k=='?'||k=='$'||k=='@');
	}

jump(s)
char *s;
	{
        static char truejump[5];

        sprintf(truejump,"j%s",s);
        for (s = truejump; *s; ++s) *s = tolower(*s);
        return(truejump);
	}

notjump(s)
char *s;
	{
        static char truejump[5];
        
        if (strcmp(s,"PE")==0) return("jpo");
        if (strcmp(s,"PO")==0) return("jpe");
        if (*s=='N') sprintf(truejump,"j%s",s+1);
        else sprintf(truejump,"jn%s",s);
        for (s = truejump; *s; ++s) *s = tolower(*s);
        return(truejump);
	}

loopdepth()
	{
	int i;

	for (i = nestlevel; i>0; --i)
		/* go back up through the nests to see if we are in a WHILE or SWITCH */
		if ((typestruct[i] == WHILE)||(typestruct[i] == SWITCH))
			return(i);
	return(-1);
	}

bad(s)
char *s;
	{
	/*
	STRUX1->2
	Have shifted \n to beginning of control line. This allows 
	print out of a possible unclosed structure error message on same line.
	*/
	fprintf(stderr,"\n\r%d: %s",lincount,s);
	++errorcount;
	}

cantopen(s)
char *s;
	{
	fprintf(stderr,"Can't open %s",s);
	exit(1);
	}
