
Program StarryNights;

{Contains the following routines:
   Date_Time_Stamp
   Min_Sec
   ProcessString
   ASCIIBox
   IniDateTime
   InitialValues
   OpeningScreen
   GetScreenType
   LoadData
   GetRaDec                    Starry Nights v. 9/12/88
   OptionMenu          Written by Rob Crockett, San Antiono, Tx
   DateTimeMenu
   GetConst          Graphics display of stars, planets and Messier
   IntroMenu         objects with Hercules Graphics, CGA, or EGA.
   Mouse             Allows some screen modification with a MicroSoft
   EGAStoreGraph     compatable mouse, and printing to an Epson
   HGStoreGraph      compatable printer.
   GetColor
   GetPlotHerc
   GetPlotCGA
   GetPlotEGA
   PlotData
   AutoSelectPlanet
   GetPlanet }    {includes planet.p}

{$K- }
Const
   Version = '9/12/88';
   Hiddencursor = 8192;

Type
  Star_Datum = Record
     RA,DEC,MAG,BV     :Real;
     Constel           :String[3];
     End;
  StarDatumArray = Array[0..2008] of Star_Datum;
  Constellation_Datum = Record
     Right_Ascen,Declin: Real;
     Abbrev            :String[3];
     Constellation     :String[20];
     end;
  String9 = String[9];                     {used in Function Min_Sec}
  String14 = String[14];
  String20 = String[20];                   {used in Function ProcessString}

Var
  Star_Array                              :StarDatumArray;
  Constellation_Array                     :Array[1..90] of Constellation_Datum;
  MSDOS_Parms                                     :Record
         AX,BX,CX,DX,BP,SI,DI,DS,ES,Flags         :Integer;
        end;
  H2rad,Radian,RAo,DECo,Wid,Yht,BVa,Maga  :Real;
  Sx,Sy,Num,Menu,Code,Xx,Yy,Constnum,IPo,
  Max_Col,Max_Row,ScreenType,Color,
  Oldcursor                               :Integer;
  Constn                                  :String[3];
  Constname,Dum,Planetname                :String[20];
  Ch,Col,High,Autoselect                  :Char;
  Mesb,ConstelDatExist,PlanetsDatExist    :Boolean;

  Daynumber, Monthnumber, Yearnumber,
  Hournumber, Minutenumber                :Integer;
  Latnumber,Longnumber                    :Real;
  Lat,Long                                :String[7];
  Year,Time                               :String[5];
  Month,Day,Hour,Minute,Second            :String[3];

{$I GPPARMS.P }                  {EGA graphics routines}
{$I GPINIT.P  }
{$I GPTERM.P  }
{$I GPCOLOR.P }
{$I GPPLOT.P  }
{$I GPRDCOL.P }
{$I GPMOVE.P  }
{$I GPLINE.P  }
{$I GPRECT.P  }

{$I HGGraph.inc }                {Hercules graphics routines}

{$I Qinit.inc   }                {Qwick write routines}
{$I Qwrites.inc }
{$I Qfills.inc  }
{$I Cursor.inc  }
                                 {Planets.p is included within GetPlanet}
{$I TMouse.inc}                  {TurboMouse procedures}

Function Date_Time_Stamp: String14;
  Begin
     Str(Monthnumber,Month);
     Str(Daynumber,Day);
     Str(Yearnumber-1900,Year);
     Str(Hournumber,Hour);
     Str(Minutenumber,Minute);
     If (Monthnumber<10) then Month:='0'+Month;
     If (Daynumber<10) then Day:='0'+Day;
     If (Yearnumber=1900) or (Yearnumber=2000) then Year:='00';
     If (Hournumber<10) then Hour:='0'+Hour;
     If (Minutenumber<10) then Minute:='0'+Minute;
     Date_Time_Stamp:=Month+'/'+Day+'/'+Year+' '+Hour+':'+Minute;
   End;

Function Min_Sec(Input:Real): String9;
  Var
    XH                 :Real;
    XM,XS              :Integer;
    Hour,Minute,Second :String[3];
  Begin
    XH:=Abs(Int(Input));
    XM:=Abs(Trunc(Frac(Input)*60));
    XS:=Abs(Round(Frac(Frac(Input)*60)*60));
    Str(XH:2:0,Hour);
    Str(XM,Minute);
    Str(XS,Second);
    if (Input<0) then Hour:='-'+Hour else Hour:=' '+Hour;
    if (XM<10) then Minute:='0'+Minute;
    if (XS<10) then Second:='0'+Second;
    Min_Sec:=Hour+':'+Minute+':'+Second;
  End;

Function ProcessString(Dum: string20): real;  {used by GetRaDec}
Var
   Position,K                 :Integer;
   Number,DumNumber           :Real;
   Negatory                   :Boolean;
Begin
   Repeat
     Position:=Pos(' ',Dum);
     If (Position<>0) then Delete(Dum,Position,1);
   Until Position=0;
   Repeat
     Position:=Pos('-',Dum);
     If (Position<>0) then
        Begin
           Negatory:=true;
           Delete(Dum,Position,1);
        End;
   Until (Position=0);
   K:=1;
   Repeat
     Position:=Pos(':',Dum);
     If Position=0 then Val(Dum,Number,Code)
     Else
       Begin
          Val(copy(Dum,1,Position-1),Number,Code);
          Delete(Dum,1,Position);
       End;
     Case K of
       1: DumNumber:=Number;
       2: DumNumber:=DumNumber+Number/60;
       3: DumNumber:=DumNumber+Number/3600;
     End;  {of case}
     K:=Succ(K);
   Until (Position=0) or (K=4);
   If Negatory then DumNumber:=-DumNumber;
   ProcessString:=Dumnumber;
end;    {of procedure}

Procedure ASCIIBox(X1,Y1,X2,Y2,C: Integer);
  Begin
    Qwrite(Y1,X1,C,'');  Qfill(Y1,X1+1,1,X2-X1-1,C,''); Qwrite(Y1,X2,C,'');
    Qfill(Y1+1,X1,Y2-Y1-1,1,C,''); Qfill(Y1+1,X2,Y2-Y1-1,1,C,'');
    Qwrite(Y2,X1,C,''); Qfill(Y2,X1+1,1,X2-X1,C,''); Qwrite(Y2,X2,C,'');
  End;

Overlay Procedure IniDateTime;
  Type Regpack = Record
        AX,BX,CX,DX,BP,SI,DI,DS,ES,Flags: Integer;
        end;
  Var
     Recpack: Regpack;
  Begin
     With Recpack do begin AX:=$2A shl 8; end;
     Msdos(Recpack);
     With Recpack do
          Begin
               Yearnumber:=CX;
               Daynumber:=DX mod 256;
               Monthnumber:=DX shr 8;
          End;
     With Recpack do begin AX:= $2C shl 8; end;
     Msdos(Recpack);
     With Recpack do
          Begin
               Hournumber:=CX shr 8;
               Minutenumber:=CX mod 256;
          End;
  End;

Overlay Procedure InitialValues;
Begin
 Menu:=6;                      {default to plot stars}
 High:='y';                    {default to highlight constellation}
 Mesb:=true;                   {default to plot Messier objects}
 Constnum:=62;                 {default Orion}
 Constn:='ORI';
 Constname:='ORION';
 RAo:=5.48;                    {default RA=5.48 DEC=4.21...Orion constellation}
 DECo:=4.21;
 IPo:=6;                       {Sixth planet is Saturn}
 PlanetName:='       ';               {clears planet name}
 Wid:=70.0;                    {default horizontal field width in degrees}
 Col:='n';                     {default not to display star colors/temperatures}
 Radian:= pi/180.0;            {constants used when loading stars to memory}
 H2rad:= radian*(360.0/24.0);
 Latnumber:=30.0;              {latitude and longitude of San Antonio, Tx}
 Longnumber:=99.0;
 Autoselect:='Y';              {yes to automatically select constellation}
 Case ScreenType of
    1: Begin                   {Hercules}
         Sx:=720;
         Sy:=348;
         Yht:=0.74;
         Max_Col:=719;
         Max_Row:=347;
       End;
    2: Begin                   {CGA}
         Sx:=640;
         Sy:=200;
         Yht:=0.38;
         Max_Col:=639;
         Max_Row:=199;
       End;
    3: Begin                   {EGA}
         Sx:=640;              {size of EGA graphics screen}
         Sy:=350;
         Max_col:=639;
         Max_Row:=349;
         Yht:=0.7616;          {empirical ratio...y*yht=x in actual distance}
       End;
   End;                        {of case}
End;                           {of procedure}

Overlay Procedure OpeningScreen;
  {Please resist the temptation to modify this procedure.  I don't
   ask for much--just my name in lights.}
Var
  K: Integer;
Begin
  Clrscr;
  Qwrite(5,1,14, '          ͸');
  Qwrite(6,1,14, '              ');
  Qwrite(7,1,14, '          ͻ        ͻ ');
  Qwrite(8,1,14, '                        ');
  Qwrite(9,1,14, '          ͼ          ');
  Qwrite(10,1,14,'                         ');
  Qwrite(11,1,14,'                        ͼ');
  Qwrite(8,16,15,'TARRY');
  Qwrite(10,29,15,'IGHTS');

  Qwrite(4,43,15, '      Starry Nights        ');
  Qwrite(5,43,15, '       v. '+version);
  Qwrite(7,43,15, ' Written by Rob Crockett   ');
  Qwrite(8,43,15, '   San Antonio, Texas      ');
  Qwrite(9,43,15, '                             ');
  Qwrite(10,43,15,'Indoor astronomy with the PC,');
  Qwrite(11,43,15,'supporting Hercules graphics,');
  Qwrite(12,43,15,'CGA, and EGA.                ');
  ASCIIBox(5,2,76,15,7);
End;

Overlay Procedure GetScreenType;
Var
  J,K: Integer;
Begin
  Repeat

    Intr($11,MSDOS_Parms);
    Screentype:=(MSDOS_Parms.AX shl 10) shr 14;   {2=color, 3=mono}
    If (ScreenType=3) then ScreenType:=1;
    If (ScreenType=2) and (GDType<>0) then ScreenType:=3;
    Str(Screentype,Dum);                 {GDType=0 means not EGA}
    Qwrite(18,10,7,'   1. Hercules');
    Qwrite(19,10,7,'   2. CGA     ');
    Qwrite(20,10,7,'   3. EGA     ');
    Qwrite(23,10,7,'Choose graphics adapter ('+Dum+'): ');
    Gotoxy(39,23); Readln(Dum);
    If (dum<>'') then Val(Dum,Screentype,Code);
    Qfill(16,1,9,80,0,' ');
  Until Screentype in [1..3];
End;

Overlay Procedure LoadData;
       {Loads star/object data into memory arrays for faster access during
        plotting:
                  RA contains modified right ascention data,
                  DEC contains modified declination data,
                  MAG contains magnitude,
                  BV contains star color/B-V.}
Var
   Textfile                           :Text;    {"STARRY.DAT" star data file}
   Binfile                            :File of StarDatumArray;
   K,Loadtype                         :Integer;
   BVa,R,D,Maga,Rh,Rm,Rs,Dd,Dm,Ds     :Real;
   Dataline                           :String[34];  {80}
   S1,S2,S3                           :String[10];
   Sign                               :String[2];
   S4                                 :String[80];

  Procedure LoadBinFile;      {within LoadData}
     Begin
       Qwrite(23,28,15,'Loading STARBIN.DAT');
       Assign(BinFile,'STARBIN.DAT');
       Reset(BinFile);
       Read(BinFile,Star_Array);
       Num:=trunc(Star_Array[0].RA);
       Close(BinFile);
     End;
  Procedure LoadTextFile;   {withing Loaddata, puts textfile in the main array}
  Begin
     Assign(Textfile,'STARRY.DAT');
     Reset(Textfile);
     Qwrite(17,5,14,'Loading the memory with 1680 stars takes about 20 seconds on an 80286.');
     Qwrite(19,5,14,'  #   Ascention  Declination   Mag   B-V  Star     Constellation');
     K:=1;
     Readln(Textfile);Readln(Textfile);Readln(Textfile); {advance past title}
     While not Eof(Textfile) do
      With Star_Array[K] do
        Begin
           Readln(Textfile,Rh,Rm,Rs,Sign,Dd,Dm,Ds,Mag,Bv,Dataline);
           Constel:=Copy(Dataline,11,3);
           R:= Rh + Rm/60.0 + Rs/3600.0;
           D:= Dd + Dm/60.0 + Ds/3600.0;
           If (Sign=' -') then D:=-Abs(D);
           Str(K:4,S1);
           Str(Mag:8:1,S2);
           Str(BV:6:1,S3);
           S4:=S1+'  '+Min_Sec(R)+'  '+Min_Sec(D)+S2+S3+' '+Dataline;
           Qwrite(20,5,15,S4);
           Ra  := R*H2rad;
           Dec := D*Radian;
           K:=K+1;
        End;    {of do}
        Num:=K-1;                         {contains number of stars}
        Close(Textfile);
  End;
  Procedure CreateBinFile;       {within LoadData}
     Begin
       Qwrite(23,28,15,'Creating STARBIN.DAT');
       Assign(Binfile,'STARBIN.DAT');
       Rewrite(Binfile);
       Star_Array[0].RA := Num;
       Write(BinFile,Star_Array);
       Flush(BinFile);
       Close(BinFile);
     End;
  Procedure LoadConstelFile;     {within LoadData}
     Begin
       Assign(TextFile,'Constel.Dat');   {load constellation names and positions}
        Reset(Textfile);
        Qwrite(24,28,15,'Loading CONSTEL.DAT');
        Readln(Textfile);Readln(Textfile); {advance past title}
        for K:=1 to 90 do
        With Constellation_Array[K] do
        Begin
           Readln(Textfile,Dataline);
           Val(Copy(Dataline, 4, 5),Right_Ascen,Code);
           Val(copy(Dataline, 10, 6),Declin,Code);
           Abbrev:=Copy(Dataline, 17, 3);
           Constellation:=Copy(Dataline, 21, 20);
           {Qwrite(23,20,15,Dataline);}
        End;
        Close(Textfile);
   End;  {of LoadConstelFile}
Begin                                     {begin Procedure  LoadData}
  Repeat
    Loadtype:=1;
    Dum:='';
    Qwrite(18,10,7,'   1. STARBIN.DAT               -Fastest load');
    Qwrite(19,10,7,'   2. STARRY.DAT                -ASCII text file');
    Qwrite(20,10,7,'   3. Create STARBIN.DAT        -from STARRY.DAT');
    Qwrite(23,10,7,'Choose Star data file to load (1): ');
    Gotoxy(45,23); Readln(Dum);
    If (dum<>'') then Val(Dum,Loadtype,Code);
    Case Loadtype of
      1:   Begin
             Assign(Binfile,'STARBIN.DAT');
             {$I-} Reset(Binfile);{$I+}
           End;
      2,3: Begin
             Assign(Textfile,'STARRY.DAT');
             {$I-} Reset(Textfile);{$I+}
           End;
    End;  {of case Loadtype}
    If (IOResult<>0) then               {reports lack of file}
          Begin
             Qwrite(24,10,15,'File not found. (R)etry or (E)xit (R):');
             Gotoxy(49,24); Readln(Ch);
             If Upcase(Ch)='E' then begin ClrScr; Halt; end else Loadtype:=0;
          End;
    Qfill(16,1,9,80,0,' ');
  Until Loadtype in [1..3];
  Cursorchange(Hiddencursor,Oldcursor);        {hides cursor, saves original value}
  Case Loadtype of
    1: LoadBinFile;
    2: LoadTextFile;
    3: Begin
         LoadTextFile;
         CreateBinFile;
       End;
    End; {of Case}
    Cursorchange(Oldcursor,Oldcursor);
    Assign(Textfile,'CONSTEL.DAT');
    {$I-} Reset(Textfile);{$I+}
    If (IOResult<>0) then
      Begin
        Qwrite(24,10,15,'"CONSTEL.DAT" File not found. (C)ontinue or (E)xit (C):');
        Gotoxy(65,24); Readln(Ch);
        If Upcase(Ch)='E' then begin ClrScr; Halt; end;
        ConstelDatExist:=False;
      End
    Else
      Begin
       LoadConstelFile;
       ConstelDatExist:=True;
      End;
    Assign(Textfile,'PLANETS.DAT');
    {$I-} Reset(Textfile);{$I+}
    If (IOResult<>0) then
      Begin
        Qwrite(25,10,15,'"PLANETS.DAT" File not found. (C)ontinue or (E)xit (C):');
        Gotoxy(65,25); Readln(Ch);
        If Upcase(Ch)='E' then begin ClrScr; Halt; end;
        PlanetsDatExist:=False;
      End
   Else PlanetsDatExist:=True;
    Close(Textfile);            {used in Planets.p--will open later}

End;  {of procedure LoadData}

Overlay Procedure GetRaDec;
Begin
 ClrScr;
   Qwrite( 3,13,14,'             Starry Nights RA/DEC Input           ');
   Qwrite( 5,5,7,'RA is the right ascention in hours with range 0 to 24.');
   Qwrite( 6,5,7,'DEC is the declination in degrees with range -90 to +90.');

   Qwrite( 8,5,7,'Either can be entered as decimal (ie -5.234) or degrees (-5:23:01)');
   Qwrite( 9,5,7,'where degrees are shown as (RA) hours:minutes:seconds or');
   Qwrite(10,5,7,'(DEC) degrees:minutes:seconds...or a combination (23:14.6).');

   Qwrite(12,20,15,' Press <return> to keep same values.');
   Qwrite(15,1,14,' Enter the RA  of the field center ('+Min_Sec(RAo)+'):  ');
   Gotoxy(49,15); Readln(Dum);
   If (Dum<>'') then RAo:=ProcessString(Dum);
   Qwrite(16,1,14,' Enter the DEC of the field center ('+Min_Sec(DECo)+'):  ');
   Gotoxy(49,16); Readln(Dum);
   If (dum<>'') then DECo:=ProcessString(Dum);
End;


Overlay Procedure OptionMenu;
Var
   Cols,Highs,Wids,Mes              :String[10];
Begin
   ClrScr;
   Qwrite( 3,13,14,'             Starry Nights Option Menu           ');

   Qwrite(6,5,7,'Width is the horizontal span of the field in degrees (60 to 120).');
   Qwrite(7,5,7,'Color display shows approximate B-V star color (y or n).');
   Qwrite(9,20,15,'Press <return> to keep the same values.');
   Str(Wid:3:3,Dum);

   Qwrite(11,1,14,'Enter the Width of the field ('+Dum+'):  ');
   Gotoxy(41,11); Readln(Wids);if (Wids<>'') then Val(Wids,Wid,Code);

   Qwrite(12,1,14,'Do you want stars in BV color ('+Col+')?  ');
   Gotoxy(38,12);  Readln(Cols);if (Cols<>'') then Col:=Cols;

   Qwrite(13,1,14,'Do you want the constellation highlighted ('+High+')?  ');
   Gotoxy(48,13); Readln(Highs); if (Highs<>'') then High:=Highs;

   If (Mesb) then Mes:='y' else Mes:='n';
   Qwrite(14,1,14,'Do you want Messier objects displayed ('+Mes+')?  ');
   Gotoxy(45,14); Readln(Mes);
   If (Mes<>'') then if (Upcase(Mes)='Y') then Mesb:=true else Mesb:=false;
End;

Overlay Procedure DateTimeMenu;       {manually set date,time,lat,long}
 Begin
     Clrscr;
     Qwrite( 3,15,14,'      Starry Nights Date/Time/Lat/Long Menu           ');

     Qwrite( 5,10, 7,'Enter date as "month day year" with only space dividers and');
     Qwrite( 6,10, 7,'with the full year (1988 instead of 88).  Enter time as in 24');
     Qwrite( 7,10, 7,'hour format as hours:minutes (ie 22:01, 3:15).  Enter latitude');
     Qwrite( 8,10, 7,'and longitude in decimal form only, with positive as north ');
     Qwrite( 9,10, 7,'latitude, positive as west latitude (30.0 90.0 Lat/Long is ');
     Qwrite(10,10, 7,'San Antonio, Tx) with only space dividers.');

     Qwrite(12,10,15,'         Press <Return> to retain same values.');

     Str(Monthnumber:2,Month);                            {set date}
     Str(Daynumber:2,Day);
     Str(Yearnumber:4,Year);

     Qwrite(15,19,14,'Enter new date ('+Month+' '+Day+' '+Year+'): ');
     Gotoxy(54,15); Readln(Monthnumber,Daynumber,Yearnumber);
     If (Monthnumber<>0) then
       Begin
          Str(Monthnumber,Month);
          Str(Daynumber,Day);
          Str(Yearnumber,Year);
        End
      Else
        Begin
           Val(Month,Monthnumber,Code);
           Val(Day,Daynumber,Code);
           Val(Year,Yearnumber,Code);
        End;

      Str(Hournumber,Hour);                              {set time}
      Str(Minutenumber,Minute);
      If (Hournumber<10) then Hour:='0'+Hour;
      If (Minutenumber<10) then Minute:='0'+Minute;
      Qwrite(16,19,14,'Enter new time ('+Hour+':'+Minute+'): ');
      Gotoxy(54,16); Readln(Time);
      If Time<>'' then
        Begin
          If (Pos(':',Time)=2) then Time:='0'+Time;
          Hour:=Copy(Time,1,2);
          Minute:=Copy(Time,4,2);
          Val(Hour,Hournumber,Code);
          Val(Minute,Minutenumber,Code);
        end;
                                                             {set lat/long}
      Str(Latnumber:3:2,Lat);
      Str(Longnumber:3:2,Long);
      Qwrite(17,19,14,'Enter new lat/long ('+Lat+' '+Long+'): ');
      Gotoxy(54,17); Readln(Latnumber, Longnumber);
      If (Latnumber<>0) then
        Begin
           Str(Latnumber:3:3,Lat);
           Str(longnumber:3:3,Long);
        End
      Else
        Begin
           Val(Lat,Latnumber,Code);
           Val(Long,Longnumber,Code);
        End;
 End;

Overlay Procedure GetConst;
Const
  CPointer = '<=';
Var
  AH,J,K          :Integer;
Begin
   Cursorchange(Hiddencursor,Oldcursor);        {hides cursor, saves original value}
   ClrScr;
   Planetname:='       ';
   For K:=1 to 10 do
      For J:=1 to 9 do
        With Constellation_Array[J+9*(K-1)] do       {display constel abbreviations}
          Begin
            Qwrite(J*2,K*5+10,7,Abbrev);
          End;
   J:= Constnum mod 9;
   K:= (Constnum div 9)+1;
   Qwrite(J*2,K*5+13,14,CPointer);
   Qwrite(20,24,7,'Constellation name:');
   With Constellation_Array[J+9*(K-1)] do
         Qwrite(20,44,15,Constellation);
   Qwrite(23,5,14,'Use cursor keys, then <Return> to select a constellation.  To retain');
   Qwrite(24,5,14,'the same constellation, press <Escape>.');
   Repeat
      Repeat
          MSDOS_Parms.AX:= $0;
          Intr(22,MSDOS_Parms);
          AH:=MSDOS_Parms.AX div 256;
      Until Chr(AH) in [#1,#28,#72,#75,#77,#80];
      Case AH of
         72: Begin                    {up arrow}
               Qwrite(J*2,K*5+13,0,'  ');
               If (J>1) then J:=J-1 else J:=9;
               Qwrite(J*2,K*5+13,14,CPointer);
             End;
         75: Begin                    {left arrow}
               Qwrite(J*2,K*5+13,0,'  ');
               If (K>1) then K:=K-1 else K:=10;
               Qwrite(J*2,K*5+13,14,CPointer);
             End;
         77: Begin                    {right arrow}
               Qwrite(J*2,K*5+13,0,'  ');
               If (K<10) then K:=K+1 else K:=1;
               Qwrite(J*2,K*5+13,14,CPointer);
             End;
         80: Begin                    {down arrow}
               Qwrite(J*2,K*5+13,0,'  ');
               If (J<9) then J:=J+1 else J:=1;
               Qwrite(J*2,K*5+13,14,CPointer);
             End;        {of case 80}
      End;               {of case AH}
      If (AH<>1) and (AH<>28) then
      Begin
        Sound(1000);Delay(3);Nosound;
      End;
      With Constellation_Array[J+9*(K-1)] do Qwrite(20,44,15,Constellation);
   Until (AH=28) or (AH=1);
   With Constellation_Array[J+9*(K-1)] do
     If (AH=28) then
       Begin
          Constnum:=J+9*(K-1);
          Rao:=Right_Ascen;
          Deco:=Declin;
          Constn:=Abbrev;
          Constname:=Constellation;
       End;
   Cursorchange(OldCursor,Oldcursor);
End;  {of procedure}

Procedure IntroMenu;
Var
  Menus                        :string[10];
Begin
  Repeat
    ClrScr;
    Qwrite( 3,13,14,'             Starry Nights Main Menu           ');

    Qwrite( 7,19,14,'1. '); qwrite( 7,22,7,'Select a constellation.');
    Qwrite( 8,19,14,'2. '); qwrite( 8,22,7,'Select Right Ascention and Declination.');
    Qwrite( 9,19,14,'3. '); qwrite( 9,22,7,'Select a Planet.');
    Qwrite(10,19,14,'4. '); qwrite(10,22,7,'Color/highlight/width options.');
    Qwrite(11,19,14,'5. '); qwrite(11,22,7,'Date/time/latitude/longitude set.');
    Qwrite(12,19,14,'6. '); qwrite(12,22,7,'Plot the sky according to above choices.');
    Qwrite(14,19,14,'9. '); qwrite(14,22,7,'Exit to DOS.');

    Qwrite(20,5,7,'           RA:                     Date/Time:');
    Qwrite(21,5,7,'          DEC:                         Color:');
    Qwrite(22,5,7,'      Constel:                     Highlight:');
    Qwrite(23,5,7,'       Planet:                       Messier:');
    Qwrite(24,5,7,'        Width:                      Lat/Long:');
    Qwrite(20,20,15,Min_Sec(RAo));  Qwrite(20,51,15,Date_Time_Stamp);
    Qwrite(21,20,15,Min_Sec(DECo)); Qwrite(21,51,15,Upcase(Col));
    Qwrite(22,20,15,ConstName);     Qwrite(22,51,15,Upcase(High));
    Qwrite(23,20,15,PlanetName);
    If (Mesb) then Qwrite(23,51,15,'Y') else Qwrite(23,51,15,'N');
    Str(Wid:4:1,Dum);
    Qwrite(24,20,15,Dum);
    Str(LatNumber:4:1,Dum);
    Qwrite(24,51,15,Dum);
    Str(LongNumber:4:1,dum);
    Qwrite(24,57,15,Dum);
    ASCIIBox(9,19,69,25,7);                            {X1,Y1,X2,Y2,grey}
    Str(Menu:1,Dum);
    Qwrite(17,12, 7,'   Selection or press <return> for same ('+Dum+'):  ');
    Gotoxy(58,17); Readln(Menus);
    Val(Menus,Menu,Code);
    If (Menu=1) and not ConstelDatExist then Menu:=0;
    If (Menu=3) and not PlanetsDatExist then Menu:=0;
  Until Menu in [1,2,3,4,5,6,9];
end;

Procedure Mouse;
Const
     Cross :CursorType =
     (HotX:7;
      HotY:7;
      Data:
      ($FFFF,$FE7F,$FE7F,$FE7F,$FE7F,$FFFF,$FFFF,$07C1, {16x16 shadow+cross}
       $07C1,$FFFF,$FE7F,$FE7F,$FE7F,$FE7F,$FFFF,$FFFF,
       $0000,$0100,$0100,$0100,$0100,$0000,$0000,$F83E, {16x16 cross}
       $0000,$0000,$0100,$0100,$0100,$0100,$0000,$0000));
Type
     LinePosition = record
          x1,y1,x2,y2     :Integer
          End;
Var
     SavedLines :array[1..50] of LinePosition;
     K,AH,AL    :Integer;
     Ch         :Char;
     Done       :Boolean;
     StartPoint,
     EndPoint   :Point;
Begin
     InitMouse;
     LoadCursor(Cross);
     ShowCursor;
     Done:=False;
     Repeat
           If KeyPressed then
              Begin
                 MSDOS_Parms.AX:= $0;
                 Intr(22,MSDOS_Parms);
                 AH:=MSDOS_Parms.AX div 256;  {Keyboard scan code}
                 AL:=MSDOS_Parms.AX mod 256;  {ASCII Characters}
                 If (Upcase(chr(AL))='E') then
                 Begin
                      K:=K-1;
                      If (K=0) then K:=50;
                      HideCursor;
                      With SavedLines[K] do
                      Begin
                         Case ScreenType of
                           1: HGLine(X1,Y1,X2,Y2,2,0);
                           2: Draw(X1,Y1,X2,Y2,0);
                           3: Begin
                                GPcolor(0);           {black}
                                GPmove(X1,Y1);
                                GPline(X2,Y2);
                              End;
                         End;   {of case}
                      End;     {of with savedlines}
                      ShowCursor;
                 End;       {of if upcase ch}
                 If (AH=28) or (AH=1) then Done:=True; {<return> or <esc>}
              End;      {of if keypressed}
           If LeftButton then
              Begin
                 MouseLocation(StartPoint);
                 GPMove(StartPoint.x,StartPoint.y);
              End;
           If RightButton then
              Begin
              While RightButton do
                    Begin
                    MouseLocation(EndPoint);
                    HideCursor;
                    Case ScreenType of
                       1: HGLine(StartPoint.x,StartPoint.Y,
                                 EndPoint.x,EndPoint.y,0,0);
                       2: Draw(StartPoint.x,StartPoint.Y,
                                 EndPoint.x,EndPoint.y,15);
                       3: Begin
                            GPcolor(1);   {blue}
                            GPmove(StartPoint.x,StartPoint.Y);
                            GPline(EndPoint.x,EndPoint.Y);
                          End;
                    End; {of case}
                    With SavedLines[K] do
                    Begin
                       X1:=StartPoint.X;    Y1:=StartPoint.Y;
                       X2:=EndPoint.X;      Y2:=EndPoint.Y;
                    End;
                    K:=K+1; If (K=51) then K:=1;
                    StartPoint:=EndPoint;
                    ShowCursor;
                    WaitForMouseEvent;
                    end;
              end;
     Until Done;
     DeInitMouse;
End;

Procedure EGAStoregraph;
Var
   X,Y,Tbcnt,AH,AL,I,Color                        :integer;
   Tube                                           :array[1..8] of byte;
   Print                                          :array[-5..640] of byte;
   Ptrfile                                        :file;
   Filename                                       :string[14];
   Buffer                                         :string[255];

Begin
   Filename:= '';
   TextColor(2);                       {green}
   X:=60; Y:=25;                       {position of prompt}
   Gotoxy(X,Y);Write('File name?');
   repeat
      repeat
          MSDOS_Parms.AX:= $0;
          Intr(22,MSDOS_Parms);
          AH:=MSDOS_Parms.AX div 256;  {Keyboard scan code}
          AL:=MSDOS_Parms.AX mod 256;  {ASCII Characters}
      until Chr(AH) in [#1..#81];
      case AH of
         2..13,16..27,30..53,57,58:
              begin
                filename:=filename+chr(AL);
                Gotoxy(X,Y);Write('              ');
                Gotoxy(X,Y);Write(filename);
              end;
       14,75: Begin                                     {*backspace,left arrow}
               if length(filename) > 0 then
                  begin
                     delete(filename,length(filename),1);
                     Gotoxy(X,Y);
                     Write(filename+' ');
                  end;
              end;                                      {of AH=14,75}
      end;                                              {of case}
   until (AH=28) or (AH=1);                             {return, escape}
   If (AH<>1) and (length(filename)>1) then
       Begin
           Assign(Ptrfile,Filename);
           Rewrite(Ptrfile,646);
           For I:=-5 to 640 do print[I]:=0;
           Print[-5]:=27;                               {line spacing....}
           Print[-4]:=51;
           Print[-3]:=24;                               {...24/216"}
           Print[-2]:=10;                               {CR}
           Blockwrite(Ptrfile,Print,1);                 {send above to file}
           Print[-5]:=27;                               {bit mode, ...}
           Print[-4]:=42;
           Print[-3]:=4;                                {...640 wide}
           Print[-2]:=128;                              {640 mod 256}
           Print[-1]:=2;                                 {640 div 256}
           Print[640]:=10;                              {CR}
           For I:=0 to 639 do
               Print[I]:=0;                             {array setup complete}
           Y:=0;
           Repeat
               For X:=0 to 639 do begin                 {for 640x350 EGA}
                   Gpmove(X,Y);                         {set current position}
                   Gprdcol(Tube,8);                     {read 8 pixel column}
                   For Tbcnt:=1 to 8 do begin
                         Print[X]:= Print[X] shl 1;
                         If (Tube[Tbcnt]<>0) then       {convert colors to...}
                             Print[X]:=Succ(Print[X]);  {...printer black}
                   End;
               End;
               Y:=Y+8;
               For X:=0 to 639 do                      {destroys ^Z's}
                   If Print[X]=26 then Print[X]:=25;
               Blockwrite(Ptrfile,Print,1);            {bitmode, data, <CR>}
           Until (Y>SY);
           Flush(Ptrfile);                             {flush buffers}
           Close(Ptrfile);
       End;                                            {of AH<>1}
       Textcolor(14);
end;                                                   {of procedure}


Procedure  GetColor;
Begin
   If (Bva<-0.18) then Color:=1;                       {blue}
   If (Bva>=-0.18) and (Bva<-0.10) then Color:=8;      {grey}
   If (Bva>=-0.10) and (Bva<1.15) then Color:=15;      {white}
   If (Bva>=1.15) and (Bva<1.85) then Color:=14;       {yellow}
   If (Bva>=1.85) then Color:=4;                       {red, low intensity}
End;

Procedure GetPlotHerc;
 Begin
   If (Color>0) then color:=1;
   HGPset(xx,yy,color,0);
   If Maga<4   then HGPset(XX+1,YY,Color,0);
   If Maga<3   then HGPset(XX-1,YY,Color,0);
   If Maga<2.3 then begin HGPset(XX  ,YY+1,Color,0); HGPset(XX  ,YY-1,Color,0); end;
   If Maga<1.5 then begin HGPset(XX+1,YY+1,Color,0); HGPset(XX+1,YY-1,Color,0); end;
   If Maga<1.0 then begin HGPset(XX-1,YY+1,Color,0); HGPset(XX-1,YY-1,Color,0); end;
   If Maga<0.5 then begin HGPset(XX-2,YY  ,Color,0); HGPset(XX+2,YY  ,Color,0); end;
   If Maga<0   then begin HGPset(XX  ,YY+2,Color,0); HGPset(XX  ,YY-2,Color,0); end;
 End;

Procedure GetPlotCGA;
  Begin
   If (Color<>0) then color:=7;                 {white on hires CGA}
   PLOT(XX,YY,Color);
   If Maga<4   then PLOT(XX+1,YY,Color);
   If Maga<3   then PLOT(XX-1,YY,Color);
   If Maga<2.3 then begin PLOT(XX  ,YY+1,Color); PLOT(XX  ,YY-1,Color); end;
   If Maga<1.5 then begin PLOT(XX+1,YY+1,Color); PLOT(XX+1,YY-1,Color); end;
   If Maga<1.0 then begin PLOT(XX-1,YY+1,Color); PLOT(XX-1,YY-1,Color); end;
   If Maga<0.5 then begin PLOT(XX-2,YY  ,Color); PLOT(XX+2,YY  ,Color); end;
   If Maga<0   then begin PLOT(XX  ,YY+2,Color); PLOT(XX  ,YY-2,Color); end;
  End;

Procedure GetPlotEGA;
Begin
   GPcolor(Color);
   GPPLOT(XX,YY);
   If Maga<4   then GPPLOT(XX+1,YY);
   If Maga<3   then GPPLOT(XX-1,YY);
   If Maga<2.3 then begin GPPLOT(XX  ,YY+1); GPPLOT(XX  ,YY-1); end;
   If Maga<1.5 then begin GPPLOT(XX+1,YY+1); GPPLOT(XX+1,YY-1); end;
   If Maga<1.0 then begin GPPLOT(XX-1,YY+1); GPPLOT(XX-1,YY-1); end;
   If Maga<0.5 then begin GPPLOT(XX-2,YY  ); GPPLOT(XX+2,YY  ); end;
   If Maga<0   then begin GPPLOT(XX  ,YY+2); GPPLOT(XX  ,YY-2); end;
End;


Procedure PlotData;
Var
  J,K,MSN,STP,LOL,UPL,MSS,CT,SIT,Delta    :Integer;
  A,B,C,D,E,F,X,Y,Ko,R,LAMo,
    PHIo,DLAM,PHI,CentX,
    CentY                                 :Real;
  COLB,HIGHB                              :Boolean;
  Linetext                                :String[90];
Begin
  Case ScreenType of
    1: Begin
         HGClrGraph(0);
         HGScrMode(1,0);             {high res herc graphics, page 0}
         HGLine(0,1,SX,1,0,0);       {line LU to RU, "or", page 0}
         HGLine(SX,0,SX,SY-15,0,0);
         HGLine(SX,SY-14,0,SY-14,0,0);
         HGLine(1,SY-15,1,0,0,0);
         HGgotoxy(2,43);             {43 rows, 90 columns of text per page}
         HGWriteln(0,'RA'+Min_Sec(RAo)+'  DEC '+Min_Sec(DECo)+'  '+Constn+'  '+
                Planetname+' '+Date_Time_Stamp);
         For Delta:=-2 to 2 do                      {plots cross at center}
           Begin
             HGPset(Trunc(SX/2)+Delta,Trunc(SY/2),0,0);
             HGPset(Trunc(SX/2),Trunc(SY/2)+Delta,0,0);
           End;
       End;
    2: Begin
         HiRes;
         HiResColor(7);                             {white}
         Color:=7;
         Draw(0,0,SX-1,0,Color);
         Draw(SX-1,0,SX-1,SY-10,Color);
         Draw(SX-1,SY-10,0,SY-10,Color);
         Draw(0,SY-10,0,0,Color);
         Textcolor(7);
         Gotoxy(1,25);
         Write('RA',Min_Sec(RAo),'  DEC ',Min_Sec(DECo),'  ',Constn,'  ',
                Planetname,' ',Date_Time_Stamp);
         For Delta:=-2 to 2 do                      {plots cross at center}
           Begin
             Plot(Trunc(SX/2)+Delta,Trunc(SY/2),Color);
             Plot(Trunc(SX/2),Trunc(SY/2)+Delta,Color);
           End;
        End;
    3: Begin
         Gpinit;
         Gpmove(0,0);
         Gpcolor(Blue);
         Gprect(SX-1,SY-15);
         Textcolor(2);           {green}
         Gotoxy(1,25);
         Write('RA',Min_Sec(RAo),'  DEC ',Min_Sec(DECo),'  ',Constn,'  ',
                Planetname,' ',Date_Time_Stamp);
         Gpcolor(11);             {high-intensity cyan}
         Gpplot(Trunc(sx/2),Trunc(sy/2));
       End;
    End;                           {of case}
  R:=    SX     *53.0/WID;
  LAMo:= H2rad  *RAo;
  PHIo:= Radian *DECo;
  J:=Trunc(Num*LAMo/2/PI);
  STP:=1;
  MSN:=Trunc(NUM/WID);
  LOL:=J;
  UPL:=J;
  MSS:=0;
  CT:=0;
  CentX:=SX/2.0 ; CentY:=SY/2.0;
  If (Upcase(Col)='Y') then COLB:=true else COLB:=false;
  If (Upcase(High)='Y') then HIGHB:=true else HIGHB:=false;
  If (COLB) and (HIGHB) then     sit:=1;
  If (COLB) and not (HIGHB) then sit:=2;
  If not (COLB) then             sit:=3;
  If (HIGHB) and not (COLB) then sit:=4;
  If (Screentype in [1,2])  then sit:=5;
  Repeat
     With Star_Array[J] do
       Begin
        DLAM:= RA - LAMo;
        PHI := DEC;
        MAGa:= MAG;
        BVa:=  BV;
       End;
     A:=Sin(PHIo);  B:=Cos(PhIo);
     C:=Sin(PHI);   D:=Cos(PHI);
     E:=Sin(DLAM);  F:=Cos(DLAM);
     Ko:= 2.0/(1 + A*C + B*D*F);
     X:= R*Ko*D*E;  Y:= R*Ko*(B*C - A*D*F);
     X:= -X + CentX ;  Y:= -Y*YHT + CentY;
     If (X>SX) or (X<0) then MSS:=MSS+1;
     If Abs(x)>1000 then X:=0; If Abs(Y)>1000 then Y:=0;
     XX:=Trunc(X); YY:=Trunc(Y);
     If (XX>1) and (XX<SX-1) and (YY>1) and (YY<SY-15) then
       Begin
          With Star_Array[J] do
            Begin
              Case Sit of
                1: If (Constel=Constn)
                      then GetColor else Color:=2;  {green}
                2: GetColor;
                3,5: Color:=7;                                       {white}
                4: If (Constel=Constn)
                      Then Color:=15                                  {white}
                      Else Color:=2;                                  {green}
              End;  {of case}
              If (Constel='MES') then
                 If (MESB) then
                   Begin
                      Case Sit of
                        1,2,4: Color:=5;                              {magenta}
                        3,5:   Color:=7;                              {white}
                      End;  {of case}
                   End        {of if mesb}
                   Else Color:=0;                                     {black}
              If(Constel='PLT') then
                 Begin
                   Case Sit of
                     1,2,4: Color:=12;                               {light red}
                     3,5:   Color:=7;                                {white}
                   End;  {of case}
                 End;    {of if}
            End;        {of with star_array do}
          Case Screentype of
             1: GetPlotHerc;
             2: GetPlotCGA;
             3: GetPlotEGA;
           End; {of case screentype}
        End;   {of if screen limit}
     If STP<0    then LOL:=J     else UPL:=J;
     If MSS>MSN  then begin STP:=-STP; MSS:=0; MSN:=2*MSN; end;
     If STP<0    then J:=LOL+STP else J:=UPL+STP;
     If J>num    then J:=0;
     If J<0      then J:=num;
     CT:=CT+1;
  Until (CT>NUM) or Keypressed;
  Case ScreenType of
      1:   Begin
              HGgotoxy(80,43);
              If (CT>NUM)
                 Then  HGWriteln(0,'Done')
                 Else
                   Begin
                      Read(Kbd,Ch);
                      HGWriteln(0,'Aborted');
                   End;                 {of if}
             End;                       {of case 1}
      2,3: Begin
              Gotoxy(73,25);
              If (CT>NUM)
                 Then Write('Done')
                 Else
                   Begin
                     Read(Kbd,Ch);
                     Textcolor(Red);
                     Write('Aborted');
                   End;                  {of if}
            End;                         {of case 2,3}
  End;                                   {of case screentype}
  Sound(1000);Delay(100);Nosound;
  Case ScreenType of
    1: Begin
         Mouse;
         HGStoreGraph(0);
         HGScrMode(0,0);
         Textmode;
       End;
    2: Begin
         Mouse;
         Read(Kbd,Ch);      {use MSDOS "GRAPHICS.EXE" and <shift><PrtSc>}
         Textmode;          {...for printing screen}
       End;
    3: Begin
         Mouse;
         EGAStoreGraph;
         GPTerm;
       End;
    End;   {of case screentype}
  Textcolor(14);       {yellow}
End;  {of procedure}

Procedure AutoSelectPlanet;  {selects constellation nearest the coordinates rao, deco}
Var
  Distance,MinDistance :Real;
  K                    :Integer;
Begin
   MinDistance:=1000;
   For K:=1 to 90 do
    With Constellation_Array[K] do
      Begin
        Distance:=Sqrt(Sqr(7.5*(Right_Ascen-RAo))+Sqr(Declin-DECo));
        If (Distance<MinDistance) then
           Begin
             MinDistance:=Distance;
             Constn:=Abbrev;
             Constname:=Constellation;
           End;
       End;
 End;

Procedure GetPlanet;
  Var
     Map                                 :Array[1..8] of Real;
     Plan                                :Array[1..8,1..9] of Real;
     Plan_loaded                         :Boolean;

       BET,CLO,CLL,CPSI,CY,DPSI,DEPS,DJD,DT,DL,DR,DML,
       DP,DS,DM,DA,DHL,EA,EPS,EPSR,INC,LAM,LL,LP,
       LPDO,LSN,LO,LPD,LG,MA,MAS,NU,OM,PSI,PSIO,P,Q,
       RE,RPD,RSN,RHO,RP,RHOO,RPO,S,SLO,SPSI,
       SLL,T,TPI,X,Y,J1,J2,J3,J4,J5,J6,J7,J8,J9,J10,J11,J12,
       SJ3,CJ3,S2J3,C2J3,SJ5,CJ5,S2J5,C2J5,
       SJ6,SJ7,CJ7,S2J7,C2J7,S3J7,C3J7,
       S4J7,C4J7,C5J7,S3J3,C3J3,S4J3,C4J3,
       S5J7,S2J8,C2J8,S3J8,C3J8,SJ11,
       CJ11,SJ4,CJ4,S2J4,C2J4,SJ9,CJ9,S2J9,C2J9,
       S2J12,C2J12,SJ8,CJ8,
         RA_local,DEC_local,A,CA,SA,CEL,Elongation,Fraction,
         Size,Magnitude,Distance            :Real;

     IPstring,Planet                        :String[10];
     PASS,CODE,IP,IPsave,Color              :Integer;
     Dum,Dum2                               :String[80];

  Function FNRAD(W:Real):Real; begin FNRAD:=1.745329252E-2*W; end;     {radians to degrees}
  Function FNDEG(W:Real):Real; begin FNDEG:=5.729577951E1*W; end;      {degrees to radians}
  Function FNASN(W:Real):Real; begin FNASN:=ArcTan(W/(Sqrt(1-W*W)+1E-20)); end;  {arcsine function}
  Function FNUNW(W:Real):Real; begin FNUNW:=W-Int(W/TPI)*TPI; end;
  Function FNROU(X,Y:Real):Real; begin FNROU:=Int(X*Y+0.5)/Y; end;
  Function FNACS(W:Real):Real; begin FNACS:=1.570796327-FNASN(W);end;   {arcosine funtion}

{$I Planets.p}

Begin
   ClrScr;
   Plan_loaded:=false;
   TPI:=2*PI;
   Repeat
      Qwrite(3,18,14,'1.                         6.');
      Qwrite(4,18,14,'2.                         7.');
      Qwrite(5,18,14,'4.                         8.');
      Qwrite(6,18,14,'5.                         9.');
      Qwrite(3,22,7,'Mercury'); Qwrite(3,49,7,'Saturn');
      Qwrite(4,22,7,'Venus  '); Qwrite(4,49,7,'Uranus');
      Qwrite(5,22,7,'Mars   '); Qwrite(5,49,7,'Neptune');
      Qwrite(6,22,7,'Jupiter'); Qwrite(6,49,7,'Pluto');
      Str(IPo,IPstring);
      Qwrite(10,18,7,'Which Planet ('+IPstring+')? ');
      Gotoxy(36,10);Readln(IPstring);
      If (IPstring<>'') then Val(IPstring,IPo,code);
      IP:=IPo; IPsave:=IPo;
      If (IP>2) then begin IP:=IP-1;IPsave:=IPsave-1; end;
  Until IP in [1,2,3,4,5,6,7,8];

  IP:=1;
  Cursorchange(Hiddencursor,Oldcursor);
  Clrscr;
  Qwrite(2,1,14,'                                Starry Nights ');

  Qwrite(4,1, 7,'                        Indoor Astronomy with the PC');
  Qwrite(5,1, 7,'                      Planetary data for '+Date_Time_Stamp);

  Qwrite(7,1,14,'                RA        DEC       Elong    Mag    Size    Illum   Dist');
  Qwrite(8,1,14,'    Planet   hr mn sc   dg mn sc     deg             sec     %      A.U.');
  Qwrite(9,1,14,'    -------  ---------  ---------   ------   ----   -----   ----   -------');

  Repeat
     Case IP of
       1: Planet:='Mercury';
       2: Planet:='Venus  ';
       3: Planet:='Mars   ';
       4: Planet:='Jupiter';
       5: Planet:='Saturn ';
       6: Planet:='Uranus ';
       7: Planet:='Neptune';
       8: Planet:='Pluto  ';
     End;     {of case}

     Julday; T:=DJD/36525.0;
     Plans;
     Nutat;
     LAM:=LAM+FNRAD(DPSI);
     A:=LG+PI-LAM;  CA:=COS(A);  SA:=SIN(A);
     LAM:=LAM-(9.9387E-5*CA/COS(BET));
     BET:=BET-(9.9387E-5*SA*SIN(BET));
     X:=LAM;  Y:=BET;
     Eqecl;

     RA_local:=FNDEG(P/15);            {RA_local=right ascention}
     DEC_local:=FNDEG(Q);              {DEC_local=declination}
     CEL:=-1*CY*Cos(LAM-LG);
     Elongation:=FNDEG(FNACS(CEL));    {Elongation=solar elongation in deg}
     Size:=Plan[IP,8]/RHO;             {Size=angular size in arcseconds}
     Fraction:=0.5*(1+cos(LAM-LPD));   {Fraction=fraction illuminated/phase}
     X:=Ln(RP*RHO/Sqrt(Fraction));
     Magnitude:=5*X/Ln(10)+Plan[IP,9]; {Magnitude=visual magnitude}
     Distance:=RHOO;                   {Distance=distance in A.U.}

     Dum:='    '+planet+'  '+Min_Sec(RA_local)+'  '+Min_Sec(DEC_local)+'   ';
     Str(elongation:6:2,Dum2); Dum:=Dum+Dum2+'   ';
     Str(magnitude:4:1,Dum2);  Dum:=Dum+Dum2+'   ';
     Str(size:5:2,Dum2);       Dum:=Dum+Dum2+'   ';
     Str(fraction:4:2,Dum2);   Dum:=Dum+Dum2+'   ';
     Str(distance:6:2,Dum2);   Dum:=Dum+Dum2;
     If (IP=IPsave) then Color:=15 else Color:=7;
     Qwrite(IP+9,1,Color,Dum);
     With Star_Array[num-8+IP] do
        begin
          RA:=RA_local*h2rad;     {load planetary data into main array}
          DEC:=DEC_local*radian;
          MAG:=Magnitude;
          BV:=0.0;
          Constel:='PLT';
        End;
     If (IP=IPsave) then
       Begin
         RAo:=RA_local;
         DECo:=DEC_local;
         Planetname:=planet;
        end;
     IP:=IP+1;
  Until (IP=9);
  Cursorchange(Oldcursor,Oldcursor);
  Qwrite(22,2,14,'Auto-select constellation near '+planetname+' ('+autoselect+')?');
  Gotoxy(45,22);
  Readln(Dum);
  If (Dum<>'') then
     Begin
       Dum:=upcase(dum);
       Autoselect:=dum;
     End;
  If (Autoselect='Y') then AutoSelectPlanet;
End;

Begin { Main program }
  GpParms;                           {sets up EGA parameters}
  Qinit;                             {sets up QWrite procedures}
  OpeningScreen;                     {cover screen}
  GetScreenType;                     {prompts for graphics card type}
  InitialValues;                     {sets default values}
  IniDateTime;                       {finds system date and time}
  LoadData;                          {loads memory with star data}
  Repeat
    IntroMenu;                       {main menu}
    Case Menu of
      1: GetConst;                   {selects constellation}
      2: GetRaDec;                   {select by RA/DEC}
      3: GetPlanet;                  {select planet/print data}
      4: OptionMenu;                 {Color/highlight/width/messier}
      5: DateTimeMenu;               {change time/date/location}
      6: PlotData;                   {plot sky for above}
    End;
  Until menu=9;
  Clrscr;
  Halt;
End.


