/***************************************************************

	CU_TMP.C    --  Minimal CURSES routines
			for Simple Software.

			Template for developing new implementations.

			Copyright (c) 1988, Ted A. Campbell

			Bywater Software
			Box 4023
			Duke Station,
			Durham, NC  27706

			The use of Simple Software is governed by the
			"Simple Software User Agreement" (see file
			SS.DOC).

***************************************************************/

/**************************************************************

	FUNCTION:       initscr()

	DESCRIPTION:    This function performs any necessary
			initialization for the video system.

	INPUT:          none.

	RETURNS:        none.

**************************************************************/

initscr()
	{
	}

/**************************************************************

	FUNCTION:       endwin() -- Deinitialize Video System

	DESCRIPTION:    This function performs any necessary
			deinitialization for the video system,
			that it, it returns the video system to
			its default state.

	INPUT:          none.

	RETURNS:        none.

**************************************************************/

endwin()
	{
	}

/**************************************************************

	FUNCTION:       clear()

	DESCRIPTION:    This function clears the screen and homes
			the cursor.

	INPUT:          none.

	RETURNS:        none.

**************************************************************/

clear()
     {
     }

/***************************************************************

	FUNCTION:       move()

	DESCRIPTION:    This function moves (or "addresses) the
			cursor to a specific line and column on
			the video screen.

	INPUT:          <line> and <column> define the position
			at which the cursor will be located.

	RETURNS:        none.

***************************************************************/

move( line, column )
     int line, column;
     {
     }

/***************************************************************

	FUNCTION:       standout()

	DESCRIPTION:    This function turns on a special video
			effect (normally reverse video).

	INPUT:          none.

	RETURNS:        none.

***************************************************************/

standout()
	{
	}

/***************************************************************

	FUNCTION:       standend()

	DESCRIPTION:    This function turns off the special video
			effect which was initiated by standout().

	INPUT:          none.

	RETURNS:        none.

***************************************************************/

standend()
	{
	}


/***************************************************************

	FUNCTION:       clrtoeol()

	DESCRIPTION:    This function clears from the current
			cursor position to the end of the line.

	INPUT:          none.

	RETURNS:        none.

***************************************************************/

clrtoeol()
	{
	}

/***************************************************************

	FUNCTION:       addch()

	DESCRIPTION:    This function outputs a character to the
			video screen.  Normally puchar() will
			work for it.

	INPUT:          <character> is the character to be output.

	RETURNS:        none.

***************************************************************/

addch( character )
	char character;
	{
	putchar( character );
	}

/***************************************************************

	FUNCTION:       refresh()

	DESCRIPTION:    This function "refreshes" the screen.  In
			this relatively limited implementation of the
			CURSES functions, it simple empties the
			stdout buffer.  In more sophisticated versions
			of CURSES, all CURSES calls are mapped to
			memory, and then are output all at once by
			this call.

	INPUT:          none.

	RETURNS:        none.

***************************************************************/

refresh()
	{
	fflush( stdout );
	}


