;DUMFILE.ASM
;
;6.12.85

comment *

        Create dummy file to force fill space

On entry:

	DX	offset to dummy file ASCIIZ string:
		  dumfdef  db  'gobbige.zzz',0   ;default dummy file name

Uses:
        Variables used by this segment, should be in prior segments:

bpc     dw      4096                    ;bytes per cluster
handle  dw      0                       ;temp space to save handle
clneed  dw      ?
clmake  dw      ?
================

        Variables created in this program segment
*

;----------------------------------------------------------
;		constants and messages

hi      	db      'Ta-da.'
hilen   	equ     $-hi
bye     	db      'Finis.'
byelen  	equ     $-bye
dumfile_msg	db	cr,lf,'dumfile: ',eos


;----------------------------------------------------------
;		data storage

hisiz2  dw      0
losiz2  dw      0
makelen dw      0

;----------------------------------------------------------
;		main code section

DUMFILE		proc	near

	        mov     ax,clmake	;check number clusters requested
	        cmp     ax,0
	        jne	oktomake
	        jmp     no_make_exit	;don't need to make it--zero length
oktomake:
		push	dx		;save address of dummy file name 
	        mul     bpc		;multiply by bytes per cluster
	        mov     hisiz2,dx	;required size in bytes for..
	        mov     losiz2,ax	;..pointer move below

		pop	dx		;restore dummy file name
	        mov	cx,20H		;normal attribute
		mov	ah,3CH		;create a file call
		int     21H
		mov	bx,ax		;file handle to BX
		jnc	df2
		push	ax		;save error code
		jmp	dumf_err2		;skip close file part

;----write something here just for practice
					;BX has file handle
df2:        	mov     cx,hilen
	        mov     dx,offset hi
	        mov     ah,40H		;write to file/dev function call
	        int     21H
		jc	dumf_err

;----move file ptr to end of file
					;BX has file handle
		mov     cx,hisiz2        ;most sig part of byte count
        	mov     dx,losiz2	;least sig part of byte count
	        mov     al,0		;to CX:DX offset from beginning of file
	        mov     ah,42H		;LSEEK call
	        int     21H
		jc	dumf_err        

;----move back to allow trailer write
					;BX has file handle
	        mov     ax,byelen	;move pointer back bylen bytes
	        neg     ax
	        cwd			;AX has least, DX has most sig
	        mov     cx,dx
	        mov     dx,ax
	        mov     al,1                    ;move current location plus offset
	        mov     ah,42H                  ;Move pointer call (LSEEK)
	        int     21H
		jc	dumf_err

;----write trailer
					;BX has file handle
	        mov     cx,byelen
	        mov     dx,offset bye
	        mov     ah,40H
	        int     21H
		jc	dumf_err

;----close file
					;BX has file handle
	        mov     ah,3EH		;close handle call
	        int     21H             
		jnc	dumf99
		push	ax		;save error code
		jmp	dumf_err2
no_make_exit:
dumf99:
	        ret

dumf_err:		
		push	ax		;save error code
					;BX has file handle
		mov	ah,3eh		;close file handle function call
		int	21h		;ignore error ret, if any
dumf_err2:	mov	dx,offset dumfile_msg
		mov	ah,9h
		int	21h
		pop	ax
		call	errmsg
		stc
		ret

dumfile		endp
