comment *

	Copy file

6.12.85

Entry:
	BX	
	CX	max bytes to read (buffer size)
	DX	address of transfer buffer
	SI	ASCIIZ string of source file
	DI	ASCIIZ string of destination file


Error returns in AX (when carry set):
	
	2	File not found
	3	Path not found
	4	Too many open files (no handles left
	5	Access denied (tried to write to existing file?)
	6	Invalid handle
	12	Invalid access code	
	99	Special error, message in this routine
	
Notes:
	Will overwrite to-file of the same name


*

cpyfile		proc	near
		jmp	cpyentry
from_handle	dw	0
to_handle	dw	0
bytes		dw	0
buf_addr	dw	0q
wrt_err_msg	db	cr,lf,'CPY: Destination write error',cr,lf,eos

cpyentry:
		mov	bytes,cx	;save buffer size
		mov	buf_addr,dx	;save buffer address	
open_from:	mov	dx,si		;open from-file
		mov	al,0		;open for read only
		mov	ah,3dh		;open a file function call
		int	21h
		jnc	ok_from_open
		jmp	cpy_erret
ok_from_open:
		mov	from_handle,ax
create_to:
		mov	cx,0		;normal attribute
		mov	dx,di		;to_file ASCIIZ string
		mov	ah,3ch		;create a file function call
		int	21h
		jnc	ok_to_create
		push	ax		;save error return code
		mov	bx,from_handle	;close from-file first 
		mov	ah,3eh		;close file handle function call
		int	21h
		pop	ax		;restore prior error code and..
					;..ignore any error from file close
		jmp	cpy_erret

ok_to_create:
		mov	to_handle,ax	;save to-file handle
do_read:	mov	bx,from_handle	;set to copy from-file
		mov	cx,bytes	;CX has bytes to read
		mov	dx,buf_addr	;DX has destination buffer
		mov	ah,3fh		;read from file function call
		int	21h
		jnc	ok_read
		push	ax		;save error code
		call	close_files
		pop	ax		;restore original error code
		jmp	cpy_erret
ok_read:
		cmp	ax,0		;if no bytes read, then tried to read..
					;..from end of file, so done copy
		jne	do_write
		jmp	cpy_ok_ret
do_write:	
		mov	bx,to_handle	;set out-file
		mov	cx,ax		;CX to bytes to write
					;DX has buffer address
		mov	ah,40h		;write to file function call
		int	21h
		jnc	chk_wrt
		push	ax		;save error code
		call	close_files
		pop	ax
		jmp	cpy_erret 
				
chk_wrt:
		cmp	ax,cx		;chk if actual = requested
		je	ok_write
		call	close_files
		mov	dx,offset wrt_err_msg
		mov	ah,9h		;print string function call
		int	21h
		mov	ax,99		;special return code	
		jmp	cpy_erret		

ok_write:
		jmp	do_read
cpy_ok_ret:
set_datetime:
get_date:
		mov	bx,from_handle
		mov	al,0		;get date function
		mov	ah,57h		;get/set date and time function
		int	21h
		jnc	ok_get_date
		push	ax		;save error code
		call	close_files
		pop	ax
		jmp	cpy_erret		
ok_get_date:
		mov	bx,to_handle
					;CX has time
					;DX has date
		mov	al,1		;set date function
		mov	ah,57h		;get/set date and time function				
		int	21h
		jnc	done
		push	ax
		call	close_files
		pop	ax
		jmp	cpy_erret	
	
done:
		call	close_files
	        ret     
cpy_erret:
		cmp	ax,99		;special write error code
		je	ce2
		call	errmsg
ce2:		stc			;set CY 
		ret

close_files	proc	near
close_infile	proc	near
		mov	bx,from_handle
		mov	ah,3eh
		int	21h
close_infile	endp

close_outfile	proc	near
		mov	bx,to_handle
		mov	ah,3eh
		int	21h
close_outfile	endp

		ret
close_files	endp

cpyfile		endp
