/*
** _strf.c source for _strftime() and _strfdate()
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>

#define MONTH_SHIFT    5
#define MONTH_MASK     0x0F
#define DAY_MASK       0x1F
#define YEAR_SHIFT     9
#define DOS_EPOCH      80
#define HOUR_SHIFT     11
#define HOUR_MASK      0x1F
#define MINUTE_SHIFT   5
#define MINUTE_MASK    0x3F

/*
** _strftime() - mimic _strtime output except uses filetime instead of systime
*/
char *_strftime(unsigned int ftime, char *ret_str)
{
   int hr, min;
   char hour[3], minute[3];
   char *ptr;

   hr = (ftime >> HOUR_SHIFT) & HOUR_MASK;
   min = (ftime >> MINUTE_SHIFT) & MINUTE_MASK;

   ptr = hour;
   ptr = itoa(hr, hour, 10);
   ptr = minute;
   ptr = itoa(min, minute, 10);

   if(hour[1] != '\0')
   {
       ret_str[0] = hour[0];
       ret_str[1] = hour[1];
   }
   else
   {
       ret_str[0] = '0';
       ret_str[1] = hour[0];
   }
   ret_str[2] = ':';
   if(minute[1] != '\0')
   {
       ret_str[3] = minute[0];
       ret_str[4] = minute[1];
   }
   else
   {
       ret_str[3] = '0';
       ret_str[4] = minute[0];
   }
   ret_str[5] = '\0';

   return(ret_str);
}

/*
** _strfdate() - mimic _strdate output except uses filetime instead of systime
*/
char *_strfdate(unsigned int fdate, char *ret_str)
{
   int mo, da, yr;
   char month[3], day[3], year[3];
   char *ptr;
   

   mo = (fdate >> MONTH_SHIFT) & MONTH_MASK;
   da = fdate & DAY_MASK;
   yr = (fdate >> YEAR_SHIFT) + DOS_EPOCH;

   ptr = month;
   ptr = itoa(mo, month, 10);
   ptr = day;
   ptr = itoa(da, day, 10);
   ptr = year;
   ptr = itoa(yr, year, 10);

   if(month[1] != '\0')
   {
       ret_str[0] = month[0];
       ret_str[1] = month[1];
   }
   else
   {
       ret_str[0] = '0';
       ret_str[1] = month[0];
   }
   ret_str[2] = '/';
   if(day[1] != '\0')
   {
       ret_str[3] = day[0];
       ret_str[4] = day[1];
   }
   else
   {
       ret_str[3] = '0';
       ret_str[4] = day[0];
   }
   ret_str[5] = '/';
   if(year[1] != '\0')
   {
       ret_str[6] = year[0];
       ret_str[7] = year[1];
   }
   else
   {
       ret_str[6] = '0';
       ret_str[7] = year[0];
   }
   ret_str[8] = '\0';

   return(ret_str);
}

