/********************************************************************
**  YEARCAL.C   v0.01Td     Copyright (c) 1987 by Paul M. Sittler.
**  All rights reserved.  The copyright owner hereby authorizes the
**  no-charge, noncommercial making and/or distribution of copies of
**  the entirety of this work unchanged and unincorporated in any
**  other work (except "LiBRary" or "ARChive" disk files for the sole
**  purpose of no-charge noncommercial distribution).  No other
**  reproduction or use is authorized without the express prior
**  written consent of the copyright owner.
**
**  Once upon a time, in a kingdom far away, people shared source
**  code and many of us benefited from the sharing.  This silly
**  little program is here presented with source in hopes that it may
**  stimulate the renewed sharing of our efforts.
**
**  I am open to comment, suggestions for enhancements, and bug
**  reports.
**
**  Paul M. Sittler
**  1106 Berkeley Drive
**  College Station, TX 77840
**
**  Modem (409) 764-0056 300/1200/2400 baud 24 hours/day
**  My Word #2 Fido 117/1
**  GENie User mail address P.M.SITTLER
**
**  Modified for Borland's Turbo-C
**  26 August 1987 <pms>
**
**  Modified for Workaround for Borland's Turbo-C bug on % Operator
**  Replaced calls to scanf with getPRN  routine.
**  10 September 1987 <pms>
**
**  Modified to produce a "Programmer's" Calendar, which can
**  display dates in Octal or Hexadecimal numbering.
**  11 September 1987 <pms>
**
**  Modified to produce calendars in any of 14 different languages
**  at user's option
**  18 September 1987 <pms>
**
**  Modified to create a Julian date calendar.
**  Modified to add support for Afrikaans language.
**  29 September 1987 <pms>
**
**  Modified to add support for Korean language.
**  Modified Julian date calendar to skip a line every five.
**  Rewrote menu for language selection to save space.
**  14 October 1987 <pms>
**
**  Added Daily and Weekly Scheduling sheets.  User may choose beginning
**  hour for scheduling.
**  16 October 1987 <pms>
**
**  Fixed Daily and Weekly scheduling sheets.
**  Added ability to select number of hours to schedule, program
**  adapts the page for it.
**  25 October 1987 <pms>
**
**  Added Monthly Calendar.
**  Added ability to specify number of lines and columns on a page for
**  file and printer output.  Modified filename routines to shorten
**  program slightly.
**  31 October 1987 <pms>
**
**  Added title lines that include the last month and next month
**  calendars and two user-defined title lines.  Rewrote the
**  program to calculate three years worth of calendars for each
**  year so that previous month's calendars can be displayed even
**  when they are last years.  Added Programmers calendar option
**  to the monthly, daily, and weekly schedule options.
**  Made defaults firm or sticky, such that once user selects one,
**  it stays the same while running program.
**  1 November 1987 <pms>
**
**************************************************************/

#include <stdio.h>
#include <fcntl.h>
#include <string.h>
#include <dos.h>
#include <conio.h>
#include <ctype.h>

/* Suppress some library functions to conserve space */
_setargv () {}
_setenvp () {}

#define ERROR (-1)
#define TRUE 1
#define FALSE 0
#define BUF 200

struct month
{
    int  length;
    int  first_day;
};

/* put month's lengths into structure */
static struct month mon[] =
    {
    { 31, 0}, { 28, 0}, { 31, 0},
    { 30, 0}, { 31, 0}, { 30, 0},
    { 31, 0}, { 31, 0}, { 30, 0},
    { 31, 0}, { 30, 0}, { 31, 0}
    };

int lingos = 16;  /* How many languages we gonna have available */
char *lingo[] =
       {
"Afrikaans",     /*  0 */
"Danish",        /*  1 */
"Dutch",         /*  2 */
"English",       /*  3 */
"Finnish",       /*  4 */
"French",        /*  5 */
"German",        /*  6 */
"Italian",       /*  7 */
/* "Latin", */
"Korean",        /*  8 */
"Norwegian",     /*  9 */
"Polish",        /* 10 */
"Portugese",     /* 11 */
"Serbo-Croatian",/* 12 */
"Spanish",       /* 13 */
"Swedish",       /* 14 */
"Texan",         /* 15 */
       } ;

char *mnam[][12] =
       {
/* Afrikaans       0 */  "JANUARI",   "FEBRUARI",   "MAART",     "APRIL",    "MEI",      "JUNI",     "JULI",     "AUGUSTUS", "SEPTEMBER",  "OKTOBER",     "NOVEMBER",  "DECEMBER",
/* Danish          1 */  "JANUAR",    "FEBRUAR",    "MARTS",     "APRIL",    "MAJ",      "JUNI",     "JULI",     "AUGUST",   "SEPTEMBER",  "OKTOBER",     "NOVEMBER",  "DECEMBER",
/* Dutch           2 */  "JANUARI",   "FEBRUARI",   "MAART",     "APRIL",    "MEI",      "JUNI",     "JULI",     "AUGUSTUS", "SEPTEMBER",  "OKTOBER",     "NOVEMBER",  "DECEMBER",
/* English         3 */  "JANUARY",   "FEBRUARY",   "MARCH",     "APRIL",    "MAY",      "JUNE",     "JULY",     "AUGUST",   "SEPTEMBER",  "OCTOBER",     "NOVEMBER",  "DECEMBER",
/* Finnish         4 */  "PRPRNUU",  "HELMIKUU",   "MAALISKUU", "HUHTIKUU", "TOUKOKUU", "KESAKUU",  "HEINAKUU", "ELOKUU",   "SYYSKUU",    "LOKAKUU",     "MARRASKUU", "JOULUKUU",
/* French          5 */  "JANVIER",   "FEVRIER",    "MARS",      "AVRIL",    "MAI",      "JUIN",     "JUILLET",  "AOUT",     "SEPTEMBRE",  "OCTOBRE",     "NOVEMBRE",  "DECEMBRE",
/* German          6 */  "JANUAR",    "FEBRUAR",    "MARZ",      "APRIL",    "MAI",      "JUNI",     "JULI",     "AUGUST",   "SEPTEMBER",  "OKTOBER",     "NOVEMBER",  "DEZEMBER",
/* Italian         7 */  "GENNAIO",   "FEBBRAIO",   "MARZO",     "APRILE",   "MAGGIO",   "GIUGNIO",  "LUGLIO",   "AGOSTO",   "SETTEMBRE",  "OTTOBRE",     "NOVEMBRE",  "DICEMBRE",
/* Latin                 "JANUARIUS", "FEBRUARIUS", "MARTIUS",   "APRILIS",  "MAIUS",    "JUNIUS",   "JULIUS",   "AUGUSTUS", "SEPTEMBER",  "OCTOBER",     "NOVEMBER",  "DECEMBER", */
/* Korean          8 */  "IL-WOL",    "I-WOL",      "SAM-WOL",   "SA-WOL",   "O-WOL",    "YU-WOL",  "CH'IL-WOL", "P'AL-WOL", "KU-WOL",     "SI-WOL",      "SIP IL-WOL","SIP I-WOL",
/* Norwegian       9 */  "JANUAR",    "FEBRUAR",    "MARS",      "APRIL",    "MAI",      "JUNI",     "JULI",     "AUGUST",   "SEPTEMBER",  "OKTOBER",     "NOVEMBER",  "DESEMBER",
/* Polish         10 */  "STYCZEN",   "LUTY",       "MARZEC",    "KWIECIEN", "MAJ",      "CZERWIEC", "LIPIEC",   "SIERPIEN", "WRZESIEN",   "PAZDZIERNIK", "LISTOPAD",  "GRUDZIEN",
/* Portugese      11 */  "JANEIRO",   "FEVEREIRO",  "MARCO",     "ABRIL",    "MAIO",     "JUNHO",    "JULHO",    "AGOSTO",   "SETEMBRO",   "OUTUBRO",     "NOVEMBRO",  "DEZEMBRO",
/* Serbo-Croatian 12 */  "JANUAR",    "FEBRUAR",    "MART",      "APRIL",    "MAJ",      "JUN",      "JULI",     "AVGUST",   "SEPTEMBAR",  "OKTOBAR",     "NOVEMBAR",  "DECEMBAR",
/* Spanish        13 */  "ENERO",     "FEBRERO",    "MARZO",     "ABRIL",    "MAYO",     "JUNIO",    "JULIO",    "AGOSTO",   "SEPTIEMBRE", "OCTUBRE",     "NOVIEMBRE", "DICIEMBRE",
/* Swedish        14 */  "JANUARI",   "FEBRUARI",   "MARS",      "APRIL",    "MAJ",      "JUNI",     "JULI",     "AUGUSTI",  "SEPTEMBER",  "OKTOBER",     "NOVEMBER",  "DECEMBER",
/* Texan          15 */  "JANYEWARY", "FEBYEWARY",  "MAHCH",     "AYEPRIL",  "MEYE",     "CHEWN",    "CHEW-LIE", "AWGUST",   "SEPTEMBUH",  "AWKTOBUH",    "NOVEMBUH",  "DEESEMBUH"
      } ;

/* put names of days into array */
char *wkday[][7] =
       {
/* Afrikaans       0 */  "SONDAG",    "MAANDAG",       "DINSDAG",     "WOENSDAG",     "DONDERDAG",    "VRYDAG",      "SATERDAG",
/* Danish          1 */  "SONDAG",    "MANDAG",        "TIRSDAG",     "ONSDAG",       "TORSDAG",      "FREDAG",      "LORDAG",
/* Dutch           2 */  "ZONDAG",    "MAANDAG",       "DINSDAG",     "WOENSDAG",     "DONDERDAG",    "VRIJDAG",     "ZATERDAG",
/* English         3 */  "SUNDAY",    "MONDAY",        "TUESDAY",     "WEDNESDAY",    "THURSDAY",     "FRIDAY",      "SATURDAY",
/* Finnish         4 */  "SUNNUNTAI", "MAANANTAI",     "TIISTAI",     "KESKIVIIKKO",  "TORSTAI",      "PERJANTAI",   "LAUANTAI",
/* French          5 */  "DIMANCHE",  "LUNDI",         "MARDI",       "MERCREDI",     "JEUDI",        "VENDREDI",    "SAMEDI",
/* German          6 */  "SONNTAG",   "MONTAG",        "DIENSTAG",    "MITTWOCH",     "DONNERSTAG",   "FREITAG",     "SONNABEND",
/* Italian         7 */  "DOMENICA",  "LUNEDI",        "MARTEDI",     "MERCOLEDI",    "GIOVEDI",      "VENERDI",     "SABATO",
/* Latin                 "DOMINICUS", "LUNES",         "MIUS",        "",             "",             "",            "", */
/* Korean          8 */  "IL-YO-IL",  "WOL-YO-IL",     "HWA-YO-IL",   "SU-YO-IL",     "MOK-YO-IL",    "KUM-YO-IL",   "T'O-YO-IL",
/*                       "KONG-IL, */
/* Norwegian       9 */  "SONDAG",    "MANDAG",        "TIRSDAG",     "ONSDAG",       "TORSDAG",      "FREDAG",      "LORDAG",
/* Polish         10 */  "NIEDZIELA", "PONIEDZIALEK",  "WTOREK",      "SRODA",        "CZWARTEK",     "PIATEK",      "SOBOTA",
/* Portugese      11 */  "DOMINGO",   "SEGUNDA-FEIRA", "TERCA-FIERA", "QUARTA-FIERA", "QUINTA-FIERA", "SEXTA-FIERA", "SABADO",
/* Serbo-Croatian 12 */  "NEDELJA",   "PONEDELJAK",    "UTORAK",      "SREDA",        "CETVRTAK",     "PETAK",       "SUBOTA",
/* Spanish        13 */  "DOMINGO",   "LUNES",         "MARTES",      "MIERCOLES",    "JUEVES",       "VIERNES",     "SABADO",
/* Swedish        14 */  "SONDAG",    "MANDAG",        "TISDAG",      "ONSDAG",       "TORSDAG",      "FREDAG",      "LORDAG",
/* Texan          15 */  "SUNNDI",    "MUNNDI",        "TEWSDI",      "WEDDSDI",      "THIRSTY",      "FRAWDDI",     "SATTADI"
      } ;

/* Deutsche: der Kalendar, der Tag, die Woche, der Monat, das Jahr
   Sonntag,               Montag,              Dienstag,
   Mittwoch,              Donnerstag,          Freitag,
   Sonnabend (Samstag)
*/

/* Espanol: calendario, dia(m), semana, mes (m), ano
   el Domingo,            Lunes,               Martes,
   Miercoles,             Jueves,              Viernes,
   Sabado
*/

/* Hebrew - based on solar years and lunar months.
   shelema - 355 days - complete year, with Heshvan & Keslev having 30 days.
   sedur   - 354 days - normal year, Heshvan is defective (29 days).
   hasera  - 353 days - Heshvan & Kislev both defective (29 days).
   The 11 days by which the solar year (365 days) exceeds the lunar year
   (354 days) are accounted for by having a 13th month (Veadar of 30 days)
   on the 3rd, 6th, 8th, 11th, 14th, and 17th year of a 19 year cycle.

    "TISHRI", 30,        "HESHVAN", 29/30,    "KISLEV", 29/30,
    "TEBET", 29,         "SHEBAT", 30,        "ADAR", 30,       "VEADAR", 30
    "NISAN", 30,         "IYAR", 29,          "SIVIAN", 30,
    "TAMMUZ", 29,        "AB", 30,            "ELUL", 29
*/

int yr[3][12][6][7];    /* Array for 3 yrs, 4-D, 3 years, */
                /* 12 months/year, 6 weeks/month, 7 days/week */

char *new_file  = "DATAFILE.$$$";
char *file      = "DATAFILE.CAL";
FILE *fp;

main()
{
  int year,
      copies,
      more_yrs,
      julian,    /* Julian calendar flag */
      aggie,     /* Aggie calendar flag */
      fy,        /* Fiscal year flag */
      fy_bm,     /* Fiscal year beginning month */
      fy_bd,     /* Fiscal year beginning date */
      bh,        /* Beginning hour for schedules */
      nh,        /* Number of Hours to schedule */
      pl,        /* Page Length in lines */
      pw,        /* Page Width in characters or columns */
      lang,      /* Language desired for calendar */
      by, bm, bd,/* Beg year, month and day passed to functions */
      i,
      j;
  char  c,
     sched_type, /* Schedule type M(onthly), W(eekly), D(aily) */
       base,     /* Number base for Programmers Calendar, 0, H(ex), O(ctal) */
       outp;
  char title[8][BUF];
  void prep_cal(),
       signon(),
       cal_printer(),
       jul_printer(),
       agg_printer(),
       day_printer(),
       sched_printer();
  struct date today;
  signon();

  for (i = 0;                   /* Initialize title array */
       i < 8;
       i++)
      title[i][0] = '\0';

    getdate(&today);            /* Get DOS's idea of date */
    year  = today.da_year;      /* It was a very good year. . . */
    fy_bd = today.da_day;
    fy_bm = today.da_mon;
    copies     = 1;             /* At least one copy. . . */
    bh         = 6;             /* Hour defaults to 0600 */
    nh         = 24;            /* Scheduled Hour defaults to 24 */
    pl         = 66;            /* Page Length in lines */
    pw         = 85;            /* Page Width in characters or columns */
    aggie      = FALSE;         /* Not all are Aggies! */
    base       = FALSE;         /* Decimal for most */
    fy         = FALSE;         /* Most are not Fiscal Year */
    julian     = FALSE;         /* Regular calendar is default */
    sched_type = FALSE;         /* Annual calendar is default */
    lang       =  4;            /* Select English as default Language */
    more_yrs   = 0;             /* One at a time. . . */

  for ( ;; )
  {
    fprintf(stderr,
    "\nSchedule period to be <A>nnual, <M>onthly, <W>eekly, or <D>aily (A/M/W/D)? %c\b",
                           sched_type ? sched_type : 'A' );
    for ( ;; )
    {
        c = toupper(getch());
        switch(c)
        {
            case  'M': break;
            case  'W': break;
            case  'D': break;
            case  'A': break;
            case '\r':
            case '\n': c = (sched_type == FALSE) ? 'A': sched_type;
            default  : ;
        }
        if( (c == 'M') ||
            (c == 'W') ||
            (c == 'D') ||
            (c == 'A')  )
        {
            sched_type = c;
            putch(c);
            if (sched_type == 'A')
                sched_type = FALSE;
            break;
        }
        continue;
    }
    fputs("\nType year desired for calendar (1901-4000): ", stderr);
    year = get_int(year, 4, 1901, 4000);

    fprintf(stderr, "\nHow many successive %ss? (0-99): ",
                (sched_type == 'M') ? "month" :
                (sched_type == 'W') ? "week" :
                (sched_type == 'D') ? "day" :
                                      "year");
    more_yrs = get_int(more_yrs, 2, 0, 99);

    if (! (sched_type) )
    {
        fputs("\nDo you want an Aggie Calendar", stderr);
        aggie = get_yn(aggie ? 'y' : 'n');
    }

    if (!aggie)
    {
        if (! (sched_type) )
        {
            fputs("\nDo you want a 3-digit Julian Calendar", stderr);
            julian = get_yn(julian ? 'y' : 'n');
        }

        if (! (julian | sched_type) )
        {
            fputs("\nFiscal year calendar ", stderr);
            fy = get_yn(fy ? 'y' : 'n');
        }

        if (fy | sched_type)
        {
            fprintf(stderr, "\n%s beginning month (1-12): ",
                (sched_type == 'M') ? "Monthly calendar" :
                (sched_type == 'W') ? "Weekly schedule" :
                (sched_type == 'D') ? "Daily schedule" :
                                      "Fiscal year");
            fy_bm = get_int(fy_bm, 2, 1, 12);
                        /* make month J=0, F=1, . . . D=11 */

            if (sched_type != 'M')
            {
                fprintf(stderr, "\n%s beginning date  (1-31): ",
                    (sched_type == 'W') ? "Weekly schedule" :
                    (sched_type == 'D') ? "Daily schedule" :
                                          "Fiscal year");
                fy_bd = get_int(fy_bd, 2, 1, 31);
            }
            else fy_bd = 1;     /* make months start on first */
        }
    }

    if ( (sched_type) &&
         (sched_type != 'M') )
    {
        fprintf(stderr, "\n%s schedule beginning hour  (0-23): ",
            (sched_type == 'W') ? "Weekly" :
                                  "Daily" );
        bh = get_int(bh, 2, 0, 23);

        fprintf(stderr, "\n%s schedule number of hours (1-24): ",
            (sched_type == 'W') ? "Weekly" :
                                  "Daily" );
        nh = get_int(nh, 2, 1, 24);

    }

    if (sched_type)
    {
        fputs("\nYou may enter two custom title lines for the schedules.", stderr);
        fputs("\nThe titles you enter will be printed on the top two lines.", stderr);
        for (i = 0;
             i < 2;
             i++)
        {
            fprintf(stderr, "\nTitle #%d currently is (RETURN to keep it the same):",
                                     i + 1);
            fprintf(stderr, "\nTitle #%d: %s", i + 1, title[i]);
            fprintf(stderr, "\nTitle #%d: ", i + 1);
            gets(title[4]);
            if (title[4][0] != '\0')
                strcpy(title[i], title[4]);
        }
    }

    fputs("\nProgrammer's Calendar", stderr);
    i = get_yn(base ? 'y' : 'n');
    if (!i)
        base = FALSE;
    else
    {
        fprintf(stderr,
        "\n<H>exadecimal or <O>ctal numbering (H/O)? %c\b",
                               (base == TRUE) ? 'H' : base);
        for ( ;; )
        {
            c = toupper(getch());
            switch(c)
            {
                case  'O': break;
                case  'H': break;
                case '\r':
                case '\n': c = (base == TRUE) ? 'H' : base ; break;
                default  : c = '?';
            }
            if( (c == 'H') || (c == 'O') )
            {
                putch(c);
                base = c;
                break;
            }
            continue;
        }
    }

    fputs("\nThe calendar(s) may be composed in several languages:\n", stderr);
    for (i = 0;
         i < lingos;
         i++)
    {
        if (!(i % 3))
            fputs("\n", stderr);
        fprintf(stderr, "%2d = %-15s",
                         i +1, lingo[i]);
    }


    fprintf(stderr, "\nWhich language for this calendar? (1-%d): ", lingos);
    lang = get_int(lang, 2, 1, lingos);

    fputs("\n<V>iew, <P>rint, or write to <F>ile(s) (V/P/F)? V\b", stderr);
    for ( ;; )
    {
        c = toupper(getch());
        switch(c)
        {
            case  'F': outp = 'F'; break;
            case  'P': outp = 'P'; break;
            case '\r':
            case '\n':
            case  'V': outp = 'V'; break;
            default  : outp = '?';
        }
        if( (outp == 'F') || (outp == 'V') || (outp == 'P') )
        {
            putch(c);
            break;
        }
        continue;
    }

    if (sched_type)             /* Page width/length useful only */
                                /* in M/W/D schedules at this time */

    if ( (outp == 'P') ||       /* We want hardcopy */
/*       (outp == 'V') || */    /* He wants to look at it */
         (outp == 'F')  )       /* He wants a file */
    {
        fputs("\nType # of lines for each page (51-132): ", stderr);
        pl = get_int(pl, 3, 51, 132);

        fputs("\nType # of characters for each line (40-200): ", stderr);
        pw = get_int(pw, 3, 40, 200);
    }

    if (outp == 'P')   /* We want hardcopy */
    {
        fprintf(stderr,
        "\nType # of copies desired of each %s (1-999): ",
                     (sched_type == 'M') ? "month" :
                     (sched_type == 'W') ? "week"  :
                     (sched_type == 'D') ? "day"   :
                                           "year"  );
        copies = get_int(copies, 3, 1, 999);
    }

    setup_files(outp);

    by = year;
    bm = fy_bm -1;
    bd = fy_bd;

    for (i = 0;
         i < more_yrs + 1;
         i++, (sched_type == 'M') ? bm++:
              (sched_type == 'W') ? bd += 7:
              (sched_type == 'D') ? bd++:
                                    by++)
    {
        if (leap(by))           /* Tidy up month length array */
            mon[1].length = 29; /* For this year by fixin' February. . . */
        else
            mon[1].length = 28;

        if (bd > mon[bm].length)/* Past this End Of Month */
        {
            bd -= mon[bm].length;
                                /* So make it appropriate day. . . */
            bm++;               /* Of following month. . . */
        }

       if (bm > 11)          /* Egad! We are past December. . . */
       {
            bm = bm % 12;       /* Normalise it. . . */
            if (bm == 0)        /* Now have January? J=0, F=1 D=11 */
                by++;           /* Ratchet the year. . . */
       }

        if (! (julian))         /* Prepare the calendar arrays */
            prep_cal(by);

        for ( j = 0;
              j < copies;
              j++)
            {
               if (sched_type)
                   sched_printer(by, outp, bm, bd, bh, nh, pl, pw, sched_type, title, base, lang);
               else
               if (julian)
                   jul_printer(by, outp, base, lang);
               else
               if (aggie)
                   agg_printer(by, outp, base, lang);
               else
               if (fy)
                   cal_printer(by, outp, bm, fy, bd, base, lang);
               else
                   cal_printer(by, outp, 0,  fy,  1, base, lang);
            }
    }
    fputs("\nAnother calendar", stderr);
    if (!get_yn('n'))
    {
        if(outp != 'F')
            fclose(fp);
/*      printf("\nClosed %s\n", file);*/
        exit(0);
    }
  }
}



setup_files(out)
char out;
{
    if (fp) fflush(fp);
    if(out == 'V')
    {
        if(!strcmp(file, "PRN"))
        {
            fclose(fp);
/*           printf("\nClosed %s\n", file);*/
        }
        if(strcmp(file, "CON"))
        {
            strcpy(file, "CON");
            fp = fopen(file, "w");
/*          printf("\nOpened %s for write\n", file);*/
        }
    }
    else
    if(out == 'P')
    {
        if(!strcmp(file, "CON"))
        {
            fclose(fp);
/*          printf("\nClosed %s\n", file);*/
        }
        if(strcmp(file, "PRN"))
        {
            strcpy(file, "PRN");
            fp = fopen(file, "w");
/*          printf("\nOpened %s for write\n", file);*/
        }
    }
}



void prep_cal(year)
int year;
{
    int count,          /* Count of the days */
        day,            /* Weekday Sun=0, Mon=2, ... Sat=6 */
        month,          /* Month Jan=0, Feb=1, ... Dec=11 */
        week,           /* Six weeks/month possible */
        yeer,           /* Year for calendar */
        y,              /* Year Last=0, This=1, Next=2 */
        weekday_month();
/*printf("\nIn Prep_cal\n"); */
    for (y = 0;         /* Start at last year y[0] */
         y < 3;         /* Stop after next year y[2] */
         y++)
    {
/*      printf("\nIn Prep_cal, y = [%d]\n", y); */
        yeer = (year + y - 1);
        if (leap(yeer))         /* Tidy up month length array */
            mon[1].length = 29; /* For this year by fixin' February. . . */
        else
            mon[1].length = 28;

        /* get weekday of first day of each month, put into array mon */
        /* Su = 0, Mo = 1, Tu = 2, We = 3, Th = 4, Fr = 5, Sa = 6   */
        for (month = 0;
             month < 12;        /* 12 months/year */
             month++)
        mon[month].first_day = weekday_month(month, yeer);

        /* form year array with 0 for unused dates, with dates */
        /* in their relative positions by weekday */
        for (month = 0;
             month < 12;        /* 12 months/year */
             month++)
        {
            count = 0;          /* set day counter to 0 */
            for (week = 0;
                 week < 6;      /* 6 weeks/month */
                 week++)
            {
                for (day = 0;
                     day < 7;   /* 7 days/week */
                     day++)
                {
                    if( (week == 0) &&  /* first week of month */
                        (day < mon[month].first_day))
                                        /* before first day */
                        yr[y][month][week][day] = 0;
                                        /* Zero it */
                    else
                    if (++count <= mon[month].length)
                                        /* Not past End of Month */
                        yr[y][month][week][day] = count;
                    else
                        yr[y][month][week][day] = 0;
                                        /* Zero it */
                }
            }
        }
    }
}



/* Function to get first day index (day of week of 1st of month) */
/* Jan = 0, Feb = 1, Mar = 2, Apr = 3, . . .  Dec = 11 */
/* Su = 0, Mo = 1, Tu = 2, We = 3, Th = 4, Fr = 5, Sa = 6 */
int weekday_month(Monat, Jahr) /* 1st day of any month after 1900 */
int Monat;
int Jahr;
{
    long int date,      /* date after 1901 */
             numb_days; /* number of days to deal with */
    int      mt[12] = {   0,  31,  59,  90, 120, 151,
                        181, 212, 243, 273, 304, 334  };
    date       = Jahr - 1901;   /* subtract 1901 from year */
    numb_days  = date * 365;    /* # of yrs times 365 days/year */
    numb_days += ( ( date / 4)  /* add number of leap years */
              - (date / 100)    /* subtract non-leap centuries */
              + (date / 400 ))  /* add number of leap centuries */
              + mt[Monat];      /* add days offset for this year */
    if ( ( Jahr % 4) == 0 &&    /* if a conventional leap year */
           Monat > 1 )          /* and after February */
        numb_days++;            /* add a day for Feb 29th */
    return((numb_days +2) %7);  /* divide the number of days by 7 */
                                /* and return the remainder */
}



/* Function to decide if a year is a leap year */
int leap(years)
int years;
{                       /* Leap year sieve */
    if (years & 0x0003) /* Mask year to see if not leap year */
       return FALSE;    /* If we look at the last two bits, and */
                        /* one of them is on, then the year can't */
                        /* be divisible by four.  Thus it is not */
                        /* a leap year, so function returns FALSE. */
                        /* Test for the leap century. */
    else                /* Leap century:   years that are: */
    if (!(years % 100) && /* evenly divisible by 100:  not leap */
         (years % 400) )  /* years unless evenly divisible by 400 */
        return FALSE;   /* Gruenberger and Jaffray, "Problems for */
                        /* Computer Solution", Wiley, 1965. */
                        /* We have filtered out all years that are */
                        /* not evenly divisible by four as well as */
                        /* those evenly divisible by 100 that are */
                        /* evenly divisible by 400. */
                        /* It seems that all the rest are */
                        /*   (a) evenly divisible by four */
                        /*   (b) evenly divisible by 400  */
    return TRUE;        /*   (c) Thus, leap years. . . */
}



void cal_printer(year, out, bm, fy, bd, base, lang)
int year;
char out;
int bm;
int fy;
int bd;
char base;      /* Number base used, 0 = Decimal, H = Hex, O = Octal */
int lang;       /* Language used 1=Danish, 2=Dutch, 3=English etc. */
{
    char hdr1[] = {" Su Mo Tu We Th Fr Sa"},
         hdr2[] = {" -- -- -- -- -- -- --"};

    int y, month, week, day, count, stat;
    char  linbuf[BUF],
          temp[BUF],
         *char_str(),
         *center(),
         *trim();
    char *off = (out == 'V') ? " " : "       ";
    y = 1;              /* Make year this year */

    sprintf(hdr1, " %2.2s %2.2s %2.2s %2.2s %2.2s %2.2s %2.2s",
           wkday[lang -1][0], wkday[lang -1][1], wkday[lang -1][2],
           wkday[lang -1][3], wkday[lang -1][4], wkday[lang -1][5],
           wkday[lang -1][6] );

    if(out == 'F')                      /* setup for file output */
    {
        sprintf(file, fy ?
                  "%dFY%c" :
                  "%d%c",
                   year, base);
        strcpy(new_file, file);
        strcat(file, ".$$$");
        sprintf(temp, ".%3.3s", lingo[lang -1]);
        strcat(new_file, temp);
        fp = fopen(file, "w");
/*      printf("\nOpened %s for write\n", file);*/
    }

    fputs("\n\n\n", fp);
    sprintf(temp, fy ? "%s%s%s Calendar for Fiscal Year %d-%d":
                       "%s%s%s Calendar for %d",
/*               ( (base == 'O') && (lang != 10) ) ? "Classical " : "" ,*/
                 base ? "Programmer's " : "" ,
                 base ? ( (base == 'O') ? "Octal " : "Hexadecimal ") : "",
                 lingo[lang -1],
                 year, year +1);

    fputs(center(temp, (out == 'V') ? 75 : 89), fp);
    fputs("\n\n\n", fp);

    if (bd == 1)                /* If fy month starts on 1st, */
        fy = FALSE;             /* treat like ordinary month */

    for (month = bm;            /* Start at beginning Month for FY */
         month < (12 + bm + fy);
         month += 3)
    {                   /* 4 sets of months  3 months across */
        sprintf(linbuf,
             "%s%s    ", off, center(mnam[lang -1][month %12], 21));

        if (month != (bm +12))  /* NOT FY and 13th month */
        {
            sprintf(temp,
                "%s    ", center(mnam[lang -1][(month +1) %12], 21));
            strcat(linbuf, temp);
            sprintf(temp,
                "%s"    , center(mnam[lang -1][(month +2) %12], 21));
            strcat(linbuf, temp);
        }

        strcat(linbuf, "\n");   /* add a newline */
        fputs(linbuf, fp);      /* Names of three Months */
        linbuf[0] = '\0';

        if(month != (bm +12))   /* NOT FY and 13th month */
        {
            fprintf(fp, "%s%s    %s    %s\n",
                        off, hdr1, hdr1, hdr1);
            fprintf(fp, "%s%s    %s    %s\n",
                        off, hdr2, hdr2, hdr2);
        }
        else                    /* FY and 13th month */
        if (bd != 1)            /* beginning after the 1st */
        {
            fprintf(fp, "%s%s\n",       /* Names of weekdays */
                        off, hdr1);
            fprintf(fp, "%s%s\n",       /* Lines of dashes */
                        off, hdr2);
        }

        for (week = 0;          /* One line per week */
             week < 6;          /* 6 wks/month possible */
             week++)
        {
            sprintf(linbuf, off);

            for (count = 0;     /* 3 months/line ordinarily */
                 count < ((month == (bm +12)) ?
                                            1 : /* FY 13th month alone */
                                            3); /* Ordinary line */
                 count++)
            {
                for (day = 0;
                     day < 7;   /* 7 days/week */
                     day++)
                {
                    if (((month + count) == bm) &&  /* FY 1st month */
                        (yr[y][month + count][week][day] < bd))
                         sprintf(temp, "   ");
                    else
                    if (((month + count) == (bm +12)) &&
                        (yr[y][month + count][week][day] >= bd))
                         sprintf(temp, "   ");
                    else
                    sprintf(temp,
                        yr[y][month + count][week][day] ?
                            (base ?
                                ((base == 'O') ? "%3o" : "%3X" ) :
                                                 "%3d" ) :
                                                 "   ",
                        yr[y][month + count][week][day]);
                    strcat(linbuf, temp);
                }
                strcat(linbuf,
                count < ((month < (bm +12)) ? 2 : 0) ? "    ": "\n" );
            }
            fputs(linbuf, fp);
            linbuf[0] = '\0';
        }
        fputs("\n\n", fp);
    }
    if (out != 'V') fputs("\f", fp);    /* no FF for screen */

    if (out == 'F')                     /* setup for file output */
        if ((stat = fclose(fp)) == ERROR)
            printf("\nCan't close %s.\n", file);
        else
/*      printf("\nClosed %s\n", file);*/

    if (out == 'F')
    {
        if ((stat = rename(file, new_file)) == ERROR)
        {
            printf(
            "\nCan't rename %s to %s.  %s may already exist.\n",
                                 file, new_file, new_file);
        }
    }
}



void agg_printer(year, out, base, lang)
int year;
char out;
char base;      /* Number base used, 0 = Decimal, H = Hex, O = Octal */
int lang;       /* Language used 1=Danish, 2=Dutch, 3=English etc. */
{
    int mf[12][2];          /* mf flag for aggie calendar */

    char agg1[] = {" Ja Fe Ma Ap Ma Jn Jl Au Se Oc No De"},
         agg2[] = {" -- -- -- -- -- -- -- -- -- -- -- --"};

    int y, month, week, day, count, stat, i, j;
    char  linbuf[BUF],
          temp[BUF],
         *char_str(),
         *center(),
         *trim();
    char *off = (out == 'V') ? " " : "    ";
    y = 1;      /* Make year this year */
    sprintf(agg1, " %2.2s %2.2s %2.2s %2.2s %2.2s %2.2s %2.2s %2.2s %2.2s %2.2s %2.2s %2.2s",
           mnam[lang -1][0], mnam[lang -1][ 1], mnam[lang -1][ 2],
           mnam[lang -1][3], mnam[lang -1][ 4], mnam[lang -1][ 5],
           mnam[lang -1][6], mnam[lang -1][ 7], mnam[lang -1][ 8],
           mnam[lang -1][9], mnam[lang -1][10], mnam[lang -1][11] );

    if (out == 'F')
    {
        sprintf(file, "%dAGG%c", year, base);
        strcpy(new_file, file);
        strcat(file, ".$$$");
        sprintf(temp, ".%3.3s", lingo[lang -1]);
        strcat(new_file, temp);
        fp = fopen(file, "w");
/*      printf("\nOpened %s for write\n", file);*/
    }
    fputs("\n\n\n", fp);
    sprintf(temp, "%sAggie %s%sGig'Em %s Calander fer %d",
                 (base == 'O') ? "Olde " : "" ,
                 base ? "Hacker's " : "" ,
                 base ? ( (base == 'O') ? "Octal " : "Hexadecimal ") : "",
                 lingo[lang -1],
                 year);
    fputs(center(temp, (out == 'V') ? 75 : 89), fp);
    fputs("\n\n\n", fp);
    for (day = 0;
         day < 7;               /* 4 sets of days */
         day += 2)              /* 2  days across */
    {
         for (i = 0;
              i < 12;           /* 12 months in a day */
              i++)
             for (j = 0;
                  j < 2;        /* 2  days across */
                  j++)
                      mf[i][j] = 0;
        if (day < 6)
        {
            sprintf(linbuf, "%s%s    ", off, center(wkday[lang -1][day], 36));
            sprintf(temp,   "%s\n"  , center(wkday[lang -1][day +1], 36));
            strcat(linbuf, temp);
            fputs(linbuf, fp);
            linbuf[0] = '\0';
            fprintf(fp, "%s%s   %s\n", off, agg1, agg1);
            fprintf(fp, "%s%s   %s\n", off, agg2, agg2);
        }
        else
        {
            fprintf(fp, "%s%s\n", off, trim(center(wkday[lang -1][day], 79) ) );
            fprintf(fp, "%s%s\n", off, trim(center(agg1, 79) ) );
            fprintf(fp, "%s%s\n", off, trim(center(agg2, 79) ) );
        }
        for (week = 0;
             week < 5;          /* 5 weeks/day possible */
             week++)
        {
            sprintf(linbuf, off);
            for (count = 0;     /* 2 days across except Saturday */
                 count < ( (day == 6) ? 1 : 2) ;
                 count++)
            {
                if (day == 6)
                    strcat(linbuf, "                     ");
                for (month = 0;
                     month < 12;        /* 12 mnths/day */
                     month++)
                {
                    if (!yr[y][month][week][day + count])
                        mf[month][count] = 1;
                    sprintf(temp,
                     yr[y][month][week +mf[month][count]][day +count] ?
                            (base ?
                                ((base == 'O') ? "%3o" : "%3X" ) :
                                                 "%3d" ) :
                                                 "   ",
                     yr[y][month][week +mf[month][count]][day + count]);
                    strcat(linbuf, temp);
                }
                strcat(linbuf, count < 1 ? "   ": "\n" );
                if (day == 6) strcat(linbuf, "\n");
            }
            fputs(linbuf, fp);
            linbuf[0] = '\0';
        }
        fputs("\n\n", fp);
    }
    if (out != 'V') fputs("\f", fp);    /* no FF for screen */
    if(out == 'F')                      /* setup for file output */
        if ((stat = fclose(fp)) == ERROR)
            printf("\nCan't close %s.\n", file);
/*      else
        printf("\nClosed %s\n", file);*/
    if(out == 'F')
    {
        if ((stat = rename(file, new_file)) == ERROR)
        {
            printf(
            "\nCan't rename %s to %s.  %s may already exist.\n",
                                 file, new_file, new_file);
        }
    }
}



void jul_printer(year, out, base, lang)
int year;
char out;
char base;      /* Number base used, 0 = Decimal, H = Hex, O = Octal */
int lang;       /* Language used 1=Danish, 2=Dutch, 3=English etc. */
{
    int month, day, stat, count, leep;
    char  linbuf[BUF],
          temp[BUF],
         *char_str(),
         *center(),
         *trim();
    int jul[12][31];     /* Array for Julian yr, 12 months/year */
                         /* 31 days/month */
    char *off = (out == 'V') ? " " : "    ";
    int month_length[12] =
    {
        0,  31,  59,  90, 120, 151, 181, 212, 243, 273, 304, 334
    };
    char jul1[] = {"Month:   Jan  Feb  Mar  Apr  May  Jun  Jul  Aug  Sep  Oct  Nov  Dec           "};
    char jul2[] = {"         ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---  ---"};

    leep = leap(year);    /* Find out if leap year */
    sprintf(jul1, "         %3.3s  %3.3s  %3.3s  %3.3s  %3.3s  %3.3s  %3.3s  %3.3s  %3.3s  %3.3s  %3.3s  %3.3s",
           mnam[lang -1][0], mnam[lang -1][ 1], mnam[lang -1][ 2],
           mnam[lang -1][3], mnam[lang -1][ 4], mnam[lang -1][ 5],
           mnam[lang -1][6], mnam[lang -1][ 7], mnam[lang -1][ 8],
           mnam[lang -1][9], mnam[lang -1][10], mnam[lang -1][11] );
    if (out == 'F')
    {
        sprintf(file, "%dJUL%c", year, base);
        strcpy(new_file, file);
        strcat(file, ".$$$");
        sprintf(temp, ".%3.3s", lingo[lang -1]);
        strcat(new_file, temp);
        fp = fopen(file, "w");
/*      printf("\nOpened %s for write\n", file);*/
    }
    fputs("\n\n\n", fp);
    sprintf(temp, "%s%s%s%s 3-Digit Julian Calendar for %d",
                 (base == 'O') ? "Olde " : "" ,
                 base ? "Hacker's " : "" ,
                 base ? ( (base == 'O') ? "Octal " : "Hexadecimal ") : "",
                 lingo[lang -1],
                 year);
    fputs(center(temp, (out == 'V') ? 75 : 89), fp);
    fputs("\n\n\n", fp);
    fprintf(fp, "%s%s\n", off, jul1);
    fprintf(fp, "%s%s\n", off, jul2);

    for (month = 0;
         month < 12;    /* 12 months */
         month++)
        for (day = 1;
             day < 32;  /* 31 days possible */
             day++)
        {
            count = (day + month_length[month] + ((month > 1) ? leep : 0) );
            if (count > (month_length[month +1] + ((month) ? leep : 0)) )
                count = 0;
/*          fprintf(stderr, "%6d", count); */
            jul[month][day -1] = count;
        }

    for (day = 0;
         day < 31;
         day++)
    {
        if ( (day)       &&
             (!(day % 2)) )
                fprintf(fp, "\n");
        fprintf(fp, "%sDay #%2d", off, day +1);

        for (month = 0;
             month < 12;
             month++)
        {
            if (jul[month][day])
            {
                fprintf(fp,
                   (base ?
                       ((base == 'O') ?
                           "  %3o" :
                           "  %3X" ) :
                           "  %3d" ),
                           jul[month][day]);
            }
            else
                fprintf(fp, "     ");
        }
        fprintf(fp, "   Day #%2d\n", day +1);
    }

    if (out != 'V') fputs("\f", fp);    /* no FF for screen */
    if (out == 'F')                     /* setup for file output */
        if ((stat = fclose(fp)) == ERROR)
            printf("\nCan't close %s.\n", file);
/*      else
        printf("\nClosed %s\n", file);*/
    if (out == 'F')
    {
        if ((stat = rename(file, new_file)) == ERROR)
        {
            printf(
            "\nCan't rename %s to %s.  %s may already exist.\n",
                                 file, new_file, new_file);
        }
    }
}



char *center(str, width)
char *str;
int width;
{
    static char buf[BUF];  /* location of finished string */
    char  filler,
         *char_str(),
         *strcpy(),
         *strcat();
    int i;

    filler = ' ';
    if (strlen(str) >= width)   /* Test for str longer than width */
        str[width] = '\0';      /* Terminate it at width */
    strcpy(buf, char_str( (width - strlen(str) ) >> 1, filler));
    strcat(buf, str);
    i = strlen(buf);
    while (width - i)
         buf[i++] = filler;
    buf[i] = '\0';
    return(buf);
}



char *trim(str)     /* trim spaces from end of string */
char *str;
{
    static char buf[BUF];  /* location of finished string */
    char  filler,
         *char_str(),
         *strcpy(),
         *strcat();
    int i;
    filler = ' ';
    strcpy(buf, str);
    i = strlen(buf);
    while (buf[--i] == filler)
        buf[i] = '\0';
    return(buf);
}



char *char_str(length, c)
int length;
char c;
{
    static char loc[BUF];
    char *ptr = loc;

    while (length--)
        *ptr++ = c;
    *ptr = '\0';
    return(loc);
}



int get_int(defalt, digits, lowest, highest)
int defalt,     /* default value when C/R alone is struck */
    digits,     /* maximum number of digits accepted */
    lowest,     /* lowest value accepted */
    highest;    /* highest value accepted */
{
    char buffer[80]; 	/* Buffer to store input string */
    int ch;             /* All purpose character ch */
    int index = 0;      /* Character array index */
    int value = 0;      /* value to return */
    int done = FALSE;   /* Done/Not Done Flag */
    char dfalt[10];     /* Buffer to store default value as string */
    int i, ii;          /* length of default value as a string */

    sprintf(dfalt, "%d", defalt); /* Convert default to string */
    i = ii = strlen(dfalt);     /* Calculate its length */
    printf("%s", dfalt);        /* Display default value */
    while (ii--)
        putch('\b');            /* Backspace to beginning */

    while (!done)
    {
        while (index < digits)  /* while not enough digits, grab 'em */
        {
            ch = getch();  	/* Get a char from console, no echo */

            if (isdigit(ch))    /* Digit!! so . . .  */
            {
                putch(ch);              /* Echo it to console, and */
                buffer[index++] = ch;   /* Stuff it into buffer */
                if (index == 1)         /* Entered first digit, so. . . */
                {
                    for (ii = digits; --ii; )
                        putch(' ');     /* Blank it out */	
                    for (ii = digits; --ii; )
                        putch('\b');    /* Backspace to beginning */
                }
            }

            else
            if ((ch == '\b') && /* Backspace? */
                (index) )       /* if index not zero */
            {
                --index;        /* Reduce index */
                putch(' ');     /* Blank it */
                putch('\b');    /* Backspace over blank */
                putch(ch);      /* Echo it to console */
            }

            else
            if (ch == '\r')     /* Return? */
                break;          /* says he's through */
        }       /* End while not enough digits, grab 'em */

        buffer[index] = '\0';   /* Terminate string */

        if (index == 0)         /* no digits entered before return */	
        {
            value = defalt;     /* so use default */
            done  = TRUE;       /* We're through */
        }

        else                            /* some digits were entered */
        {
            value = atoi(buffer);       /* Convert string to integer */

            if ((value < lowest) ||     /* Range test value returned */
                (value > highest) )
            {                           /* Out of allowable range. . . */
                for ( ; index; --index)
                    putch('\b');        /* Backspace to beginning */
                for (ii = digits; ii; --ii)
                    putch(' ');         /* Blank it out */	
                for (ii = digits; ii; --ii)
                    putch('\b');        /* Backspace to beginning */
                printf("%s", dfalt);    /* Display default value */
                for (ii = i; ii; --ii)
                    putch('\b');        /* Backspace to beginning */
            }

            else
            {
                done  = TRUE;           /* We're through */
            }
        }
    }  /* end while !done */
    return(value);
}



int get_yn(defalt)
char defalt;
{
    char c;                     /* all purpose character */
    fputs(" (y/n) ? ", stderr); /* Prompt for Yes or No */
    putch(defalt);              /* Display default */
    putch('\b');                /* Backspace to it */
    do
    {
        c = tolower(getch());   /* Get a character, make it lowercase */
    }   while ( (c != 'y') &&   /* Until we get a y, n or return */
                (c != 'n') &&
                (c != '\r') );
    if (c == '\r')              /* If a return, make it the default */
        c = defalt;
    putch(c);                   /* Display choice to user */
    return (c == 'y') ? TRUE : FALSE ;
}



void signon()
{
    fputs(
    "\t\t\tYEARCAL v0.04T 2 Nov 1987\n\n\t\tCopyright 1987 by Paul M. Sittler\n\n", stderr);
    fputs(
    "\tYEARCAL makes calendars (A) or schedules (M/W/D) for years after 1901.\n\n", stderr);
    fputs(
    "\tAt the user's option, Normal, Fiscal Year, AGGIE, or 3-Digit Julian\n", stderr);
    fputs(
    "\tDate Calendars can be produced, in multiple copies, for a number of\n", stderr);
    fputs(
    "\tconsecutive years, or both.  Fiscal Year calendars may be produced for\n", stderr);
    fputs(
    "\tany arbitrary 12 or 13 month fiscal year.  The user may select a\n", stderr);
    fputs(
    "\tProgrammer's calendar, numbered in Hexadecimal or Octal numbers rather\n", stderr);
    fputs(
    "\tthan decimal numbers, and may choose one of several languages.\n\n", stderr);
    fputs(
    "\tThe calendars may be displayed on the screen, printed, or written to\n", stderr);
    fputs(
    "\ta file as desired.  If written to disk, files are named like YYYY.ENG\n", stderr);
    fputs(
    "\t(Normal ENGlish), YYYYFY.DUT (Fiscal-Year DUTch), YYYYAGG.TEX (Aggie-\n", stderr);
    fputs(
    "\ttype TEXan), or YYYYJUL.POL (3-Digit Julian Date POLish) calendars,\n", stderr);
    fputs(
    "\tetc.  Hex or Octal calendar files will have an \"H\" or \"O\" added to\n", stderr);
    fputs(
    "\ttheir names, such as YYYYH.SPA, YYYYFYO.SER or YYYYAGGH.FRE.\n\n", stderr);
    fputs(
    "\tYEARCAL may be freely distributed, and used for non-commercial\n", stderr);
    fputs(
    "\tpurposes, as long as the unmodified program source code and\n", stderr);
    fputs(
    "\tdocumentation files are distributed with it.\n", stderr);
}



void sched_printer(year, out, bm, bd, bh, nh, pl, pw, sched_type, title, base, lang)
int year;       /* Year for calendar */
char out;       /* Output goes where? View, Printer, File */
int bm;         /* Month (beginning) for schedule */
int bd;         /* Day (beginning) for schedule */
int bh;         /* Hour (beginning) for schedule */
int nh;         /* number of hours to schedule (1-24) */
int pl;         /* Page Length in lines */
int pw;         /* Page Width in characters or columns */
char sched_type;/* Schedule type M(onthly), W(eekly), D(aily) */
char title[][BUF];
char base;      /* Number base used, 0 = Decimal, H = Hex, O = Octal */
int lang;       /* Language used 1=Danish, 2=Dutch, 3=English etc. */
{
    int i, j,
        bw,     /* Box width */
        w,      /* Week number for printing top calendars */
        y,
        month,
        day,
        first_day,
        stat,
        wk_day;
    char  linbuf  [BUF],
          temp    [BUF],
          temp1   [BUF],
          temp2   [BUF],
          bnd     [BUF],
          sep     [BUF],
          hoursw  [BUF],
          spacerw [BUF],
          dates   [BUF],
         *char_str(),
         *center(),
         *trim();
    char *off = (out == 'V') ?
                         " " :          /* Offset for screen */
                         "       ";     /* Offset for printing */
    y = 1;      /* Make year this year */
/*  printf(
"\nArgs: year=[%d], out=[%c], bm=[%d], bd=[%d], bh=[%d], nh=[%d], pl=[%d]\n",
       year,      out,      bm,      bd,      bh,      nh,      pl);
    printf(
"Args: pw=[%d], sched_type=[%c], base=[%c], lang=[%d]\n",
       pw,      sched_type,      base,      lang);
 */
    if (out == 'V')             /* Gonna View it, so. . . */
          pw = 80  ;            /* pw is screen width */

    if (out == 'F')             /* setup for file output */
    {
        (sched_type == 'M') ?
            sprintf(file, "%d%3.3s%c", year, mnam[lang -1][bm], base):
            sprintf(file, "%d%02d%02d", year, bm + 1, bd);
        strcpy(new_file, file);
        strcat(file, ".$$$");
        sprintf(temp, ".%3.3s", lingo[lang -1]);
        strcat(new_file, temp);
        fp = fopen(file, "w");
/*      printf("\nOpened %s for write\n", file);*/
    }

    first_day = weekday_month(bm, year);        /* 1st day of month */
    if (sched_type == 'M')
        wk_day = 0;
    else
        wk_day = ( (first_day + bd -1) % 7);    /* Gives us weekday */

    sprintf(title[5], "%s",
                   (sched_type == 'M')? /* Monthly calendar */
                   "Monthly Calendar" :
                   (sched_type == 'W')? /* if weekly instead of daily */
                    "Weekly Schedule" :
                    "Daily Schedule");

    sprintf(title[4], (sched_type == 'W') ?
                     "Week begins on %s" :
                         (sched_type == 'D') ?
                                        "%s" :
                                          "" ,
                       wkday[lang -1][wk_day]);

    if (sched_type == 'M')
    {
        sprintf(title[3], "%s %d",
                   mnam[lang -1][bm], year );
    }
    else
        sprintf(title[3], "%d %s, %d",
                   bd,
                   mnam[lang -1][bm],
                   year );

    strcpy(hoursw, off);                /* Put offset into hoursw */
    strcpy(spacerw, off);               /* Put offset into spacerw */

    if (sched_type != 'M')              /* If Daily or Weekly */
    {
        sprintf(temp, "| %s00 |",
                            (base ?
                   ((base == 'O') ?
                            "%02o" :
                          "%02X" ) :
                          "%02d" ) );
        strcat(hoursw, temp);           /* Add header info to hoursw */
        strcat(spacerw, "|      |");    /* Add header info to spacerw */
    }
    else                                /* Monthly Calendar, so. . . */
    {
        strcat(hoursw, "|");            /* Add header info to hoursw */
        strcat(spacerw, "|");           /* Add header info to spacerw */
    }

    bw = (((pw - strlen(hoursw) ) / 7) -1);  /* Calculate Box Width */
    for (i = 0;                         /* Form strings for each day */
         i < bw;
         i++)
    {
        temp [i] = ' ';                 /* Using spaces */
    }
    if (sched_type == 'M')              /* Monthly Calendar */
    {
        strcpy(dates, temp);            /* Copy temp to dates for length */
        dates[i -2] = '\0';             /* Cut dates to length */
    }

    temp[i++] =  (sched_type == 'D')?   /* If Daily */
                                 ' ':   /* Add ' ' */
                                 '|';   /* Otherwise add '|' */
    temp[i]   = '\0';                   /* Terminate string */

    for (i = 0;                 /* Adding multiple temps to */
         i < 7;
         i++)
    {
        if (sched_type != 'M')
            strcat(hoursw, temp);       /* Add temp to hoursw */
        strcat(spacerw, temp);  /* Add temp to spacerw */
    }
    if(sched_type == 'D')
    {
        hoursw [strlen(hoursw) -1] = '|';
        spacerw[strlen(spacerw)-1] = '|';
    }

    strcat(spacerw, "\n");      /* Add '\n' */
    strcat(hoursw, "\n");       /* Add '\n' */

    strcpy(bnd, off);                   /* Put offset into boundary */
    strcpy(sep, off);                   /* Put offset into separator */
    for (i = 0;                         /* Draw them lines. . . */
         i < (strlen(spacerw) - strlen(off) -1);
         i++)
    {
        temp[i] = '-';                  /* Using Hyphens */
    }
    temp[i]     = '\n';                 /* Add Newline */
    temp[i +1]  = '\0';                 /* Terminate string */
    strcat(bnd, temp);                  /* Add temp to bnd */
    temp[0]     = '|';
    temp[i -1]  = '|';
    strcat(sep, temp);                  /* Add temp to sep */

    pw = strlen(bnd) -1;                /* Adjust Page Width */

    fputs("\n\n", fp);                  /* Print two blank lines */
    /* Line One: Last and Next Month's names */
    sprintf(temp, "%s %d",      /* Last month's name and year */
                   mnam[lang -1]
                      [(sched_type == 'M') ?
                           (bm +11) % 12 :
                                      bm ],
                       (sched_type == 'M') ?
                                 (bm == 0) ?
                                 year -1 :
                                    year :
                                    year );
    sprintf(temp2,"%s %d",      /* Next month's name and year */
                   mnam[lang -1][(bm +1) %12],
                   (bm == 11) ? year +1 : year );
    strcpy(linbuf, off);
    strcat(linbuf, center(temp, 21) );
    strcat(linbuf, center(title[0], (pw -42 -strlen(off)) ) );
    strcat(linbuf, center(temp2, 21) );
    strcat(linbuf, "\n");
    fputs(linbuf, fp);

    /* Line Two: Weekday headers */
    sprintf(temp, " %2.2s %2.2s %2.2s %2.2s %2.2s %2.2s %2.2s",
           wkday[lang -1][0], wkday[lang -1][1], wkday[lang -1][2],
           wkday[lang -1][3], wkday[lang -1][4], wkday[lang -1][5],
           wkday[lang -1][6] );

    strcpy(linbuf, off);
    strcat(linbuf, center(temp, 21) );
    strcat(linbuf, center(title[1], (pw -42 -strlen(off)) ) );
    strcat(linbuf, center(temp, 21) );
    strcat(linbuf, "\n");
    fputs(linbuf, fp);

    /* Lines 3-8: Last and Next Month's first weeks */
    for (w = 0;
         w < 6;
         w++)
    {
        temp[0] = '\0';
        temp2[0] = '\0';
        for (day = 0;
             day < 7;   /* 7 days/week */
             day++)
        {
            sprintf(linbuf,
                 yr[(sched_type == 'M') ? (bm == 0) ? y -1 : y : y]
                 [(sched_type == 'M') ? (bm +11) % 12 : bm][w][day] ?
                                       (base ?
                              ((base == 'O') ?
                                       "%3o" :
                                     "%3X" ) :
                                     "%3d" ) :
                                        "   ",
                 yr[(sched_type == 'M') ? (bm == 0) ? y -1 : y : y]
                 [(sched_type == 'M') ? (bm +11) % 12 : bm][w][day]);
            sprintf(temp1,
                 yr[((bm == 11) ? y +1 : y)][(bm +1) %12][w][day] ?
                                       (base ?
                              ((base == 'O') ?
                                       "%3o" :
                                     "%3X" ) :
                                     "%3d" ) :
                                        "   ",
                 yr[((bm == 11) ? y +1 : y)][(bm +1) %12][w][day]);
            strcat(temp, linbuf);
            strcat(temp2, temp1);
        }
        strcpy(linbuf, off);
        strcat(linbuf, center(temp, 21) );
        strcat(linbuf, center(title[w + 2], (pw -42 -strlen(off)) ) );
        strcat(linbuf, center(temp2, 21) );
        strcat(linbuf, "\n");
        fputs(linbuf, fp);
    }

    fputs(bnd, fp);             /* print boundary */

  if (sched_type != 'M')              /* NOT Monthly calendar */
  {
    sprintf(linbuf, "%s|      |", off);
    for (i = day = bd, month = bm; i < (bd + 7); i++, day++)
    {
        if (day >  mon[month].length)   /* Past this month */
        {
            day -= mon[month].length;
                                /* So make it appropriate day. . . */
            month++;            /* Of following month. . . */
            month = month % 12; /* And then normalise it. . . */
        }
        sprintf(temp1, "%d %3.3s", day, mnam[lang -1][month]);
        sprintf(temp, "%s|", center(temp1, bw) );
        strcat(linbuf, temp);
    }
    strcat(linbuf, "\n");
    fputs(linbuf, fp);
  }

    sprintf(linbuf, (sched_type != 'M')?
                           "%s|      |":
                           "%s|", off);
    for (i = wk_day; i < (wk_day + 7); i++)
    {
        sprintf(temp1, "%3.9s", wkday[lang -1][i % 7]);
        sprintf(temp, "%s|", center(temp1, bw) );
        strcat(linbuf, temp);
    }
    strcat(linbuf, "\n");
    fputs(linbuf, fp);

    if (sched_type == 'M')              /* Monthly calendar */
    {                                   /* Months have 5 or 6 weeks */
        bh = 0;
        nh = (yr[y][bm][5][0])?         /* Sixth week, Sunday? */
                           6:           /* Six weeks/month */
                           5;           /* Five weeks/month */
    }

    for (i = bh;
         i < (bh + nh);
         i++)    /* print the hourly lines */
    {
        fputs(sep, fp);                 /* print separators */
        if (sched_type == 'M')
        {
            sprintf(hoursw, "%s|", off);/* Initialize hoursw */
            for (j = 0; j < 7; j++)
            {
                sprintf(temp,
                        yr[y][bm][i][j] ?
                            (base ?
                                ((base == 'O') ? "%s%2o|" : "%s%2X|" ) :
                                                 "%s%2d|" ) :
                                                 "%s  |",
                        dates,
                        yr[y][bm][i][j]);
                strcat(hoursw, temp);
            }
            strcat(hoursw, "\n");
        }

        fprintf(fp, hoursw, (i % 24)); /* print hour/week line */

        for (j = 2;
             j < ((pl - 18) / nh);
             j++)
            fputs(spacerw, fp);         /* print spacer line(s) */
    }
    fputs(bnd, fp);                     /* print boundary */

    if(out != 'V') fputs("\f", fp);     /* no FF for screen */
    if(out == 'F')                      /* setup for file output */
        if((stat = fclose(fp)) == ERROR)
            printf("\nCan't close %s.\n", file);
        else
/*      printf("\nClosed %s\n", file);*/
    if(out == 'F')
    {
        if ((stat = rename(file, new_file)) == ERROR)
        {
            printf(
            "\nCan't rename %s to %s.  %s may already exist.\n",
                                 file, new_file, new_file);
        }
    }
}
