	PAGE	45,132
	TITLE	SCRNSAVE.ASM - 6 January 1985

	;INCLUDE SCRNSAVE.DOC


;	Misc. Z-100 system equates

ZVIDEO	EQU	0D8H			; Z-100 68A21 video port
INT_UTMA EQU	051H			; User Timer interrupt
INT_UKBA EQU	050H			; User Keyboard interrupt
INT_UCRTA EQU	055H			; User CRT interrupt (6/24)

;	Misc. Z-150 system equates

CRTBASE EQU	063H			; 6845 CRT controller port pointer
MODE	EQU	065H			; Current CRT mode pointer
INT_TMA EQU	01CH			; Timer interrupt
INT_KBD EQU	009H			; Keyboard interrupt
INT_VID EQU	010H			; Video interrupt
KBD_DATA EQU	060H			; Keyboard data port
KBD_CNTL EQU	061H			; Keyboard control port

;	Other equates

OFF	EQU	0
ON	EQU	1
FALSE	EQU	0
TRUE	EQU	NOT FALSE

Z100	EQU	FALSE			; Flag to assemble for Z-100
Z150	EQU	NOT Z100		; ... otherwise, for Z-150, IBM PC
DEBUG	EQU	FALSE
EATBYTE EQU	FALSE			; Whether to gobble screen-on char
MONVID	EQU	TRUE			; Whether to monitor video I/O
TIME	EQU	5			; Default time-out (minutes)

;	The resident portion of the program

CODE    SEGMENT BYTE PUBLIC 'CODE'
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE

	ORG	0100H

START	LABEL	NEAR
	JMP	START1

TEST    DB      'SCRNSAVE.COM'
TESTL	EQU	$-TEST
        DB      ' - Copyright (c) 1984 by MicroMagic -'
        DB      ' All rights reserved.'

;	CLK_ENTRY is the timer interrupt handler.  Upon entry, we first
;	check to see if the screen is already disabled.  If so, we can
;	just exit with no further action.  If the screen is on, we first
;	increment the counter and then check to see if the counter has
;	reached the time-out value set when the program was invoked.
;       If we have timed out, we save the user's video port value and
;	then turn the screen off.

CLK_ENTRY LABEL NEAR				; The timer entry point

        PUSH    AX                              ; Save user's AX
	PUSH	DS				;  and DATA segment

	MOV	AX,CS				; Set my data segment
	MOV	DS,AX

	CMP	BYTE PTR SCREEN,OFF		; Screen already off?
	JE	CLK_EXIT			;  yes, just exit

	CMP	WORD PTR MAX_CNT,0		; Screen saver turned off?
	JE	CLK_EXIT			;  yes, just exit

	INC	WORD PTR COUNTER		; Screen on, so bump count
	MOV	AX,WORD PTR COUNTER		; Get new count

    IF DEBUG
	INC	WORD PTR CNTTEST
    ENDIF

	CMP	AX,WORD PTR MAX_CNT		;   and see if timed out
	JB	CLK_EXIT			; Not yet, just exit
	MOV	BYTE PTR SCREEN,OFF		; Timed out, flag screen off

    IF Z100

	IN	AL,ZVIDEO			; Get video port value
	MOV	BYTE PTR VIDEO,AL		;  and save it for later
	OR	AL,0FH				;  and disable screen
	OUT	ZVIDEO,AL

    ENDIF

    IF Z150

	PUSH	ES				; Save ES
	PUSH	DX				;  and DX
	MOV	AX,0040H			; Point to BIOS
	MOV	ES,AX
	MOV	DX,WORD PTR ES:CRTBASE		; Get CRT address
	ADD	DX,6				;  point to control port
	MOV	AL,0
	OUT	DX,AL				; Put into IBM mode
	SUB	DX,2				;  and point to mode register
	MOV	AL,BYTE PTR ES:MODE		; Get current mode value
	AND	AL,11110111B			; Clear video enable bit
	OUT	DX,AL				;  and switch screen off
	MOV	BYTE PTR ES:MODE,AL
	POP	DX
	POP	ES

    ENDIF

CLK_EXIT LABEL NEAR

	POP	DS				; Get back DATA segment
	POP	AX				;  and his AX

	DB	0EAH				; Far jump to original
						;  interrupt handler
CLKVEC	DW	0				; Place for Interrupt Offset
CLKSEG	DW	0				;  and Segment

;	KEY_ENTRY is the keyboard interrupt processor.	Upon entry we
;	zero the counter to force the timer interrupt routine to start
;	counting from the beginning.  If the screen was off, we also
;       restore the user's old video port value.

KEY_ENTRY LABEL NEAR

        PUSH    AX                              ; Save user's AX
	PUSH	DS				;  and DS
	MOV	AX,CS
	MOV	DS,AX

	MOV	WORD PTR COUNTER,0		; Zero count
	CMP	BYTE PTR SCREEN,ON		; Was the screen on?
	JE	KEY_EXIT			;  yes, no action needed

	MOV	BYTE PTR SCREEN,ON		; Flag screen on

      IF Z100
	MOV	AL,BYTE PTR VIDEO		; Get his video setting
	OUT	ZVIDEO,AL			;  and restore the screen
      ENDIF

      IF Z150
	PUSH	ES				; Save ES
	PUSH	DX				;  and DX
	MOV	AX,040H 			; Point to BIOS
	MOV	ES,AX
	MOV	DX,WORD PTR ES:CRTBASE		; Get CRT address
	ADD	DX,4				;  adjust to point to mode
	MOV	AL,BYTE PTR ES:MODE		; Get current mode
	OR	AL,00001000B			;  enable video
	OUT	DX,AL				;  and send it
	MOV	BYTE PTR ES:MODE,AL
	MOV	AL,1
	ADD	DX,2				; Point to control port
	OUT	DX,AL				;  and clear IBM mode
	POP	DX				; Restore his registers
	POP	ES
      ENDIF

	POP	DS				; Restore his registers
	POP	AX

    IF Z150
      IF EATBYTE
	PUSH	AX
	IN	AL,KBD_DATA			; Read the key
	IN	AL,KBD_CNTL			; Get keyboard control bits
	MOV	AH,AL
	OR	AL,080H 			; Reset bit
	OUT	KBD_CNTL,AL
	XCHG	AH,AL
	OUT	KBD_CNTL,AL

	CLI
	MOV	AL,020H
	OUT	020H,AL

	POP	AX

	IRET
      ENDIF
    ENDIF

    IF Z100
      IF EATBYTE
	MOV	AH,0FFH 			;  and tell DOS we used the
      ENDIF
    ENDIF

	JMP	KEY_EXIT1			;  keystroke

KEY_EXIT LABEL NEAR

	POP	DS				; Get back DS
	POP	AX				; and AX

KEY_EXIT1 LABEL NEAR

	DB	0EAH				; Far jump to original
						;  interrupt handler
KEYVEC	DW	?				; Place for Interrupt Offset
KEYSEG	DW	?				;  and Segment


;	CRT_ENTRY is the crt interrupt processor.  Upon entry we
;	zero the counter to force the timer interrupt routine to start
;	counting from the beginning.  If the screen was off, we also
;       restore the user's old video port value.

CRT_ENTRY LABEL NEAR

        PUSH    AX                              ; Save user's AX
	PUSH	DS				;  and DS
	MOV	AX,CS
	MOV	DS,AX

	MOV	WORD PTR COUNTER,0		; Zero count
	CMP	BYTE PTR SCREEN,ON		; Was the screen on?
	JE	CRT_EXIT			;  yes, no action needed

	MOV	BYTE PTR SCREEN,ON		; Flag screen on

	IF Z100
	MOV	AL,BYTE PTR VIDEO		; Get his video setting
	OUT	ZVIDEO,AL			;  and restore the screen
	ENDIF

	IF Z150
	PUSH	ES				; Save ES
	PUSH	DX				;  and DX
	MOV	AX,040H 			; Point to BIOS
	MOV	ES,AX
	MOV	DX,WORD PTR ES:CRTBASE		; Get pointer
	ADD	DX,4				;  adjust for mode pointer
	MOV	AL,BYTE PTR ES:MODE		; Get current mode
	OR	AL,00001000B			;  enable video
	OUT	DX,AL				;  and send it
	MOV	BYTE PTR ES:MODE,AL
	ADD	DX,2				; Point at control port
	MOV	AL,1				;  and restore non-IBM mode
	OUT	DX,AL
	POP	DX
	POP	ES
	ENDIF

CRT_EXIT LABEL NEAR

	POP	DS				; Get back DS
	POP	AX				; and AX

	DB	0EAH				; Far jump to original
						;  interrupt handler
CRTVEC	DW	?				; Place for Interrupt Offset
CRTSEG	DW	?				;  and Segment

;	Data storage area

VIDEO	DB	?				; Video port data save
SCREEN	DB	ON				; Screen ON/OFF flag
COUNTER DW	0				; Interval counter
	IF DEBUG
CNTTEST DW	0
	ENDIF

	IF Z100
MAX_CNT DW	TIME*60*100			; Maximum count value
	ENDIF
	IF Z150 AND (NOT DEBUG)
MAX_CNT DW	TIME*1092
	ENDIF

	IF Z150 AND DEBUG
MAX_CNT DW	500
	ENDIF


ENDRES LABEL NEAR				; End of the resident code

;	The following is present only during initialization

START1	LABEL	NEAR

	MOV	AX,CS				; Set segment registers
	MOV	DS,AX
	MOV	ES,AX
	PUSH	ES

;	Start by getting the old interrupt service routine address

	MOV	AX,0				; Make ES point to interrupt
	MOV	ES,AX				;  segment in low memory
	IF Z100
	MOV	BX,INT_UTMA*4			; BX points to timer interrupt
	ENDIF
	IF Z150
	MOV	BX,INT_TMA*4
	ENDIF
	LES	BX,DWORD PTR ES:[BX]		; ES:BX dword pointer to old
						;  interrupt service routine
	MOV	WORD PTR CLKSEG,ES		; Save the old Segment
	MOV	WORD PTR CLKVEC,BX		;  and Offset for my jump

;	Now check and see if I was already loaded

	MOV	SI,OFFSET TEST			; DS:SI = Test in this seg
	MOV	DI,OFFSET TEST			; ES:DI = Test in int. seg
	MOV	CX,TESTL			; CX = length of test string
	CLD					; Clear direction flag
	REPE	CMPSB				; Check for equality
	MOV	BYTE PTR LOADED,TRUE		; Assume loaded
	JE	START2				;  skip next part if true
	MOV	BYTE PTR LOADED,FALSE		;  else flag not loaded

;	Then set up my service routine in its place

	MOV	DX,OFFSET CLK_ENTRY		; Set DS:DX = clock entry
	MOV	AH,025H 			; Now set up my entry

	IF Z100
	MOV	AL,INT_UTMA			;  in the timer int. slot
	ENDIF
	IF Z150
	MOV	AL,INT_TMA
	ENDIF

	INT	021H

;	Now do the same thing for the keyboard interrupt

	MOV	AX,0				; Point to interrupt segment
	MOV	ES,AX				;  with ES
	IF Z100
	MOV	BX,INT_UKBA*4			; BX points to keyboard int
	ENDIF
	IF Z150
	MOV	BX,INT_KBD*4
	ENDIF
	LES	BX,DWORD PTR ES:[BX]		; ES:BX old key int address
	MOV	WORD PTR KEYSEG,ES		; Save these addresses also
	MOV	WORD PTR KEYVEC,BX

;	And set up my key handler entry

	MOV	DX,OFFSET KEY_ENTRY		; DS:DX points to my key entry
	MOV	AH,025H 			;  set interrupt vector
	IF Z100
	MOV	AL,INT_UKBA			;  to my routine
	ENDIF
	IF Z150
	MOV	AL,INT_KBD
	ENDIF
	INT	021H

;	Next set up the CRT handler

    IF MONVID
	MOV	AX,0				; Point to interrupt segment
	MOV	ES,AX				;  with ES
      IF Z100
	MOV	BX,INT_UCRTA*4			; BX points to CRT int
      ENDIF
      IF Z150
	MOV	BX,INT_VID*4
      ENDIF
	LES	BX,DWORD PTR ES:[BX]		; ES:BX old CRT int address
	MOV	WORD PTR CRTSEG,ES		; Save these addresses also
	MOV	WORD PTR CRTVEC,BX

;	And set up my CRT handler entry

	MOV	DX,OFFSET CRT_ENTRY		; DS:DX points to my CRT entry
	MOV	AH,025H 			;  set interrupt vector
      IF Z100
	MOV	AL,INT_UCRTA			;  to my routine
      ENDIF
      IF Z150
	MOV	AL,INT_VID
      ENDIF
	INT	021H
    ENDIF

	JMP	START3

;	Come to START2 if already loaded, else jump around

START2	LABEL NEAR

	MOV	AX,ES				; Make loaded data area into
	MOV	DS,AX				;  my data seg

START3	LABEL NEAR

;	Now set some default values

	MOV	BYTE PTR SCREEN,ON		; Flag the screen on
	MOV	WORD PTR COUNTER,0		; Start the counter at zero
	IF Z100
	MOV	WORD PTR MAX_CNT,TIME*60*100	;  with the default time-out
	IN	AL,ZVIDEO			; Get the current video value
	MOV	BYTE PTR VIDEO,AL		;  and save it.
	ENDIF
	IF Z150
	MOV	WORD PTR MAX_CNT,TIME*1092
	ENDIF

;	And check for a passed argument

	MOV	AX,TIME 			; Get default timeout
	AAM					;  adjust value
	CMP	AH,0
	JE	START3A
        ADD     AH,'0'                          ; Make tens digit ASCII

START3A LABEL NEAR

	MOV	BYTE PTR CS:TMSG,AH		;  and save for message
        ADD     AL,'0'                          ;  do the same for ones digit
	MOV	BYTE PTR CS:TMSG+1,AL

	POP	ES				; Get back extra seg
	CMP	BYTE PTR CS:[0080H],0		; Was an argument present?
	JE	EXIT				;  no, just exit
	MOV	CL,BYTE PTR CS:[0080H]		;  else get character count
	XOR	CH,CH				;  into CX
	MOV	DI,0081H			; Point ES:DI to string
        MOV     AL,'/'                          ; Look for switch character
	CLD					;  clear direction flag
	REPNE	SCASB				;  perform the search
	MOV	CS:BYTE PTR PARMERR,TRUE	;  assume parameter error
	JNE	EXIT				;  no switch character found

START4 LABEL NEAR

	XOR	AH,AH
	MOV	AL,ES:[DI]			; Get the character
        SUB     AL,'0'                          ;  and make binary
	JC	EXIT				;  too low
	CMP	AL,10				;
	JNC	EXIT				;  too high
	DEC	CX				; Second digit?
	JZ	START5				;  no
	MOV	AH,AL				; Yes, save first digit
	INC	DI				;  and point to second
	MOV	AL,ES:[DI]
        SUB     AL,'0'                          ;  make binary
	JC	EXIT				;  not a digit
	CMP	AL,10
	JNC	EXIT				; Too high
	AAD					; AL = AH*10 + AL
	CMP	AL,11
        JNC     EXIT                            ; Can't be more than 10 min.

START5 LABEL NEAR

	MOV	CS:BYTE PTR DISABLE,TRUE
	CMP	AL,0
	JE	START6
	MOV	CS:BYTE PTR DISABLE,FALSE

START6 LABEL NEAR

	PUSH	AX
	AAM
	CMP	AH,0
	JE	START6A
        ADD     AH,'0'

START6A LABEL NEAR

        ADD     AL,'0'
	MOV	BYTE PTR CS:TMSG,AH
	MOV	BYTE PTR CS:TMSG+1,AL
	POP	AX

	MOV	CS:BYTE PTR PARMERR,FALSE	; Got a good parameter
	IF Z100
	MOV	CX,100*60
	ENDIF
	IF Z150
	MOV	CX,1092
	ENDIF
	MUL	CX				; Convert AX to timer counts

	CMP	CS:BYTE PTR LOADED,TRUE
	JNE	START7

	MOV	WORD PTR MAX_CNT,AX
	JMP	EXIT

START7 LABEL NEAR

	MOV	ES:WORD PTR MAX_CNT,AX

EXIT LABEL NEAR

	MOV	AX,CS
	MOV	DS,AX
	MOV	DX,OFFSET MSG1
	CMP	BYTE PTR LOADED,TRUE
	JE	EXITA
	MOV	AH,9
	INT	021H

EXITA LABEL NEAR

	MOV	DX,OFFSET MSG2
	CMP	BYTE PTR DISABLE,TRUE
	JNE	EXIT1
	MOV	DX,OFFSET MSG4

EXIT1 LABEL NEAR

	MOV	AH,9				; Print message
	INT	21H

	MOV	DX,OFFSET MSG3
	CMP	BYTE PTR PARMERR,TRUE
	JNE	EXIT3

EXIT2 LABEL NEAR

	MOV	AH,9
	INT	21H

EXIT3 LABEL NEAR

	CMP	BYTE PTR LOADED,TRUE
	JE	EXIT4

	MOV	DX,OFFSET ENDRES		; Point to end of resident code
	ADD	DX,0100H
	INT	027H				;  terminate and stay resident

EXIT4 LABEL NEAR

	INT	020H				; Already loaded, just quit

DISABLE DB	?
LOADED	DB	?
PARMERR DB	FALSE
MSG1    DB      0AH,0DH,09H,'Screen Saver version 1.4 activated',0AH,0DH
        DB      09H,'Copyright (c) 1984 by MicroMagic',0AH,0DH,'$'
MSG2    DB      0AH,0DH,09H,'Screen saver timeout set to '
TMSG    DB      0,0,' minutes',0AH,0DH,'$'
MSG3    DB      0AH,0DH,09H,07H,'Illegal parameter - ignored'
        DB      0AH,0DH,09H,'Default value used.',0AH,0DH
        DB      0AH,0DH,09H,'Usage: SCRNSAVE/n'
        DB      0AH,0DH,09H,'       n = The time in minutes (0 to 10) before'
        DB      0AH,0DH,09H,'       the screen is blanked.  Use 0 to turn the'
        DB      0AH,0DH,09H,'       screen saver off.',0AH,0DH,'$'
MSG4    DB      0AH,0DH,09H,'Screen saver deactivated',0AH,0DH,'$'

CODE	ENDS
	END	START
