/***************************************************************

	SE.H		General Header for Simple EDIT

			Copyright (c) 1988, Ted A. Campbell

			The first few lines of this file include 
			user-customizable features.  

			The macro UINCLUDE 
			should be defined if your C compiler 
			utilizes Unix-compatible include files, 
			such as 'ctype.h' for character-type 
			functions.  This should be defined for the
			AT&T UNIX C compiler and for the Microsoft 
			Quick C (tm) compiler.  

			The macro USECR should be defined if text
			files in your system are saved utilizing 
			a CR-LF combination and with a ^Z terminating
			the file.  This should be defined for CP/M (tm)
			and MSDOS (tm) systems, but not for UNIX (tm).

***************************************************************/

#define VERSION        "1.01"

#define UINCLUDE       /* Use Unix-style include files */
#define USECR          /* Use Carriage-Return after Line Feed */
#define FAST_VIDEO     /* Use Fast Video, not CURSES routines */

#ifdef  FAST_VIDEO
#define initscr()       fv_init()
#define endwin()        fv_deinit()
#define move            fv_adr
#define refresh()
#define standend()
#define standout()
#define clear()         fv_cls()
#endif

/**********************************************************************

	Definitions specific to Simple EDIT

**********************************************************************/

#define SS_NOMINAL      0               /* Nominal (OK) return       */
#define SS_ERROR        -1              /* Error return              */
#define SE_EXIT         -2              /* Exit from program         */

#ifndef LF
#define LF              0x0a            /* Define ASCII characters   */
#define CR              0x0d
#endif

#define TAB             0x09
#define DEL_BACK        0x08

#define LINESIZE        128             /* Maximum size of a line    */
#define LINEOFFSET      4               /* Offset to first line      */
#define COLOFFSET       0               /* Offset to first column    */
#define TAB_INTERVAL    8               /* Interval for tab settings */

#define SE_NORMAL       0               /* Normal video attribute    */
#define SE_SPECIAL      1               /* Special video attribute   */

/**********************************************************************

	Declarations of External variables

**********************************************************************/

extern int se_trct;

extern unsigned char se_lines;                /* Lines in window            */
extern unsigned char se_cols;                 /* Columns in window          */
extern unsigned char se_lpos;                 /* Line position of the
					   current character         */
extern unsigned int se_alc;                   /* Absolute line count        */

extern int se_bpos;                          /* Position in edit buffer of
						the current character     */
extern char se_tbuf[ LINESIZE ];             /* Temporary (scratch) buffer  */

extern unsigned se_imode;                     /* Insert mode:  0 = over-write
					   mode; 1 = insert mode; toggled
					   while editing by ^V       */
extern unsigned char se_file[ 40 ];

struct se_line
		{
		struct se_line *prev;
		struct se_line *next;
		unsigned char characters[ LINESIZE ];
		} ;

extern struct se_line *se_current, *se_btop, *se_bbot;

extern struct se_line *se_traverse();
extern struct se_line *se_top();


