;=============================================================================
; TOGGLE.COM for the IBM Personal Computer - 1988 by Jeff Prosise
;
; TOGGLE allows the CapsLock, NumLock, and ScrollLock states to be
; toggled on and off in batch mode.  Syntax is:
;
;	TOGGLE [+c|-c] [+n|-n] [+s|-s]
;
; where the 'c' parameter controls the CapsLock state, 'n' controls
; NumLock, and 's' controls ScrollLock.
;=============================================================================

BIOS_DATA	SEGMENT	AT 40H
		ORG	17H
SHIFT_STATE	DB	?			;Bit 4 = ScrollLock
						;Bit 5 = NumLock
						;Bit 6 = CapsLock
BIOS_DATA	ENDS

;=============================================================================
; Code Segment (code and data)
;=============================================================================
CODE		SEGMENT PARA PUBLIC 'CODE'
		ASSUME	CS:CODE, DS:CODE
		ORG	100H
BEGIN:		JMP	MAIN

CR		EQU	13
LF		EQU	10

PROGRAM		DB	"TOGGLE 1.0 (c) 1988 Ziff Communications Co.",CR,LF
		DB	"PC Magazine ",254," Jeff Prosise",CR,LF,"$",1AH

ERRMSG		DB	CR,LF,"Usage:  TOGGLE [+c|-c] [+n|-n] [+s|-s]"
		DB	CR,LF,"$"

TEXT1		DB	CR,LF
                DB	"    CapsLock   :  $"
TEXT2		DB	"    NumLock    :  $"
TEXT3		DB	"    ScrollLock :  $"
ONTEXT		DB	"On",CR,LF,"$"
OFFTEXT		DB	"Off",CR,LF,"$"

;-----------------------------------------------------------------------------
; MAIN is the primary portion of the code.
;-----------------------------------------------------------------------------
MAIN		PROC	NEAR

		MOV	AX,BIOS_DATA		;point ES to BIOS Data Area
		MOV	ES,AX
		ASSUME	ES:BIOS_DATA
		CLD				;clear DF
		MOV	SI,81H			;point SI to command line
;
;Search the command line for entries, and loop until all are processed.
;
MAINLOOP:	LODSB				;search for next non-space
		CMP	AL,20H
		JE	MAINLOOP

		CMP	AL,0DH			;branch if end-of-line reached
		JE	END_PARSE
		CMP	AL,"+"			;branch if plus operator is
		JE	PROCESS			;  encountered
		CMP	AL,"-"			;branch if minus operator is
		JE	PROCESS			;  encountered
;
;An unrecognized entry was found.  Print correct syntax and exit.
;
ERROR_EXIT:	MOV	AH,9			;display correct syntax
		MOV	DX,OFFSET ERRMSG
		INT	21H
		MOV	AX,4C01H		;exit with ERRORLEVEL = 1
		INT	21H
;
;Check current parameter against list of valid ones.
;
PROCESS:	LODSB				;get parameter byte
		AND	AL,0DFH			;capitalize it
		MOV	AH,10H			;branch if parameter is an "S"
		CMP	AL,"S"
		JE	TOGGLE_STATE_BIT
		MOV	AH,20H			;branch on "N"
		CMP	AL,"N"
		JE	TOGGLE_STATE_BIT
		MOV	AH,40H			;branch on "C"
		CMP	AL,"C"
		JNE	ERROR_EXIT
;
;Turn the indicated state bit on or off.
;
TOGGLE_STATE_BIT:
		CMP	BYTE PTR [SI-2],"+"	;branch if operator was a
		JNE	CLEAR_BIT		;  minus symbol
		OR	SHIFT_STATE,AH		;turn indicated state on
		JMP	MAINLOOP		;reenter parsing loop

CLEAR_BIT:	NOT	AH			;complement bit indicator
		AND	SHIFT_STATE,AH		;turn indicated state off
		JMP	MAINLOOP		;reenter parsing loop
;
;Display current status of all three lock states and exit.
;
END_PARSE:	MOV	AH,9			;display copyright notice
		MOV	DX,OFFSET  PROGRAM
		INT	21H

		MOV	AH,9			;display CapsLock state
		MOV	DX,OFFSET TEXT1
		INT	21H
		MOV	AH,40H
		CALL	PRINT_STATE

		MOV	AH,9			;display NumLock state
		MOV	DX,OFFSET TEXT2
		INT	21H
		MOV	AH,20H
		CALL	PRINT_STATE

		MOV	AH,9			;display ScrollLock state
		MOV	DX,OFFSET TEXT3
		INT	21H
		MOV	AH,10H
		CALL	PRINT_STATE

		MOV	AX,4C00H		;exit with ERRORLEVEL = 0
		INT	21H
MAIN		ENDP

;-----------------------------------------------------------------------------
; PRINT_STATE is called by MAIN to display "On" or "Off" to a 1 or 0 value,
; respectively, of the bit in the BIOS shift state byte indicated in AH.
;-----------------------------------------------------------------------------
PRINT_STATE	PROC	NEAR
		MOV	DX,OFFSET OFFTEXT	;preload "Off" text address 
		TEST	SHIFT_STATE,AH		;test actual state
		JZ	IS_OFF			;branch if assumption valid
		MOV	DX,OFFSET ONTEXT	;load "On" text address
IS_OFF:		MOV	AH,9			;display "On" or "Off"
		INT	21H
		RET
PRINT_STATE	ENDP

CODE		ENDS
		END BEGIN
