PAGE	84,132
TITLE	CrLfRM - remove crlf from end of file
SUBTTL	PL Glatz        version 1.00  6/29/86

COMMENT *

	This utility is a filter to remove the last crlf from text.  If
	last 2 characters are crlf, the file will be considered completed
	at 2 bytes preceeding them.  EOF marks are stripped from end of
	file if last 2 chars removed.

*


DosInt		EQU	21H		;DOS function call entry
StackDepth 	EQU	256		;depth of stack, in words
StdIn		EQU	0		;stdin stream
StdOut		EQU	1		;stdout stream
BufLen		EQU	4096		;length of read buffer
LastBufLen	EQU	256		;length of last line buffer
false		EQU	0
true		EQU	NOT FALSE
EofMark		EQU	1AH		;file end-of-file mark
Lf		EQU	0AH		;line feed
Cr		EQU	0DH		;carriage return

; DOS function calls:
CreateFile	EQU	3CH		;create new file
OpenFile	EQU	3DH		;create new file
CloseFile	EQU	3EH		;close file stream
ReadBlock	EQU	3FH		;read string from device
WriteBlock	EQU	40H		;write string to device
Terminate	EQU	4CH		;terminate program


; macro to perform function call
DosCall	MACRO	service
	MOV	AH,service
	INT	DosInt
	ENDM

; macro to switch ES:DI with DS:SI
SwitchPtrs MACRO
	PUSH	DS
	PUSH	ES
	POP	DS
	POP	ES
	XCHG	SI,DI
	ENDM


;	============ Code segment ==============

code	SEGMENT PARA PUBLIC
	ASSUME  CS:code, DS:data, ES:data


CrLfRM	PROC    FAR          		;start of main procedure block
	MOV     AX,data
	MOV     ES,AX        		;set up ES & DS to data segment
	MOV	DS,AX
	MOV	BYTE PTR InactiveFull,false

ReadNextBuf:
	MOV	CX,BufLen
	MOV	DX,ActiveBuffer
	CALL	ReadNextBlock		;try to read a buffer full
	JE	CheckLast		;ZR=end of file

	CMP	BYTE PTR InactiveFull,true
	JNE	InactiveNotFull
	PUSH	AX			;save read size
	PUSH	CX
	MOV	CX,BufLen
	MOV	DX,InactiveBuffer	;last read was full buffer -
	CALL	WriteNextBlock		;write inactive buffer to file
	MOV	BYTE PTR InactiveFull,false
	POP	CX
	POP	AX

InactiveNotFull:
	CMP	AX,CX			;was last read full buffer?
	JNE	CheckLast
	CALL	SwapBuffers		;active <- inactive
	MOV	BYTE PTR InactiveFull,true
	JMP	ReadNextBuf
		
; file read, active buffer contains last data read, AX=size
CheckLast:
	MOV	CX,AX			;CX=bytes in buffer
	MOV	SI,ActiveBuffer
	ADD	SI,CX
	DEC	SI			;SI -> last byte in buffer

	;remove EOF marks from end of buffer
RmvEof:
	CMP	BYTE PTR DS:[SI],EofMark
	JNE	PastEof
	DEC	SI
	LOOP	RmvEof

PastEof:
	CMP	CX,2			;done if cx<2
	JL	Done
	CMP	WORD PTR DS:[SI-1],0A0DH
	JNE	Done			;if crlf at end,
	DEC	CX			;don't write 'em
	DEC	CX
Done:
	OR	CX,CX			;write to output stream if
	JE	Finish			;anything left
	MOV	DX,ActiveBuffer
	CALL	WriteNextBlock

Finish:
	XOR	AL,AL			;errorlevel=0
	DosCall	Terminate		;exit back to DOS
CrLfRM ENDP


; Read block from input stream, return count in CX
;	ENTRY:	DS:DX -> read buffer
;		CX=buffer size
;	EXIT:
;		AX=bytes read
;		ZR set if EOF

ReadNextBlock	PROC	NEAR
	MOV	BX,StdIn
	DosCall	ReadBlock
	OR	CX,CX			;set ZR
	RET
ReadNextBlock	ENDP


; Write CX bytes to output stream
;	ENTRY:	DS:DX -> read buffer
;		CX=bytes to write

WriteNextBlock	PROC	NEAR
	MOV	BX,StdOut
	DosCall	WriteBlock
	RET
WriteNextBlock	ENDP


; Swap buffer pointers
SwapBuffers PROC	NEAR
	MOV	AX, ActiveBuffer
	XCHG	AX, InactiveBuffer
	MOV	ActiveBuffer, AX
	RET
SwapBuffers ENDP

code     ENDS

PAGE

; 	========== Stack segment ================

stack   SEGMENT PARA stack

	DW      StackDepth DUP('Ss')	;stack area

stkptr	LABEL	BYTE			;where to set SP

stack   ENDS



; 	========== Data segment =================

data    SEGMENT PARA public

Buffer1	DB BufLen DUP ('1')		;file read buffer # 1
Buffer2 DB BufLen DUP ('2')		;file read buffer # 2

ActiveBuffer	DW	OFFSET data:Buffer1	; buffer pointers
InactiveBuffer	DW	OFFSET data:buffer2

InactiveFull	DB	?		; true if inactive buffer full
data     ENDS


         END   CrLfRM        ;specify starting address in END statement
