

begin :-
	print( 'What is the name of the input file? : '),
	ratom( File ),
	open( File, r ),
	print( 'How many iterations? : '),
	rnum( N ),
	docalc( N, File ),
	close( File ).
	
docalc( N, File ) :- N > 0, 
	M is N - 1,  
	calculate( File ),
	docalc( M, File ).

docalc( 0, _ ).

calculate( Source ) :-

/* Read in 2 elements: */
	readlist_n( Parset, Source, 2 ),
	listval( Parset, 0, 1 ),

/* Typical formats: '3.5g', '5.7e', etc. */
	open( mathout, wr ),
	wrlist( Parset, mathout ),
	close( mathout ),
	exec( calc ), 
/* Read mathinps from file test5 wrote: */
	open( mathinp, r ),
	readlist( Num_list, mathinp ),
        close( mathinp ),
/* Display results: */
        print('\nAnd now, the results: '),
	prt_numlist( Num_list ).

/* Numlist will be of the form: Numlist = [ 12345, 5678 ]. */


readlist( [H|T], File ) :- rnum( H, File), readlist( T, File ).
readlist( [], _ ).

readlist_n( [H|T], File,N ) :- 
	N > 0, M is N - 1,
	rnum( H, File), 
	readlist_n( T, File, M ).

readlist_n( [], _, 0 ).

doinp(X) :- open( mathinp, r ), 
	readlist( X, mathinp ),
	close( mathinp ).

 
query( X, Argnum ) :-
	print('\nWhat is the', Argnum, 'argument:\n\t' ),
	rnum( X ).

listval( [H|T], Lower, Upper ) :-
	H > Lower,
	H < Upper,
	listval( T, Lower, Upper ).
listval( [], _, _ ).


valid( X ) :- X < 1, X > 0.


prt_numlist( [] ).
prt_numlist( [H|T] ) :- 
	wrnum( user, H, '5.5f' ), 
	print( ' , ' ),
	prt_numlist( T ).


wrlist( [H|T], Stream ) :-
	wrnum( Stream, H, '3.3f' ), nlf( Stream ),
	wrlist( T, Stream ).

wrlist( [], _ ).

