/* Converts an ASCII string with hexadecimal digits into an unsigned int */

/* Copyright 1986 John Navas II, All Rights Reserved.
XTOU is made available for personal, non-commercial use only.  You
are granted a limited license to use XTOU, and to copy it and
distribute it, provided that no fee is charged for such copying and
distribution, and that it is ONLY distributed in its original,
unmodified state. */

/* Language: Microsoft C Version 3.00 */

#include <ctype.h>

unsigned int xtou( s )					/* CONVERT ASCII HEX INTO UNSIGNED */
char *s;
{
	register unsigned int u = 0;
	register char c;

	for ( ; c = *s; ++s ) {
		if ( isdigit( c ) ) {
			u <<= 4;
			u += (unsigned int) ( c - '0' );
			}
		else if ( ( c = tolower( c ) ) >= 'a' && c <= 'f' ) {
			u <<= 4;
			u += (unsigned int) ( c - 'a' + 10 );
			}
		else break;
		}

	return u;
	}
