/******************************************************************************
 * 	This is the main METAL/Z-MSG module
 *
 *	Name: METAL.C or Z-MSG.C
 *
 *			Copyright (c) 1984,1985 Tim Gary
 *			     All rights reserved.
 *
 *	This is a commercial product, and is for use by a single system
 *	and user.  Copies may be made for backup purposes ONLY.
 *
 ******************************************************************************
 *
 * 1.31a  10/13/85 Release version.  Includes following changes:
 *		    Now able to load ZCPR3 system Segs based on user type.
 *		    Other ZCPR3 init stuff added.
 *		    Custom init routine called (MEINIT).
 *		    Command table moved to MECMDS.H
 *		    Overlay to overlay calling supported (one level..),
 *		     calling overlay will be returned to when other done.
 * 1.30xx 7/01/85  Print and echo flags saved/restored now..
 * 1.30xx 6/19/85  G_restore, etc done here to avoid ANY memory conflicts..
 * 1.30xx 6/15/85  Apply/Comments pass diff. 'func' vals, time expired fixed.
 * 1.30xx 6/09/85  Moved memory allocation settop routine here.  Etc..
 * 1.30xx 5/26/85  Make sure non expert mode set for welcome message, etc..
 * 1.30xx 5/25/85  Modified to find highest location for msg allocation, so
 *		  extra memory won't be needed for an alias (for msg).
 * 1.30xx 5/02/85  Turned Z3BUG off, Z3MSG_OFFSET define added.
 * 1.30xx 5/01/85  Fixed for renaming of MESUMM TO MESTUFF.
 * 1.30xx 4/28/85  Slight Z3 debug stuff added..
 * 1.30xx 4/26/85  Fix for saving z3 command line..
 * 1.30xx 3/13/85  Fix for return from OS...
 * 1.30xx 3/07/85  BBSNAME stuff added..
 * 1.30xx 3/03/85  Continued with z3setup..
 * 1.30xx 2/20/85  Start changes for Z3 multi command lines, etc..
 * 1.20b 01/18/85  Showtime seperated to overlay..
 * 1.20b 01/14/85  Prompt shows time on system so far.
 * 1.20b 01/11/85  More clock support added at prompts, etc..
 * 1.20b 01/05/85  Bug fixes, add fast change to sysop stat from CP/M.
 * 1.20a 11/04/84  Alias to apply command is COMMENT.
 * 1.10e 11/03/84  Added APPLY command.
 * 1.10e 10/31/84  Functions moved out of this routine, overlays functions
 *		  added, new UNKILL command (also RESTORE=same thing).
 * 1.10c 10/12/84  Some routines moved to MEMISC overlay to conserve space.
 *
 * 1.10b 10/04/84  Chat fixed for xx columns, auto return..
 * 1.10b 10/01/84  Spelling error fixed.  Other cosmetics.
 *
 * 1.10a  9/27/84  More cosmetic changes.
 * 1.10a  9/08/84  Chat routines expanded to include user name, and if
 *		  sysop is not around, ask if they would like to leave
 *		  private comments to the sysop.
 * 1.10a  9/01/84  Continued work on overlays.
 * 1.10a  8/24/84  JUST STARTING OVERLAY VERSION.
 *
 * 1.01a  7/02/84  Multi-user lastcalr implemented.
 * 1.01a  6/27/84  Multi user OS support cont..  
 * 1.01a  6/10/84  Fixes for Aztec C 1.06.  Added Link to mutil command,
 *		  also started provisions for Multi-user OS's..
 *
 * 1.0b   4/22/84  Problem with mult commands fixed (introduced 9 days ago)
 * 1.0b   4/20/84  Fixed 'U' bug (command changed user.lastread..)
 * 1.0b   4/13/84  Added upper/lower case name ability.  3 User defined
 *		   files may be displayed.  '!' command now restores original
 *		   user status when turning off sysop status.  'Articles'
 *		   command added to allow printing of various text files.
 *
 * 1.0a	  2/15/84  Lastcalr file changed, benefit: pretty xmodem log, and
 *		   user parameters 'stick' when the user changes them and exits
 *		   to CP/M, and then returns.  NOCPM fix.
 *
 *****************************************************************************/

/* #define Z3BUG   */ /* for duration of debugging Z3 stuff in this file */

#include "xpm.h"	/* CPMIO header file for i/o operations.*/
#include "megen.h"	/* general defines		*/
#include "meglob.h"	/* global variable definitions	*/
#include "meovfn.h"	/* overlay function numbers	*/
#include "mefiles.h"	/* file names			*/

#include "ctype.h"

extern struct cmdtype maincomtab[];	/* declared seperately like O */
char sotries=0;		/* tries attempted with '!' command */

/**********************************************************************/

/**************************
 * start the main program *
 **************************/

main(argc,argv)
 int argc;
 char *argv[];
{
char temp[40];

/* do initial stuff in another area...  Must be the VERY FIRST thing here */

init(argc,argv);


/***************************
 * main command input loop *
 ***************************/

while(1)				/* one giant endless loop.. */
	{
	*temp='\0';
	if (user.parm.expert!=PON) strcat(temp,"(Enter '?' for help)  ");
	if (user.status==SYSOP) strcat(temp,"Sysop: ");
	  else strcat(temp,"Command: ");

	if (get_cmd(temp,maincomtab)==ERROR)	/* ERROR=bad command */
		{
		send("\nI didn't follow that, try '?' for help!");
		strloc=0;	/* sorry, but one error aborts rest.. */
		}	/* error in command */
	}	/* main while loop */

}	/* MAIN loop */ 	 	


/*********************************************
 * Init stuff.. Sets top of program pointer
 * for overlays.  Checks to see if init
 * overaly is to be loaded.  Does g_restore if
 * return from zcpr command...
 *********************************************/

init(argc,argv)
 int argc;
 char *argv[];
{
char **m_buff;
int envok_flag=YES;

settop(OVRSPACE);	/* alloc space for overlays */
ov_init(MAINOVRS);	/* open overlay file */

/* if z3 stuff, make sure there's room for protection code here */
if (O.ZCPR==3) z3_hp=settop(sizeof(struct g_prot)+10);

msg=settop((O.MAXTOTMSGS*8)+16);	/* space for the message array */

user.parm.expert=POFF;	/* make sure user is novice class */
findbye();	/* get bye addresses.. */

#ifdef Z3
/* setup z3 pointer if being used */

if (O.ZCPR==3)
	{
	z3env=0x100;	/* point to initial 'internal' descriptor */
	if (z3env->class==1) z3env=z3env->expath; /* if ext., point there */
	if (z3env==0 || z3env->msg==0)
		{	/* appearently z3 not really installed.. */
		O.ZCPR=0;
		envok_flag=NO;	/* flag not ok, for later.. */		
		}
	  else
		{
		*(z3env->wheel)=0;	/* no wheel */
		m_buff=(z3env->msg)+O.Z3MSG;

#ifdef Z3BUG
		printf("\nZ3 is being used, and z3env is located at %xh.\n",
			(unsigned)z3env);
		printf("\nZ3 message buffer (@ %xh) has a value of %xh.\n",
			(unsigned)m_buff,(unsigned)*m_buff);
#endif

		if (*m_buff!=(char *)0 && argc>1)
			{
			argc=-1;		/* MUST do this to flag silent stuff */
			g_restore(*m_buff);
#ifdef Z3BUG
			printf("\nBack from g_restore.  User name=%s %s.\n",
				user.first,user.last);
#endif
			*m_buff=(char *)0;	/* clear this */
			}
		} /* env ok flag.. */
	}
	else	/* falls through */
#endif	/* Z3 */
	  if (O.ZCPR) *O.SECURELOC=0;	/* make sure system is safe */

if (argc>1) argc=ovloader(OVMENTER,argc,argv);

*maxuser=O.user_types[user.type].maxuser;	/* fix this */

if (!envok_flag)
	{
	if (user.status==SYSOP)
		send("\n\n***  ERROR: Z3 Environment is Invalid.\
\nUse Z3INS to install!!  ***\n\n");
	 else   {
		user.status=NOCPM;	/* sorry folks */
		user.type=get_type(user.status);
		send("\nNOTE: Operating System access has\
\ntemporarily been suspended for all users.\n");
		}
	}

if (argc==1)
	{
	ovloader(OVINFREQ,INIT,argc);	/* initialize the works.. */

/* if auto read option ON, then do this.. */
	if (user.parm.rp==POFF)
		{
		send("[Auto Read]\n");
		ovloader(OVREAD,0,'P');	/* do a RP */
		}
	}

new_page();	/* reset line count */

} /* init */


/* Custom user init code caller.. passes if bye present, user struct and
   user status table address..	*/

cust_init()
{
int (*initloc)()=0x390;		/* location of actual code */
char *bye_flag=0x385;		/* flag if bye there.. */
usr **up=0x386;			/* pointer to pointer to user struct */
u_types **usp=0x388;		/* pointer to pointer to user status stuff */

if ( ! (*(bye_flag-1)) ) return;	/* not installed, ignore */

if (bye) *bye_flag=0xff;
*up=&user;
*usp=&O.user_types[user.type];

(*initloc)();		/* call routine */
}


/* Restore global variables */

#ifdef Z3

g_restore(glob_loc)
 char *glob_loc;
{
struct g_prot *gh_p;	/* header pointer */
struct g_save *gp;	/* global variables pointer */
int size;

gh_p=glob_loc;		/* header loc */
glob_loc=gh_p->g_vars;	/* skip to real fields */

#ifdef Z3BUG
printf("\nglob_loc now=%x   gh_p=%x\n",glob_loc,gh_p);
#endif

movmem(glob_loc,&user,sizeof(user));
glob_loc+=sizeof(user);
gp=glob_loc;	/* get misc. variables area */

#ifdef Z3BUG
printf("\nUser #%d  '%s %s'\n",user.number,user.first,user.last);
printf("gp=%x, gp->glbstr=%x  glbstr=%x\n",gp,gp->glbstr,glbstr);
#endif

movmem(gp->glbstr,glbstr,MAXLINE+1);	/* restore command line */

#ifdef Z3BUG
printf("after glbstr move, name='%s %s'\n",user.first,user.last);
#endif

/* msg=gp->msg;	*/	/* restore msg variable pointer */
strloc=gp->strloc;
globalch=gp->globalch;
print_flag=gp->print_flag;
echo_flag=gp->echo_flag;
sepstr=gp->sepstr;
fmsg=gp->fmsg;
lmsg=gp->lmsg;
mindex=gp->mindex;
msgcount=gp->msgcount;
privmsgs=gp->privmsgs;
nextmsg=gp->nextmsg;
totalmsgs=gp->totalmsgs;
callnum=gp->callnum;
strcpy(date,gp->date);
strcpy(time,gp->time);
strcpy(last_date,gp->last_date);
strcpy(last_time,gp->last_time);
height=gp->height;
sotries=gp->sotries;

#ifdef Z3BUG
printf("\nname='%s %s'...gp=%xh\n",user.first,user.last,gp);
#endif

movmem(gp->path,z3env->expath,(unsigned)(2*z3env->expaths));
movmem(&(gp->cmdbuf),z3env->cl,(unsigned)(z3env->cls+4) );

} /* g_restore */

#ifdef Z3

/*************************************************************************
 *  z3_init() does init stuff for zcpr3 systems..
 *  Like: loading system segments and setting registers..
 ****************/

z3_init()
{
static struct seg_type
	{
	int num;	/* segment # offset into sysseg array	*/
	char *type;	/* Filetype to add to file		*/
	}
	segs[] = {
			ENV,".ENV",	NDR,".NDR",	RCP,".RCP",
			FCP,".FCP",	IOP,".IOP",	-1,0		};
int i;
struct seg_type *sp;
u_types *uptr;
char *cp;

send("\n[Initializing Environment]\n");
uptr=&(O.user_types[user.type]);

/* load system segments.. */

for (sp=segs; (sp->num)>=0; sp++)
	if (*(uptr->sysseg[sp->num]))
		load_seg(uptr->sysseg[sp->num],sp->num,sp->type);

/* Set z3 regsiters.. */

for (i=0; i<10; i++)
	if (uptr->regs[i] & 0xff00) z3env->msg[0x30+i] = uptr->regs[i] &0xff;

/* Put user name in system file name area */

cp=z3env; cp+=0x52+((uptr->sysnum-1)*11);	/* point to system file name */
setmem(cp,11,' ');				/* blank pad */
strncpy(cp+8,user.first,3);	strncpy(cp,user.last,8);

/* Set system path */

if (uptr->path) movmem(uptr->path,z3env->expath,(unsigned)(2*z3env->expaths));

}


load_seg(file,num,ft)
 int num;
 char *file,*ft;
{
char tfile[20],*addr;
FILE *seg_file;

sprintf(tfile,"%s%s",file,ft);
switch (num) {
	case ENV:
		addr=z3env->env;
		break;
	case NDR:
		addr=z3env->ndir;
		break;
	case RCP:
		addr=z3env->rcp;
		break;
	case FCP:
		addr=z3env->fcp;
		break;
	case IOP:
		addr=z3env->iop;
		break;
	} /* switch */


if (seg_file=open(tfile,F_RD))
	{
	for ( ; read(seg_file,1)==128; addr+=128)
		movmem(bufloc(seg_file),addr,128);
	close(seg_file);
	}

} /* load_seg */
		

#endif	/* Z3 */


/********************************************
 * Get a line of input, and do command if a *
 * match is found....			    *
 ********************************************/

get_cmd(str,cmdlist)
 char *str;
 struct cmdtype *cmdlist;
{
register struct cmdtype *ind;		/* index to go through list */
register char *chind;			/* character index	    */
char s_time[TIMELEN+10];
char temp[MAXLINE+1];

sepstr=' ';	/* allow space seperator */
do {
   if (O.RTC)
	{
	int mins,tm;
	readclock();	/* get time */
	mins=timecomp(time,user.time,date,user.date);
	sprintf(s_time,"[%d min.] ",mins);
	tm=O.user_types[user.type].minutes;
	if (tm)
	   {
	   if (mins>tm)
		{
		send("\n[Time Limit Expired]\n");
		hangup(YES);	/* hangup after printing copyright/etc */
		}
	     else if (mins>(tm-3)) send("\n[Your time on the system is almost up]\n");
	   } /* if tm */
	}
     else *s_time='\0';

   sprintf(temp,"\n%s%s",s_time,str);	/* add current time to string */
   ask(temp,buffer,MAXLINE,UP);	/* print prompt, and get line */
   if (*buffer=='/' && buffer[1]!='/')
	{
	strloc=0;	/* nullify rest of line */
	*buffer='\0';
	continue;
	}
   } while (*buffer=='\0');

sepstr='\0';	/* turn this off */

for (ind=cmdlist; ind->abbr; ind++)
	{
	if (!strncmp(buffer,ind->abbr,strlen(ind->abbr)))
		{	/* matched abbreviation */
		chind=buffer+strlen(ind->abbr);
		if (!strncmp(chind,ind->full,strlen(chind)))
			{
			if (ind->ovname==0) (*ind->func)(ind->value);
			  else ovloader(ind->ovname,ind->func,ind->value);
			break;	/* get out of all these nested tests */
			}
		} 	/* abbr. match test */
	}  /* search loop */

if (ind->abbr) return NULL;	/* NULL=command found */

#ifdef Z3
if (O.ZCPR==3)			/* if ZCPR3 is in use */
	{
	strcpy(temp,buffer);
	return ovloader(OVZ3,CMD,temp);	/* do alias command if found */
	}
   else	/* 'fall' through to return ERROR */
#endif

return ERROR;	/* command not found */

}  /* get_cmd */


char ostat=0;	/* these need to be externs here, since overlays */
char otype=0;	/* don't like statics (they don't stick)	 */


/*****************************
 * Check if user matches the passed string
 *****************************/

thisis(s)
 register char *s;
{
char bs[FNAMELEN+LNAMELEN+2];

sprintf(buffer,"%s %s",user.first,user.last);
strcpy(bs,s);  upcase(bs);	/* make passed string upper case only */

/* if (!ustrcmp(buffer,s) || (user.status==SYSOP && usindex("SYSOP",bs))) */

if (!ustrcmp(buffer,s) || (user.status==SYSOP && (usindex("SYSOP",bs) && (user.number==1))))

	return TRUE;

return FALSE;
}


/****************************************
 * da..du..du..da..dat's all folks....	*
 ****************************************/

