/******************************************************************************
 *	METAL Message section...
 *
 *	File name: MES.C
 *
 *	       Metal and Metal Message System are Trademarked and
 *			Copyright (c) 1984, 1985 Tim Gary
 *			       All rights reserved.
 *
 *
 *   This module contains common message base routines (read, msgheader, etc)
 *
 *****************************************************************************
 *
 * 1.31a  10/13/85 Release version.  Fixed bug in getheader(), moved read
 *  		   message functions to overlay.
 * 1.30xx 6/23/85  Spelling error fixed.
 * 1.30xx 3/03/85  Z3 stuff added, fixed prompts for ignoring controls.
 * 1.20b 01/21/85  Message read fixed for sysop '<' function..
 * 1.20b 01/11/85  Swap order of sender/recipient in summary.
 * 1.20b 01/09/85  Really fixed search function.  Added & op to search.
 *		  Added sysop link of a message to a file..
 * 1.20b 01/07/85  Search function fixed, Quiet read mode, novice help,
 *		  extended abort checking during search operations, and
 *		  summary function output changed.
 * 1.20a 11/11/84  Nothing found message fixed in selective read.
 * 1.20<test c> 11/09/84  [Nothing found/not addressed to ya/dead] msg in read.
 * 1.20<test a> 11/04/84  Fixed timefix routine for no clock.
 * 1.10e 11/01/84  Allow for reading of dead msgs.
 * 1.10e 10/31/84  Width stuff changed in msgheader, fixed for unkill.
 * 1.10c 10/12/84  Made a few functions here overlays to conserve space.
 * 1.10b 10/09/84  Complete reworking of read message routines (internal only).
 * 1.10b 10/04/84  More cosmetics.. Should be it for a while.
 * 1.10a  9/28/84  Fixed reply problem (msg shown after reply..).
 * 1.10a  9/26/84  Added a few cosmetic changes (y/n)? and selective read help.
 * 1.10a  9/24/84  Fixed edit user/kill this msg, bugs.. (introduced 8/31/84)
 * 1.10a  9/12/84  Eliminated Reverse read bug (replies not listed)
 * 1.10a  9/12/84  Cosmetic changes.
 * 1.10a  9/09/84  Cosmetic changes.
 * 1.10a  9/07/84  Added Kill previous message to selective read for sysop.
 * 1.10a  9/06/84  Changed Edit/delete user on read for previous message.
 * 1.10a  8/31/84  Split for overlays, now contains readmsg() and commons.
 *
 * 1.01a  8/05/84  Got things going, added delete user, and edit user during
 *		  message read (prompted mode).
 * 1.01a  7/14/84  Message editing bugs fixed (delete line.. movmem changed).
 *		   Added subject truncation notice on message entry.
 * 1.01a  6/30/84  Cleaned up more functions.
 * 1.01a  6/26/84  Cleaned up a few functions, and added MULTI_USER stuff.
 * 1.01a  6/10/84  Fixed to work with Aztec C 1.06. Started Multi-user stuff.
 *
 * 1.0b   4/20/84  (cont) Added msearch, for string search for msgs..
 * 1.0b	  4/13/84  Modified for upper/lower case names, and added check for
 *		maximum messages allowed (killed and active ones).
 *
 * 1.0	  1/20/84  New format of Message file headers.
 * p3.0	 12/14/83  pre-release version 3.0 mods for MCONFIG..
 *
 *****************************************************************************/

#include "xpm.h"	/* i/o operations related defs	*/
#include "megen.h"	/* general defines		*/
#include "meglob.h"	/* global variable definitions	*/
#include "meovfn.h"	/* overlay function numbers	*/
#include "mefiles.h"	/* file names			*/

#include "ctype.h"


getindex(m)
 register unsigned m;
{
register int a;
 if (m==0) return ERROR;
 for (a=0; a<mindex; a++) if (msg[a].number==m) break;
 if (msg[a].number!=m) return ERROR;
return a;
}

/* update message and summary file with the new reply/parent of the msg at
 * the index (into msg array) passed to it 
 */

updatemsg(a)
 register unsigned a;
{
register unsigned *b;

messages=open(MESSAGES,F_RW | F_UNLOCK);
summary=open(SUMMARY,F_RW | F_UNLOCK);
b=bufloc(summary);
setarec(summary,1);
do  read(summary,1);		/* position to right place in sum. */
	while (*b!=msg[a].number);
setrrec(summary,-1);		/* back up one record */
setarec(messages,msg[a].seek);	/* seek to parent loc */

movmem(&msg[a].number,bufloc(summary),8);	/* summary hdr same */
movmem(bufloc(summary),bufloc(messages),128);	/* as message hdr  */

write(summary,0);
close(summary);

write(messages,0);
close(messages);

}	/* update msg */


#ifdef MULTI_USER

/*********************************************************
 * Check for new messages, update counters/array if some
 * are actually found.  Used only in Multi-user systems
 *********************************************************/

mu_update()
{
register unsigned tn_msg;
register msg_record *mptr;
register int rval=0;		/* return value # of new msgs */
unsigned new_msgs();

if (!(tn_msg=new_msgs())) return rval;	/* check if counters updated */

/* tn_msg will contain # of new 'nextmsg' counter, from counters file */

printf("\n%u new messages entered by other users.\n",tn_msg-nextmsg);
summary=open(SUMMARY,F_RD | F_UNLOCK);
mptr=bufloc(summary);
toeof(summary);	setrrec(summary,nextmsg-tn_msg);	/* backup # msgs */
rval=tn_msg-nextmsg;

while ((nextmsg++)<tn_msg)	/* and here we read new stuff */
	{
	read(summary,1);
	if (mptr->status!=DEADMSG)
		{
		msg[mindex].number=mptr->number;
		msg[mindex].seek=mptr->seek;
		msg[mindex].parent=mptr->parent;
		msg[mindex].reply=mptr->reply;
		++totalmsgs;  ++msgcount;
		if (thisis(mptr->reciever))
			printf("\n#%u from %s %s is for you.\n",mptr->number,
				mptr->fsend,mptr->lsend);
		}  /* if */
	}  /* while */
close(summary);
lmsg=msg[mindex-1].number;
putchar('\n');

return rval;	/* # of new msgs */
}  /* mu_update */


/*********************************************************
 * check for differing (in nextmsg) counters file
 * returns new nextmsg
 *********************************************************/

unsigned new_msgs()
{
unsigned tnext=0;

if ((counters=open(COUNTERS,F_RD | F_UNLOCK))!=NULL)
	{
	sscanf(bufloc(counters),"%*d %*d %d",&tnext);
	close(counters);
	if (tnext==nextmsg) tnext=0;
	}
return tnext;
}

#endif /* multi user */



/****************************************************************
 * format message header info 					*
 * formats.  0=Quick Summary format    1=Full summary format	*
 *           2=Read Message format     3=Kill message format	*
 *	     4=unkill..						*
 ****************************************************************/

get_header(mode,buf)
 register int mode;
 register char *buf;
{
char tstr[30];
register int a;

*tstr='\0';

if (message.parent) 
	if ((a=msg[getindex(message.parent)].number)==ERROR) message.parent=0;

if (mode==0)
	sprintf(buf,"\n%u  %s",message.number,message.topic);
   else if (mode==1)
	{
/*	if (message.parent) sprintf(tstr,"[R/%u]",a); */
	*(message.date+5)='\0';		/* chop off year... */
	sprintf(buf,"\n%4u %s %s \"%s\"(%d) %sTo: %s %s%sFrom: %s %s",
		message.number,message.date,tstr,message.topic,message.lines,
		user.parm.width<80 ? "\n    " : " ",
		message.receiver,
		(message.status==PRIVMSG ? "<Priv>" :
		    message.status==DEADMSG ? "<Dead>" : ""),
		user.parm.width<80 ? "\n    " : "  ",
		message.fsend,message.lsend);
	if (user.parm.width>=80)
		buf[user.parm.width]='\0'; /* cut off at 80 chars */
	}
     else
	if ((mode!=3 && mode!=4) || user.parm.expert==POFF)
	  {
	  if (message.parent) sprintf(tstr,"\n[Reply to msg #%u]\n",a);
	  sprintf(buf,"\nMsg #%u posted %s %s%s by %s %s\
\nTo: %s %s %sAbout: %s (%d lines)\n%s\n",message.number,message.date,
O.RTC ? "at " : "",O.RTC ? message.time : "",
message.fsend,message.lsend,message.receiver,
message.status==PRIVMSG ? "<Priv>" : message.status==DEADMSG ? "<Dead>" : "  ",
user.parm.width<80 ? "\n" : " ",
message.topic,message.lines,tstr);
	  }
}


/* msgheader() displays the message header information in one of three
 * formats.  0=Quick Summary format    1=Full summary format
 *           2=Read Message format     3=Kill message format
 *	     4=Unkill msg
 * Bit 0x80 of mode indicates display even if dead.
 * It expects you to supply the file descriptor, a 'starting' msg number (which
 *	is only used by the summary funtions, and should be 1 or 0 for Read),
 *      and the mode as described above.
 *
 * it returns ERROR if it could not read the header, or ^K was entered aborting
 *  its output.
 * NULL (0) is returned if the message is private, and can't be read by the
 *  current user of the system.
 * if everything is ok, it returns the number of lines in the message.
 */

msgheader(ffd,startmsg,mode)
 FILE *ffd;
 unsigned startmsg;
 int mode;
{
register unsigned a;
int fixed_mode;

fixed_mode=mode&0x7f;

if (read(ffd,1)!=128) return ERROR;
movmem(bufloc(ffd),&message,128);	/* get msg structure	*/
timefix(message.time);			/* make time look better.. */

if (message.status==DEADMSG) message.parent=message.reply=0;

if (fixed_mode==4)
	{
	if (message.status!=DEADMSG)
		{
		if (startmsg!=0) printf("\n[Message %u not dead!] ",message.number);
		return NULL;
		}
	}
  else if ((message.status==DEADMSG) && !(mode & 0x80)) return NULL;

/* send(".");	*/

if ((message.status==PRIVMSG || (message.status==DEADMSG && (mode & 0x80)))
	 && !thisis(message.receiver)
	 && ( (fixed_mode<3)
		? (O.user_types[user.type].readpriv==NO)
		: (O.user_types[user.type].killflag==NO) )
	 && (ustrcmp(message.fsend,user.first)
	     || ustrcmp(message.lsend,user.last))  )
	return NULL;

/* send(".");	*/

if (fixed_mode==3 && !thisis(message.receiver) &&
	(ustrcmp(message.fsend,user.first) || ustrcmp(message.lsend,user.last))
	&& O.user_types[user.type].killflag==NO) return NULL;

/* send(".");	*/

if (message.number>=startmsg || startmsg==0) 	
	{
	if (msearch(0)==0) return NULL;	/* no match.. ret */
	if (message.parent!=0)
		{	/* find original msg number */
		if ((fixed_mode==2) &&
		    (message.parent>=startmsg) && startmsg!=0)
			return NULL;
		while (msg[getindex(message.parent)].parent!=0)
			message.parent=msg[getindex(message.parent)].parent;

		/* parent now has 0 if none, else orig. msg number */
		}

	get_header(fixed_mode,buffer);
	if ((fixed_mode!=3 && fixed_mode!=4) || user.parm.expert==POFF)  /* write line */
		if (send(buffer)==ERROR) return ERROR;

	}
	else return NULL;
return message.lines ? message.lines : 1;	/* if 0 lines, fake it.. */
}


/* convert passed string (containing time in hh:mm:ss format) to hh:mm[am|pm]
   format	*/

timefix(s)
 register char *s;
{
register int n;
char ch[3];

 if (strlen(s)>=8)
	{
	n=atoi(s);
	if (n>=12)
		{
		n-=12;
		strncpy(ch,s+3,2);	*(ch+2)='\0';	/* get mins in ch */
		sprintf(s,"%2d:%2s pm",n,ch);
		}
	  else strcpy(s+5," am");
	}
if (n==0) strncpy(s,"12",2);	/* fix 00:xx:xx type times.. */
if (*s=='0') *s=' ';		/* we don't like leading zeros */
}


/***************
 * search help *
 ***************/

search_help()
{
static char *s_hlp[] = {
	"\nThe following message fields may be searched:",
	"\n  s: = subject field         d: = date field",
	"\n  f: = from (name) field     t: = to (name) field",
	"\n  *: = ALL of the above fields",
	"\nIf multiple fields are specified, a message with",
	"\na match in ANY field will be selected.  To select",
	"\nonly messages which match all fields you specified,",
	"\ninsert an '&' character before any of the fields.",
	"\nMultiple search fields may separately be specified.",
	"\nExamples: 244+ s:for sale &t:all users",
	"\n          1024- t:all users",
	"\n          ft:sysop s:metal\n",
	0 };	/* that's enuf for now */

dis_text(s_hlp);
}


/************************************************************************
 *  Search for string in message variables if passed string ptr=0,
 *  else, setup the string to be compared to the message variables later.
 *  string, if passed, format of:
 *	<s|d|f|t|*>:<search string>	s=subject search
 *		f=from search		t=to search	d=date search
 *		*=search all above fields	&=perform 'and' search on
 *  examples:					  ALL fields...sorry
 *	s:for sale		ft:tim gary		d:09-02-84
 *	t:all &s:for sale	t:tim gary s:metal
 *  in read operations:
 *	rs;30+ s:wanted		r;223+ *:sysop    etc...
 *
 *  returns:	bit 0 ON for SUBJECT match	bit 1 ON for DATE match
 *		bit 2 ON for FROM match		bit 3 ON for TO match
 *		bit 8 ON if no search..
 ************************************************************************/

char msearch(sstr)
 char *sstr;
{
char *ps,*t_sstr;
register char ret_flag;

static char f_pattern[FNAMELEN+LNAMELEN+3];
static char t_pattern[FNAMELEN+LNAMELEN+3];
static char s_pattern[TOPICLEN+2];
static char d_pattern[DATELEN+2];

static int field_flag,and_flag;

ret_flag=0;

if (sstr)	/* if not null ptr, setup search string */
	{
	(*t_pattern)=(*f_pattern)=(*s_pattern)=(*d_pattern)='\0';  /* make empty at first */
	field_flag=and_flag=NO;	/* all off */
	for (t_sstr=sstr; (ps=index(t_sstr,':')) && (t_sstr!=1); t_sstr=index(t_sstr,':')+1)
	  /* '=' IS ON PURPOSE!!!!!!!!	*/
		{
		while (--ps>=t_sstr)	/* backwards parse from ':'	*/
			{
			switch (*ps) {
				case 'S':
					field_flag|=1;
					get_pat(ps,s_pattern,TOPICLEN);
					break;
				case 'D':
					field_flag|=2;
					get_pat(ps,d_pattern,DATELEN);
					break;
				case 'F':
					field_flag|=4;
					get_pat(ps,f_pattern,FNAMELEN+LNAMELEN+1);
					break;
				case 'T':
					field_flag|=8;
					get_pat(ps,t_pattern,FNAMELEN+LNAMELEN+1);
					break;
				case '&':
					and_flag=YES;
					break;
				case '*':
					field_flag=15;   /* all bits on */
					get_pat(ps,t_pattern,FNAMELEN+LNAMELEN+1);
					get_pat(ps,f_pattern,FNAMELEN+LNAMELEN+1);
					get_pat(ps,d_pattern,DATELEN);
					get_pat(ps,s_pattern,TOPICLEN);

					break;
				default:
					ps=t_sstr;	/* stop loop here */
				} /* switch */
			} /* while loop */
		} /* for loop */
	ret_flag=field_flag;
	} /* main 'string passed' if */

  else {	/* no string passed, compare with message fields */
	if (!field_flag) ret_flag=128;	/* flag bit 7 if no compare */
	   else	{
		char tstr[MAXLINE+1];	/* used for sender string */
		if (field_flag&1)
			ret_flag|=(usindex(s_pattern,message.topic) ? 1 : 0);
		if (field_flag&2)
			ret_flag|=(usindex(d_pattern,message.date) ? 2 : 0);
		if (field_flag&4) {
			sprintf(tstr,"%s %s",message.fsend,message.lsend);
			ret_flag|=(usindex(f_pattern,tstr) ? 4 : 0);
			}
		if (field_flag&8)
			ret_flag|=(usindex(t_pattern,message.receiver) ? 8 : 0);
		if (and_flag && (field_flag!=ret_flag)) ret_flag=0; /* not & */
		} /* check pattern?? if */
	}

return ret_flag;	/* return value */
}	/* msearch */


get_pat(sub_str,dest,max_len)
 char *sub_str,*dest;
 int max_len;
{
register char *tp2;
register char *tp1,*s_cop;

tp1=s_cop=index(sub_str,':')+1;

if (tp2=index(tp1,':'))		/* if there are more ':'s */
	while (!isspace(*(--tp2)) && tp2>tp1);
  else tp2=tp1+strlen(tp1);
--tp2;

while (tp1<=tp2 && (tp1-s_cop)<=max_len) *(dest++)=*(tp1++);
*dest='\0';	/* terminate */

} /* get_pat */


/* End of MES.C */


