/****************************************************************
 *   Metal Message System read message functions
 *
 *	File:  MEREAD.C
 *
 *	Metal Message System and Z-Msg are Trademarked and
 *		 Copyright (c) 1984,1985 Tim Gary
 *			All Rights Reserved.
 *
 ****************************************************************
 *
 * 1.31a  10/13/85  Release version.  New overlay method allows
 *		    overlay to overlay calling, with return, so read
 *		    routines were moved here to regain needed memory space.
 *		    Modify, write, and print message functions from
 *		    selective read act on PREVIOUS message in all cases.
 * 1.31xx 08/22/85  File created, for use with new overlay to
 *		   overlay support (one level)..
 *
 ****************************************************************/

#include "xpm.h"	/* CPMIO header file for i/o operations.*/
#include "megen.h"	/* general defines		*/
#include "meglob.h"	/* global variable definitions	*/
#include "meovfn.h"	/* overlay function numbers	*/
#include "mefiles.h"	/* file names			*/

#include "ctype.h"


ovmain(func,parm)
int func;		/* not used in this overlay, but definition required */
int parm;
{
readmsgs(parm);		/* all that's here for now */
}


/***************************
 * help for read functions *
 ***************************/

read_help(mode)
 char mode;
{
static char *r_hlp[] = {
	"\nEnter the message number you wish to retrieve.",
	"\nTo read a series of messages, enter a plus (+)",
	"\nor minus (-) (for increasing or decreasing order)",
	"\nafter the number of the first message you wish",
	"\nto read. (eg. 10+ or 280-)\n",
	0 };	/* help text */

if (mode=='S' || mode=='R')
	send("\nEnter the message you wish to start retrieval at.\n-->");
  else if (mode!='P') dis_text(r_hlp);

if (mode & 128) search_help();
}


selrd_help()
{
static char *nsr_help[] = {
	"\n(Y)es, read this message.    (N)o, don't read it.",
	"\n(R)eply to PREVIOUS message. (Q)uit reading messages.",
	"\n(M)odify PREVIOUS message header (subject).\n",
	0 };
static char *ssr_help[] = {
	"\n** Special SYSOP functions:",
	"\n(K)ill PREVIOUS message.",
	"\n(W)rite PREVIOUS message to disk file.",
	"\n(P)rint message to LST: device",
	"\n(E)dit sender of PREVIOUS message",
	"\n(D)elete sender of previous message\n",
	0 };

if (dis_text(nsr_help)!=ERROR) if (user.status==SYSOP) dis_text(ssr_help);
}


/******************************************
 *  Read messages routine.		  *
 *  Code is much clearer, and is not	  *
 *  dependent on message structure.	  *
 ******************************************/

readmsgs(mode)
 int mode;
{
int firstm,lastm,inc;		/* message indexes and increment count	*/
int flag;			/* flag for various things ERROR=abort	*/
unsigned startmsg;		/* starting message number		*/
int read_flag;			/* flag for something read or not	*/

#ifdef MULTI_USER
  mu_update();
#endif

if (!msgcount)
       {
       send("\nSorry, there are currently no messages posted.\n");
       return;
       }

novhelp();

if (strloc==0 && user.parm.expert==POFF) read_help(mode);

   /*
    *  Loop the Loop...
    */

  do   {
       if (get_range(&mode,&firstm,&lastm,&inc)==ERROR) break;
	read_flag=FALSE;	/* nothing read yet */

       if ((messages=open(MESSAGES,F_RD | F_UNLOCK))==NULL)
	       {
	       send("\nUnable to open messages file.\n");
		read_flag=TRUE;		/* fake it out so only one msg! */
	       break;
	       }

       for (flag=NULL,startmsg=msg[firstm].number;
	    ((inc!=-1) ? (firstm<=lastm) : (firstm>=lastm)) && (flag!=ERROR);
	    firstm+=((inc==0) ? 1 : inc) )
	       {
		int loc_first,loc_reply;	/* local copies */
		loc_first=firstm;
		loc_reply=msg[firstm].reply;

	       if (msg[loc_first].number && (msg[loc_first].parent<startmsg) )
		    do {
		       flag=rm(msg[loc_first].number,mode);
			if (flag) read_flag=TRUE;
		       if (inc!=1) break;      /* single and backward.. */
		       if (!msg[loc_first].number)
				if (loc_reply) loc_first=getindex(loc_reply);
				  else break;
			if (loc_first!=ERROR) loc_reply=msg[loc_first].reply;
		       } while ((flag!=ERROR) &&
				((loc_first=getindex(msg[loc_first].reply))
				 != ERROR) && (loc_first<=lastm) );
	       } /* for */

if (!read_flag)
	send("\n[Nothing found.]\n[Message(s) either private or deleted.]");

close(messages);
} while ((flag!=ERROR) && !inc);

putchar('\n');

} /* readmsgs */


/************************************
 * Get range function for read msgs *
 ************************************/

get_range(pmode,pfirst,plast,pinc)
 int *pmode,*pfirst,*plast,*pinc;
{
char *tp;
unsigned msgnum;
int bit;
int sreq;	/* search request flag.. */

bit=0;

do {   /* silly do concept */

if (*pmode!='P')       /* new message read function has no options */
       {
       do {
	  if (user.parm.expert!=PON)
		sprintf(buffer,"\nRead which message\
\n(first=%u, last=%u, '?' for help)? ",fmsg,lmsg);
	   else sprintf(buffer,"\nRead (first=%u, last=%u)? ",fmsg,lmsg);
	  ask(buffer,buffer,MAXLINE,UP);
	  if (*buffer=='?') read_help(*pmode | 128);
	  } while (*buffer=='?');
       } else  {	       /* if it is 'P' mode */
	       *buffer='N';    /* for new messages  */
	       *pmode='S';     /* selective read mode */
	       }
       if (*buffer=='K')	/* K must be BEFORE Q if both are used */
		{
		sprintf(buffer,"%s",buffer+1);
		bit=0x80;
		}
	if (*buffer=='Q')	/* flag quiet no prompts when to you mode */
		{
		sprintf(buffer,"%s",buffer+1);
		bit|=0x100;
		}

       sreq=msearch(buffer);   /* setup search if there is one */

       if (*buffer=='N') msgnum=user.lastread+1;
	  else {
	       if (isdigit(*buffer))
		       {
		       if ( ((msgnum=atoi(buffer))>lmsg) || (msgnum<0))
			       {
			       if (*buffer!='\0')
				       send("\n[Message out of range]\n");
			       strloc=0;    /* clear this global pointer */
			       return ERROR;
			       }
		       } else if (sreq) {      /* can have search alone  */
					msgnum=1;  /* and start at msg 1 */
					*buffer='+';
					}
				    else return ERROR;
	       } /* 'N' else test */

       if (*pmode=='S') *buffer='+';   /* Forward selective read */
       if (*pmode=='R') 	       /* Reverse selective read */
	       {
	       *buffer='-';
	       *pmode='S';
	       }
       if (msgnum==0) ++msgnum;        /* convert a zero to a one */

/* All options of modes are reduced by now, so start setting	 *
 * up values to be returned					 */

       if ( ( (tp=index(buffer,'+')) <buffer+7) && (tp!=0) ) *pinc=1;
	  else if ( ( (tp=index(buffer,'-'))<buffer+7) && (tp!=0) ) *pinc=-1;
	      else *pinc=0;

       for (*pfirst=0; msg[*pfirst].number<msgnum; ++(*pfirst));

       if (*pinc==-1) if (*pfirst!=0 && msg[*pfirst].number!=msgnum) *pfirst--;

       if (*pinc)
	       {
	       if (*pinc==1) *plast=mindex-1;
		 else *plast=0;
	       if (*pmode!='S' && user.parm.expert==POFF)
		       send("\n*** Control-O skips to the next message. ***\n");
	       }
	  else if (msg[*pfirst].number!=msgnum)
		       {
		       printf("\n[Message %u not found]\n",msgnum);
		       continue;
		       }
		       else *plast=*pfirst;

    break;	       /* I know.. wierd */

    } while (1);

(*pmode)|=bit;
return NULL;   /* done, ok */

} /* get_range */


extern char prevsender[],status;
extern unsigned prevmsg;

/* This routine displays the message, it's header, from current place in file
 *  expects message number, and read mode given to it.
 *	mode is 'S' for selective read.. (ie prompt), else, no prompt
 *  returns ERROR if break hit, or can't read a record
 *  returns NULL if not addressed to user and private, or not selected
 *  returns #of lines if read.....
 */

rm(msgnum,rd_mode)
 unsigned msgnum;
 int rd_mode;
{
 int lns;
 unsigned saveseek;
 char str[3],ttt[80];
 int c;
 unsigned ind,mode;
 char tsender[FNAMELEN+LNAMELEN+3];

mode=rd_mode&0x7f;
if ((ind=getindex(msgnum))==ERROR || msg[ind].number==0)  return NULL;
if (breakkey()) return ERROR;

do {		/* silly loop to avoid goto, and for single exit point	 */
 setarec(messages,msg[ind].seek);	/* goto message location in file */
 lns=msgheader(messages,0,2|(rd_mode & 0x80));	/* read header info.. */

 status=message.status;
 if (lns==ERROR || lns==NULL) break;

 sprintf(tsender,"%s %s",message.fsend,message.lsend);
 saveseek=getrec(messages)-1;	/* save current loc  */

 if (mode=='S')		/* selective read */
	{
	if (user.status==SYSOP) send("[y/n/r/p/w/e/d/k/m/q]");
	   else if (user.parm.expert==PON) send("[Read? y/n/r/m/q/?]");
		  else send("[Read? Yes/No/Reply/Mod/Quit/Help]");
	while ((c=toupper(getd()))<' ');	/* ignore control chars */
	send(" [");
	if (c=='N') {	send("no]\n");  break;	}

	if (c=='Q') {	send("quit]");	lns=ERROR;	break;	}

	if (prevmsg!=0)
	  {

	  if (c=='M')
		{
		send("modify]\n\n");
		do_ov("[Modify PREVIOUS message header information\
\n(subject, etc..) (y/n)? ]",OVSTUFF,EDITMSG,prevmsg,0);
		continue;
		}

	  if (c=='R')
		{
		send("reply]\n\n");
		do_ov("[Reply to PREVIOUS message (y/n)? ]",OVSEND,0,prevmsg,0);
		continue;
		}

	  if (user.status==SYSOP)
	    {
	    int flag;
	    flag=TRUE;

	    switch(c)
	      {
	      case 'K':
		send("kill]\n\n");
		sprintf(ttt,"[Kill PREVIOUS message #%u (y/n)? ]",prevmsg);
		do_ov(ttt,OVKILL,KILL,prevmsg,0);
		break;

	      case 'E':
		send("edit user]\n\n");
		do_ov(0,OVUSER,EDITUSER,0,prevsender);
		break;

	      case 'D':
		send("delete user]\n\n");
		sprintf(ttt,"[Delete PREVIOUS sender (%s)\
\nfrom users file (y/n)? ]",prevsender);
		do_ov(ttt,OVUSER,DELETEUSER,0,prevsender);
		break;

	      case 'P':
	      case 'W':
		if (out_msg(c,prevmsg)) break;
		   else continue;
		break;

	      default:
		flag=FALSE;
		break;
	      } /* switch */
	    if (flag) continue;		/* go back and get header stuff */
	    } /* sysop test */
	  } /* previous message available */


	if (c=='H' || c=='?') {
		send(" ? ]\n\n");
		selrd_help();	/* selective read help */
		continue;
		}

	send("yes]\n\n");
	} /* mode==TRUE */	/* else read the thing */

read(messages,1);		/* next record */
if (showmsg(lns)==ERROR) {  lns=ERROR; break;	}
putchar('\n');

if (!(rd_mode&0x100) && thisis(message.receiver))
	{	/* message was to this guy.. does he want to reply? */
	if (do_ov("\n[Reply to this msg (y/n)? ]",OVSEND,0,msgnum,0)==TRUE)
	     sprintf(ttt,"\n[Kill Message you've just replied to (y/n)? ]");
	   else sprintf(ttt,"[Delete this Message (y/n)? ]");
	do_ov(ttt,OVKILL,KILL,msgnum,0);
	putchar('\n');
	}

  break;		/* continue gets by this crock */
   } while (1);

if (lns!=NULL && ((rd_mode&0x80) || status!=DEADMSG))
	{
	prevmsg=msgnum;
	strcpy(prevsender,tsender);
	}

return lns;	/* return lines.. */
}


/* do overlay from selective read... special kill msg handling */

do_ov(atext,ovname,ovfn,uparm,cparm)
 char *atext,*ovname,*cparm;
 int ovfn;
 unsigned uparm;
{
int c;
int ret_flag=YES;

/* prompt and get single letter yes=y, no=other char */
if (atext) ret_flag=yes_no(atext);	

if (ret_flag)
	{
	if (!strcmp(OVKILL,ovname)) close(messages);	/* killmsg req. */

	if (cparm) ovovload(ovname,ovfn,cparm);	/* do char overlay func */
	  else	{
		ovovload(ovname,ovfn,uparm);	/* do unn overlay func	*/
		messages=open(MESSAGES,F_RD | F_UNLOCK);
		}
	putchar('\n');
	}

return ret_flag;	/* true=we did the overlay */
}


/* This routine prints the message from file ffd, for nl lines */

showmsg(nl)
 register int nl;
{
register int lc;

globalchar='\0';	/* clear this before and after showing msg! */
for (lc=0; lc<nl; lc++)
	{
	fgets(buffer,messages);			/* get a line	*/
	if (index(buffer,'<'+0x80))
		{
		putchar('\n');
		type(index(buffer,'<'+0x80)+1);
		}
	  else if (send(buffer)==ERROR) return ERROR;
	if ((globalchar & 0x1f)==0x0f) break;	/* ^O hit to skip to next */
	}
globalchar='\0';
return 0;
}


/* yes=y, any other=no */

yes_no(text)
 char *text;
{
register int ret_flag,c;
ret_flag=NO;			/* default return value */

send(text);
while ((c=toupper(getd()))<' ');	/* ignore control chars */
if (c!='Y') send(" [no]\n");
    else {
	 ret_flag=YES;
	 send(" [yes]\n");
	 }

return ret_flag;
}


/**********************************************
 * outputs message to printer 'P' or file 'W' *
 **********************************************/

out_msg(place,num)
 int place;
 register unsigned num;
{
register int line_count;
unsigned save_seek;
int ret_flag;

setarec(messages,msg[getindex(num)].seek);	/* place on message to save */

if (place=='P')		/* printer output */
	{
	printf("print msg %u]\n\n",num);  /* next line '=' is on purpose */
	if (ret_flag=yes_no("Print PREVIOUS message (y/n)?"))
		{
		msgheader(messages,0,0x82);	/* read header info.. */
		get_header(2,buffer);
		read(messages,1);	/* for fgets */
		print(buffer);
		for (line_count=0; line_count<message.lines; line_count++)
			{
			fgets(buffer,messages);
			print(buffer);
			print("\r");
			}
		print("\r\n");	/* flush */
		} /* ok.. */
	} 	/* printer output */
/* otherwise, it's to a file.. get name, etc.. */
   else
	{
	char file[MAXLINE+1];
	FILE *fd;
	printf("write msg %u]\n\n",num);	/* Next line '=' on purpose */
	if (ret_flag=yes_no("Write PREVIOUS message to disk file (y/n)?"))
		{
		send("Write message to what file (uu/d:file.nam)?\n --> ");
		getl(file,UP);
		if (*file=='\0')
			{
			strcpy(file,"14/a:message.log");
			send("[File 14/A:MESSAGE.LOG assumed]\n");
			}
		save_seek=getrec(messages);
		close(messages);
		reset_disk(0);		/* for cp/m independence later */
		messages=open(MESSAGES,0);
		setarec(messages,save_seek);
/*		read(messages,1);	*/
		if (fd=open(file,1))
			{
			toeof(fd);	/* go to end to check if exists */
			if (getrec(fd)!=0)
				{
				send("\n[File Exists!]\n");
				if (ret_flag=yes_no("[Append to existing file? ]"))
					{
					setrrec(fd,-1);	/* backup rec */
					read(fd,0);
					while(gchar(fd)!=26);	/* test eof */
					setbuf(fd,getbuf(fd)-1);/* backup 1 */
					}
				   else if (ret_flag=yes_no("[Delete existing file? ]"))
						{
						close(fd);
						unlink(file);
						fd=open(file,1);
						}
					  else {
						send("[Aborting message write]\n");
						close(fd);
						return NO;
						}
				}

			msgheader(messages,0,0x82);	/* read header info */
			get_header(2,buffer);
			read(messages,1);	/* for fgets below */
			fputs(buffer,fd);
			for (line_count=0; line_count<message.lines; line_count++)
				{
				fgets(buffer,messages);
				fputs(buffer,fd);
				send(buffer);
				}
			fputs("\r\n\032",fd);	/* cr/lf and eof */
			write(fd,0);	/* finish up (make sure all written) */
			close(fd);
			}
			else send("\n[Unable to open file]\n");
		} /* y/n */
	} /* output to file */
putchar('\n');
return ret_flag;
}


/* end file MEREAD.C */


