/**************************************************************************
 *
 *	Header file for METAL/Z-MSG Version 1.30xx
 *
 *
 *	FILE: HMH.H
 *
 *			Copyright (c) 1984  Tim Gary
 *			    Delphi Data Systems
 *			    All rights reserved.
 *
 **************************************************************************
 *
 * 1.30xx 7/01/85  Print and echo flags moved here..
 * 1.30xx 6/09/85  Bye clone space deleted.
 * 1.30xx 5/26/85  Space for clone of highmem bye area for aliases.
 * 1.30xx 5/25/85  gp.msg added to global save structure.
 * 1.30xx 5/15/85  CONFIG define tested for, to reduce global space in it.
 * 1.30xx 5/03/85  Path space added in alias save structure.
 * 1.30xx 5/02/85  Moved last_date/last_time here/put in g_save, Z3MSG_OFFSET
 *		  define added...
 * 1.30xx 5/01/85  MESUMM changed to MESTUFF.  Added define for return from
 *		  alias.
 * 1.30xx 4/26/85  Added area for command buffer saving..
 * 1.30xx 3/07/85  BYE file definition and BBS name define added.
 * 1.30xx 2/25/85  More defines added.  new Z3STUFF.OVR file, and COMMANDS.
 * 1.30xx 2/20/85  Started Z3 routines.  Need >60k CP/M system to compile.
 * 1.20b 01/18/85  SHOWTIME define added for memisc overlay file..
 * 1.20b 01/13/85  KENMORE clock board defines added.
 * 1.20b 01/05/85  Added CCS and QX10 clock defines.
 * 1.20a 11/04/84  Version change.
 * 1.10e 10/30/84  Fixed for new functions moved to overlays.
 *
 * 1.10c 10/12/84  Made unused config files null for now (see hmconfg.h),
 *		  and now have OVMISC, and its defines.
 *
 * 1.10b <none>
 * 1.10a  8/31/84  Overlay support added.
 *		NOTE: new config fields..
 *
 * 1.01a  7/02/84  Multi_User Id support added.
 * 1.01a  6/10/84  Now requires Aztec C 1.06 to compile.  Added MAIN 
 *		  declaration for defining external symbols for NON-MAIN
 *		  files (like hmlib, ms, etc..).  Added CCS clock type.
 *
 * 1.0c   5/17/84  Added Hayes clock support.  Tested/working 6/8/84.
 *
 * 1.0b	  4/13/84  Added user defined file stuff, external 'height' variable
 *		and MAXTOTMSGS declaration.  NOTE: new config format 
 *		incompatible with previous versions.
 *
 * 1.0a	  1/24/84  Split into two parts one for no changes, other for options
 *
 * 1.0	  1/17/84  Changes for version 3.0 (more) EXTENSIVE ONES..
 *
 *************************************************************************/

/*************************************************************************
 * NOTE: the flag MAIN is used to tell if this file is to be setup for
 *   external variables.  That is, in the main files (metal.c, menter.c,    
 *   etc..) must declare this.
 *************************************************************************/

/* THE FOLLOWING DEFINE MUST NOT BE CHANGED UNDER ANY CIRCUMSTANCES!!!! */

#define BBSNAME "Metal Message System"

/* If ZCPR3 is never to be used, comment out the following line to save code */
/* space....	*/
#define Z3

#ifdef Z3
#define ALIASRET ";METAL alias"
#define Z3MSG_OFFSET 0x48	/* offset into Z3 message buffer for two */
				/* bytes of data (change if confict)	 */
#endif

/************************************************************************
 *!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*
 *!!!!!! This file has NO options that would need changing in it. !!!!!!*
 *!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*
 *! For configuration options, the file HMCONFG.H has things to change !*
 *!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*
 ************************************************************************/

/********************************************
 * so we can compile this file seperately.. *
 ********************************************/

#ifndef ERROR
#include "xpm.h"
#endif

/*****************
 * flag stuff... *
 *****************/

#define TRUE 1
#define FALSE 0
#define ON 1
#define OFF 0
#define YES 1
#define NO 0
#define NULL 0

#define PON	'1'	/* user parm on char...	*/
#define POFF	'0'	/* user parm off char..	*/

#define PRINT	1	/* flag print operation */
#define NOPRINT	0	/* flag no print op	*/

#define MAXLINE	128	/* max line length */
#define MAXMLINES 250	/* absolute maximum lines per msg */

/**************************
 * user parameter lengths *
 **************************/

#define FNAMELEN 14	/* first name up to 14 chars */
#define LNAMELEN 20	/* last   "    "  " 20   "   */
#define CITYLEN	28	/* up to 28 chars for the city, state */
#define PASSLEN 8	/* up to 8 char password     */
#define DATELEN 9	/* date string format mm/dd/yy  */
#define TIMELEN 9	/* time string format hh:mm:ss  */

/*****************************
 * message base length stuff *
 *****************************/

#define TOPICLEN 26	/* 26 char topic for msgs */

/*********************
 * ask routine flags *
 *********************/

#define UPLOW	0	/* no modification of input	*/
#define UP	1	/* convert input to upper case	*/
#define NOECHO	2	/* don't echo input		*/
#define NUMBER	4	/* number input as is comes in	*/
/* #define NOWAIT	8	*/	/* <<not implemented yet>>	*/
#define MSGLINE	16	/* flag for getl, to get max of MAXMSGLINE chars */

/*******************************************************
 * for read/write commands and other temp string oprs. *
 *******************************************************/

#ifdef MAIN

#define OVRSPACE 0x1f80		/* almost 8k space for overlay area */

char buffer[257]="Metal Message System (TM) and Z-MSG Copyright (c) 1984 by Tim Gary  All rights reserved.\n";
#else
extern char buffer[257];
#endif

char glbstr[MAXLINE+2];	/* global string used with ask(), etc.. and ';' */
char last_time[TIMELEN],last_date[DATELEN];

#ifdef MAIN
char print_flag=OFF;	/* flag for print mode */
char echo_flag=ON;	/* flag for "half-dup" non echo.. */
int strloc=0;		/* current position into glbstr */
int globalch='\0';	/* global char */
char sepstr='\0';	/* if !=0 then this acts same as ';' */
#else
extern char print_flag;	/* flag for print mode */
extern char echo_flag;	/* flag for "half-dup" non echo.. */
extern int strloc,globalch;
extern char sepstr;
#endif

/*****************************************************************************
 * Multi user console id #.. used for systems without a 'get console id' func.
 *****************************************************************************/

#ifdef MULTI_USER
unsigned id_num;	

#define ID_STR	"Id#"	/* 3 char string to use as Id check */

#endif

/****************************************
 * message base variable definitions	*
 ****************************************/

struct	{
	unsigned number;	/* message number	*/
	unsigned seek;		/* seek pointer to message header */
	unsigned parent;	/* parent msg.. original msg in rep. series */
	unsigned reply;		/* next reply in list... 0 if at end of list */
	} *msg;	/* POINTER NOW */

unsigned fmsg,lmsg;	/* first/last active msg numbers	*/
int mindex;		/* index into above msg array		*/

#define PRIVMSG	'p'	/* Private message stat char	*/
#define NORMMSG	'n'	/* Normal message status	*/
#define	DEADMSG	'x'	/* Dead/Killed message		*/

/**********************************************************************
 * message structure definition, new format with unencoded #'s, etc.. *
 **********************************************************************/

#ifndef CONFIG
typedef struct	{
	unsigned number;		/* message # */
	unsigned seek;			/* cp/m record, seek loc of msg */
	unsigned parent;		/* parent message #, if any	*/
	unsigned reply;			/* reply message #, if any	*/
	char	receiver[FNAMELEN+LNAMELEN+2];	/* who's msg to?	*/
	char	fsend[FNAMELEN+1];	/* who's msg from (first name)	*/
	char	lsend[LNAMELEN+1];	/*  "     "    "  (last name)	*/
	char	status;			/* private/normal, etc.. */
	int	lines;			/* # of lines in message */
	char	date[DATELEN];		/* date message entered */
	char	time[TIMELEN];		/* time message entered */
	char	topic[TOPICLEN+1];	/* subject of message	*/
	} msg_record;	/* new type */

/**************************************************************************
 * and now, the external, globally known, and loved, one and only msg var *
 **************************************************************************/

msg_record message;	/* Message variable that can be, and is, read	*/
			/* directly from the message/summary file	*/

int msgcount;		/* # of active messages		*/
int privmsgs;		/* # of private messages	*/
unsigned nextmsg;	/* next message number		*/
unsigned totalmsgs;	/* total active and killed msgs allowed	*/

unsigned callnum;	/* caller number NOW UNSIGNED!	*/
char date[DATELEN];	/* todays date			*/
char time[TIMELEN];	/* time string			*/

char nothing[6];	/* place to put BYE parms if inactive */

#endif /* CONFIG */

/***********************************************************************
 * global height var, so routines aren't dependent on user.parm.height *
 ***********************************************************************/

#ifdef MAIN
char height=24;	/* terminal height for putchar.. assume 24 char screen */
#else
extern char height;
#endif

/***********************
 * global BYE pointers *
 ***********************/

char *bye,*maxuser,*tout,*nulls;

/****************
 * global files	*
 ****************/

FILE *users;		/* users file			*/
FILE *counters;		/* message counters file	*/
FILE *lastcalr;		/* last caller file		*/
FILE *summary;		/* summary file for messages	*/
FILE *messages;		/* message base file		*/
FILE *callers;		/* callers file			*/

/*********************************************************
 * Make this a type, so that it can be defined elsewhere *
 *********************************************************/

#ifndef CONFIG
typedef struct	{
	int	number;
	char	first[FNAMELEN+1];
	char	last[LNAMELEN+1];
	char	pass[PASSLEN+1];
	char	date[DATELEN];
	char	time[TIMELEN];
	char	city[CITYLEN+1];
	unsigned lastread;
	char	status;
	char	type;
	struct	{
		char	ulcase;		/* upper or lower case 	*/
		char	jmpcpm;		/* jump to cpm/no bbs  	*/
		char	expert;		/* expert user? 	*/
		char	bell;		/* bell on or off 	*/
		char	rp;		/* 'RP' command at bbs  */
		char	video;		/* video mode ok?	*/
		char	nulls;		/* number of nulls	*/
		char	height;		/* height of terminal	*/
		char	width;		/* width of terminal	*/
		unsigned tcap;		/* tcap ptr (coming)	*/
		unsigned uploads;	/* upload count		*/
		unsigned downloads;	/* download count	*/
		unsigned minutes;	/* time on system today	*/
		unsigned inforec;	/* user info file rec	*/
		unsigned calls;		/* # of times called	*/
		char	reserved[5];	/* reserved for future	*/
		char	udef[4];	/* parms for users use	*/
		} parm;
	} usr;

usr user;	/* user variable */

#endif /* CONFIG */

struct cmdtype {	/* command structure definition  */
	char	*abbr;		/* abbreviation 	 */
	char	*full;		/* the rest of the thing */
	int	(*func)();	/* pointer to function   */
	int	value;		/* call the routine with this value */
	char	*ovname;	/* overlay name if used  */
	};

/**********************************************************************
 * LEAVE THESE ALONE!! must have correct numbers, and names for later *
 **********************************************************************/

#define BULLETIN O.files[0]
#define WELCOME	 O.files[1]
#define USERFILE O.files[2]
#define CALLERS  O.files[3]
#define COUNTERS O.files[4]
#define MESSAGES O.files[5]
#define SUMMARY	 O.files[6]
#define LASTCALR O.files[7]
#define NEWUSER	 O.files[8]
#define HELP	 O.files[9]
#define CPMINFO	 O.files[10]
#define SYSINFO	 O.files[11]
#define COMMENTS O.files[12]
#define OTHERSYS O.files[13]
#define NOTEFILE O.files[14]	/* notes file index (same format as below) */
#define FEATFILE O.files[15]	/* features file table of contents */
#define OVINFREQ O.files[16]
#define OVMENTER O.files[17]
#define OVSTUFF  O.files[18]	/* name changed 5/1/85 */
#define OVKILL   O.files[19]
#define OVSEND   O.files[20]
#define OVUSER   O.files[21]
#define OVSYSOP  O.files[22]
#define OVMISC	 O.files[23]
#define COMMANDS O.files[24]
#define OVZ3	 O.files[25]
#define BYE	 O.files[26]
/* #define OVXFER	 O.files[]	*/
/* #define OVOPSYS	 O.files[]	*/
/* #define OVHELP	 O.files[]	*/

/* Special function defines for overlay functions... */

#ifndef CONFIG

/* OVINFREQ */

#define INIT	  0
#define MSGALERT  1
#define READUSERS 2
#define SAVEUSER  3
#define STATS	  4
#define CALLS	  5

/* OVUSER */

#define EDITUSER   0
#define DELETEUSER 1

/* OVSTUFF */

#define ADDUSER	1
#define SUMM	2
#define WHO	3
#define EXPERT	4

/* OVMISC */

#define FEATURE	 0
#define OUTMSG	 1
#define GETRANGE 2
#define CHAT	 3
#define GOCPM	 4
#define GOODBYE	 5
#define SHOWTIME 6

/* OVSYSOP */

#define SOSTAT	 0
#define READCOMM 1
#define PURGE	 2

/* OVKILL */

#define KILL	0
#define UNKILL	1

/* OVZ3 */

#define CMD	0

#endif /* CONFIG */

/***/

#define SYSOP	'+'
#define	SPECIAL	's'	/* special user */
#define	NORMAL	'n'
#define NOCPM	'x'	/* no access to cpm	*/
#define TWIT	'X'	/* logout now !		*/


/**************************
 * user type parameters.. *
 **************************/

typedef	struct	{
	char type;	/* the character that gets this type 		*/
	char maxuser;	/* Max CP/M user number this guy gets, 0=nocpm	*/
	char timeout;	/* # of mins before no-typing timeout, 0=twit	*/
	char killflag;	/* Can he kill messages?			*/
	char zcprflag;	/* Does he get master CP/M privs? (with zcpr)	*/
	char readpriv;	/* Can he read private mail?			*/
	char postmsg;	/* can the guy post messages			*/
	char minutes;	/* minutes allowed on system (Metal/MBYE)	*/
	unsigned flags;	/* special flags for Z3 operations		*/
	char reserved[10];	/* space for more */
	} u_types;

/*********************************
 * clock stuff, don't change!!!! *
 *********************************/

#define NOCLOCK  0	/* no clock board at all */
#define COMPUPRO 1	/* using compupro clock  */
#define	HAYES	 2	/* using Hayes chronograph thing-a-ma-jig */
#define QX10	 3	/* using QX10 bios+45 clock routine */
#define CCS	 4	/* using CCS clock/terminator board */ 
#define KENMORE	 5	/* using Kenmore Computer Tech. clock board */


/****************************************************
 * All Options are contained in one large structure *
 ****************************************************/

struct options	{
	char	zippo[10];		/* mark start of options	*/
	u_types	user_types[9];		/* User types table		*/
	char	DSTATUS;		/* default user status (login init) */
	char	PRIVATE;		/* private system flag		*/
	   char	PRIVPASS[PASSLEN+1];	/* private system password	*/
	char	files[30][18];		/* file names/locations		*/
	char	MAXTRIES;		/* Max # of logon attempts	*/
	int	MAXMSGS;		/* Max # of ACTIVE msgs allowed	*/
	char	MAXMSGLINE;		/* Max length of msg line	*/
	int	MLINES;			/* Max # of lines		*/
	int	MAXTOTMSGS;		/* Max total active + dead msgs */
	char	RTC;			/* using clock???		*/
	   unsigned CLKCMD;		/* command/status port		*/
	   unsigned CLKDATA;		/* data port			*/
	   char	    CLKOMASK;		/* clock output status mask	*/
	   char	    CLKIMASK;		/* clock input status mask	*/
	   unsigned RDTA;		/* other clock parm		*/
	char	ASKNULLS;		/* if bye asks for nulls	*/
	char	ZCPR;			/* if using ZCPR		*/
	   char *SECURELOC;		/* location of zcpr wheel	*/ 
	char	*id_loc;		/* console id # value pointer	*/
	char	INITLENGTH;		/* initial terminal length	*/
	char	WHERE[81];		/* location of site		*/
	char	PRTLOG;			/* if using printer for log	*/
	char	STATUSLINE;		/* you have status line???	*/
	   char	TO25[16];		/* up to 15 chars to get there	*/
	   char	FROM25[16];		/* to get back to last position	*/
	   unsigned OSTAT;		/* Terminal output stat port	*/
	   unsigned ODATA;		/* Terminal data port		*/
	   char	OSMASK;			/* output status mask		*/
	char	SOFIRST[FNAMELEN+1];	/* sysop's first name		*/
	char	SOLAST[LNAMELEN+1];	/* sysop's last name		*/
	char	SOPASS[PASSLEN+1];	/* sysop password		*/
	char	expansion_room[38];
/* zappo to end this madness */
	char	zappo[10];		/* "KABOOM!!!"	EOO flag	*/
	};

/* global variables needing saving */

#ifndef HMLIB
#ifndef CONFIG
#ifdef Z3

/* Z3 command line buffer pointer below */

struct cmd_line {
	char *next_char;	/* Pointer to next char in buffer */
	char buf_size;		/* length of buffer (unused)	  */
	char char_cnt;		/* character count		  */
	char buffer[250];	/* buffer area..		  */
	} ;	/* command line pointer structure */

struct envptr {
	char	jmp[3];		/* skip over initial JMP instruction */
	char	id[5];		/* Id, usually Z3ENV		*/
	char	class;		/* 1=external, 2 internal	*/
	char	*expath;
	char	expaths;
/*	char	*rcp;
	char	rcps;
	char	*iop;
	char	iops;
	char	*fcp;
	char	fcps;
	char	*ndir;
	char	ndirs;
*/
   char t[12];
	struct cmd_line *cl;	/* command line pointer			*/
	char	cls;		/* # of bytes in cl			*/
/*	char	*env;	*/	/* ptr to external environment desc.	*/
/*	char	envs;	*/
/*	char	*shstk;	*/	/* shell stack				*/
/*	char	shstks;	*/	/* # of (shsize) stack entries		*/
/*	char	shsize;	*/	/* size of shell stack entry		*/
   char t1[7];
	char	*msg;		/* message buffer			*/
/*	char	*extfcb;
	char	*extstk;
	char	quiet;
*/
   char t2[5];
	char	*wheel;		/* secure mode wheel		*/
/*	char	speed;	*/	/* speed in mhz			*/
/*	char	maxdisk;
	char	maxuser;
*/
	} *z3env;

/* This header structure variable protects globals when doing an alias */

struct g_prot {
	char n0;		/* jmp */
	char *obdos;
	char msgsys[7];		/* "MSGSYS",0 */
	char *g_vars;		/* pointer to global variables */
/*	char bye_a1[32];	*/ /* bye data area */
	struct	{
		char jmp;
		char *addr;
		} bt[6];
	char swap;		/* push h */
	char n1;		/* lxi h  */
	char *prot_bdos;
	char n2;		/* shld 6 */
	char *n3;
	char n6;		/* pop h */
	char n7;		/* ret */
	struct	{
		char call;
		char *addr;
		char jmp;
		char *swapbdos;
		} abt[6];
	} g_h
#ifdef MAIN
	      = {
		0xc3,0000,"MSGSYS",0000,
			{ 0xc3,0000,
			  0xc3,0000,
			  0xc3,0000,
			  0xc3,0000,
			  0xc3,0000,
			  0xc3,0000 },
		0xe5,0x21,0000,0x22,0006,0xe1,0xc9,
			{ 0xcd,0000,0xc3,0000,
			  0xcd,0000,0xc3,0000,
			  0xcd,0000,0xc3,0000,
			  0xcd,0000,0xc3,0000,
			  0xcd,0000,0xc3,0000,
			  0xcd,0000,0xc3,0000 }
		}
#endif	/* MAIN */
;

struct g_prot *z3_hp;	/* loc to put this at */

struct g_save {
	char	*msg;
	char	glbstr[MAXLINE+2];
	int	strloc;
	int	globalchar;
	char	print_flag;	/* flag for print mode */
	char	echo_flag;	/* flag for "half-dup" non echo.. */
	char	sepstr;
	unsigned fmsg,lmsg;
	int	mindex;
	int	msgcount;
	int	privmsgs;
	unsigned nextmsg,totalmsgs;
	unsigned callnum;
	char	date[DATELEN];
	char	time[TIMELEN];
	char	height;
	char	last_date[DATELEN];
	char	last_time[TIMELEN];
	struct	cmd_line cmdbuf;  /* place to save current z3 cmd buffer */
	char	path[24];	  /* allow for 12 path entries */
	};

#endif /* Z3 */
#endif /* NOT-CONFIG */
#endif /* HMLIB */

/* EOF (HMH.H) */


