/*
 *
 * @(#)cvt.h	4.4 dated 1/29/84      Tektronix 8560 Unix System Kernel
 *
 *	Copyright C, 1981, Tektronix Inc.
 *	All rights Reserved
 */


/*
 * The Configuration Variable Table, (CVT for compatability of course)
 * is initialized by the boot system in conjunction with main.c
 * (eventually all will be in the boot system).
 *
 * Pointed to by a pointer at CVT_LOC (see the comments below).
 */

#ifndef KERNEL /* kernel already knows these things */
#define CVT_LOC 050

struct cvt_ptr {		/* this is at location CVT_LOC */
	unsigned cp_cvt;	/* pointer to real CVT */
	unsigned cp_kend;	/* end of kernel instruction/data memory */
	unsigned cp_end; 	/* end of used memory */
};
#endif

struct cvt {			/* this is at location CVT_LOC->cp_cvt */
	unsigned	c_nbuf;		/* total number of I/O buffers */
	unsigned	c_sbuf;		/* size of a buffer entry */
	struct buf	*c_buf;		/* start of buf table */
	struct buf	*c_ebuf;	/* end of buf table */

	char		*c_bstart;	/* start of actual in-kernel buffers */
	unsigned	c_iocache;	/* number of buffers not in low kernel*/

	unsigned	c_ninode;	/* number of inodes */
	unsigned	c_sinode;	/* size of an inode entry */
	struct inode	*c_inode;	/* start of inode table */
	struct inode	*c_einode;	/* end of inode table */

	unsigned	c_nfile;	/* number of file table entries */
	unsigned	c_sfile;	/* size of a file table entry */
	struct file	*c_file;	/* start of file table */
	struct file	*c_efile;	/* end of file table */

	unsigned	c_nproc;	/* number of process table entries */
	unsigned	c_sproc;	/* size of a process table entry */
	struct proc	*c_proc;	/* start of proc table */
	struct proc	*c_eproc;	/* end of proc table */

	unsigned	c_nmount;	/* number of mountable filesystems */
	unsigned	c_smount;	/* size of a mount table entry */
	struct mount	*c_mount;	/* start of mount table */
	struct mount	*c_emount;	/* end of mount table */

	unsigned	c_ntext;	/* number of text table entries */
	unsigned	c_stext;	/* size of a text table entry */
	struct text	*c_text;	/* start of text table */
	struct text	*c_etext;	/* end of text table */

	unsigned	c_nsmap;	/* number of swapmap table entries */
	unsigned	c_ssmap;	/* size of a swapmap table entry */
	struct map	*c_smap;	/* start of swapmap table */
	struct map	*c_esmap;	/* end of swapmap table */

	unsigned	c_ncmap;	/* number of coremap table entries */
	unsigned	c_scmap;	/* size of a coremap table entry */
	struct map	*c_cmap;	/* start of coremap table */
	struct map	*c_ecmap;	/* end of coremap table */

	dev_t		rootdev;	/* root device (major/minor) */
	dev_t		swapdev;	/* swap device (major/minor) */
	dev_t		pipedev;	/* pipe device (major/minor) */

	unsigned	nswap;		/* amount of swap space */
	daddr_t		swplo;		/* location of swap space */

	time_t		c_time;		/* system time of day */
	char		tz_name[4];	/* time zone name (3 char plus null) */
	char		tz_dayname[4];	/* daylight time zone name */
	short		tz_offgmt;	/* minutes west of GMT */
	short		tz_flag;	/* time zone flags */
					/* bit 0: 1 --> daylight time in effect (US rules) */

	unsigned	maxmem;		/* maximum user process memory (clicks) */
	unsigned	mem_start;	/* start of user memory (clicks) */
	unsigned	mem_end;	/* end of user memory (clicks) */

	char	*c_pmsg;	/* pointer into buffer */
	char	*c_msgbuf;	/* start of msg buffer */
	char	*c_emsgbuf;	/* end of msg buffer */

	struct IO_Info {	/* buffer cache profiling (bio.c) */
		long	nread;	/* # blocks read */
		long	nreada;	/* # blocks read ahead */
		long	ncache;	/* # blocks found in cache */
		long	nwrite;	/* # blocks written */
		long	*bufcount; /* # free cache blocks (histogram) */
	} io_info;
#ifdef TIMMING
	struct timeblk	*tmblk;	/* pointer to timeblk struct for timing info */
#endif
};

#ifdef KERNEL
extern struct cvt cvt; /* the real cvt gets declared here */
#endif
