/*
 * Tektronix 8560 Unix System Kernel
 *
 *	Based on Western Electric Version 7 Unix
 *
 *	Tektronix Modifications from Western Electric code
 *	Copyright C, 1981, Tektronix Inc.
 *	All rights Reserved
 */

#ifdef SCCSID
/*static char *sccsid = "@(#)tiop.h	4.3 dated 9/30/83	Tektronix 8560 Unix";*/
#endif
/*
 * A tiop(old tty) structure is needed for
 * each UNIX character device that
 * is used for normal terminal IO.
 * The routines in iop.c handle the
 * common code associated with
 * these structures.
 */

struct tc {
	char	t_intrc;	/* interrupt */
	char	t_quitc;	/* quit */
	char	t_startc;	/* start output */
	char	t_stopc;	/* stop output */
	char	t_eofc;		/* end-of-file */
	char	t_brkc;		/* input delimiter (like nl) */
};

struct tiop
{
	dev_t	t_dev;		/* device number */
	short	t_flags;	/* mode, settable by ioctl call */
	short	t_state;	/* internal state, not visible externally */
	short	t_pgrp;		/* process group name */
	char	t_erase;	/* erase character */
	char	t_kill;		/* kill character */
	char	t_char;		/* character temporary */
	char	t_ispeed;	/* input speed */
	struct tc t_un;
};

#define	tun	tp->t_un

/*
 * structure of arg for ioctl
 */
struct sgttyb {
	char	sg_ispeed;
	char	sg_ospeed;
	char	sg_erase;
	char 	sg_kill;
	int	sg_flags;
};


#define	TTIPRI	28
#define	TTOPRI	29

#define	CERASE	'\b'		/* default special characters */
#define	CEOT	004		/* EOT, cntl D */
#define	CKILL	025		/* NAK, cntl U */
#define	CQUIT	034		/* FS, cntl shift L */
#define	CINTR	003		/* ETX, cntl C */
#define	CSTOP	023		/* Stop output: ctl-s */
#define	CSTART	021		/* Start output: ctl-q */
#define	CBRK	0377		/* additional break character */
#define	CFLUSH	017		/* SI, control O */
#define	CSTATUS	0377		/* DC4, control T (eventually) */


/*
 * Speeds
 */
#define B0	0
#define B300	7
#define B600	8
#define B1200	9
#define B2400	11
#define B4800	12
#define B9600	13

/* modes */
#define TANDEM	03		/* tandem is a mask	*/
#define XONXOF	01

#ifdef KERNEL			/* the IOP f/w (or h/w) flips the sense of    */
#define DTR	02		/* DTR and CTS. The kernel doesn't know about */
#else				/* this, but user programs and commands do.   */
#define DTR	0400		/* So the flip gets flopped correctly, we     */
#endif				/* exchange DTR & CTSFLG for user progs only. */

#define	CBREAK	04
#define	ECHO	010
#define	CRMOD	020
#define	RAW	040
#define	XTABS	0100
#define ARESM	0200


#ifdef KERNEL			/* same deal as for DTR			      */
#define CTSFLG	0400
#else
#define CTSFLG	02
#endif

#define IPRTY	07000
#define INOCAR	0
#define IEVEN	01000
#define IODD	02000
#define INOP	03000
#define IMARK	04000
#define IDATA	05000
#define OPRTY	070000
#define ONOCAR	0
#define OEVEN	010000
#define OODD	020000
#define ONOP	030000
#define OMARK	040000
#define ODATA	050000
#define CHNGED	0100000


/*
 * Old tty modes
 */
#define	OTANDEM		01
#define	OCBREAK		02
#define	OLCASE		04
#define	OECHO		010
#define	OCRMOD		020
#define	ORAW		040
#define	OODDP		0100
#define	OEVENP		0200
#define OANYP		0300
#define	ONLDELAY	001400
#define	OTBDELAY	006000
#define	OXTABS		06000
#define	OCRDELAY	030000
#define	OVTDELAY	040000
#define OBSDELAY 	0100000
#define OALLDELAY 	0177400


/* Internal state bits */
#define	WOPEN	02		/* Waiting for open to complete */
#define	ISOPEN	04		/* Device is open */
#define	XCLUDE	0200		/* exclusive-use flag against open */
#define	HUPCLS	01000		/* Hang up upon last close */



/*
 * tty ioctl commands
 */
#define	FIOCLEX		(('f'<<8)|1)
#define	FIONCLEX	(('f'<<8)|2)
#define	TIOCHPCL	(('t'<<8)|2)
#define	TIOCGETP	(('t'<<8)|8)
#define	TIOCSETP	(('t'<<8)|9)
#define	TIOCSETN	(('t'<<8)|10)
#define	TIOCEXCL	(('t'<<8)|13)
#define	TIOCNXCL	(('t'<<8)|14)
#define	TIOCFLUSH	(('t'<<8)|16)
#define	TIOCSETC	(('t'<<8)|17)
#define	TIOCGETC	(('t'<<8)|18)
#define	TIOTGET		(('t'<<8)|22)
#define	TIOTSET		(('t'<<8)|23)
#define	TIOAIU		(('t'<<8)|24)
#define	TIOPGETP	(('t'<<8)|25)
#define	TIOPSETP	(('t'<<8)|26)
#define	TIOPSETN	(('t'<<8)|27)
#define TIOCNHPCL	(('t'<<8)|28)
#define TIONIU		(('t'<<8)|29)


/* Read status states	*/
#define R_IDLE		0	/* no reads pending		*/
#define R_0OUT		1	/* 0 byte read outstanding	*/
#define R_0DONE		2	/* 0 byte read done		*/
#define R_NOUT		3	/* n byte read outstanding	*/

/* Response values	*/
#define RES_R0		0	/* for read 0 request		*/
#define RES_RN		2	/* for read n request		*/
#define RES_OTHR	4	/* for other requests		*/
#define RES_OPEN	6	/* for open modem request	*/
