$$INIT	$MACRO	;INITIALIZATION MACRO USED BY ASSEMBLER
	$ENDM	$$INIT

@@V2@@	$MACRO
	$DSABL	F87
	$ENDM	@@V2@@

@PLIB	$MACRO	P1,P2,P3,P4,P5,P6,P7,P8
;THIS MACRO IS USED BY PASCAL RUNTIME SUPPORT ROUTINES
;HEADER DECLARATIONS FOR EACH MODULE
	 $ENABL	GBL
@HEAP	EQU	2
@LINE	EQU	0
_CVTBUF	EQU	50
_LASTP	EQU	4
_HIGHP	EQU	6
	 $IFC	NB,P1		;ALLOW FOR HEADER IN MODULE
	 $NAME	P1
	 $CSEG
@@LIB	 $GROUP	@@@CSG
	 $IRP	P,<P1,P2,P3,P4,P5,P6,P7,P8>
	 $IIFC	NB,P,	$PUBLIC	P
	 $ENDR
	 $ENDC
;MACROS USED BY THREAD ROUTINES
INCVT	$MACRO	A1,A2
	$IRP	ARG,<A1,A2>
	$IFC	IDN,ARG,AX
	RCL	AX,1
	RCRB	AL,1
	XCHGB	AH,AL
	$ENDC
	$IFC	IDN,ARG,BX
	RCL	BX,1
	RCRB	BL,1
	XCHGB	BH,BL
	$ENDC
	$ENDR
	$ENDM	INCVT
OUTCVT	$MACRO	RESULT,NEG
	$IIFC	DIF,RESULT,AX	BAD NEWS
	XCHGB	AH,AL
	RCLB	AL,1
	RCL	NEG,1
	RCR	AX,1
	XCHG	AX,DX
	$ENDM	OUTCVT

POPN	$MACRO	A1,A2,A3,A4,A5,A6,A7,A8
	 $IRP	A,<A1,A2,A3,A4,A5,A6,A7,A8>
	 $IFC	NB,A
	 POP	A
	 $ENDC
	 $ENDR
	$ENDM	POPN
PUSHN	$MACRO	A1,A2,A3,A4,A5,A6,A7,A8
	 $IRP	A,<A1,A2,A3,A4,A5,A6,A7,A8>
	 $IFC	NB,A
	 PUSH	A
	 $ENDC
	 $ENDR
	$ENDM	PUSHN
JC	$MACRO	DEST
	 JB	DEST
	$ENDM	JC
JNC	$MACRO	DEST
	 JAE	DEST
	$ENDM	JNC
	$ENDM	@PLIB

@LIB	$MACRO	P1,P2,P3,P4,P5,P6,P7,P8
;THIS MACRO IS USED BY FORTRAN RUNTIME SUPPORT ROUTINES
;HEADER DECLARATIONS FOR EACH MODULE
	 $ENABL	GBL
	 $IFC	NB,P1		;ALLOW FOR HEADER IN MODULE
	 $NAME	P1
	 $CSEG
@@LIB	 $GROUP	@@@CSG
	 $IRP	P,<P1,P2,P3,P4,P5,P6,P7,P8>
	 $IIFC	NB,P,	$PUBLIC	P
	 $ENDR
	 $ENDC
;MACROS USED BY THREAD ROUTINES
INCVT	$MACRO	A1,A2
	$IRP	ARG,<A1,A2>
	$IFC	IDN,ARG,AX
	XCHG	AX,DX
	RCL	AX,1
	RCRB	AL,1
	XCHGB	AH,AL
	$ENDC
	$IFC	IDN,ARG,BX
	XCHG	BX,CX
	RCL	BX,1
	RCRB	BL,1
	XCHGB	BH,BL
	$ENDC
	$ENDR
	$ENDM	INCVT
OUTCVT	$MACRO	RESULT,NEG
	$IIFC	DIF,RESULT,AX	BAD NEWS
	XCHGB	AH,AL
	RCLB	AL,1
	RCL	NEG,1
	RCR	AX,1
	XCHG	AX,DX
	$ENDM	OUTCVT
POPN	$MACRO	A1,A2,A3,A4,A5,A6,A7,A8
	 $IRP	A,<A1,A2,A3,A4,A5,A6,A7,A8>
	 $IFC	NB,A
	 POP	A
	 $ENDC
	 $ENDR
	$ENDM	POPN
PUSHN	$MACRO	A1,A2,A3,A4,A5,A6,A7,A8
	 $IRP	A,<A1,A2,A3,A4,A5,A6,A7,A8>
	 $IFC	NB,A
	 PUSH	A
	 $ENDC
	 $ENDR
	$ENDM	PUSHN
FCALL	$MACRO	SUBNAM
	 PUSHN	DS,SI,ES,BP
	 MOV	AX,SS
	 MOV	DS,AX		;ASSUME PARAM LIST ON STACK
	 MOV	SI,BP
	 CALLS	SUBNAM		;CALL INTRINSIC/FORMATTER ROUTINE
	 POPN	BP,ES,SI,DS
	$ENDM	FCALL
FCALLI	$MACRO	SUBNAM
	 PUSHN	DS,SI,ES,BP
	 MOV	AX,SS
	 MOV	DS,AX		;ASSUME PARAM LIST ON STACK
	 MOV	SI,BP
	 CALLSI	SUBNAM
	 POPN	BP,ES,SI,DS
	$ENDM	FCALLI
JC	$MACRO	DEST
	 JB	DEST
	$ENDM	JC
JNC	$MACRO	DEST
	 JAE	DEST
	$ENDM	JNC
	$ENDM	@LIB

	
@@V1A@	$MACRO
;THIS MACRO IMPLEMENTS THE INSTRUCTION SET RECOGNIZED BY THE
; VERSION 1A MICROBENCH 8086 ASSEMBLER.
	 MODE	NONE
CMPB	$MACRO	P1,P2
	 $ENABL	OPC
	 $IFC	NB,P1
	 CMPB	P1,P2
	 $IFF
	 CMPSB
	 $ENDC
	 $DSABL	OPC
	$ENDM	CMPB
CMPW	$MACRO
	 CMPS
	$ENDM	CMPW
ESC	$MACRO	MEM
	 $ENABL	OPC
	 ESC	0,MEM
	 $DSABL	OPC
	$ENDM	ESC
IN	$MACRO	SRC
	 INB	AL,SRC
	$ENDM	IN
INW	$MACRO	SRC
	 $ENABL	OPC
	 IN	AX,SRC
	 $DSABL	OPC
	$ENDM	INW
LODB	$MACRO
	 LODSB
	$ENDM	LODB
LODW	$MACRO
	 LODS
	$ENDM	LODW
MOVB	$MACRO	P1,P2
	 $ENABL	OPC
	 $IFC	NB,P1
	 MOVB	P1,P2
	 $IFF
	 MOVSB
	 $ENDC
	 $DSABL	OPC
	$ENDM	MOVB
MOVW	$MACRO
	 MOVS
	$ENDM	MOVW
OUT	$MACRO	DEST
	 OUTB	DEST,AL
	$ENDM	OUT
OUTW	$MACRO	DEST
	 $ENABL	OPC
	 OUT	DEST,AX
	 $DSABL	OPC
	$ENDM	OUTW
RCL	$MACRO	EFF
	 $ENABL	OPC
	 RCL	EFF,1
	 $DSABL	OPC
	$ENDM	RCL
RCLB	$MACRO	EFF
	 $ENABL	OPC
	 RCLB	EFF,1
	 $DSABL	OPC
	$ENDM	RCLB
RCLV	$MACRO	EFF
	 $ENABL	OPC
	 RCL	EFF,CL
	 $DSABL	OPC
	$ENDM	RCLV
RCLVB	$MACRO	EFF
	 $ENABL	OPC
	 RCLB	EFF,CL
	 $DSABL	OPC
	$ENDM	RCLVB
RCR	$MACRO	EFF
	 $ENABL	OPC
	 RCR	EFF,1
	 $DSABL	OPC
	$ENDM	RCR
RCRB	$MACRO	EFF
	 $ENABL	OPC
	 RCRB	EFF,1
	 $DSABL	OPC
	$ENDM	RCRB
RCRV	$MACRO	EFF
	 $ENABL	OPC
	 RCR	EFF,CL
	 $DSABL	OPC
	$ENDM	RCRV
RCRVB	$MACRO	EFF
	 $ENABL	OPC
	 RCRB	EFF,CL
	 $DSABL	OPC
	$ENDM	RCRVB
ROL	$MACRO	EFF
	 $ENABL	OPC
	 ROL	EFF,1
	 $DSABL	OPC
	$ENDM	ROL
ROLB	$MACRO	EFF
	 $ENABL	OPC
	 ROLB	EFF,1
	 $DSABL	OPC
	$ENDM	ROLB
ROLV	$MACRO	EFF
	 $ENABL	OPC
	 ROL	EFF,CL
	 $DSABL	OPC
	$ENDM	ROLV
ROLVB	$MACRO	EFF
	 $ENABL	OPC
	 ROLB	EFF,CL
	 $DSABL	OPC
	$ENDM	ROLVB
ROR	$MACRO	EFF
	 $ENABL	OPC
	 ROR	EFF,1
	 $DSABL	OPC
	$ENDM	ROR
RORB	$MACRO	EFF
	 $ENABL	OPC
	 RORB	EFF,1
	 $DSABL	OPC
	$ENDM	RORB
RORV	$MACRO	EFF
	 $ENABL	OPC
	 ROR	EFF,CL
	 $DSABL	OPC
	$ENDM	RORV
RORVB	$MACRO	EFF
	 $ENABL	OPC
	 RORB	EFF,CL
	 $DSABL	OPC
	$ENDM	RORVB
SAL	$MACRO	EFF
	 $ENABL	OPC
	 SAL	EFF,1
	 $DSABL	OPC
	$ENDM	SAL
SALB	$MACRO	EFF
	 $ENABL	OPC
	 SALB	EFF,1
	 $DSABL	OPC
	$ENDM	SALB
SALV	$MACRO	EFF
	 $ENABL	OPC
	 SAL	EFF,CL
	 $DSABL	OPC
	$ENDM	SALV
SALVB	$MACRO	EFF
	 $ENABL	OPC
	 SALB	EFF,CL
	 $DSABL	OPC
	$ENDM	SALVB
SAR	$MACRO	EFF
	 $ENABL	OPC
	 SAR	EFF,1
	 $DSABL	OPC
	$ENDM	SAR
SARB	$MACRO	EFF
	 $ENABL	OPC
	 SARB	EFF,1
	 $DSABL	OPC
	$ENDM	SARB
SARV	$MACRO	EFF
	 $ENABL	OPC
	 SAR	EFF,CL
	 $DSABL	OPC
	$ENDM	SARV
SARVB	$MACRO	EFF
	 $ENABL	OPC
	 SARB	EFF,CL
	 $DSABL	OPC
	$ENDM	SARVB
SCAB	$MACRO
	 SCASB
	$ENDM	SCAB
SCAW	$MACRO
	 SCAS
	$ENDM	SCAW
SHL	$MACRO	EFF
	 $ENABL	OPC
	 SHL	EFF,1
	 $DSABL	OPC
	$ENDM	SHL
SHLB	$MACRO	EFF
	 $ENABL	OPC
	 SHLB	EFF,1
	 $DSABL	OPC
	$ENDM	SHLB
SHLV	$MACRO	EFF
	 $ENABL	OPC
	 SHL	EFF,CL
	 $DSABL	OPC
	$ENDM	SHLV
SHLVB	$MACRO	EFF
	 $ENABL	OPC
	 SHLB	EFF,CL
	 $DSABL	OPC
	$ENDM	SHLVB
SHR	$MACRO	EFF
	 $ENABL	OPC
	 SHR	EFF,1
	 $DSABL	OPC
	$ENDM	SHR
SHRB	$MACRO	EFF
	 $ENABL	OPC
	 SHRB	EFF,1
	 $DSABL	OPC
	$ENDM	SHRB
SHRV	$MACRO	EFF
	 $ENABL	OPC
	 SHR	EFF,CL
	 $DSABL	OPC
	$ENDM	SHRV
SHRVB	$MACRO	EFF
	 $ENABL	OPC
	 SHRB	EFF,CL
	 $DSABL	OPC
	$ENDM	SHRVB
STOB	$MACRO
	 STOSB
	$ENDM	STOB
STOW	$MACRO
	 STOS
	$ENDM	STOW
STKLN	$MACRO	EXPR
	 $DSEG	STACK
	 $ORG	0
	 $PUBLIC	STACK
STACK	 $SET	$+EXPR
	 $ASEG
	$ENDM	STKLN
$STKLN	$MACRO	EXPR
	 $DSEG	STACK
	 $ORG	0
	 $PUBLIC	STACK
STACK	 $SET	$+EXPR
	 $ASEG
	$ENDM	$STKLN

	$ENDM	@@V1A@
 ;+
; FILE NAME:
;	ma8086.sml
;
; PURPOSE:
;	System macro library.
;
; DESCRIPTION:
;	Author:		FELARCA
;	Version:	1sep85
;	UNCLASSIFIED
;-

;+
; MACRO NAME:
;	_CLRMB
;
; PURPOSE:
;	Clear bits in the specified memory byte.
;
; DESCRIPTION:
;	Author:		FELARCA
;	Version:	1sep85
;	UNCLASSIFIED
;
; CALLING SEQUENCE:
;	_CLRMB	MEMB,MASK
; where,
;	MEMB: in BYTE, memory byte to be cleared
;	MASK: in BYTE, mask of bits to be cleared
;-

_CLRMB	MACRO	MEMB,MASK

	MOVB	AL,MASK
	NOTB	AL
	ANDB	MEMB,AL
		
	ENDM	_CLRMB

;+
; MACRO NAME:
;	_CLRMST
;
; PURPOSE:
;	Clear bit in the specified byte of the MADS statua table.
;
; DESCRIPTION:
;	Author:		FELARCA
;	Version:	18sep85
;	UNCLASSIFIED
;
; CALLING SEQUENCE:
;	_CLRMST	BYTE,BIT
; where,
;	BYTE: in BYTE, MST byte to be cleared
;	BIT: in BYTE, mask of bit to be cleared
;-

_CLRMST	MACRO	BYTE,BIT

	MOVB	AL,BIT
	NOTB	AL
	ANDB	ZT_MST+BYTE,AL
	CALLS	SU_HIST

	ENDM	_CLRMST

;+
; MACRO NAME:
;	_CLRRB
;
; PURPOSE:
;	Clear the specified bit(s) in the specified register.
;
; DESCRIPTION:
;	Author:		FELARCA
;	Version:	1sep85
;	UNCLASSIFIED
;
; CALLING SEQUENCE:
;	_CLRRB	REG,MASK
; where,
;	REG: in WORD, I/O map address of hardware register
;	MASK: in BYTE, bits to be cleared
;-

_CLRRB	MACRO	REG,MASK

	MOV	DX,REG
	INB	AL,DX
	MOVB	BL,MASK
	NOTB	BL
	ANDB	AL,BL
	OUTB	DX,AL

	ENDM	_CLRRB

;+
; MACRO NAME:
;	_CLRR
;
; PURPOSE:
;	Clear the specified bit(s) in the specified register.
;
; DESCRIPTION:
;	Author:		FELARCA
;	Version:	1sep85
;	UNCLASSIFIED
;
; CALLING SEQUENCE:
;	_CLRR	REG,MASK
; where,
;	REG: in WORD, I/O map address of hardware register
;	MASK: in WORD, bits to be cleared
;-

_CLRR	MACRO	REG,MASK

	MOV	DX,REG
	IN	AX,DX
	MOV	BX,MASK
	NOT	BX
	AND	AX,BX
	OUT	DX,AX
	
	ENDM	_CLRR

;+
; MACRO NAME:
;	_CLRTST
;
; PURPOSE:
;	Clear OS test mode.
;
; DESCRIPTION:
;	Author:		FELARCA
;	Version:	12sep85
;	UNCLASSIFIED
;
; CALLING SEQUENCE:
;	_CLRTST
; where,
;	DS: points to SBRAM
;	ES: points to SBPROM
;-

_CLRTST	MACRO

	MOV	AX,ES:ZC_PGMID
	MOV	ZV_PGMID,AX
	MOV	AX,ES:ZC_PGMID+2
	MOV	ZV_PGMID+2,AX

	ENDM	_CLRTST

;+
; MACRO NAME:
;	_GETRB
;
; PURPOSE:
;	Read the contents of the specified register.
;
; DESCRIPTION:
;	Author:		FELARCA
;	Version:	1sep85
;	UNCLASSIFIED
;
; CALLING SEQUENCE:
;	_GETRB	REG
; where,
;	REG: in WORD, I/O map address of hardware register
;-

_GETRB	MACRO	REG

	MOV	DX,REG
	INB	AL,DX

	ENDM	_GETRB

;+
; MACRO NAME:
;	_GETR
;
; PURPOSE:
;	Read the contents of the specified register.
;
; DESCRIPTION:
;	Author:		FELARCA
;	Version:	1sep85
;	UNCLASSIFIED
;
; CALLING SEQUENCE:
;	_GETR	REG
; where,
;	REG: in WORD, I/O map address of hardware register
;-

_GETR	MACRO	REG

	MOV	DX,REG
	IN	AX,DX
	
	ENDM	_GETR

;+
; MACRO NAME:
;	_IFTST
;
; PURPOSE:
;	Determine if OS in test mode.
;
; DESCRIPTION:
;	Author:		FELARCA
;	Version:	12sep85
;	UNCLASSIFIED
;
; CALLING SEQUENCE:
;	_IFTST	LABEL
; where,
;	LABEL: destination if condition is TRUE (OS in test mode)
;	DS: points to SBRAM
;	ES: points to SBPROM
;-

_IFTST	MACRO	LABEL

	MOV	AX,ZV_PGMID
	CMP	AX,ES:ZC_PGMID
	JNE	LABEL
	MOV	AX,ZV_PGMID+2
	CMP	AX,ES:ZC_PGMID+2
	JNE	LABEL

	ENDM	_IFTST

;+
; MACRO NAME:
;	_LDSEG
;
; PURPOSE:
;	Load a segment register
;
; DESCRIPTION:
;	Author:		FELARCA
;	Version:	1sep85
;	UNCLASSIFIED
;
; CALLING SEQUENCE:
;	_LDSEG	SEG,DATA
; where,
;	SEG: in WORD, segment register name
;	DATA: in WORD, value to be loaded
;-
_LDSEG	MACRO	SEG,DATA

	MOV	AX,DATA
	MOV	SEG,AX

	ENDM	_LDSEG

_POPN	MACRO	A1,A2,A3,A4,A5,A6,A7,A8
	IRP	A,<A1,A2,A3,A4,A5,A6,A7,A8>
	IFC	NB,A
	POP	A
	ENDC
	ENDR
	ENDM	_POPN

;+
; MACRO NAME:
;	_POPSEG
;
; PURPOSE:
;	Pop the DS and ES registers from stack.
;
; DESCRIPTION:
;	Author:		FELARCA
;	Version:	1sep85
;	UNCLASSIFIED
;
; CALLING SEQUENCE:
;	_POPSEG
;-

_POPSEG	MACRO

	POP	ES
	POP	DS

	ENDM	_POPSEG

;+
; MACRO NAME:
;	_PSHSEG
;
; PURPOSE:
;	Push the DS and ES registers.
;
; DESCRIPTION:
;	Author:		FELARCA
;	Version:	1sep85
;	UNCLASSIFIED
;
; CALLING SEQUENCE:
;	_PSHSEG
;-

_PSHSEG	MACRO

	PUSH	DS
	PUSH	ES

	ENDM	_PSHSEG

_PUSHN	MACRO	A1,A2,A3,A4,A5,A6,A7,A8
	IRP	A,<A1,A2,A3,A4,A5,A6,A7,A8>
	IFC	NB,A
	PUSH	A
	ENDC
	ENDR
	ENDM	_PUSHN

;+
; MACRO NAME:
;	_PUTR
;
; PURPOSE:
;	Write the specified data to the specified register
;
; DESCRIPTION:
;	Author:		FELARCA
;	Version:	1sep85
;	UNCLASSIFIED
;
; CALLING SEQUENCE:
;	_PUTR	REG,DATA
; where,
;	REG: in WORD, I/O map address of hardware register
;	DATA: in WORD, data to be written
;-

_PUTR	MACRO	REG,DATA

	IFC	NB,REG
	MOV	DX,REG
	ENDC
	MOV	AX,DATA
	OUT	DX,AX
	
	ENDM	_PUTR
	
;+
; MACRO NAME:
;	_PUTRB
;
; PURPOSE:
;	Write the specified data byte to the specified register
;
; DESCRIPTION:
;	Author:		FELARCA
;	Version:	1sep85
;	UNCLASSIFIED
;
; CALLING SEQUENCE:
;	_PUTRB	REG,DATA
; where,
;	REG: in WORD, I/O map address of hardware register
;	DATA: in BYTE, data to be written
;-

_PUTRB	MACRO	REG,DATA

	IFC	NB,REG
	MOV	DX,REG
	ENDC
	MOVB	AL,DATA
	OUTB	DX,AL
	
	ENDM	_PUTRB

;+
; MACRO NAME:
;	_SETMST
;
; PURPOSE:
;	Set bit in the specified byte of the MADS statua table.
;
; DESCRIPTION:
;	Author:		FELARCA
;	Version:	18sep85
;	UNCLASSIFIED
;
; CALLING SEQUENCE:
;	_SETMST	BYTE,BIT
; where,
;	BYTE: in BYTE, MST byte to be set
;	BIT: in BYTE, mask of bit to be set
;-

_SETMST	MACRO	BYTE,BIT

	ORB	ZT_MST+BYTE,BIT
	CALLS	SU_HIST

	ENDM	_SETMST

;+
; MACRO NAME:
;	_SETRB
;
; PURPOSE:
;	Set the specified bits in the specified register.
;
; DESCRIPTION:
;	Author:		FELARCA
;	Version:	1sep85
;	UNCLASSIFIED
;
; CALLING SEQUENCE:
;	_SETRB	REG,MASK
; where,
;	REG: in WORD, I/O map address of hardware register
;	MASK: in BYTE, bits to be set
;-

_SETRB	MACRO	REG,MASK

	MOV	DX,REG
	INB	AL,DX
	ORB	AL,MASK
	OUTB	DX,AL

	ENDM	_SETRB

;+
; MACRO NAME:
;	_SETR
;
; PURPOSE:
;	Set the specified bits in the specified register.
;
; DESCRIPTION:
;	Author:		FELARCA
;	Version:	1sep85
;	UNCLASSIFIED
;
; CALLING SEQUENCE:
;	_SETR	REG,MASK
; where,
;	REG: in WORD, I/O map address of hardware register
;	MASK: in WORD, bits to be set
;-

_SETR	MACRO	REG,MASK

	MOV	DX,REG
	IN	AX,DX
	OR	AX,MASK
	OUT	DX,AX
	
	ENDM	_SETR

;+
; MACRO NAME:
;	_SETTST
;
; PURPOSE:
;	Set OS test mode.
;
; DESCRIPTION:
;	Author:		FELARCA
;	Version:	12sep85
;	UNCLASSIFIED
;
; CALLING SEQUENCE:
;	_SETTST
; where,
;	DS: points to SBRAM
;-

_SETTST	MACRO

	MOV	ZV_PGMID,#-1
	MOV	ZV_PGMID+2,#-1

	ENDM	_SETTST

;+
; MACRO NAME:
;	_TRACER
;
; PURPOSE:
;	Invoke TRACER
;
; DESCRIPTION:
;	Author:		FELARCA
;	Version:	1sep85
;	UNCLASSIFIED
;
; CALLING SEQUENCE:
;	_TRACER	FCODE
; where,
;	FCODE: in WORD, function code
;-

_TRACER	MACRO	FCODE

	MOV	AX,FCODE
	INT	ZI_TRACER
	
	ENDM	_TRACER

;+
; MACRO NAME:
;	_VRTX
;
; PURPOSE:
;	Invoke VRTX
;
; DESCRIPTION:
;	Author:		FELARCA
;	Version:	1sep85
;	UNCLASSIFIED
;
; CALLING SEQUENCE:
;	_VRTX	FCODE
; where,
;	FCODE: in WORD, function code
;-

_VRTX	MACRO	FCODE

	MOV	AX,FCODE
	INT	ZI_VRTX
	
	ENDM	_VRTX
