C$CONTROL LARGE,RENAME,ALIST,ROM
	SUBROUTINE FIOCS(IFUNC,ILU,IBUF,ILEN,ISTAT,IREC,INAME,ICHARS)
	CHARACTER*24 INAME
	CHARACTER*1 IBUF(*)
C  A SIMPLE IMPLEMENTATION OF THE FORTRAN IO CONTROL SYSTEM 
C
C  THE FORTRAN I/O CONTROL SYSTEM IS RESPONSIBLE FOR ALL INTERACTION 
C  BETWEEN A FORTRAN PROGRAM AND THE INPUT/OUTPUT AND FILE MANIPULATION
C  ON THE HOST MACHINE.  FIOCS MAINTAINS INFORMATION ABOUT ALL FORTRAN
C  LOGICAL UNITS AND IS CALLED TO TRANSFER RECORDS OF DATA TO AND FROM
C  THE PHYSICAL UNITS CONNECTED TO FORTRAN LOGICAL UNITS.  THE IMPLEMENTATION
C  OF FIOCS IS MACHINE DEPENDENT AND MAY TAKE ADVANTAGE OF AN ALREADY 
C  EXISTING OPERATING SYSTEM ON THE HOST MACHINE.  HOWEVER, THE FORTRAN
C  SYSTEM INTERFACE TO FIOCS IS WELL DEFINED AND CONSISTS OF A STANDARD
C  FORTRAN CALL TO THE ROUTINE FIOCS WITH SOME OR ALL OF THE ABOVE
C  PARAMETERS.  THE DEFINITION OF THESE PARAMETERS IS AS FOLLOWS:
C
C	IFUNC-AN INTEGER FUNCTION CODE (ADDITION OF 128 SIGNIFIES WITH WAIT)
C		1--INITIALIZE I/O
C		2--TERMINATE ALL I/O (E.G. CLOSE ANY OPEN FILES)
C		3--BACKSPACE FILE
C		4--REWIND FILE
C		5--WRITE END OF FILE
C		6--FORMATTED READ SEQUENTIAL
C		7--UNFORMATTED READ SEQUENTIAL
C		8--FORMATTED WRITE SEQUENTIAL
C		9--UNFORMATTED WRITE SEQUENTIAL
C		10-OPEN A DIRECT ACCESS FILE
C		11-DIRECT ACCESS READ
C		12-RETURN RECORD SIZE OF DIRECT ACCESS FILE
C		13-DIRECT ACCESS WRITE
C	ILU-AN INTEGER LOGICAL UNIT SPECIFIER
C       IBUF-AN ARRAY REPRESENTING THE TRANSFER BUFFER
C	       WHEN FIOCS IS ENTERED VIA THE RENAMED ENTRYPOINT FIOCS@
C	       (IE, WHEN CALLED BY FORTRAN77 FORMATTER ROUTINES), IBUF
C	       IS AN INTEGER CONTAINING THE ADDRESS OF THE TRANSFER
C	       BUFFER, AND NOT THE BUFFER ITSELF.
C		(REQUIRES ASSEMBLY-LANGUAGE MANIPULATION)
C	ILEN-AN INTEGER CONTAINING
C		A) THE NUMBER OF BYTES TO BE TRANSFERRED ON OUTPUT
C		B) THE MAXIMUM RECORD SIZE ON INPUT (BYTES), THE ACTUAL
C		   NUMBER OF BYTES INPUT IS RETURNED IN THIS VARIABLE
C		C) FOR FUNCTION CODE 10, ILEN SPECIFIES THE SIZE IN BYTES
C		   OF EACH DIRECT ACCESS RECORD
C		D) FOR FUNCTION CODE 12, THE SIZE OF FILE RECORDS IS 
C		   RETURNED IN THIS VARIABLE
C	ISTAT-AN INTEGER RETURN STATUS VARIABLE SET BY FIOCS TO
C	      INDICATE TO THE CALLING PROGRAM THE STATUS OF THE IO REQUEST
C		-1--STILL INCOMPLETE  (REQUEST WAS WITH NO WAIT)
C		 0--NORMAL COMPLETION
C		 1--END OF FILE ON READ
C		 2--UNDEFINED LOGICAL UNIT
C		 3--ILLEGAL FUNCTION FOR DEVICE
C	IREC-AN INTEGER RECORD NUMBER FOR DIRECT ACCESS I/O
C	INAME-A CHARACTER VARIABLE CONTAINING A FILE NAME FOR DIRECT ACCESS I/O
C	ICHARS-AN INTEGER GIVING THE LENGTH OF THE FILE NAME IN INAME
C
C  THIS SIMPLE EXECUTIVE CAN BE REPLACE OR MODIFIED AS LONG AS THE 
C  DEFINED INTERFACE STANDARDS ARE MAINTAINED
C
C
C  THIS EXECUTIVE SKELETON IS DESIGNED TO MAP LOGICAL UNITS 0-16 TO
C  DRIVER SUBROUTINES.   LOGICAL TO PHYSICAL MAPPINGS ARE CHANGED
C  BY MAKING SOURCE MODIFICATINS TO THIS EXECUTIVE.
C  INITIALLY THE LOGICAL UNIT MAPPING IS:
C	0--BIT BUCKET
C	1--THE SYSTEM CONSOLE
C	2-16--UNDEFINED
C
	DIMENSION LUMAP(17)
	DATA LUMAP/1,2,15*-1/
C
C  MAP THE IBUF ARRAY TO THE ADDRESS SPECIFIED BY PARAMETER IBUF
$$ASSEMBLE
; THIS IS FIRST CODE FOLLOWING COMPILER-GENERATED ENTRYPOINT
	LES	DI,IBUF
	LES	DI,ES:(DI)
	MOV	IBUF,DI
	MOV	IBUF+2,ES
; THE FOLLOWING ENTRYPOINT ALLOWS FIOCS TO BE CALLED NORMALLY FROM
; A FORTRAN PROGRAM, WITH IBUF BEING AN ACTUAL FORTRAN ARRAY.
	JMP	SHORT DONE@	;BRANCH AROUND ALTERNATIVE ENTRYPOINT
	PUBLIC	FIOCS		;DEFINE NORMAL FORTRAN ENTRYPOINT
	EVEN			;ALLIGN GENERATED CODE
FIOCS:	
	CALLS	@PINIT		;PROCESS PARAMETER LIST
	DP	?00001		;ADDRESS OF PARAM STORAGE
	DB	8		;NUMBER OF PARAMS IN TEMPLATE
	VAL	2,2,0,2,2,2,12,2	;PARAMETER TEMPLATE
	PNT	JUMP_		;REENTER THREAD SEQUENCE AND CONTINUE
	PNT	@5		;CONTINUE AT FORTRAN STATEMENT LABEL 10
DONE@:				;CONTINUATION POINT FOR NORMAL CODE
$$COMPILE
C
C  DETERMINE BASIC FUNCTION
5	CONTINUE
	KFUNC=IFUNC
	IF(KFUNC.GT.128) KFUNC=KFUNC-128
	GOTO (10,20,30,40,50,60,70,80,90,100,110,120,130),KFUNC
C  BAD FUNCTION CODE
1000	CALL TTDRVR(128+8,' ?BAD FIOCS FUNCTION CODE?',25)
	ISTAT=3
	RETURN
C
C  CODE 1 - INITIALIZE ALL I/O, ETC.
C  INITIALIZE TELETYPE OUTPUT
10	CALL TTDRVR(128+KFUNC,IBUF,ILEN)
	ISTAT=0
	RETURN
C
C  CODE 2 - TERMINATE ALL I/O OPERATIONS
20	CALL TTDRVR(128+KFUNC,0)
	ISTAT=0
	RETURN
C
C  CODE 3 - BACKSPACE FILE
C  (NOT IMPLEMENTED)
30	GOTO 1000
C
C  CODE 4 - REWIND FILE
C  (NOT IMPLEMENTED)
40	GOTO 1000
C
C  CODE 5 - WRITE ENDFILE
C  (NOT IMPLEMENTED)
50	GOTO 1000
C
C  CODE 6 - FORMATTED SEQUENTIAL READ
60	CONTINUE
C
C  CODE 7 - UNFORMATTED SEQUENTIAL READ
70	CONTINUE
C
C  CODE 8 - FORMATTED SEQUENTIAL WRITE
80	CONTINUE
C
C  CODE 9 - UNFORMATTED SEQUENTIAL WRITE
90	CONTINUE
C
C  SEQUENTIAL READ/WRITE
C  DECODE LOGICAL UNIT INTO PHYSICAL UNIT AND MAKE DRIVER CALL
C  NOTE THAT DRIVER PARAMETERS ARE SAME AS FOR FIOCS BUT ILU IS OMITTED
	ITEMP=LUMAP(1+ILU)
	GO TO (91,92),ITEMP
C  ERROR IF IT FALLS THROUGH
	CALL TTDRVR(128+8,' ?UNDEFINED LOGICAL UNIT?',23)
	ISTAT=2
	RETURN
C  PHYSICAL DEVICE 1 IS THE BIT BUCKET
91	CALL BUCKET(IFUNC,IBUF,ILEN,ISTAT)
	RETURN
C  PYSICAL DEVICE 2 IS THE CONSOLE
92	CALL TTDRVR(IFUNC,IBUF,ILEN,ISTAT)
	IF (ISTAT .EQ. 3) 
	1	CALL TTDRVR(128+8,' ?TTDRVR: ILLEGAL FUNCTION?',26)
	RETURN
C
C  CODE 10 - OPEN DIRECT-ACCESS FILE
C  (NOT IMPLEMENTED)
100	GOTO 1000
C
C  CODE 11 - DIRECT-ACCESS READ
C  (NOT IMPLEMENTED)
110	GOTO 1000
C
C  CODE 12 - RETURN RECORD SIZE OF DIRECT-ACCESS FILE RECORD
120	GOTO 1000
C
C  CODE 13 - DIRECT-ACCESS WRITE
C  (NOT IMPLEMENTED)
130	GOTO 1000
C
	END
	SUBROUTINE BUCKET(IFUNC,IBUF,ILEN,ISTAT)
C  BIT BUCKET DRIVER ROUTINE
C  IGNORES WRITE REQUESTS AND RETURNS ZERO LENGTH READ REQUESTS
	KFUNC=IFUNC
	IF(KFUNC.GT.128) KFUNC=KFUNC-128
	GO TO (101,102,103,104,105,106,108,109,110,111,112,113),KFUNC
C
C  IGNORE FUNCTION , RETURN GOOD STATUS
101     CONTINUE
102     CONTINUE
103     CONTINUE
104     CONTINUE
105     CONTINUE
108     CONTINUE
109     CONTINUE
110     CONTINUE
112     CONTINUE
113     CONTINUE
	ISTAT=0
	RETURN
C
C  READ, SET LENGTH TO ZERO
106     CONTINUE
107     CONTINUE
111     CONTINUE
	ILEN=0
	ISTAT=0
	RETURN
	END
	SUBROUTINE TTDRVR(IFUNC,IBUF,ILEN,ISTAT)
C  DRIVER FOR CONSOLE TERMINAL ON SDK 86 BOARD
C  FUNCTIONS
C	1,2,3,4,5--IGNORED
C	6--READS 7-BIT ASCII CHARACTERS UNTIL A CARRIAGE RETURN OR CONTROL-Z
C	   RETURNS: RECORD WITHOUT CR-LF IN IBUF, ACTUAL LENGTH IN ILEN
C		    AND ISTAT=0 (OR 1 IF CONTROL-Z RECOGNIZED)
C	7--READ ILEN 8-BIT FRAMES FROM TERMINAL
C	   RETURNS: RECORD IN IBUF AND ISTAT=0
C	8/9--WRITES ILEN BYTES FROM BUFFER TO CONSOLE, APPENDS A CR-LF FOR
C	     CODE 8
C	10,11,12,13--ILLEGAL FUNCTION STATUS RETURNED
C
C  ALL FUNCTIONS ARE PERFORMED WITH WAIT
	CHARACTER*1 IBUF(*)
	INTEGER ASTER,CTRLU,CTRLZ,CR,LF,FF,DIG0,DIG1,PLUS,RUBOUT
	DATA ASTER,CTRLU,CTRLZ,CR,LF/42,21,26,13,10/
	DATA FF,DIG0,DIG1,PLUS,RUBOUT/12,48,49,43,127/
C
C  DECODE FUNCTION
	KFUNC=IFUNC
	IF(KFUNC.GT.128) KFUNC=KFUNC-128
	GO TO (1010,1020,1030,1040,1050,1060,1070,1080,1090),KFUNC
C  ILLEGAL FUNCTION, RETURN STATUS
	ISTAT=3
	RETURN
C  IGNORE THESE FUNCTIONS AND RETURN GOOD STATUS
1010    CONTINUE
1020    CONTINUE
1030    CONTINUE
1040    CONTINUE
1050    CONTINUE
	ISTAT=0
	RETURN
C
C  READ SEQUENTIAL
C  SET NEXT CHAR POSITION INDEX
1060    IMAX=ILEN
C  PROMPT USER WITH ASTERISK
1061	CALL OUTB(CR)
	CALL OUTB(LF)
	CALL OUTB(ASTER)
	ILEN=0
C  LOOP UNTIL END OF RECORD OR FILE
C  GET AN INPUT BYTE AND MASK TO 7 BITS
1062    CALL INB(IBYTE)
C$ASSEMBLE
	ANDB	IBYTE,#^B01111111
C$COMPILE
C  ECHO
	IF (IBYTE .EQ. RUBOUT) THEN
	  IF (ILEN .EQ. 0) GO TO 1062
	  ILEN=ILEN-1
	  CALL ECHO(IBYTE)
	  GO TO 1062
	  ENDIF
	CALL ECHO(IBYTE)
C  CONTROL-U CAUSES LINE TO BE DISCARDED AND NEW LINE STARTED
	IF (IBYTE .EQ. CTRLU) THEN
	  GOTO 1061
C  CONTROL-Z MARKS END OF FILE
	ELSEIF (IBYTE .EQ. CTRLZ) THEN
	  ISTAT=1
	  RETURN
C  CARRIAGE RETURN MARKS END OF RECORD
	ELSEIF (IBYTE .EQ. CR) THEN
	  ISTAT=0
	  RETURN
C NORMAL CHARACTER, ADD TO BUFFER IF ROOM
	ELSE
	  IF (ILEN .GE. IMAX)  GO TO 1062
	  ILEN=ILEN+1
	  CALL PUTB(IBYTE,IBUF,ILEN)
	  GOTO 1062
	ENDIF
C
C
C  BINARY READ SEQUENTIAL
C  READ EACH INPUT BYTE AND STORE IN BUFFER
1070    DO 1075 I=1,ILEN
	  CALL INB(IBYTE)
	  CALL PUTB(IBYTE,IBUF,I)
1075    CONTINUE
C  END OF RECORD
	ISTAT=0
	RETURN
C
C  FORMATTED SEQUENTIAL WRITE
C
C PROCESS FIRST CHARACTER AS CARRIAGE CONTROL:
C   ' 1' (PAGE EJECT) IS REPLACED WITH FORM-FEED
C   ' 0' (DOUBLE SPACE) IS REPLACED WITH TWO LINE FEEDS
C   ' +' (NO ADVANCE) SUPPRESSES LINE FEED BEFORE RECORD
C   '  ' (SINGLE SPACE) (AND ANY OTHER CHAR) IS REPLACED WITH LINE FEED
1080	CALL GETB(IBYTE,IBUF,1)
	IF(IBYTE.EQ.DIG1) THEN
		CALL OUTB(FF)
	ELSEIF(IBYTE.EQ.DIG0) THEN
		CALL OUTB(LF)
		CALL OUTB(LF)
	ELSEIF(IBYTE.EQ.PLUS) THEN
	ELSE
		CALL OUTB(LF)
	ENDIF
C  AFTER OUTPUTTING CARRIAGE CONTROL, OUTPUT REST OF RECORD
C  FOLLOWED BY A CARRIAGE RETURN.  AFTER EACH 80 CHARACTERS,
C  OUTPUT CR-LF TO PREVENT TELETYPE RECORD LENGTH OVERFLOW.
	IBEG=2
1085	IEND=IBEG+79
	IF(IEND.GT.ILEN) IEND=ILEN
	DO 1086 I=IBEG,IEND
	  CALL GETB(IBYTE,IBUF,I)
	  CALL OUTB(IBYTE)
1086    CONTINUE
C  DONE, INSERT FINAL CR
	CALL OUTB(CR)
C CHECK IF END OF RECORD, IF NOT OUTPUT LF AND REST OF RECORD
	IF(IEND.GE.ILEN) GOTO 1087
	  CALL OUTB(LF)
	  IBEG=IEND+1
	GOTO 1085
C  SET STATUS AND RETURN
1087	ISTAT=0
	RETURN
C
C  UNFORMATTED SEQUENTIAL WRITE
1090	DO 1095 I=1,ILEN
	  CALL GETB(IBYTE,IBUF,I)
	  CALL OUTB(IBYTE)
1095	CONTINUE
C  SET STATUS AND RETURN
	ISTAT=0
	RETURN
	END
	SUBROUTINE GETB(IBYTE,IARR,INDEX)
	CHARACTER*1 IARR(*)
C  GET BYTE AT POSITION INDEX INTO INTEGER IBYTE
C  CLEAR RESULT
	IBYTE=0
C  FORM ADDRESS OF BYTE AND RETRIEVE IT
$$ASSEMBLE
	LES	DI,IARR		;GET ADDRESS
	MOV	AX,INDEX	;GET OFFSET
	DEC	AX		;ADJUST FOR FORTRAN ARRAY INDEXING
	ADD	DI,AX		;COMPUTE DI
	JAE	11$		;CARRY OUT?
	MOV	AX,ES
	ADD	AX,#^H1000	;YES, BUMP SEGMENT VALUE
	MOV	ES,AX
11$:	MOVB	AL,ES:(DI)	;GET BYTE
	MOVB	IBYTE,AL	;STORE IT
$$COMPILE
	RETURN
	END
	SUBROUTINE PUTB(IBYTE,IARR,INDEX)
	CHARACTER*1 IARR(*)
C  STORE BYTE IN INTEGER IBYTE INTO IARR AT POSITION INDEX
C  FORM ADDRESS OF BYTE AND STORE IT
$$ASSEMBLE
	LES	DI,IARR		;GET ADDRESS
	MOV	AX,INDEX	;GET OFFSET
	DEC	AX		;ADJUST FOR FORTRAN ARRAY INDEXING
	ADD	DI,AX		;COMPUTE DI
	JAE	11$		;CARRY?
	MOV	AX,ES
	ADD	AX,#^H1000	;YES, BUMP SEGMENT
	MOV	ES,AX
11$:	MOVB	AL,IBYTE	;GET BYTE
	MOVB	ES:(DI),AL	;STORE IT (CAN USE STOSB)
$$COMPILE
	RETURN
	END
	SUBROUTINE OUTB(KBYTE)
C  THIS ROUTINE OUTPUTS THE FIRST BYTE OF INTEGER ITYPE WHEN USART IS READY
C  THE VALUE ASSIGNED TO VARIABLE IFILL DETERMINES THE NUMBER OF FILL
C  CHARACTERS TRANSMITTED AFTER A CARRIAGE RETURN
	IFILL=2
	IBYTE=KBYTE
1	CONTINUE
$$ASSEMBLE
;WAIT TIL READY
	MOV	DX,#^HFFF2	;SIO$STAT$PORT
11$:    INB	AL,DX
	TESTB	AL,#1
	JZ	11$		;NOT READY
	MOVB	AL,IBYTE	;READY, GET DATA
	MOV	DX,#^HFFF0	;SIO$DATA$PORT
	OUTB	DX,AL
	MOV	IBYTE+2,#0	;CLEAR HIGH ORDER BYTES
	MOVB	IBYTE+1,#0
$$COMPILE
C  ADD FILL CHARACTERS FOR CARRIAGE RETURN ONLY
	IF (KBYTE .NE. 13)  RETURN
	IF (IFILL .EQ. 0)  RETURN
	IFILL=IFILL-1
	IBYTE=0
	GO TO 1
	END
	SUBROUTINE INB(IBYTE)
C  GETS THE NEXT 8 BIT INPUT CHARACTER INTO IBYTE IN INTEGER FORM WHEN USART
C  BECOMES READY WITH INPUT
$$ASSEMBLE
;WAIT TIL READY
	MOV	DX,#^HFFF2	;SIO$STAT$PORT
11$:    INB	AL,DX
	TESTB	AL,#2H
	JZ	11$
	MOV	DX,#^HFFF0	;SIO$DATA$PORT
	INB	AL,DX
	MOVB	IBYTE,AL	;STORE DATA
	MOVB	IBYTE+1,#0	;CLEAR REST OF DATUM
	MOV	IBYTE+2,#0
$$COMPILE
	RETURN
	END
	SUBROUTINE ECHO(IBYTE)
C  ECHOES THE PARAMETER BYTE
C
	INTEGER CR,LF,BLANK,RUBOUT,BACKSP,CTRLU,UPARR,U
	DATA CR,LF,BLANK,RUBOUT,BACKSP/13,10,32,127,8/
	DATA CTRLU,UPARR,U/21,94,85/
C  ECHO CR AS CR-LF
	IF (IBYTE .EQ. CR) THEN
		CALL OUTB(CR)
		CALL OUTB(LF)
C  ECHO CONTROL U AS ^U CR-LF
	ELSEIF (IBYTE .EQ. CTRLU) THEN
		CALL OUTB(UPARR)
		CALL OUTB(U)
		CALL OUTB(CR)
		CALL OUTB(LF)
C  ECHO BACKSP AS BACKSPACE, BLANK, BACKSPACE
	ELSEIF (IBYTE .EQ. RUBOUT) THEN
		CALL OUTB(BACKSP)
		CALL OUTB(BLANK)
		CALL OUTB(BACKSP)
C  NORMAL ECHO
	ELSE
		CALL OUTB(IBYTE)
	ENDIF
	RETURN
	END
      SUBROUTINE ARMAP(DATA)
      INTEGER DATA(*)
C  RECEIVES IN THE DATA ARRAY A TABLE REGARDING LARGE ARRAY ALLOCATION
C  REQUESTS THAT WAS PASSED TO THE FINIT_ THREAD ROUTINE.  THE TERMINATION
C  WORD IS A -1 IN PLACE OF AN ADDRESS OFFSET.  FOR FORMAT OF TABLE
C  ENTRIES SEE THE FINIT_ ROUTINE.
C
C
      DO 100 I=1,1000000,5
C  SCAN THE ENTIRE DATA ARRAY, ONE ENTRY AT A TIME, PRINTING PERTINENT FACTS
      IF (DATA(I) .EQ. -1)  RETURN
C  FIRST PRINT CURRENT FACTS
      CALL PRINT(DATA(I),DATA(I+2),DATA(I+4)*2)
C  VALID ENTRY, IS THERE ANY PREVIOUS ENTRY WITH SAME BASE VARIABLE ADDR
      JLIM=I-1
      DO 50 J=1,JLIM,5
      IF (DATA(J) .EQ. DATA(I))  THEN
C  YES, CHECK ALLOCATED LENGTH
	   IF(DATA(J+4) .LT. DATA(I+4)) THEN
C  TRUNCATION RESULTED, WARN USER
		LEN=DATA(J+4)*2
		WRITE (*,40) DATA(J+2),LEN
40	       FORMAT(1X,'***WARNING: COMMON ASSOCIATION WITH ARRAY"',A6,
     1	      '" HAS REDUCED ACTUAL ALLOCATION TO ',I9,' BYTES')
	   ENDIF
C  NO MORE CHECKING OF PREVIOUS ENTRIES IS NECESSARY
      GO TO 100
      ENDIF
50    CONTINUE
100   CONTINUE
      END
      SUBROUTINE PRINT(IARR,NAMES,LENGTH)
      CHARACTER*6 NAMES(2)
      CHARACTER*2 IARR(*)
      CHARACTER*5 BEGADD,ENDADD
C  RETRIEVE ACTUAL START ADDRESS OF ARRAY
$$ASSEMBLE
     	LES	DI,IARR
	LES	DI,ES:(DI)
	MOV	IARR,DI
	MOV	IARR+2,ES
$$COMPILE
C  CONVERT ADDRESSES TO HEX
      CALL HEXAD(BEGADD,IARR,0)
      CALL HEXAD(ENDADD,IARR(LENGTH/2),1)
C  PRINT LINE
      WRITE(*,100) NAMES(1),NAMES(2),LENGTH,BEGADD,ENDADD
100   FORMAT(1X,'ARRAY: ',A6,'  PROGRAM UNIT: ',A6,'  SIZE: ',I6,
     1       '  START: ',A5,'  END: ',A5)
      RETURN
      END
      SUBROUTINE HEXAD(STRING,IARR,IADJ)
      CHARACTER*5 STRING(*)
C  SUBROUTINE TO CONVERT THE ADDRESS OF IARR +IADJ INTO A 5 CHARACTER
C  HEX STRING
      CHARACTER*2 HEXDIG(16),IARR(*)
      DATA HEXDIG/'0','1','2','3','4','5','6','7','8','9','A','B','C'
     1	       ,'D','E','F'/
$$ASSEMBLE
     	MOV	AX,IARR		;MOVE ADDRESS TO TEMP
	MOV	ITEMP,AX
	MOV	AX,IARR+2
	REPT	4		;ADJUST SEGMENT TO 20 BIT QUANTITY
	ROL	AX,1
	ENDR
	MOV	ITEMP+2,AX
$$COMPILE
C  ADD IN ADJUSTMENT PARAMETER
      ITEMP=ITEMP+IADJ
C  CONVERT TO HEX DIGITS
      DO 100 J=5,1,-1
      INEW=ITEMP/16
      IREM=ITEMP-(INEW)*16
      ITEMP=INEW
      CALL PUTB(HEXDIG(IREM+1),STRING,J)
100   CONTINUE
      RETURN
      END
C$END
 