/*
 * Tektronix 8560 Unix System Kernel
 *
 *	Based on Western Electric Version 7 Unix
 *
 *	Tektronix Modifications from Western Electric code
 *	Copyright C, 1981, Tektronix Inc.
 *	All rights Reserved
 */

#ifdef SCCSID
/*static char *sccsid = "@(#)trm_def.h	4.2 dated 11/16/82	Tektronix 8560 Unix";*/
#endif
/*
 * Input table action definitions
 */

# define ICM_ACT	0xf	/* mask for action */

# define IC_IGNORE	0	/* ignore character */
# define IC_ACCEPT	1	/* accept character */
# define IC_IGNBRK	2	/* ignore and break */
# define IC_ACCBRK	3	/* accept and break */
# define IC_SIGINT	4	/* interrupt signal */
# define IC_SIGQUIT	5	/* quit signal */
# define IC_BS		6	/* plain backspace */
# define IC_BS1		7	/* fancy backspace */
# define IC_REPRINT	8	/* reprint line */
# define IC_STOP	9	/* stop output */
# define IC_START	10	/* start output */
# define IC_KILL	11	/* plain line kill */
# define IC_KILL1	12	/* fancy line kill */
# define IC_EOL		13	/* end of line */
# define IC_ESC		14	/* escape next char */
# define IC_COPY	15	/* copy char from last line */


/*
 * Input table echo definitions
 */

# define ICS_ECHO	5		/* shift for echo */
# define ICM_ECHO	(03<<ICS_ECHO)	/* mask for echo */

# define IC_NOECHO	(0<<ICS_ECHO)	/* no echo */
# define IC_ECHO	(1<<ICS_ECHO)	/* echo character */
# define IC_CECHO	(2<<ICS_ECHO)	/* ctrl char echo */
# define IC_RECHO	(3<<ICS_ECHO)	/* ctrl char return echo */


/*
 * Flag byte definitions
 */

# define ICF_AUTOGO	(1<<4)	/* any input clears STOP status */
# define ICF_TAB	(1<<5)	/* expand tabs */


/*
 * Parity definitions
 */

# define IC_EVENP	0	/* even parity */
# define IC_ODDP	1	/* odd parity */
# define IC_NOP		2	/* no (0) parity */
# define IC_MARKP	3	/* mark (1) parity */
# define IC_DATAP	4	/* parity bit is data */
# define IC_DKP		5	/* parity is ignored and stripped */


/*
 * Stop Bit definitions
 */

# define IC_ONE		0x04	/* one stop bit */
# define IC_ONEH	0x08	/* one and half stop bits */
# define IC_TWO		0x0c	/* two stop bits */


/*
 * Input flow control ("tandem") definitions
 */

# define ICM_IFLOW	03	/* mask for input flow values */

# define IC_IFOFF	0	/* off */
# define IC_IFX		1	/* X-ON/X-OFF flagging */
# define IC_IFDTR	2	/* DTR flagging */


/*
 * CTS control definitions
 */

# define ICS_OFLOW	2		/* shift for output flow values */
# define ICM_OFLOW	(03<<ICS_OFLOW)	/* mask for output flow values */

# define IC_OFOFF	0		/* CTS ignored */
# define IC_OFFLAG	(1<<ICS_OFLOW)	/* CTS flagging */
# define IC_OFHUP	(2<<ICS_OFLOW)	/* Send hangup when CTS drops */


/*
 * Terminal speed definitions
 */

# define IC_300		0xc0	/* 300 baud */
# define IC_600		0x80	/* 600 baud */
# define IC_1200	0x40	/* 1200 baud */
# define IC_2400	0xd0	/* 2400 baud */
# define IC_4800	0x90	/* 4800 baud */
# define IC_9600	0x50	/* 9600 baud */
