/*	prom2.h	2.1	82/09/08	*/

/* (C) Copyright 1982 by Sun Microsystems, Inc. */

/*
	prom2.h

	What the Outside World needs to Know about Prom set #2
*/

/*
| Note that when changing the identifying string, both PROMID in 
| ../h/prom2.h, and the argument of the .ascii in ../prom2/header.s, must be
| changed.  This must occur whenever entries are added to, or changed in, this
| table, so that new prom1's don't call garbage addresses in prom2.
*/
/*
	PROMIDMAX is the largest Prom ID value which Prom 1 will accept.
	In other words, since usually entries are added but not deleted,
	an old Prom 1 will accept any Prom 2 from PROMID thru PROMIDMAX.
	If you change or delete existing entries (invalidating old Prom1s'
	assumptions), you must reassign PROMID and PROMIDMAX outside their
	current range.
*/

#define PROMID		((('S'*256+'u')*256+'n')*256)+'1'
#define PROMIDMAX	((('S'*256+'u')*256+'n')*256)+'9'

typedef struct prom2vec {

	char v2_identifier[4];	/* PROMID goes here */
	char *v2_version;	/* Version name string pointer */
/* v2_version is printed at startup, between the main prom version and
   the ")" in "Sun Workstation Monitor (Rev B)".  Thus v2_version should
   also include a delimiter so it looks like "(Rev B/Rev A)" or 
   "(Rev B & Rev A)" or "(Rev B;&A)" or "(Rev B.A)".  By making this
   point to the null string, you can have no indication that the proms
   have been found by the main monitor, if you choose.   */
	int (*v2_Diagnostic)();	/* Power-up diagnostics */
	int (*v2_Bootload) ();	/* Bootstrap loader - disk, net, whatever */
	int (*v2_FwrVect) ();	/* Vector writing code for 4014 emulator */

	} prom2vectype;

#define Prom2Ptr ((struct prom2vec *)0x400000)
