/*
	@(#)standalone.h	1.10	(3/1/85 13:53:39)
*/
#include <sys/param.h>
#ifdef SYSV
#include <sys/types.h>
#endif
#include <sys/ino.h>
#include <sys/inode.h>
#include <sys/filsys.h>
#include <sys/dir.h>
#include <sys/stat.h>

typedef	unsigned	char	U8;
typedef	unsigned	short	U16;
typedef	unsigned	int	U32;
typedef			char	S8;
typedef			short	S16;
typedef			int	S32;

typedef	struct
	{
	int	diob_dix;	/* I/O driver index.			*/
	int	diob_fnc;	/* Function code (see below).		*/
	U8	diob_buf[2048];	/* The buffer.				*/
	int	diob_fdb;	/* Filesystem: Desired block number.	*/
	U8	diob_nblks;	/* Number of blocks to read.            */
	int	diob_fsb;	/* Filesystem: Starting block number.	*/
	int	diob_feb;	/* Filesystem: Ending block number.	*/
	int	diob_drv;	/* Disk drive: drive number.		*/
	int	diob_dbt;	/* Disk drive: blocks per track.	*/
	int	diob_dtc;	/* Disk drive: tracks per cylinder.	*/
	int	diob_dcd;	/* Disk drive: cylinders per drive.	*/
	int	diob_dp1;	/* Disk drive: Controller parameter 1.	*/
	int	diob_dp2;	/* Disk drive: Controller parameter 2.	*/
	int	diob_dp3;	/* Disk drive: Controller parameter 3.	*/
	int	diob_dp4;	/* Disk drive: Controller parameter 4.	*/
	}	DIOB;

#define	DIOB_CWC	1	/* diob_dix: Callan Winchester Cnt'rlr.	*/
#define	DIOB_CFC	2	/* diob_dix: Callan Floppy Controller.*/
#define	DIOB_MSC	3	/* diob_dix: MSC-9205 Controller. */
#define	DIOB_RF		4	/* diob_dix: Ciprico Rimfire 50 SMD Cntlr. */

#define	DIOB_RD		1	/* diob_fnc: Read a block function. */

#ifdef bcopy
#undef bcopy
#endif bcopy
#define bcopy(a,b,c)	blt(b, a, c)

typedef	struct
	{
	int	file_off;	/* File byte offset.			*/
	U8	file_buf[2048];	/* The file buffer.			*/
	int	file_cblk;	/* The block number in the buffer.	*/
	struct dinode file_ino;	/* File inode image.			*/
	daddr_t	file_ib1[512];	/* The singly indirect block.		*/
	daddr_t	file_i1b;	/* Current daddr of single block.       */
	daddr_t	file_ib2[512];	/* The doubly indirect block.		*/
	daddr_t	file_i2b;	/* Current daddr of double block.       */
	daddr_t	file_ib3[512];	/* The triply indirect block.		*/
	daddr_t	file_i3b;	/* Current daddr of triple block.       */
	DIOB	file_diob;	/* File diob.				*/
	}	FILE;

#define	EOF	-1

/*
	Messages from the control panel to the CPU
*/
#define	BUT_EXEC	'E'	/* The 'execute' button was touched */
#define BUT_PF0		'0'	/* The 'pf0' button was touched  */
#define BUT_PF1		'1'	/* The 'pf1' button was touched */
#define BUT_SELECT	'S'	/* The 'select' button was touched */ 
#define KEY_MAINT	'M'	/* The key position is 'maintenance' */
#define KEY_OFF		'O'	/* The key position is 'off' */
#define	KEY_ON		'N'	/* The key position is 'on' */
#define RESET8748       '2'     /* The 8748 has been reset */

/*
	Messages from the CPU to the control panel
*/
#define BELL_ON		0xE	/* Turn bell on */
#define BELL_OFF	0xF	/* Turn bell off */
