/*	sunmon.h	2.3	82/09/22	*/

/* (C) Copyright 1982 by Sun Microsystems, Inc. */

/*
 * sunmon.h
 *
 * Header file for Sun MC68000 ROM Monitor
 *
 * Created:
 *	Jeffrey Mogul @ Stanford	14 May 1981
 *	out of the ashes of code originally written by Luis Trabb-Pardo
 *	Moved to Unisoft Unix by JCGilmore		13 May 1982
 */

#ifndef	SUNMONDEFINED
#define SUNMONDEFINED

/*
 * Various memory layout parameters
 */
#define INITSP 0x1000		/* Initial stack pointer after reset */
	asm ("INITSPa = 0x1000"); /* initial stack pointer, for asm use */

#define	USERCODE 0x2000		/* starting address for user programs */
	asm ("USERCODE = 0x2000");


/*
 * RAM Refresh
 *
 * The current hardware does not support the use of "User Interrupt
 * Vectors"; therefore, the RAM Refresh routine starts where they
 * lie.
 */
#define RAMREFR	((int (*)())0x100)		/* address of RAM
						 * refresh routine
						 */

#define RAMREFOPS 128	/* operations to do refresh */
#define RAMREFTIME MS_2	/* time between refreshes */

/*
 * STRTDATA is the starting address of monitor global data
 */
/* The following defn gives the compiler fits sometimes, too big */
/* #define STRTDATA ( ((int)RAMREFR) + (RAMREFOPS*sizeof(short)) ) */
#define STRTDATA 0x200

/*
 * Size of line input buffer - this should be at least 80,
 * to leave room for a full-length S-record.
 */
#define BUFSIZE	80

/*
 * Size of up/down keyboard's typeahead buffer.  It is scanned
 * by the refresh routine, and keycodes deposited here.  Then later
 * they are picked up by the monitor busywait keyboard routine, or
 * by Unix or other application programs directly.
 *
 * Note that each keystroke, if typed slowly (by computer standards)
 * takes 3 bytes: a key-down, a key-up, and a keyboard-idle.  So allocate
 * three times as much room as you want to be able to type ahead.  (Of
 * course, this typeahead won't echo immediately in the monitor, but will
 * echo in its proper place in the I/O transcript.)
 */
#define KEYBUFSIZE 90

/*
 * Size of the transparent I/O (terminal emulator) receive-ahead buffer.
 * It needs at least a line or so, for when it scrolls.
 *
 * HALTMAX is the how many chars are in the buffer when we send a ^S
 * to encourage the host to stop sending.  HALTMIN is how many are in
 * when we send a ^Q to encourage the host to resume.  (It should be
 * more than 0, because it takes the host awhile to receive the ^Q
 * and to restart its output.)  HALTCHAR is ^S.  HALTENDCHAR is ^Q.
 *
 * Note that the larger TranspBufSIZE is, the more lines we can scroll up
 * at once as we get behind.  This may be undesirable to some people; it may
 * be very desirable to others, 'coz it makes it run mooch faster.
 *
 * When you change TranspBufSIZE, be sure to change HALTMAX too.  It should
 * lag behind BufSIZE by 100 or so chars, depending on how fast the host
 * responds to ^S.  (100 chars gives .1 second leeway at 9600 baud).
 */
#define TranspBufSIZE	1000
#define TranspHALTMAX	 900
#define TranspHALTMIN	25
#define TranspHALTCHAR	0x13
#define TranspHALTENDCHAR 0x11

/*
 * These are the "erase" and "kill" characters for
 * input processing; they can be changed.
 */
#define	CERASE1 '\b'	/* backspace */
#define CERASE2 0x7F	/* delete */
#ifndef CKILL
#define CKILL	'\025'	/* ctrl/U */
#endif

/*
 * These are the default mode-changing characters
 */
#define CENDTRANSP	'\036'	/* end transparent mode, ctrl/^ */
#define	CSTLD		'\\'	/* Start Load */

#define UPCASE	0x5F	/* mask to force upper case letters */
#define	NOPARITY 0x7F	/* mask to strip off parity */

/*
 * These are the possible values for InSource and OutSink.
 */
#define InKEYB		0	/* Input from parallel keyboard */
#define OutSCREEN	0	/* Output to frame buffer */
#define IoUARTA		1	/* Input or output to Uart A */
#define IoUARTB		2	/* Input or output to Uart B */
#define InMAX		2	/* MAX VALUE FOR INPUT SOURCE */
#define OutMAX		2	/* MAX VALUE FOR OUTPUT SINK */
/* Change the below for switching modem<->terminal ports as A and B */
#define InDEFAULT	IoUARTA /* Default input device if none better */
#define OutDEFAULT	IoUARTA /* Default output device if none better */


/*
 * Exception cause codes
 *
 * sunmon.c passes one of these to monitor() [in commands.c] on special
 * exceptions.
 *
 * These definitions get used in asm()'s and thus must not have
 * trailing tabs!  (or more than one leading tab)
 *
 * In fact, furthermore, with the Unisoft C compiler, they cannot be
 * substituted into asm()'s, so we have to asm their definitions
 * into the assembler output here and now:
 *						JCGilmore 14May82
 */
#define	EXC_RESET	0
				/* Reset switch hit (or soft reset) */
#define	EXC_ABORT	1
				/* Abort switch hit */
#define	EXC_BREAK	2
				/* Breakpoint trap taken */
#define	EXC_EXIT	3
				/* Exit trap taken */
#define	EXC_TRACE	4
				/* Trace trap taken */
#define	EXC_DOG		5
				/* Watchdog timer reset */
#define EXC_BUSERR	6
				/* Bus Error */
#define EXC_ADRERR	7
				/* Address Error */
#define EXC_BOOTING	8
				/* About to boot, want maps straight */
#define EXC_KCMD	9
				/* Soft K command from user */
	asm ("EXC_RESET = 0");
	asm ("EXC_ABORT = 1");
	asm ("EXC_BREAK = 2");
	asm ("EXC_EXIT  = 3");
	asm ("EXC_TRACE = 4");
	asm ("EXC_DOG   = 5");
	asm ("EXC_BUSERR= 6");
	asm ("EXC_ADRERR= 7");
	asm ("EXC_BOOTING=8");
	asm ("EXC_KCMD  = 9");


/*
 * To support automatic booting, we define the time (in milliseconds)
 * between the system power coming up (or "k2" command) and when the
 * system will boot itself, (assuming no chars have been typed by the
 * user).
 *
 * The delay is so long (30 sec) because the warning message must appear
 * on the CRT before we actually boot, and it takes it awhile to warm up.
 */

#define BOOTDELAY	30000	/* 30 second delay, power -> autoboot */

/*
 * This register is the error interface between the diagnostics in 
 * prom 2 and the error reporting code in prom 1.  Unfortunately,
 * since this C compiler has some very lousy restrictions around
 * what you can do in the argument to an asm(), the register used
 * for this has had to be hard-coded in some places.  In each place,
 * however, there is a reference to DIAGRESULT nearby, so a grep(1)
 * will find it.
 *
 * The define is actually used in commands.c, where it is appended
 * to "r_" to access the variable containing the appropriate register.
 */
#define DIAGRESULT a0
 
#endif SUNMONDEFINED
