program TypeIt;

{---------------------------------------------------------------------
{
{ Abstract:
{    Program to type a text file to the console.
{
{ Written by: Don Scelza
{
{ Copyright (C) Three Rivers Computer Corperation, 1981.
{
{----------------------------------------------------------------------}


{ 29-Jul-81  V3.4   Brad Myers
{ Made into demo
{ }

{ 23-Jun-81  V3.2   Brad Myers
{ IOKeyClear on ^C
{ }

{ 19-May-81  V3.1   Brad Myers
{ Switches for no wait on ^L and help
{ Use new FSExtLookUp
{ Waits on ^Q rather than CR (and ^C will abort)
{ }

{ ??-Apr-81  V3.0  John Strait
{ Very fast print using new RasterOp entry point
{ }

{ 31-Mar-81  V2.0  Brad Myers
{ Title line; asks before ^L; blotch at end of file
{ }

{ 19-Mar-81  V1.2  Brad Myers
{ Changed PERQ.String to PERQ_String; fixed so works if BlkNum wrong or zero.
{  No FF before print
{ }

{  9-Mar-81  V1.1  Don Scelza
{ Added the calls to Progress.
{ }

{  9-Mar-81  V1.0  Don Scelza
{ Created the new version of type based on design by Brad Myers.
{ }


imports System       from System;
imports CmdParse     from CmdParse;
imports FileUtils    from FileUtils;
imports IO_Unit      from IO_Unit;
imports IO_Others    from IO_Others;
imports Screen       from Screen;
imports Perq_String  from Perq_String;
imports ReadDisk     from ReadDisk;
imports UtilProgress from UtilProgress;
imports memory       from memory;  {using screenSeg}
imports SigUtils     from SigUtils;

{$R-}

const Version = 'V3.4';
      LF = Chr(#012);
      CR = Chr(#015);
      Blotch = Chr(#213);  {^K with high bit set is EOF blotch}
      Nul = Chr(#000);
      Del = Chr(#177);

      Extensions = ' .Pas .Micro .Cmd .Dfs .Doc .Prose ';
      
var
  InputFile       : PathName;
  Broke           : string;
  MyFID           : FileID;
  Bits, CurIndex, 
  Blocks, CurBlock,
  LastChar,
  JumpLines, 
  Dum             : integer;
  CmdTable        : CmdArray;
  NumCmds         : integer;
  Switch          : String;
  wait            : boolean;


procedure DoSwitch;
{--------------------------------------------------------------------
{
{ Abstract:
{    Handles switches.
{
{ Side Effects:
{    This procedure will change MyFID, Blocks and Bits.
{    If the file is not found then it will exit the type program.
{
{--------------------------------------------------------------------}
     var I: Integer;
     begin
     Remdelimiters(UsrCmdLine, ' /', Broke);
     GetSymbol(UsrCmdLine, Switch, ' ', Broke);
     ConvUpper(Switch);
     case UniqueCmdIndex(Switch, CmdTable, NumCmds) of
          1: Wait := true;
          2: Wait := false;
          3: begin
             writeln('Type is used to print files on the PERQ display.');
             writeln('Command line is of the form:');
             writeln('    Type <File Spec> {/Switch}');
             writeln('The valid switches are:');
             for I := 1 to NumCmds do writeln('    ', CmdTable[I]);
             exit(TypeIt);
             end;
          otherwise: begin
              writeln(Switch, ' is not a valid switch');
              exit(TypeIt);
              end;
          end;
     end;

procedure GetFileID;
{--------------------------------------------------------------------
{
{ Abstract:
{    Get the FileID and other information of the file that
{    is to be typed.
{
{ Side Effects:
{    This procedure will change MyFID, Blocks and Bits.
{    If the file is not found then it will exit the type program.
{
{--------------------------------------------------------------------}
    var i: integer;
        win: WinRange;
        
    begin
    CmdTable[1] := 'WAIT      wait for CR when typing a ^L; (The default).';
    CmdTable[2] := 'NOWAIT    don''t wait.';
    CmdTable[3] := 'HELP      print this message.';
    NumCmds := 3;
  
    wait := true;
    
    RemDelimiters(UsrCmdLine,' ',Broke);
    GetSymbol(UsrCmdLine, InputFile, ' /', Broke);
    
    while Broke = '/' do DoSwitch;

    RemDelimiters(UsrCmdLine,' ',Broke);
    GetSymbol(UsrCmdLine, InputFile, ' /', Broke);
    while length(InputFile) = 0 do
        begin
        write('File to type: ');
        readln(InputFile);
        end;
  
    while Broke = '/' do DoSwitch;
      
    if length(UsrCmdLine) <> 0 then
       begin
       NextArgInt(i);
       win := i;
       ChangeWindow(i);
       RefreshWindow(i);
       write(FF);
       end;
    
    MyFID := FSExtSearch(FSSysSearchList,Extensions,InputFile,Blocks,Bits);
    if MyFID = 0 then
        begin
        writeln('** File ', InputFile, ' not found.');
        exit(TypeIt);
        end;
    if Blocks = 0 then JumpLines := 1
    else JumpLines := 1024 div Blocks;
    WriteLn;
    WriteLn(' ----- File is ',InputFile,' -----');
    WriteLn;
    end;
    

procedure VeryFastPrint;
{---------------------------------------------------------------------
{
{ Abstract:
{    Print the file very very quickly.
{
{---------------------------------------------------------------------}
  var  id : SegID;
       ptr: ptrDiskBuffer;
       hdr: ptrHeader;
       i, stop, blkCnt: integer;
       c: Char;
     
       Win: WinRange;
       X, Y, Width, Height, MaxX: Integer;
       HasTitle: Boolean;
       
       FontP: FontPtr;
       
       Termination: (CharCount, ScreenWidth, ControlChar);
    
    procedure DoFF;
    {---------------------------------------------------------------------
    {
    { Abstract:
    {    Waits for ^Q on FF if should.
    {
    {---------------------------------------------------------------------}
       Handler CtlC;
         begin
         CtrlSPending := false;
         SCurOff;
         WriteLn('^C');
         IOKeyClear;
         Exit(VeryFastPrint);
         end;

       begin
       if wait then begin
                    WriteLn;
                    Write('  ** ^Q for MORE **');
                    SCurOn;
                    CtrlSPending := true;
                    while CtrlSPending do;
                    SCurOff;
                    end;
       SPutChr(FF);
       SReadCursor(X, Y)
       end;

    begin
    GetWindowParms(Win, X, Y, Width, Height, HasTitle);
    FontP := GetFont;
    Width := Width - 6;
    X := X + 3;
    MaxX := X + Width;
    id := FileIDToSegID(myFid);
    hdr := ReadHeader(id);  {FIBlk}
    id := hdr^.nextAdr;
    LoadCurs;
    blkCnt := 0;
    SReadCursor(X,Y);
    while id <> DBLZERO do
      begin
      blkCnt := blkCnt+1;
      ptr := ReadDisk(id);
      hdr := ReadHeader(id);
      id := hdr^.nextAdr;
      if id = DBLZERO then 
        stop := bits div 8 {last block}
      else 
        stop := 512;
      i := 0;
      repeat
        while CtrlSPending do ;
        LoadExpr(RRpl);               { Raster-Op function }
        LoadExpr(X);                  { destination X }
        LoadExpr(Y);                  { destination Y }
        LoadExpr(ScreenSeg);          { destination base }
        LoadExpr(0);
        InLineByte( 227 {TLATE} );
        LoadAdr(FontP);
        InLineByte( 239 {LDDW} );
        LoadAdr( ptr^.ByteData );
        LoadExpr( i );
        LoadExpr( stop );
        LoadExpr( MaxX );
        LoadExpr( LOr( Shift(#4010,8), Shift(#4010,-8) ) );
        InLineByte( 240 {STLATE} );
        InLineByte( #165 {7,,5} );
{
        (Tos)   = Maximum X-coordinate + 1.
        (Tos-1) = Maximum byte offset + 1.
        (Tos-2) = Byte offset from the beginning of the byte array.
        (Tos-3) = Address of the byte array as an offset from the base of the
                  memory stack.
        (Tos-4) = Character set address as an offset from the base of the
                  memory stack.
        (Tos-5) = Destination base address as an offset from the base of the
                  memory stack.
        (Tos-6) = Destination Y-coordinate.
        (Tos-7) = Destination X-coordinate.
        (Tos-8) = Raster-op function.
}
        InLineByte( 191 {JCS} );
{
        (Tos)   = Current X-Coordinate.
        (Tos-1) = Next byte offset.
        (Tos-2) = Termination condition:
                    0 - Character count exhausted.
                    1 - Screen width exhausted.
                    2 - Control character encountered.
}
        StorExpr(X);
        StorExpr(i);
        StorExpr(Termination);
        SSetCursor(X,Y);
        if Termination = ControlChar then
          begin
            c := chr(ptr^.ByteData[i]);
            if c = FF then DoFF
              else begin
                   SPutChr(c);
                   SReadCursor(X, Y)
                   end;
            i := i + 1;
            if i >= stop then Termination := CharCount
          end
        else
          if Termination = ScreenWidth then
            begin Writeln; SReadCursor(X, Y) end
      until Termination = CharCount;
      ShowProgress(JumpLines);
      end;
    Writeln(Blotch);
    QuitProgress;
    if blkCnt <> Blocks then
       begin
       WriteLn;
       WriteLn('***WARNING: Number of blocks in file (',blkCnt:1,')');
       WriteLn('***         does not agree with length hint (',Blocks:1,')');
       WriteLn('***Suggest you run Scavenger***');
       end;
    end;


begin
GetFileID;

FSAddToTitleLine(Concat(Concat('Type ', Version),'.  Type Type/Help for help'));
VeryFastPrint;
end.
