Program TestReceive;

Imports Ether10IO from Ether10IO;
Imports EBuffer from EBuffer;

Function Swab (i: Integer): Integer;

        Begin
        Swab := LOR (Shift (i, -8), Shift (i, 8));
        End;

Procedure printptr (p: pointer; s: string);

        var     bullshit: record case boolean of
                        true:  (ptr: pointer);
                        false: (os: integer;
                                sg: integer);
                        end;

        Begin
        with bullshit do
            begin
            ptr := p;
            writeln (s, ' is from segment ', sg:1, ' offset ', os:1);
            end;
        End;

Procedure printaddr (ea: EtherAddress; s: String);

        Begin
        with ea do
            writeln (s, High:1, ', ', Mid:1, ', ', Low:1, '.');
        End;

Var     Rec1Buf, Rec2Buf: pEtherBuffer;
        Rec1Head, Rec2Head: pEtherHeader;
        Rec1Stat, Rec2Stat: pEtherStatus;
        AdRec: pEtherAdRec;
        MyAddress, HisAddress, BroadcastAddr: EtherAddress;
        RecCmd: EtherCommand;

Function EquAddress (a, b: EtherAddress): Boolean;

        Begin
        EquAddress := (a . High = b . High) and (a . Mid = b . Mid) and
                (a . Low = b . Low);
        End;

Var     Another: Boolean;
        OtherStat: pEtherStatus;

Procedure ReceiveDone (stat: pEtherStatus);

        Handler E10ReceiveDone (stat: pEtherStatus);

                Begin
                if not Another then
                    begin
                    Another := True;
                    OtherStat := stat;
                    end;
                End;

        Handler E10DByteError;

                Begin
                writeln ('Bad number of bits in received packet.');
                End;

        Var     Bytes: Integer;
                head: pEtherHeader;
                buf: pEtherBuffer;
                i: Integer;

        Begin
        writeln;
        if stat = Rec1Stat
            then begin
                writeln ('Received #1.');
                head := Rec1Head;
                buf := Rec1Buf;
                end
            else if stat = Rec2Stat
            then begin
                writeln ('Received #2.');
                head := Rec2Head;
                buf := Rec2Buf;
                end
            else begin
            writeln ('Received packet with unknown status block.');
            printptr (stat, 'stat');
            Exit (TestReceive);
            end;
        Bytes := E10DataBytes (stat^ . BitsRecv);
{
        with Head^ do
            begin
            if EquAddress (Dest, BroadcastAddr) then
                begin
                printaddr (Src, 'Received broadcast packet from ');
                end
            else if not EquAddress (Dest, MyAddress) then
                begin
                writeln ('Received packet not to me.');
                end;
            if not EquAddress (Src, HisAddress) then
                begin
                writeln ('Received packet not from him.');
                end;
            end;
}
        with Head^ do
            begin
            printaddr (Src, 'Src is ');
            printaddr (Dest, 'Dest is ');
            writeln ('Type is ', EType:1);
            end;
        with Stat^ do
            begin
            if CRCError then
                write ('CRCError, ');
            if Collision then
                write ('Collision, ');
            if RecvTrans then
                write ('RecvTrans, ');
            if Busy then
                write ('Busy, ');
            if ClockOver then
                write ('ClockOver, ');
            if PIP then
                write ('PIP, ');
            if Carrier then
                write ('Carrier, ');
            if RetryTime <> 0 then
                write ('RetryTime is ', RetryTime:1, ', ');
            if SendError then
                write ('SendError, ');
            if CmdInProg then
                write ('CmdInProg, ');
            write ('BitsRecv is ', BitsRecv:1, ', ');
            writeln ('Bytes is ', Bytes:1);
            end;

        writeln;
        write (Buf^ [0]:1, ', ');
        for i := 1 to (Bytes - 1) div 2 do
            write (', ', Buf^ [i]:1);
        writeln;

        E10IO (RecCmd, Head, Buf, Stat, MaxDataBytes);
        writeln ('Set up receive again.');
        if Another
            then begin
                Another := False;
                ReceiveDone (OtherStat);
                end
            else write ('Type <return> to end program.');
        End;

Handler E10ReceiveDone (stat: pEtherStatus);

        Begin
        ReceiveDone (stat);
        End;

Var     ans: Boolean;

Begin
EB_Alloc (2, AdRec);
EB_Buffers (Rec1Head, Rec1Buf, Rec1Stat);
EB_Buffers (Rec2Head, Rec2Buf, Rec2Stat);
writeln ('Buffers Allocated.');
E10Init;
MyAddress := E10GetAdr;
with MyAddress do
    begin
    High := Swab (High);
    Mid := Swab (Mid);
    end;
printaddr (MyAddress, 'My address is ');
{
with HisAddress do
    begin
    write ('His address:  High? ');
    readln (High);
    write ('Mid? ');
    readln (Mid);
    write ('Low? ');
    readln (Low);
    end;
printaddr (HisAddress, 'His address is ');
}
with BroadCastAddr do
    begin
    High := -1;
    Mid := -1;
    Low := -1;
    end;
with AdRec^ do
    begin
    LowAddress := MyAddress . Low;
    MCB := MltCstNone;
    end;
E10Reset (AdRec);
writeln ('Reset Ethernet.');
write ('Promiscuous receives? (T/F) ');
readln (ans);
if ans
    then RecCmd := EPromiscuousReceive
    else RecCmd := EReceive;
Another := False;
E10IO (RecCmd, Rec1Head, Rec1Buf, Rec1Stat, MaxDataBytes);
E10IO (RecCmd, Rec2Head, Rec2Buf, Rec2Stat, MaxDataBytes);
writeln ('Set up receives.');
write ('Type <return> to end program.');
readln;
E10Reset (AdRec);
End.
