Module LineRect;
{----------------------------------------------------------------------------
 Draw a line or a rectangle at a factor of 8 bigger than regular.  Used by
   Cursdesign and FontEd.
 
 Written by Brad A. Myers   July 11, 1981

 Copyright (C) - 1981 Brad A. Myers
----------------------------------------------------------------------------}

{----------------------------------------------------------------------------
  Change Log:
    22-Sep-81 Brad A. Myers V1.1  No text typed out
    11-Jul-81 Brad A. Myers V1.0  Broken off from Cursdesign
----------------------------------------------------------------------------}


{/////////////////////////////} Exports {\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\}

Type Funct = (Black, White, Toggle);

Procedure MakeLine(yBase, xBase, maxW, maxH: integer; curMode: Funct;
                   Procedure CursPt(y,x: integer; mode: Funct)
                  );
Procedure MakeRect(yBase, xBase, maxW, maxH: integer; curMode: Funct;
                   Procedure CursPt(y,x: integer; mode: Funct)
                  );
Procedure MakeCircle(yBase, xBase, maxW, maxH: integer; curMode: Funct;
                   Procedure CursPt(y,x: integer; mode: Funct)
                  );



{/////////////////////////////} Private {\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\}


Imports IO_Others from IO_Others;
Imports Screen from Screen;

Const Beep = Chr(7);

Procedure SetPts(x1,y1,x2,y2: integer; curMode: Funct;
                   Procedure CursPt(y,x: integer; mode: Funct));
   var x,y,t,dx,dy,d,e,f,xstep,ystep: integer;
   begin
   CursPt(y1,x1,curMode);
   x := x1; y := y1;
   
   dx := x2-x1;  dy := y2-y1;
   
   if dx >= 0 then xstep := 1
   else begin
        xStep := -1;
        dx := -dx;
        end;
   if dy >= 0 then ystep := 1
   else begin
        yStep := -1;
        dy := -dy;
        end;
   
   t := dy;
   d := dy-dx;
   f := dx+dy;
   if d >= 0 then begin
                  t := dx;
                  d := dx-dy;
                  end;
   e := 0;
   
   {loop}
   
   while f > 0 do
     begin
     f := f-1;
     if d+e+e+t >= 0 then
        begin
        f := f-1;
        e := d+e;
        y := y+yStep;
        x := x+xStep;
        end
     else begin
          e := e+t;
          if dx >= dy then x := x+ xStep
          else y := y + yStep;
          end;
     CursPt(y,x,curMode);
     end;
   end;

Procedure MakeLine(* yBase, xBase, maxW, maxH: integer; curMode: Funct;
                   Procedure CursPt(y,x: integer; mode: Funct)
                  *);
    var tabx, taby,x,y: integer;
        x1,y1, x2, y2, temp: integer;
        got: boolean;
    begin
    got := false;
    while tabswitch do;
    while not tabswitch do;
    IOReadTablet(tabx, taby);
    y := (taby-yBase) div 8;
    x := (tabx-xBase) div 8;
    if (tabx >= xBase) and (taby >= yBase) and (tabx < xBase+maxW) and
             (taby < yBase+maxH) then {nothing}
    else begin
         Write(Beep);
         while TabSwitch do; {wait for it to go off}
         exit(MakeLine);
         end;
    x1:=x;
    y1:=y;
    CursPt(y1,x1, Toggle);
    got := false;
    while TabSwitch do; {wait for it to go off}
    x2 := x1;
    y2 := y1;
    repeat
       IOReadTablet(tabx, taby);
       y := (taby-yBase) div 8;
       x := (tabx-xBase) div 8;
       if (tabx >= xBase) and (taby >= yBase) and (tabx <= xBase+maxW) and
          (taby <= yBase+maxH) then
                   begin
                   got := true;
  {x,y is new pt; x1, y1 is source; x2,y2 is last pt}
                   if (x <> x2) or (y <> y2) then
                       begin
                       Line(XorLine, x1*8+xBase+4, y1*8+yBase+4,    {erase old}
                                     x2*8+xBase+4, y2*8+yBase+4, SScreenP);
                       x2 := x;
                       y2 := y;
                       Line(XorLine, x1*8+xBase+4, y1*8+yBase+4,    {draw new}
                                     x2*8+xBase+4, y2*8+yBase+4, SScreenP);
                       end;
                   end
       else got := false;
(*       if tabswitch and not got then Write(Beep); *)
    until (* got and *) tabswitch;
    if (x2 <> x1) or (y2 <> y1) then
          Line(XorLine, x1*8+xBase+4, y1*8+yBase+4,    {erase old}
                        x2*8+xBase+4, y2*8+yBase+4, SScreenP);
    CursPt(y1,x1, Toggle);
    SetPts(x1,y1,x2,y2,curMode, CursPt);
    while TabSwitch do;  {wait for release}
    end; {MakeLine}
   
Procedure DoLineBox(x1,y1,x2,y2,xBase,yBase: integer);
        begin
        x1 := x1*8+xBase+4;
        y1 := y1*8+yBase+4;
        x2 := x2*8+xBase+4;
        y2 := y2*8+yBase+4;
        Line(XorLine, x1, y1, x2-1, y1, SScreenP); { Draw to just before dest}
        Line(XorLine, x2, y1, x2, y2-1, SScreenP); { so corners are visible}
        Line(XorLine, x2, y2, x1+1, y2, SScreenP);
        Line(XorLine, x1, y2, x1, y1+1, SScreenP);
        end;

Procedure MakeRect(* yBase, xBase, maxW, maxH: integer; curMode: Funct;
                   Procedure CursPt(y,x: integer; mode: Funct)
                  *);
    var tabx, taby,x,y: integer;
        x1,y1, x2, y2, temp, i,j: integer;
        got: boolean;
    begin
    got := false;
    while tabswitch do;
    while not tabswitch do;
    IOReadTablet(tabx, taby);
    y := (taby-yBase) div 8;
    x := (tabx-xBase) div 8;
    if (tabx >= xBase) and (taby >= yBase) and (tabx < xBase+maxW) and
             (taby < yBase+maxH) then {nothing}
    else begin
         Write(Beep);
         while TabSwitch do; {wait for it to go off}
         exit(MakeRect);
         end;
    x1:= x;
    y1:=y;
    CursPt(y1,x1, Toggle);
    x2 := x1;
    y2 := y1;
    got := false;
    while TabSwitch do;
    repeat
       IOReadTablet(tabx, taby);
       y := (taby-yBase) div 8;
       x := (tabx-xBase) div 8;
       if (tabx >= xBase) and (taby >= yBase) and (tabx <= xBase+maxW) and
             (taby <= yBase+maxH) then 
                begin
                got := true;
  {x,y is new pt; x1, y1 is source corner; x2,y2 is last pt}
                if (x <> x2) or (y <> y2) then
                       begin
                       DoLineBox(x1,y1,x2,y2,xBase,yBase); {erase old}
                       x2 := x;
                       y2 := y;
                       DoLineBox(x1,y1,x2,y2,xBase,yBase); {draw new}
                       end;
                end
       else got := false;
(*       if tabswitch and not got then Write(Beep); *)
    until (* got and *) tabswitch;
    if (x2 <> x1) or (y2 <> y1) then
          DoLineBox(x1,y1,x2,y2,xBase,yBase); {erase old}
    CursPt(y1,x1,Toggle);  {change back to original state}
    if x1 > x2 then begin
                    temp := x1;
                    x1:= x2;
                    x2:=temp;
                    end;
    if y1 > y2 then begin
                    temp := y1;
                    y1 := y2;
                    y2:= temp;
                    end;
    for i := x1 to x2 do
      for j := y1 to y2 do
         CursPt(j,i,curMode);
    while TabSwitch do;  {wait for release}
    end; {MakeRect}

Function GetTBit(y,x: integer; p: CurPatPtr): boolean;
   var hack: record case boolean of
               true: (w: integer);
               false: (b: packed array [0..15] of boolean);
              end;
   begin
   hack.w := p^[y, x div 16];
   GetTBit := hack.b[(15-(x mod 16))];
   end;

function Sqrt( X: Integer ): Integer;
  var V, I: integer;
  begin { Sqrt }
    V := 0;
    I := 128;
    while I <> 0 do
      begin
        if (V + I <= 180) and ((V + I) * (V + I) <= X) then V := V + I;
        I := I div 2
      end;
    Sqrt := V
  end { Sqrt };

Procedure MakeCircle(* yBase, xBase, maxW, maxH: integer; curMode: Funct;
                   Procedure CursPt(y,x: integer; mode: Funct)
                    *);
  var r, oldR, x, y, x1, y1,i,j, diameter, tabx, taby, maxR: integer;
      circleP : CurPatPtr;
      got: boolean;
  begin
  got := false;
  while tabswitch do;
  while not tabswitch do;
  IOReadTablet(tabx, taby);
  y := ((taby-yBase) div 8);
  x := ((tabx-xBase) div 8);
  if (tabx >= xBase) and (taby >= yBase) and (tabx < xBase+maxW) and
             (taby < yBase+maxH) then {nothing}
    else begin
         Write(Beep);
         while TabSwitch do; {wait for it to go off}
         exit(MakeCircle);
         end;
  x1 := x;
  y1 := y;
  CursPt(y1,x1, Toggle);
  oldR := 0;
  if x1 < (maxW div 8) - x1 then x := x1 else x := (maxW div 8) - x1;
  if y1 < (maxH div 8) - y1 then y := y1 else y := (maxH div 8) - y1;
  if x < y then maxR := x+1 else maxR := y+1;
  while TabSwitch do; {wait for it to go off}
  repeat
       IOReadTablet(tabx, taby);
       y := (taby-yBase) div 8;
       x := (tabx-xBase) div 8;
       if (tabx >= xBase) and (taby >= yBase) and (tabx <= xBase+maxW+7) and
             (taby <= yBase+maxH+7) then 
                begin
                got := true;
                if Abs(x-x1) > Abs(y-y1) then r := Abs(x1-x)
                else r := Abs(y1-y);
                if r > maxR then r := maxR;
                if r < 2 then r := 0;
  {r is new radius; x1, y1 is center; oldR is last radius}
                if (r <> oldR) then
                       begin
                       if oldR <> 0 then
                         DoLineBox(x1-oldR+1,y1-oldR+1,           {erase old}
                                   x1+oldR-1,y1+oldR-1,xBase,yBase);
                       oldR := r;
                       if oldR <> 0 then
                         DoLineBox(x1-oldR+1,y1-oldR+1,           {draw new}
                                   x1+oldR-1,y1+oldR-1,xBase,yBase);
                       end;
                end
       else got := false;
(*       if tabswitch and not got then Write(Beep); *)
    until (* got and *) tabswitch;
  if oldR <> 0 then DoLineBox(x1-oldR+1,y1-oldR+1,
                              x1+oldR-1,y1+oldR-1,xBase,yBase); {erase old}
  CursPt(y1,x1, Toggle);
  
{create circle with correct radius }
  diameter := r * 2;
  New(0,4, circleP);
  RasterOp(RXor, 64,64, 0, 0, 4, circleP, 0, 0, 4, circleP); {Clear out buffer}
    for I := 1 to r-1 do
      begin
        J := Sqrt((r-1)*(r-1) - I*I);
        RasterOp(RXNor, 2*I+1, 2*J+1, (x1-r)+r-I, (y1-r)+r-J, 4, circleP,
                                      (x1-r)+r-i, (y1-r)+r-j, 4, circleP);
        RasterOp(RXNor, 2*J+1, 2*I+1, (x1-r)+r-j, (y1-r)+r-i, 4, circleP,
                                      (x1-r)+r-j, (y1-r)+r-i, 4, circleP)
      end;
  
{merge circle into picture}
  for x := 0 to maxW div 8 do
    for y := 0 to maxH div 8 do
      if GetTBit(y,x,circleP) then
         CursPt(y,x,curMode);

  Dispose(circleP);
  while TabSwitch do;  {wait for release}
  end.
  
<><><><>><><>><>><><>><

procedure Initialize;
var I, J: Integer;
  begin { Initialize }
    New(0,4,BallPat);
    RasterOp(RXor, Diameter+1, Diameter+1, 0, 0, 4, BallPat, 0, 0, 4, BallPat);
    for I := 1 to RadMinus1 do
      begin
        J := Sqrt(RadMinus1*RadMinus1 - I*I);
        RasterOp(RXNor, 2*I+1, 2*J+1, Radius-I, Radius-J, 4, BallPat,
                                      Radius-I, Radius-J, 4, BallPat);
        RasterOp(RXNor, 2*J+1, 2*I+1, Radius-J, Radius-I, 4, BallPat,
                                      Radius-J, Radius-I, 4, BallPat)
      end;
