Module board;

Exports

imports buttons from buttons;
imports pathname from pathname;
imports Perq_String from Perq_String;

type
   Colour = (cwhite,cblack);
   Colore = (LITE,DARK,NONE);

var
   PerqColore : colore;
   bPlayer : colour;
   ButnList : butnptr;
   MaxX,MaxY,lastPos : Integer;
   FNODEL : Integer;

Function FindField(rx,ry : Integer) : Integer;
procedure message(s:string);
procedure endgame;
Procedure UpdateClock(redr : Boolean);
procedure redrawboard;
Procedure InitBoard;
procedure changeplayer;
Procedure MoveFigure(s : string;source,dest:Integer);
Procedure Request;
Procedure MarkThought(pos : Integer);
Procedure Incrmnt;
Procedure Decrmnt;
Procedure recordmove(s : string);
Private

imports time from timeuser;
imports oldtimestamp from oldtimestamp;
imports PascalInit from PascalInit;

const

   WhiteField = '0';
   WRook   = 't';
   BRook   = 'T';
   WKnight = 'p';
   BKnight = 'P';
   WBishop = 'f';
   BBishop = 'F';
   WQueen  = 'd';
   BQueen  = 'D';
   WKing   = 'k';
   BKing   = 'K';
   WPawn   = 'b';
   BPawn   = 'B';

   line1 = -21846;
   line2 = 21845;
   Boarder = 18;
   OrgX  = 3+Boarder;
   OrgY  = 20+Boarder;
   FieldW = 60;

   ClW = 112;
   ClH = 50;
   ClWX = OrgX+8*FieldW+Boarder+6;
   ClWY = OrgY+8*FieldW+2*Boarder+54;
   ClBX = ClWX+ClW-2;
   ClBY = ClWY;

   ButnH = 50;
   ButnBord = 8;
   distance = 15;
   ButOrgX = OrgX;
   ButOrgY = OrgY+8*FieldW+2*Boarder+10;

   BarY = 675;
   BarX = ButOrgX;
   BarW = 516;
   BarH = ButnH div 2;


Type
   Box = array[0 .. 63] of array[0 .. 3] of integer;
   BoxPtr = ^Box;
   figure = char;

Var
   lastmessage,lastmove: string;
   BaseAddress : long;
   active_field : Port;
   FiguresFont,NumbersFont,LettersFont : Port;
   BlkTaken,WhtTaken,CurntBar : Integer;
   WTaknCnt,BTaknCnt : Array[0 .. 15] of figure;
   BoardContent : Array[0 .. 63] of figure;

   Field : BoxPtr;
   CurTStamp,WTStamp,BTStamp : TimeStamp;
   Even : Boolean;

   Chesslog : Text;
   Clearstr,Name : String;

Function Odd(m:Integer) : Boolean;
begin
   Odd := 2*(m div 2) <> m
end;

Function Rem(n,m : Integer) : Integer;
begin
   rem := n-m*(n div m)
end;

Function FieldColour(x,y : Integer) : Colour;
begin
   if odd(x+y) then FieldColour := cblack
   else FieldColour := cwhite;
end;

Procedure InitGraphics;
var i : Integer;
    cc : GeneralReturn;

begin
   UWindow := UserWindow;
   WindowViewport(UWindow,UView,MaxX,MaxY);
   cc := SetPriority(KernelPort,0);
   For i := 0 to 15 do Begin
     WTaknCnt[i] := Whitefield;
     BTaknCnt[i] := WhiteField
   End;
end;

Procedure MarkThought(pos : Integer);

Procedure Mark(pos : Integer);
var xpos,ypos : Integer;

begin
   If (pos > 0) And (pos < 63) Then Begin
     ypos := (63 - pos) div 8;
     xpos := pos - (7 -ypos)*8;
     VPColorRect(UView,RectInvert,OrgX+15+xpos*FieldW,
                        OrgY+(8-ypos)*FieldW-45,25,25);
     End;
End;

Begin
   Mark(lastPos);
{   If lastPos <> pos Then} Mark(Pos);
   lastPos := Pos;
End;

Procedure Incrmnt;

Begin
   If FNODEL < 6400 Then Begin
     FNODEL := 2*FNODEL;
     VPColorRect(UView,RectBlack,BarX+CurntBar+3,BarY,CurntBar-3,BarH);
     CurntBar := CurntBar*2;
     End;
   SetButton(off,ButnList,'smarter perq');
End;

Procedure Decrmnt;

Begin
   If FNODEL > 100 Then Begin
     FNODEL := FNODEL div 2;
     CurntBar := CurntBar div 2;
     VPColorRect(UView,RectWhite,BarX+CurntBar,BarY,CurntBar,BarH);
     End;
   SetButton(off,ButnList,'dumber  perq');
End;



Procedure InitList;
var head,tail : butnptr;

begin
   new(head);
   head^ .str := '    Quit    ';
   new(head^ .follow);
   tail := head^ .follow;
   tail^ .str := 'redraw board';
   new(tail^ .follow);
   tail := tail^ .follow;
   tail^ .str := 'change sides';
   new(tail^ .follow);
   tail := tail^ .follow;
   tail^ .str := ' perq alone ';
   new(tail^ .follow);
   tail := tail^ .follow;
   tail^ .str := 'smarter perq';
   new(tail^ .follow);
   tail := tail^ .follow;
   tail^ .str := 'dumber  perq';
   tail^ .follow := Nil;
   butnlist := head;
end;

procedure endgame;
var b:boolean;
    cc : GeneralReturn;
begin
  cc:= DestroySegment(KERNELPORT, recast(Field, long));
  Close(chesslog);
  EnableWinListener(Uwindow,nullport,'<boot>ts.keytran',10);
end;

procedure changeplayer;

begin
   If bplayer = cblack Then Begin
     VPColorRect(UView,RectWhite,CLBX+40,CLBY+CLH,32,24);
     VPColorRect(UView,RectBlack,ClWX+40,ClWY-10,32,24);
     VPColorRect(UView,RectBlack,ClBX+40,ClBY-22,32,12);
     bplayer := cwhite;
     End
   Else Begin
     VPColorRect(UView,RectWhite,ClWX+40,ClWY+CLH,32,24);
     VPColorRect(UView,RectBlack,ClWX+40,ClWY-10,32,12);
     VPColorRect(UView,RectBlack,ClBX+40,ClBY-22,32,24);
     bplayer := cblack;
     End;
end;

Procedure Request;

Begin
   Repeat
     Kevent := Getevent(Uview,KeyDontWait);
     UpdateClock(False);
    Until Kevent.cmd <> 40;
End;

Procedure DrawFigure(f:Figure;pos:Integer);
var i,xpos,ypos,startx,starty : integer;

begin
   ypos := (63-pos) div 8;
   xpos := pos - (7-ypos)*8;

   BoardContent[pos] := f;
   if FieldColour(xpos,ypos) = cblack then f := chr(ord(f)+1);
   startx := OrgX+7+xpos*FieldW;
   starty := OrgY+(8-ypos)*FieldW-50;
   VPChar(UView,FiguresFont,RRpl,startx,starty,f);
end;


procedure message(s: string);
var 
   xstring,ystring,startch,endch:integer;

begin
  xstring := OrgX;
  ystring := OrgY+8*FieldW+2*boarder;
  endch := DontCare;
  startch := 1;
  VPString(UView,NullPort,RRpl,xstring,ystring,clearstr,startch,endch);
  xstring := OrgX;
  ystring := OrgY+8*FieldW+2*boarder;
  endch := DontCare;
  startch := 1;
  VPString(UView,NullPort,RRpl,xstring,ystring,s,startch,endch);
  lastmessage := s;
end;

Procedure recordmove(s : string);
var 
   xstring,ystring,startch,endch: Integer;

Begin
   xstring := OrgX+7*FieldW;
   ystring := OrgY+8*FieldW+2*Boarder;
   startch := 1;
   endch := DontCare;
   VPString(UView,NullViewport,Rrpl,xstring,ystring,clearstr,
              startch,endch);
   xstring := OrgX+7*FieldW;
   ystring := OrgY+8*FieldW+2*Boarder;
   startch := 1;
   endch := DontCare;
   VPString(UView,NullViewport,Rrpl,xstring,ystring,s,startch,endch);
   If even Then Begin
     If (PerqColore = LITE) Or (PerqColore = NONE)
       Then Write(Chesslog,s,'P    ')
     Else Write(Chesslog,s,'H    ');
     Even := False;
   End
   Else Begin
      If (PerqColore = DARK) Or (PerqColore = NONE)
        Then Writeln(Chesslog,s,'P    ')
      Else Writeln(Chesslog,s,'H    ');
      Even := True;
   End;
   lastmove := s;
End;

Procedure InitFigures;
var i : integer;

begin
   for i := 0 to 63 do BoardContent[i] := WhiteField;
   BoardContent[0] := WRook;
   BoardContent[1] := WKnight;
   BoardContent[2] := WBishop;
   BoardContent[3] := WQueen;
   BoardContent[4] := WKing;
   BoardContent[5] := WBishop;
   BoardContent[6] := WKnight;
   BoardContent[7] := WRook;
   for i := 0 to 7 do
      BoardContent[8+i] := WPawn;

   BoardContent[56] := BRook;
   BoardContent[57] := BKnight;
   BoardContent[58] := BBishop;
   BoardContent[59] := BQueen;
   BoardContent[60] := BKing;
   BoardContent[61] := BBishop;
   BoardContent[62] := BKnight;
   BoardContent[63] := BRook;
   for i := 0 to 7 do
      BoardContent[48+i] := BPawn;
end;


Procedure MoveFigure(s : string;Source,dest:Integer);
var   f,oldf:Char;
      i,startx,starty : Integer;

begin
   f := BoardContent[source];
   oldf := BoardContent[dest];
   If ((dest div 8 = 0) Or (dest div 8 = 7)) And ((f = BPawn) Or (f = WPawn))
     Then If bplayer = cblack Then Begin
            f := BQueen;
            i := 0;
            While (BTaknCnt[i] <> BQueen) And (i < 15) Do i := i +1;
            If BTaknCnt[i] = BQueen Then Begin
              BTaknCnt[i] := BPawn;
              startx := OrgX+10*FieldW+2*Boarder+(i div 8)*FieldW-10;
              starty := OrgY+(rem(i,8)+1)*FieldW-20;
              VPChar(UView,FiguresFont,RRpl,startx,starty,BPawn);
            End;
          End
          Else Begin
            f := WQueen;
            i := 0;
            While (WTaknCnt[i] <> WQueen) And (i < 15) Do i := i +1;
            If WTaknCnt[i] = WQueen Then Begin
              WTaknCnt[i] := WPawn;
              startx := OrgX+8*FieldW+2*Boarder+(i div 8)*FieldW-10;
              starty := OrgY+(rem(i,8)+1)*FieldW-20;
              VPChar(UView,FiguresFont,RRpl,startx,starty,WPawn)
            End;
          End;
   If oldf <> WhiteField Then
     If bplayer = cblack Then Begin
       startx := OrgX+8*FieldW+2*Boarder+(WhtTaken div 8)*FieldW-10;
       starty := OrgY+(rem(WhtTaken,8)+1)*FieldW-20;
       VPChar(UView,FiguresFont,RRpl,startx,starty,oldf);
       WTaknCnt[WhtTaken] := oldf;
       WhtTaken := WhtTaken +1
       End
     Else Begin
       startx := OrgX+10*FieldW+2*Boarder+(BlkTaken div 8)*FieldW-10;
       starty := OrgY+(rem(BlkTaken,8)+1)*FieldW-20;
       VPChar(UView,FiguresFont,RRpl,startx,starty,oldf);
       BTaknCnt[BlkTaken] := oldf;
       BlkTaken := BlkTaken + 1
       End;
   DrawFigure(WhiteField,source);
   DrawFigure(f,dest);
   recordmove(s);
end;

Procedure UpdateClock(redr : Boolean);
var x : TimeStamp;
    delta : Integer;

Procedure WriteClock(var x : TimeStamp);
var time : Integer;
    s1 : String;
    s2 : String[8];
    intern : Internal_Time;
    usertime : User_Time;
    xstring,ystring,startch,endch : Integer;

Begin
   time := x.second + x.minute*60 + x.hour*3600 + delta;
   x.hour := time div 3600;
   time := time - x.hour*3600;
   x.minute := time div 60;
   x.second := time - x.minute*60;
   intern := OldToNewTime(x);
   usertime := T_IntToUser(timeport,Intern);
   s1 := T_UserToString(timeport,usertime,0);
   s2 := subStr(s1,11,8);
   startch := 1;
   endch := DontCare;
   If bplayer = cwhite
     Then Begin
       xstring := ClWX+4;
       ystring := CLWY+42;
       VPString(UView,NumbersFont,RRpl,xstring,ystring,s2,startch,endch);
      End
   Else Begin
       xstring := ClBX+4;
       ystring := CLBY+42;
       VPString(UView,NumbersFont,RRpl,xstring,ystring,s2,startch,endch);
      End;
End;

begin
   x := OldCurrentTime;
   delta := 0;
   if x.second <> CurTStamp.second then delta := x.second-curTSTamp.second;
   if x.minute <> CurTStamp.minute
     Then delta := delta + (x.minute-CurTStamp.minute)*60;
   If x.hour >= CurTStamp.hour then delta := delta + (x.hour-CurTStamp.hour)*60*60
     Else delta := delta + (24-CurTStamp.hour)*60*60;
   if (delta <> 0) Or Redr Then Begin
     CurTStamp := x;
     if bplayer = cwhite Then WriteClock(WTStamp)
     else WriteClock(BTStamp)
     End
end;



procedure redrawboard;
var startch,endch,i,j,xstring,ystring: integer;
    Tmp : ButnPtr;

begin
   VPColorRect(UView,RectWhite,0,0,MaxX,MaxY);

   VPColorRect(UView,RectBlack,OrgX-Boarder,OrgY-Boarder,2*Boarder+8*FieldW,
                 Boarder);
   VPColorRect(UView,RectBlack,OrgX-Boarder,OrgY,Boarder,8*FieldW);
   VPColorRect(UView,RectBlack,OrgX-Boarder,OrgY+8*FieldW,8*FieldW+Boarder,
                 Boarder);
   VPColorRect(UView,RectBlack,OrgX+8*FieldW,OrgY,Boarder,
                 8*FieldW+Boarder);

   For i := 0 to 7 do Begin
     xstring := OrgX+(i+1)*FieldW-FieldW div 2-4;
     ystring := OrgY-boarder div 2+5;
     VPChar(UView,Nullport,RNot,xstring,ystring,chr(i+ord('a')));
     xstring := OrgX+(i+1)*FieldW-FieldW div 2 -4;
     ystring := OrgY+8*FieldW+(boarder div 2)+5;
     VPChar(UView,Nullport,RNot,xstring,ystring,chr(i+Ord('a')));
     xstring := OrgX-(boarder div 2)-4;
     ystring := OrgY+(i+1)*FieldW-(FieldW div 2)+5;
     VPChar(UView,Nullport,RNot,xstring,ystring,chr(i+ord('1')));
     xstring := OrgX+8*FieldW+5;
     ystring := OrgY+(i+1)*FieldW-(FieldW div 2)+5;
     VPChar(UView,Nullport,RNot,xstring,ystring,chr(i+ord('1')));
   End;

   for i := 0 to 3 do
      for j := 0 to 3 do begin
         VPRop(UView,RRpl,OrgX+FieldW*(2*j),OrgY+FieldW*2*i,FieldW,FieldW,
                 Active_field,0,0);
         VPRop(UView,RRpl,OrgX+FieldW*(2*j+1),OrgY+FieldW*(2*i+1),FieldW,
                 FieldW,Active_field,0,0);
      end;
   for i := 0 to 63 do DrawFigure(BoardContent[i], i);

   VPColorRect(UView,RectBlack,OrgX+10*FieldW+Boarder,OrgY-Boarder,6,
                 8*FieldW+2*Boarder);

   VPColorRect(UView,RectBlack,ClWX,ClWY,ClW,2);
   VPColorRect(UView,RectBlack,ClWX,ClWY+ClH-2,ClW,2);
   VPColorRect(UView,RectBlack,ClWX,ClWY,2,ClH);
   VPColorRect(UView,RectBlack,ClWX+ClW-2,ClWY,2,ClH);
   VPColorRect(UView,RectBlack,ClBX,ClBY,ClW,2);
   VPColorRect(UView,RectBlack,ClBX,ClBY+ClH-2,ClW,2);
   VPColorRect(UView,RectBlack,ClBX+ClW-2,ClBY,2,ClH);
   VPColorRect(UView,RectBlack,ClWX,ClWY+20,ClW+ClW-2,2);
   VPColorRect(UView,RectBlack,ClBX,ClBY,ClW,20);

   DrawButns(ButnList,400,300);

   CurntBar := 10;
   VPColorRect(UView,RectBlack,BarX,BarY,CurntBar,BarH);
   i := FNODEL;
   FNODEL := 100;
   While FNODEL < i Do
     Incrmnt;

   For i := 0 to WhtTaken do Begin
     xstring := OrgX+8*FieldW+2*Boarder+(i div 8)*FieldW - 10;
     ystring := OrgY+(rem(i,8)+1)*FieldW-20;
     VPChar(UView,FiguresFont,RRpl,xstring,ystring,WTaknCnt[i]);
    End;
   For i := 0 to BlkTaken do Begin
     xstring := OrgX+10*FieldW+2*Boarder+(i div 8)*FieldW-10;
     ystring := OrgY+(rem(i,8)+1)*FieldW-20;
     VPChar(UView,FiguresFont,RRpl,xstring,ystring,BTaknCnt[i]);
    End;
   Tmp := ButnList;
   While Tmp <> Nil Do Begin
     If Tmp^ .status = on Then
       VPColorRect(UView,RectInvert,Tmp^ .x,Tmp^ .y,Tmp^.width,Tmp^.height);
     Tmp := Tmp^ .follow
   End;

   UpdateClock(True);
   changeplayer;
   UpdateClock(True);
   changeplayer;

   message(lastmessage);
   xstring := OrgX+6*FieldW;
   ystring := OrgY+8*FieldW+2*boarder;
   startch := 1;
   endch := 25;
   VPString(UView,NullViewPort,RRpl,xstring,ystring,clearstr,startch,
              endch);
   xstring := OrgX+6*FieldW;
   ystring := OrgY+8*FieldW+2*boarder;
   startch := 1;
   endch := 25;
   VPString(UView,NullViewPort,RRpl,xstring,ystring,lastmove,startch,
              endch);
   MarkThought(LastPos);
end;


function MakeName(p: Path_Name): Path_Name;
var
  GR: GeneralReturn;
  et: Entry_Type;
  ns: Name_Status;
begin
  GR := FindTypedName(p, '', '', false, et, ns);
  MakeName := p;
end;


Function FindField(rx,ry: Integer) : Integer;
var
   posx,posy : Integer;

begin
   posx := (rx-OrgX) div FieldW;
   posy := (ry-OrgY) div FieldW;
   FindField := (posy*8)+posx
End;


Procedure initboard;
Var i_size,j,i : Integer;
    GR : GeneralReturn;

begin
   Initgraphics;
   InitList;
   GR := enableprivs(KernelPort);

   WhtTaken := 0;
   FNODEL := 100;
   BlkTaken := 0;
   bPlayer:=cwhite;
   PerqColore := DARK;
   lastpos := -1;
   Even := True;
   lastmove :='          ';
   clearstr := '                                                             ';

   EnableWinListener(UWindow,nullport,MakeName('chess.keytran'),10);
   FiguresFont := LoadFont(UView,MakeName('chess.figures'));
   If figuresfont = nullport then writeln('chess.figures not found');
   NumbersFont := LoadFont(UView,MakeName('chess.numbers'));
   If Numbersfont = nullport then writeln('chess.numbers not found');
   LettersFont := LoadFont(UView,MakeName('chess.letters'));
   If LettersFont = nullport then writeln('chess.letters not found');

   GR := AllocatePort(KERNELPORT, active_field, 0);
   GR := CreateSegment(KERNELPORT,active_field,SEGPHYSICAL,1,
                             1,false,BaseAddress);
   GR := CreateRectangle(kernelport,active_field,BaseAddress,
                              4, 0, 0, 63, 63,false);
   Field := recast(BaseAddress, Boxptr);
   for i := 0 to 31 do
      for j := 0 to 3 do begin
         Field^[2*i][j] := line1;
         Field^[2*i+1][j] := line2;
      end;
   CreateButnList(ButnList,ButOrgX,ButOrgY,300,400,ButnBord,distance);

   WTStamp.hour := 0;
   WTStamp.minute := 0;
   WTStamp.second := 0;
   BTStamp.hour := 0;
   BTStamp.minute := 0;
   BTStamp.second := 0;

   Name := 'chess.log';
   Rewrite(chesslog,Name);
   Writeln(chesslog,' White          Black   ');
   Writeln(chesslog);

   InitFigures;
   CurTStamp := OldCurrentTime;
   lastmessage := '                     ';
   redrawboard

end.


